/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.enzo.roundlcdclock;

import eu.hansolo.enzo.fonts.Fonts;
import eu.hansolo.enzo.roundlcdclock.AlarmEvent;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoField;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.stream.IntStream;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.event.EventTarget;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.ArcType;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.text.Font;
import javafx.scene.text.TextAlignment;

public class RoundLcdClock
extends Region {
    private static final double PREFERRED_WIDTH = 200.0;
    private static final double PREFERRED_HEIGHT = 200.0;
    private static final double MINIMUM_WIDTH = 25.0;
    private static final double MINIMUM_HEIGHT = 25.0;
    private static final double MAXIMUM_WIDTH = 1024.0;
    private static final double MAXIMUM_HEIGHT = 1024.0;
    private volatile ScheduledFuture<?> periodicClockTask;
    private static ScheduledExecutorService periodicClockExecutorService;
    private double size;
    private double width;
    private double height;
    private ObjectProperty<Color> hColor = new SimpleObjectProperty((Object)this, "hourColor", (Object)Color.BLACK);
    private ObjectProperty<Color> mColor = new SimpleObjectProperty((Object)this, "minuteColor", (Object)Color.rgb((int)0, (int)0, (int)0, (double)0.5));
    private ObjectProperty<Color> m5Color = new SimpleObjectProperty((Object)this, "5MinuteColor", (Object)Color.BLACK);
    private ObjectProperty<Color> sColor = new SimpleObjectProperty((Object)this, "secondColor", (Object)Color.BLACK);
    private ObjectProperty<Color> timeColor = new SimpleObjectProperty((Object)this, "timeColor", (Object)Color.BLACK);
    private ObjectProperty<Color> dateColor = new SimpleObjectProperty((Object)this, "dateColor", (Object)Color.BLACK);
    private BooleanProperty alarmOn = new SimpleBooleanProperty((Object)this, "alarmOn", false);
    private ObjectProperty<LocalTime> alarm = new SimpleObjectProperty((Object)LocalTime.now().minusMinutes(1L));
    private BooleanProperty dateVisible = new SimpleBooleanProperty((Object)this, "dateVisible", false);
    private BooleanProperty alarmVisible = new SimpleBooleanProperty((Object)this, "alarmVisible", false);
    private Pane pane;
    private Canvas canvasBkg;
    private GraphicsContext ctxBkg;
    private Canvas canvasFg;
    private GraphicsContext ctxFg;
    private Canvas canvasHours;
    private GraphicsContext ctxHours;
    private Canvas canvasMinutes;
    private GraphicsContext ctxMinutes;
    private Canvas canvasSeconds;
    private GraphicsContext ctxSeconds;
    private Font font;
    private IntegerProperty hours;
    private IntegerProperty minutes;
    private IntegerProperty seconds;
    private boolean pm;
    private StringBuilder time = new StringBuilder();

    public RoundLcdClock() {
        this.hours = new SimpleIntegerProperty((Object)this, "hours", -1);
        this.minutes = new SimpleIntegerProperty((Object)this, "minutes", -1);
        this.seconds = new SimpleIntegerProperty((Object)this, "seconds", -1);
        this.init();
        this.initGraphics();
        this.registerListeners();
        this.scheduleClockTask();
    }

    private void init() {
        if (Double.compare(this.getPrefWidth(), 0.0) <= 0 || Double.compare(this.getPrefHeight(), 0.0) <= 0 || Double.compare(this.getWidth(), 0.0) <= 0 || Double.compare(this.getHeight(), 0.0) <= 0) {
            if (this.getPrefWidth() > 0.0 && this.getPrefHeight() > 0.0) {
                this.setPrefSize(this.getPrefWidth(), this.getPrefHeight());
            } else {
                this.setPrefSize(200.0, 200.0);
            }
        }
        if (Double.compare(this.getMinWidth(), 0.0) <= 0 || Double.compare(this.getMinHeight(), 0.0) <= 0) {
            this.setMinSize(25.0, 25.0);
        }
        if (Double.compare(this.getMaxWidth(), 0.0) <= 0 || Double.compare(this.getMaxHeight(), 0.0) <= 0) {
            this.setMaxSize(1024.0, 1024.0);
        }
    }

    private void initGraphics() {
        this.canvasBkg = new Canvas(200.0, 200.0);
        this.ctxBkg = this.canvasBkg.getGraphicsContext2D();
        this.canvasFg = new Canvas(200.0, 200.0);
        this.ctxFg = this.canvasFg.getGraphicsContext2D();
        this.canvasHours = new Canvas(200.0, 200.0);
        this.ctxHours = this.canvasHours.getGraphicsContext2D();
        this.canvasMinutes = new Canvas(200.0, 200.0);
        this.ctxMinutes = this.canvasMinutes.getGraphicsContext2D();
        this.canvasSeconds = new Canvas(200.0, 200.0);
        this.ctxSeconds = this.canvasSeconds.getGraphicsContext2D();
        this.pane = new Pane();
        this.pane.getChildren().setAll((Object[])new Node[]{this.canvasBkg, this.canvasFg, this.canvasHours, this.canvasMinutes, this.canvasSeconds});
        this.getChildren().setAll((Object[])new Node[]{this.pane});
    }

    private void registerListeners() {
        this.widthProperty().addListener(o -> this.handleControlPropertyChanged("RESIZE"));
        this.heightProperty().addListener(o -> this.handleControlPropertyChanged("RESIZE"));
        this.hColor.addListener(o -> this.handleControlPropertyChanged("REDRAW"));
        this.mColor.addListener(o -> this.handleControlPropertyChanged("REDRAW"));
        this.m5Color.addListener(o -> this.handleControlPropertyChanged("REDRAW"));
        this.sColor.addListener(o -> this.handleControlPropertyChanged("REDRAW"));
        this.timeColor.addListener(o -> this.handleControlPropertyChanged("REDRAW"));
        this.dateColor.addListener(o -> this.handleControlPropertyChanged("REDRAW"));
        this.alarmOn.addListener(o -> this.handleControlPropertyChanged("REDRAW"));
        this.dateVisible.addListener(o -> this.handleControlPropertyChanged("REDRAW"));
        this.alarmVisible.addListener(o -> this.handleControlPropertyChanged("REDRAW"));
        this.hours.addListener((ov, o, n) -> this.handleControlPropertyChanged("HOURS"));
        this.minutes.addListener((ov, o, n) -> this.handleControlPropertyChanged("MINUTES"));
        this.seconds.addListener((ov, o, n) -> this.handleControlPropertyChanged("SECONDS"));
    }

    protected void handleControlPropertyChanged(String PROPERTY) {
        if ("RESIZE".equals(PROPERTY)) {
            this.resize();
        } else if ("REDRAW".equals(PROPERTY)) {
            this.stopTask(this.periodicClockTask);
            this.drawBackground();
            this.drawForeground();
            this.scheduleClockTask();
        } else if ("SECONDS".equals(PROPERTY)) {
            this.drawForeground();
            this.drawSeconds();
        } else if ("MINUTES".equals(PROPERTY)) {
            this.drawMinutes();
        } else if ("HOURS".equals(PROPERTY)) {
            this.drawHours();
        }
    }

    public final Color getHourColor() {
        return (Color)this.hColor.get();
    }

    public final void setHourColor(Color HOUR_COLOR) {
        this.hColor.set((Object)HOUR_COLOR);
    }

    public final ObjectProperty<Color> hourColorProperty() {
        return this.hColor;
    }

    public final Color getMinuteColor() {
        return (Color)this.mColor.get();
    }

    public final void setMinuteColor(Color MINUTE_COLOR) {
        this.mColor.set((Object)MINUTE_COLOR);
    }

    public final ObjectProperty<Color> minuteColorProperty() {
        return this.mColor;
    }

    public final Color getMinute5Color() {
        return (Color)this.m5Color.get();
    }

    public final void setMinute5Color(Color MINUTE_5_COLOR) {
        this.m5Color.set((Object)MINUTE_5_COLOR);
    }

    public final ObjectProperty<Color> minute5ColorProperty() {
        return this.m5Color;
    }

    public final Color getSecondColor() {
        return (Color)this.sColor.get();
    }

    public final void setSecondColor(Color SECOND_COLOR) {
        this.sColor.set((Object)SECOND_COLOR);
    }

    public final ObjectProperty<Color> secondColorProperty() {
        return this.sColor;
    }

    public final Color getTimeColor() {
        return (Color)this.timeColor.get();
    }

    public final void setTimeColor(Color TIME_COLOR) {
        this.timeColor.set((Object)TIME_COLOR);
    }

    public final ObjectProperty<Color> timeColorProperty() {
        return this.timeColor;
    }

    public final Color getDateColor() {
        return (Color)this.dateColor.get();
    }

    public final void setDateColor(Color DATE_COLOR) {
        this.dateColor.set((Object)DATE_COLOR);
    }

    public final ObjectProperty<Color> dateColorProperty() {
        return this.dateColor;
    }

    public final boolean isAlarmOn() {
        return this.alarmOn.get();
    }

    public final void setAlarmOn(boolean ALARM_ON) {
        this.alarmOn.set(ALARM_ON);
    }

    public final BooleanProperty alarmOnProperty() {
        return this.alarmOn;
    }

    public final LocalTime getAlarm() {
        return (LocalTime)this.alarm.get();
    }

    public final void setAlarm(LocalTime ALARM) {
        this.alarm.set((Object)ALARM);
    }

    public final ObjectProperty<LocalTime> alarmProperty() {
        return this.alarm;
    }

    public final boolean isDateVisible() {
        return this.dateVisible.get();
    }

    public final void setDateVisible(boolean DATE_VISIBLE) {
        this.dateVisible.set(DATE_VISIBLE);
    }

    public final BooleanProperty dateVisibleProperty() {
        return this.dateVisible;
    }

    public final boolean isAlarmVisible() {
        return this.alarmVisible.get();
    }

    public final void setAlarmVisible(boolean ALARM_VISIBLE) {
        this.alarmVisible.set(ALARM_VISIBLE);
    }

    public final BooleanProperty alarmVisibleProperty() {
        return this.alarmVisible;
    }

    public final void setColor(Color COLOR) {
        this.setHourColor(COLOR);
        this.setMinuteColor(Color.color((double)COLOR.getRed(), (double)COLOR.getGreen(), (double)COLOR.getBlue(), (double)0.6));
        this.setMinute5Color(COLOR);
        this.setSecondColor(COLOR);
        this.setTimeColor(COLOR);
        this.setDateColor(COLOR);
    }

    private void fireAlarmEvent() {
        this.fireEvent(new AlarmEvent((Object)this, (EventTarget)this, AlarmEvent.ALARM));
    }

    private void drawForeground() {
        this.ctxFg.clearRect(0.0, 0.0, this.size, this.size);
        this.ctxFg.setFill((Paint)this.getTimeColor());
        this.font = Fonts.digital(0.2 * this.size);
        this.ctxFg.setTextBaseline(VPos.CENTER);
        this.ctxFg.setTextAlign(TextAlignment.CENTER);
        this.ctxFg.setFont(this.font);
        this.ctxFg.fillText(this.time.toString(), this.size * 0.5, this.size * 0.5);
        if (this.isDateVisible()) {
            this.ctxFg.setFill((Paint)this.getDateColor());
            this.font = Fonts.digital(0.09 * this.size);
            this.ctxFg.setFont(this.font);
            this.ctxFg.fillText(LocalDate.now().format(DateTimeFormatter.ISO_DATE), this.size * 0.5, this.size * 0.65);
        }
        if (this.isAlarmVisible() && this.isAlarmOn()) {
            this.drawAlarmIcon(this.ctxFg, this.ctxFg.getFill());
        }
    }

    private void drawHours() {
        int hourCounter = 1;
        double strokeWidth = this.size * 0.06;
        this.ctxHours.setLineCap(StrokeLineCap.BUTT);
        this.ctxHours.clearRect(0.0, 0.0, this.size, this.size);
        for (int i = 450; i >= 90; --i) {
            this.ctxHours.save();
            if (i % 30 == 0) {
                this.ctxHours.setStroke((Paint)this.getHourColor());
                this.ctxHours.setLineWidth(strokeWidth);
                if (this.hours.get() == 0 || this.hours.get() == 12) {
                    this.ctxHours.strokeArc(strokeWidth * 0.5, strokeWidth * 0.5, this.size - strokeWidth, this.size - strokeWidth, (double)(i + 1 - 30), 28.0, ArcType.OPEN);
                } else if (hourCounter <= (this.pm ? this.hours.get() - 12 : this.hours.get())) {
                    this.ctxHours.strokeArc(strokeWidth * 0.5, strokeWidth * 0.5, this.size - strokeWidth, this.size - strokeWidth, (double)(i + 1 - 30), 28.0, ArcType.OPEN);
                    ++hourCounter;
                }
            }
            this.ctxFg.restore();
        }
    }

    private void drawMinutes() {
        int minCounter = 1;
        double strokeWidth = this.size * 0.06;
        this.ctxMinutes.setLineCap(StrokeLineCap.BUTT);
        this.ctxMinutes.clearRect(0.0, 0.0, this.size, this.size);
        for (int i = 450; i >= 90; --i) {
            this.ctxMinutes.save();
            if (i % 6 == 0 && minCounter <= this.minutes.get()) {
                this.ctxMinutes.setStroke((Paint)(minCounter % 5 == 0 ? this.getMinute5Color() : this.getMinuteColor()));
                this.ctxMinutes.setLineWidth(strokeWidth);
                this.ctxMinutes.strokeArc(strokeWidth * 0.5 + strokeWidth * 1.1, strokeWidth * 0.5 + strokeWidth * 1.1, this.size - strokeWidth - strokeWidth * 2.2, this.size - strokeWidth - strokeWidth * 2.2, (double)(i + 1 - 6), 4.0, ArcType.OPEN);
                ++minCounter;
            }
            this.ctxMinutes.restore();
        }
    }

    private void drawSeconds() {
        int secCounter = 1;
        double strokeWidth = this.size * 0.06;
        this.ctxSeconds.setLineCap(StrokeLineCap.BUTT);
        this.ctxSeconds.clearRect(0.0, 0.0, this.size, this.size);
        for (int i = 450; i >= 90; --i) {
            this.ctxSeconds.save();
            if (i % 6 == 0 && secCounter <= this.seconds.get() + 1) {
                this.ctxSeconds.setStroke((Paint)this.getSecondColor());
                this.ctxSeconds.setLineWidth(strokeWidth * 0.25);
                this.ctxSeconds.strokeArc(strokeWidth * 0.5 + strokeWidth * 1.8, strokeWidth * 0.5 + strokeWidth * 1.8, this.size - strokeWidth - strokeWidth * 3.6, this.size - strokeWidth - strokeWidth * 3.6, (double)(i + 1 - 6), 4.0, ArcType.OPEN);
                ++secCounter;
            }
            this.ctxSeconds.restore();
        }
    }

    private void drawBackground() {
        double strokeWidth = this.size * 0.06;
        this.ctxBkg.setLineCap(StrokeLineCap.BUTT);
        this.ctxBkg.clearRect(0.0, 0.0, this.size, this.size);
        this.ctxBkg.setStroke((Paint)Color.rgb((int)0, (int)12, (int)6, (double)0.1));
        IntStream.range(0, 360).forEach(i -> {
            this.ctxBkg.save();
            if (i % 6 == 0) {
                this.ctxBkg.setStroke((Paint)Color.color((double)((Color)this.mColor.get()).getRed(), (double)((Color)this.mColor.get()).getGreen(), (double)((Color)this.mColor.get()).getBlue(), (double)0.1));
                this.ctxBkg.setLineWidth(strokeWidth);
                this.ctxBkg.strokeArc(strokeWidth * 0.5 + strokeWidth * 1.1, strokeWidth * 0.5 + strokeWidth * 1.1, this.size - strokeWidth - strokeWidth * 2.2, this.size - strokeWidth - strokeWidth * 2.2, (double)(i + 1), 4.0, ArcType.OPEN);
                this.ctxBkg.setStroke((Paint)Color.color((double)((Color)this.sColor.get()).getRed(), (double)((Color)this.sColor.get()).getGreen(), (double)((Color)this.sColor.get()).getBlue(), (double)0.1));
                this.ctxBkg.setLineWidth(strokeWidth * 0.25);
                this.ctxBkg.strokeArc(strokeWidth * 0.5 + strokeWidth * 1.8, strokeWidth * 0.5 + strokeWidth * 1.8, this.size - strokeWidth - strokeWidth * 3.6, this.size - strokeWidth - strokeWidth * 3.6, (double)(i + 1), 4.0, ArcType.OPEN);
            }
            if (i % 30 == 0) {
                this.ctxBkg.setStroke((Paint)Color.color((double)((Color)this.hColor.get()).getRed(), (double)((Color)this.hColor.get()).getGreen(), (double)((Color)this.hColor.get()).getBlue(), (double)0.1));
                this.ctxBkg.setLineWidth(strokeWidth);
                this.ctxBkg.strokeArc(strokeWidth * 0.5, strokeWidth * 0.5, this.size - strokeWidth, this.size - strokeWidth, (double)(i + 1), 28.0, ArcType.OPEN);
            }
            this.ctxBkg.restore();
        });
        this.ctxBkg.setFill((Paint)Color.color((double)((Color)this.timeColor.get()).getRed(), (double)((Color)this.timeColor.get()).getGreen(), (double)((Color)this.timeColor.get()).getBlue(), (double)0.1));
        this.font = Fonts.digital(0.2 * this.size);
        this.ctxBkg.setTextBaseline(VPos.CENTER);
        this.ctxBkg.setTextAlign(TextAlignment.CENTER);
        this.ctxBkg.setFont(this.font);
        this.ctxBkg.fillText("88:88", this.size * 0.5, this.size * 0.5);
        if (this.isDateVisible()) {
            this.ctxBkg.setFill((Paint)Color.color((double)((Color)this.dateColor.get()).getRed(), (double)((Color)this.dateColor.get()).getGreen(), (double)((Color)this.dateColor.get()).getBlue(), (double)0.1));
            this.font = Fonts.digital(0.09 * this.size);
            this.ctxBkg.setFont(this.font);
            this.ctxBkg.fillText("8888-88-88", this.size * 0.5, this.size * 0.65);
        }
        if (this.isAlarmVisible() && !this.isAlarmOn()) {
            this.drawAlarmIcon(this.ctxBkg, this.ctxBkg.getFill());
        }
    }

    private void drawAlarmIcon(GraphicsContext CTX, Paint COLOR) {
        double iconSize = 0.1 * this.size;
        CTX.save();
        CTX.translate((this.size - iconSize) * 0.5, this.size * 0.25);
        CTX.beginPath();
        CTX.moveTo(0.6875 * iconSize, 0.875 * iconSize);
        CTX.bezierCurveTo(0.625 * iconSize, 0.9375 * iconSize, 0.5625 * iconSize, iconSize, 0.5 * iconSize, iconSize);
        CTX.bezierCurveTo(0.4375 * iconSize, iconSize, 0.375 * iconSize, 0.9375 * iconSize, 0.375 * iconSize, 0.875 * iconSize);
        CTX.bezierCurveTo(0.375 * iconSize, 0.875 * iconSize, 0.6875 * iconSize, 0.875 * iconSize, 0.6875 * iconSize, 0.875 * iconSize);
        CTX.closePath();
        CTX.moveTo(iconSize, 0.8125 * iconSize);
        CTX.bezierCurveTo(0.6875 * iconSize, 0.5625 * iconSize, 0.9375 * iconSize, 0.0, 0.5 * iconSize, 0.0);
        CTX.bezierCurveTo(0.5 * iconSize, 0.0, 0.5 * iconSize, 0.0, 0.5 * iconSize, 0.0);
        CTX.bezierCurveTo(0.5 * iconSize, 0.0, 0.5 * iconSize, 0.0, 0.5 * iconSize, 0.0);
        CTX.bezierCurveTo(0.125 * iconSize, 0.0, 0.375 * iconSize, 0.5625 * iconSize, 0.0, 0.8125 * iconSize);
        CTX.bezierCurveTo(0.0, 0.8125 * iconSize, 0.0, 0.8125 * iconSize, 0.0, 0.8125 * iconSize);
        CTX.bezierCurveTo(0.0, 0.8125 * iconSize, 0.0, 0.8125 * iconSize, 0.0, 0.8125 * iconSize);
        CTX.bezierCurveTo(0.0, 0.8125 * iconSize, 0.0, 0.8125 * iconSize, 0.0625 * iconSize, 0.8125 * iconSize);
        CTX.bezierCurveTo(0.0625 * iconSize, 0.8125 * iconSize, 0.5 * iconSize, 0.8125 * iconSize, 0.5 * iconSize, 0.8125 * iconSize);
        CTX.bezierCurveTo(0.5 * iconSize, 0.8125 * iconSize, iconSize, 0.8125 * iconSize, iconSize, 0.8125 * iconSize);
        CTX.bezierCurveTo(iconSize, 0.8125 * iconSize, iconSize, 0.8125 * iconSize, iconSize, 0.8125 * iconSize);
        CTX.bezierCurveTo(iconSize, 0.8125 * iconSize, iconSize, 0.8125 * iconSize, iconSize, 0.8125 * iconSize);
        CTX.bezierCurveTo(iconSize, 0.8125 * iconSize, iconSize, 0.8125 * iconSize, iconSize, 0.8125 * iconSize);
        CTX.closePath();
        CTX.setFill(COLOR);
        CTX.fill();
        CTX.restore();
    }

    private void updateClock() {
        this.time.setLength(0);
        LocalTime now = LocalTime.now();
        this.pm = now.get(ChronoField.AMPM_OF_DAY) == 1;
        this.hours.set(now.getHour());
        String hourString = Integer.toString(this.hours.get());
        if (this.hours.get() < 10) {
            this.time.append("0");
            this.time.append(hourString.substring(0, 1));
        } else {
            this.time.append(hourString.substring(0, 1));
            this.time.append(hourString.substring(1));
        }
        this.time.append(":");
        this.minutes.set(now.getMinute());
        String minutesString = Integer.toString(this.minutes.get());
        if (this.minutes.get() < 10) {
            this.time.append("0");
            this.time.append(minutesString.substring(0, 1));
        } else {
            this.time.append(minutesString.substring(0, 1));
            this.time.append(minutesString.substring(1));
        }
        this.seconds.set(now.getSecond());
        if (this.isAlarmOn() && now.isAfter(this.getAlarm()) && now.isBefore(this.getAlarm().plusNanos(105000000L))) {
            this.fireAlarmEvent();
        }
    }

    private static synchronized void enableClockExecutorService() {
        if (null == periodicClockExecutorService) {
            periodicClockExecutorService = new ScheduledThreadPoolExecutor(1, RoundLcdClock.getThreadFactory("RoundLcdClock", true));
        }
    }

    private synchronized void scheduleClockTask() {
        RoundLcdClock.enableClockExecutorService();
        this.stopTask(this.periodicClockTask);
        this.periodicClockTask = periodicClockExecutorService.scheduleAtFixedRate(() -> {
            if (this.isVisible()) {
                Platform.runLater(() -> this.updateClock());
            }
        }, 1L, 1L, TimeUnit.SECONDS);
    }

    private static ThreadFactory getThreadFactory(String THREAD_NAME, boolean IS_DAEMON) {
        return runnable -> {
            Thread thread = new Thread(runnable, THREAD_NAME);
            thread.setDaemon(IS_DAEMON);
            return thread;
        };
    }

    private void stopTask(ScheduledFuture<?> task) {
        if (null == task) {
            return;
        }
        task.cancel(true);
        task = null;
    }

    private void resize() {
        this.size = this.getWidth() < this.getHeight() ? this.getWidth() : this.getHeight();
        this.width = this.getWidth();
        this.height = this.getHeight();
        if (this.width > 0.0 && this.height > 0.0) {
            this.pane.setMaxSize(this.size, this.size);
            this.pane.relocate((this.getWidth() - this.size) * 0.5, (this.getHeight() - this.size) * 0.5);
            this.canvasBkg.setWidth(this.size);
            this.canvasBkg.setHeight(this.size);
            this.canvasFg.setWidth(this.size);
            this.canvasFg.setHeight(this.size);
            this.canvasHours.setWidth(this.size);
            this.canvasHours.setHeight(this.size);
            this.canvasMinutes.setWidth(this.size);
            this.canvasMinutes.setHeight(this.size);
            this.canvasSeconds.setWidth(this.size);
            this.canvasSeconds.setHeight(this.size);
            this.drawBackground();
            this.drawForeground();
            this.drawHours();
            this.drawMinutes();
            this.drawSeconds();
        }
    }
}

