/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.enzo.splitflap;

import eu.hansolo.enzo.splitflap.FlipEvent;
import eu.hansolo.enzo.splitflap.skin.SplitFlapSkin;
import java.util.ArrayList;
import java.util.Arrays;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;
import javafx.scene.paint.Color;

public class SplitFlap
extends Control {
    public static final String[] TIME_0_TO_5 = new String[]{"1", "2", "3", "4", "5", "0"};
    public static final String[] TIME_0_TO_9 = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "0"};
    public static final String[] NUMERIC = new String[]{" ", "1", "2", "3", "4", "5", "6", "7", "8", "9", "0"};
    public static final String[] ALPHANUMERIC = new String[]{" ", "1", "2", "3", "4", "5", "6", "7", "8", "9", "0", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z"};
    public static final String[] ALPHA = new String[]{" ", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z"};
    public static final String[] EXTENDED = new String[]{" ", "1", "2", "3", "4", "5", "6", "7", "8", "9", "0", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "-", "/", ":", ",", "", ";", "@", "#", "+", "?", "!", "%", "$", "=", "<", ">"};
    public static final String[] EXTENDED_UMLAUTE = new String[]{" ", "1", "2", "3", "4", "5", "6", "7", "8", "9", "0", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "-", "/", ":", ",", "", ";", "@", "#", "+", "?", "!", "%", "$", "=", "<", ">", "\u00c4", "\u00d6", "\u00dc", "\u00df"};
    private final FlipEvent FLIP_FORWARD = new FlipEvent((Object)this, null, FlipEvent.FLIP_FORWARD);
    private final FlipEvent FIP_BACKWARD = new FlipEvent((Object)this, null, FlipEvent.FLIP_BACKWARD);
    private boolean keepAspect;
    private double _flipTime = 500.0;
    private DoubleProperty flipTime;
    private boolean _wordMode = false;
    private BooleanProperty wordMode;
    private boolean _withFixture = true;
    private BooleanProperty withFixture;
    private boolean _darkFixture = false;
    private BooleanProperty darkFixture;
    private boolean _squareFlaps = false;
    private BooleanProperty squareFlaps;
    private Color _flapColor = Color.rgb((int)59, (int)58, (int)53);
    private ObjectProperty<Color> flapColor;
    private Color _textColor = Color.WHITE;
    private ObjectProperty<Color> textColor;
    private String _text = "";
    private StringProperty text;
    private ArrayList<String> selectedSet;
    private String[] selection;
    private int currentSelectionIndex;
    private int nextSelectionIndex;
    private int previousSelectionIndex;

    public SplitFlap() {
        this(EXTENDED, " ");
    }

    public SplitFlap(String[] SELECTION, String TEXT) {
        this.getStyleClass().add((Object)"split-flap");
        this.keepAspect = true;
        this.selectedSet = new ArrayList(64);
        this.selection = SELECTION;
        this.currentSelectionIndex = 0;
        this.nextSelectionIndex = 1;
        this.previousSelectionIndex = this.selection.length - 1;
        this._text = TEXT;
        this.selectedSet.addAll(Arrays.asList(this.selection));
    }

    public final boolean isKeepAspect() {
        return this.keepAspect;
    }

    public final void setKeepAspect(boolean KEEP_ASPECT) {
        this.keepAspect = KEEP_ASPECT;
    }

    public final double getFlipTime() {
        return null == this.flipTime ? this._flipTime : this.flipTime.get();
    }

    public final void setFlipTime(double FLIP_TIME) {
        if (null == this.flipTime) {
            this._flipTime = FLIP_TIME;
        } else {
            this.flipTime.set(FLIP_TIME);
        }
    }

    public final DoubleProperty flipTimeProperty() {
        if (null == this.flipTime) {
            this.flipTime = new SimpleDoubleProperty((Object)this, "flipTime", this._flipTime);
        }
        return this.flipTime;
    }

    public final boolean isWordMode() {
        return null == this.wordMode ? this._wordMode : this.wordMode.get();
    }

    public final void setWordMode(boolean WORD_MODE) {
        if (null == this.wordMode) {
            this._wordMode = WORD_MODE;
        } else {
            this.wordMode.set(WORD_MODE);
        }
    }

    public final BooleanProperty wordModeProperty() {
        if (null == this.wordMode) {
            this.wordMode = new SimpleBooleanProperty((Object)this, "wordMode", this._wordMode);
        }
        return this.wordMode;
    }

    public final boolean isWithFixture() {
        return null == this.withFixture ? this._withFixture : this.withFixture.get();
    }

    public final void setWithFixture(boolean WITH_FIXTURE) {
        if (null == this.withFixture) {
            this._withFixture = WITH_FIXTURE;
        } else {
            this.withFixture.set(WITH_FIXTURE);
        }
    }

    public final BooleanProperty withFixtureProperty() {
        if (null == this.withFixture) {
            this.withFixture = new SimpleBooleanProperty((Object)this, "withFixture", this._withFixture);
        }
        return this.withFixture;
    }

    public final boolean isDarkFixture() {
        return null == this.darkFixture ? this._darkFixture : this.darkFixture.get();
    }

    public final void setDarkFixture(boolean DARK_FIXTURE) {
        if (null == this.darkFixture) {
            this._darkFixture = DARK_FIXTURE;
        } else {
            this.darkFixture.set(DARK_FIXTURE);
        }
    }

    public final BooleanProperty darkFixtureProperty() {
        if (null == this.darkFixture) {
            this.darkFixture = new SimpleBooleanProperty((Object)this, "darkFixture", this._darkFixture);
        }
        return this.darkFixture;
    }

    public final boolean isSquareFlaps() {
        return null == this.squareFlaps ? this._squareFlaps : this.squareFlaps.get();
    }

    public final void setSquareFlaps(boolean SQUARE_FLAPS) {
        if (null == this.squareFlaps) {
            this._squareFlaps = SQUARE_FLAPS;
        } else {
            this.squareFlaps.set(SQUARE_FLAPS);
        }
    }

    public final BooleanProperty squareFlapsProperty() {
        if (null == this.squareFlaps) {
            this.squareFlaps = new SimpleBooleanProperty((Object)this, "squareFlaps", this._squareFlaps);
        }
        return this.squareFlaps;
    }

    public final Color getFlapColor() {
        return null == this.flapColor ? this._flapColor : (Color)this.flapColor.get();
    }

    public final void setFlapColor(Color FLAP_COLOR) {
        if (null == this.flapColor) {
            this._flapColor = FLAP_COLOR;
        } else {
            this.flapColor.set((Object)FLAP_COLOR);
        }
    }

    public final ObjectProperty<Color> flapColorProperty() {
        if (null == this.flapColor) {
            this.flapColor = new SimpleObjectProperty((Object)this, "flapColor", (Object)this._flapColor);
        }
        return this.flapColor;
    }

    public final Color getTextColor() {
        return null == this.textColor ? this._textColor : (Color)this.textColor.get();
    }

    public final void setTextColor(Color TEXT_COLOR) {
        if (null == this.textColor) {
            this._textColor = TEXT_COLOR;
        } else {
            this.textColor.set((Object)TEXT_COLOR);
        }
    }

    public final ObjectProperty<Color> textColorProperty() {
        if (null == this.textColor) {
            this.textColor = new SimpleObjectProperty((Object)this, "textColor", (Object)this._textColor);
        }
        return this.textColor;
    }

    public final String getText() {
        return null == this.text ? this._text : (String)this.text.get();
    }

    public final void setText(char CHAR) {
        this.setText(Character.toString(CHAR));
    }

    public final void setText(String TEXT) {
        if (!TEXT.isEmpty() && this.selectedSet.contains(TEXT)) {
            if (null == this.text) {
                this._text = TEXT;
            } else {
                this.text.set((Object)TEXT);
            }
            this.currentSelectionIndex = this.selectedSet.indexOf(TEXT);
            this.nextSelectionIndex = this.currentSelectionIndex + 1 > this.selectedSet.size() ? 0 : this.currentSelectionIndex + 1;
        } else {
            if (null == this.text) {
                this._text = this.selectedSet.get(0);
            } else {
                this.text.set((Object)this.selectedSet.get(0));
            }
            this.currentSelectionIndex = 0;
            this.nextSelectionIndex = this.currentSelectionIndex + 1 > this.selectedSet.size() ? 0 : this.currentSelectionIndex + 1;
        }
    }

    public final StringProperty textProperty() {
        if (null == this.text) {
            this.text = new SimpleStringProperty((Object)this, "text", this._text);
        }
        return this.text;
    }

    public final String getNextText() {
        return this.selectedSet.get(this.nextSelectionIndex);
    }

    public final String getPreviousText() {
        return this.selectedSet.get(this.previousSelectionIndex);
    }

    public final String[] getSelection() {
        return this.selection;
    }

    public final void setSelection(String[] SELECTION) {
        this.selection = SELECTION;
        this.selectedSet.clear();
        this.selectedSet.addAll(Arrays.asList(this.selection));
    }

    public final ArrayList<String> getSelectedSet() {
        return this.selectedSet;
    }

    public final void flipForward() {
        this.previousSelectionIndex = this.currentSelectionIndex++;
        if (this.currentSelectionIndex >= this.selectedSet.size()) {
            this.currentSelectionIndex = 0;
        }
        this.nextSelectionIndex = this.currentSelectionIndex + 1;
        if (this.nextSelectionIndex >= this.selectedSet.size()) {
            this.nextSelectionIndex = 0;
        }
        this.setText(this.selectedSet.get(this.currentSelectionIndex));
        this.fireEvent(this.FLIP_FORWARD);
    }

    public final void flipBackward() {
        this.fireEvent(this.FIP_BACKWARD);
        ((SplitFlapSkin)this.getSkin()).flipBackward();
    }

    public boolean isResizable() {
        return true;
    }

    protected Skin createDefaultSkin() {
        return new SplitFlapSkin(this);
    }

    public String getUserAgentStylesheet() {
        return ((Object)((Object)this)).getClass().getResource(((Object)((Object)this)).getClass().getSimpleName().toLowerCase() + ".css").toExternalForm();
    }
}

