/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.enzo.validationpane;

import eu.hansolo.enzo.validationpane.ValidationPane;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.geometry.Pos;
import javafx.scene.image.Image;

public class Validator {
    public static final int IMG_SIZE = 12;
    public static final int IMG_OFFSET = 6;
    private DoubleProperty alpha = new SimpleDoubleProperty(1.0);
    private State state;
    private String _infoText;
    private StringProperty infoText;
    private Pos validatorPosition;
    private double iconLocationX;
    private double iconLocationY;

    public Validator(State STATE) {
        this(STATE, Pos.TOP_LEFT, "");
    }

    public Validator(State STATE, Pos POSITION) {
        this(STATE, POSITION, "");
    }

    public Validator(State STATE, Pos POSITION, String INFO_TEXT) {
        this.state = STATE;
        this.validatorPosition = POSITION;
        this._infoText = INFO_TEXT;
        this.iconLocationX = 0.0;
        this.iconLocationY = 0.0;
    }

    public State getState() {
        return this.state;
    }

    public void setState(State STATE) {
        this.state = STATE;
    }

    public Pos getValidatorPosition() {
        return this.validatorPosition;
    }

    public void setValidatorPosition(Pos VALIDATOR_POSITION) {
        this.validatorPosition = VALIDATOR_POSITION;
    }

    public double getIconLocationX() {
        return this.iconLocationX;
    }

    public void setIconLocationX(double X) {
        this.iconLocationX = X;
    }

    public double getIconLocationY() {
        return this.iconLocationY;
    }

    public void setIconLocationY(double Y) {
        this.iconLocationY = Y;
    }

    public double[] getIconLocation() {
        return new double[]{this.iconLocationX, this.iconLocationY};
    }

    public void setIconLocation(double X, double Y) {
        this.iconLocationX = X;
        this.iconLocationY = Y;
    }

    public Image getIcon() {
        return this.state.IMAGE;
    }

    public String getInfoText() {
        return null == this.infoText ? this._infoText : (String)this.infoText.get();
    }

    public void setInfoText(String INFO_TEXT) {
        if (null == this.infoText) {
            this._infoText = INFO_TEXT;
        } else {
            this.infoText.set((Object)INFO_TEXT);
        }
    }

    public StringProperty infoTextProperty() {
        if (null == this.infoText) {
            this.infoText = new SimpleStringProperty((Object)this, "infoText", this._infoText);
        }
        return this.infoText;
    }

    public double getAlpha() {
        return this.alpha.get();
    }

    public void setAlpha(double ALPHA) {
        this.alpha.set(ALPHA);
    }

    public DoubleProperty alphaProperty() {
        return this.alpha;
    }

    public static enum State {
        VALID("Valid", new Image(ValidationPane.class.getResource("valid.png").toExternalForm(), 12.0, 12.0, true, false)),
        INVALID("Invalid", new Image(ValidationPane.class.getResource("invalid.png").toExternalForm(), 12.0, 12.0, true, false)),
        INFO("Information", new Image(ValidationPane.class.getResource("info.png").toExternalForm(), 12.0, 12.0, true, false)),
        OPTIONAL("Option", new Image(ValidationPane.class.getResource("optional.png").toExternalForm(), 12.0, 12.0, true, false)),
        CLEAR("", null);

        public final String TEXT;
        public final Image IMAGE;

        private State(String TEXT, Image IMAGE) {
            this.TEXT = TEXT;
            this.IMAGE = IMAGE;
        }
    }
}

