/*
 * This is a simple test program for Rexx/SQL.  It simply connects to
 * the database using the supplied username, password and database
 * specified as arguments.
 * Run this as:
 * rexxsql simple.cmd user=username pass=password data=database
 *
 * If your database does not require values for any of the parameters,
 * simply leave the parameter out. eg rexxsql simple.cmd data=MYDB
 *
 * This program will unload the Rexx/SQL external functions on exit,
 * so don't run this if unloading the external functions could cause
 * other running Rexx/SQL programs to fail.
 */
Signal On Syntax
Parse Arg . 'user=' username . 1 . 'pass=' password . 1 . 'data=' database .
If username = '' & password = '' & database = '' Then
  Do
     Say 'Usage: simple.cmd user=username pass=password data=database'
     Exit 1
  End
If RxFuncQuery('SQLLoadFuncs') Then
  Do
     Call RxFuncAdd 'SQLLoadFuncs', 'rexxsql', 'SQLLoadFuncs'
     Call SQLLoadFuncs
  End
If SQLConnect( 'c1', username, password, database ) < 0 Then Call Abort( 'connecting' )
Say 'Connect succeeded!'
Say 'Rexx/SQL Version:' SQLVariable( 'VERSION' )
If SQLGetinfo('c1','DBMSNAME','desc.') < 0 Then Call Abort( 'getting db version' )
Say 'Database Name:   ' desc.1
If SQLGetinfo('c1','DBMSVERSION','desc.') < 0 Then Call Abort( 'getting db version' )
Say 'Database Version:' desc.1
If SQLDisconnect( 'c1' ) < 0 Then Call Abort( 'disconnecting' )
Say 'Disconnect succeeded!'
Call SQLDropFuncs 'UNLOAD'
Return

Abort: Procedure Expose sqlca.
Parse Arg msg
Say 'Program failed:' msg
Say sqlca.interrm
Say sqlca.sqlerrm
Call SQLDropFuncs 'UNLOAD'
Exit 1

Syntax: Procedure Expose sqlca.
Call Abort 'syntax error on line' sigl
Return
