/** Msgcont.cmd **/
/*********************************************/
/*                                           */
/* Command line syntax:                      */
/*                                           */
/* msgcont db_path user_password user_name   */
/*                                           */
/*                                           */
/*********************************************/
ARG db_path user_pw user_name
'@echo off'
'@cls'
Say 'RexxVIM Message Container Demonstration Program'
Say

/* Unload the function upon error */
SIGNAL ON ERROR NAME done

/* Prompt for the parameters if not passed on the */
/* command line                                   */
if LENGTH(STRIP(db_path)) = 0 then do
   Say 'Enter Postoffice Directory -'
   PARSE PULL db_path .
   Say
   Say 'Enter User Name -'
   PARSE PULL user_name
   Say 'Enter Password -'
   PARSE PULL user_pw
end  /* Do */


/* Load the RexxVIM extensions to Rexx */
rc = RxFuncAdd('RxVIMLoadFuncs', 'REXXVIM', 'RxVIMLoadFuncs')
if rc <> 0 then do
   Say
   Say 'RexxVIM failed to load, return code' rc
   Say
   Say 'Functions have been released.  Retry program.'
   signal done
end  /* Do */
call RxVIMLoadFuncs
Say 'Functions are now loaded'
Say


/* Initialize the VIM subsystem */
rc = RxVIMInitialize()
if (rc > 0) then call vimerr

/* Open a session with the postoffice using the parameters */
/* provided by the user                                    */
rc = RxVIMOpenSession(db_path,user_name,user_pw,Session)
if (rc > 0) then call vimerr


/* Open the default message container -- Inbox */
rc = RxVIMOpenMessageContainer(Session,'','Inbox')
if (rc > 0) then call vimerr


/* Query the message container for new mail */
rc = RxVIMQueryNewMessages(Inbox,'New_Mail')
if (rc > 0) then call vimerr
Say '--------------------------------------------------------'
Say '      New Mail Flag is' New_Mail


/* Query the number of new messages */
rc = RxVIMQueryUnreadMailCount(Inbox,'Unread_Count')
if (rc > 0) then call vimerr
Say '   Number of unread messages is' Unread_Count
Say '--------------------------------------------------------'
Say


/* Display all messages in Inbox if new mail exists */

if New_Mail = 'True' then do

     Say 'To review all messages in Inbox,'
     'pause'

     /* Enumerate messages in container -- Inbox */
     pos = ''                           /* Start at the beginning of the container */
     skipcnt = 1                        /* Move forward through the container one at a time */
     mcount  = 1                        /* Retrieve 1 message for each call */
     filter  = 'VIMSEL_NO_FILTER'       /* No filter, return all messages in inbox */
     fdata   = ''                       /* No filter data */
     flags   = 'VIM_NO_FLAGS'           /* No enumeration flags, return all messages in inbox */
     more    = ''                       /* Set the value of more to nul */
     action  = 'N'                      /* Set the value of repeat loop indicator to N */

     AttrDesc.0 = 2                          /* Retrieve 2 attributes for each message */
     AttrDesc.1.Selector = 'VIMSEL_REF'      /* 1st attribute is the message reference number */
     AttrDesc.1.Buffer   = 'MsgRefNo'        /* store results in this stem variable */
     AttrDesc.2.Selector = 'VIMSEL_SUBJECT'  /* 2nd attribute is the message subject */
     AttrDesc.2.Buffer   = 'Subject'         /* store results in this stem variable */

     do until TRANSLATE(SUBSTR(action,1,1)) = 'X'

          /* Continue retrieving message info until user enters N */

          rc = RxVIMEnumerateMessages(Inbox,'pos',skipcnt,'AttrDesc','mcount',filter,fdata,flags,'more')
          if (rc > 0) then call vimerr

          /* Display results */
         'cls'
          Say 'RexxVIM - (c) Innovative Business Technologies, Inc'
          Say
          Say 'Message Container Demo'
          Say
          Say '--------------------------------------------------------'
          Say '    Message =' MsgRefNo.1
          Say '    Subject =' Subject.1
          Say '--------------------------------------------------------'
          Say
          Say
          Say 'Select an action for this message'
          Say
          Say '   D - Delete message'
          Say '   F - File message in a folder'
          Say '   N - Go to next message, leave this one in the Inbox'
          Say '   X - Exit demo now'
          Say
          Say 'Enter your selection below:'
          PULL action
          if more = 'False' then do
             Say 'All messages have been retrieved'
             action = 'X'
          end  /* Do */

          /* Process the selection entered.  X will fall through the select statement */
          select
             when TRANSLATE(SUBSTR(action,1,1)) = 'D' then do
                /* Delete message */
                rc = RxVIMRemoveMessage(Inbox,MsgRefNo.1)
                if (rc > 0) then call vimerr
           end  /* Do */
             when TRANSLATE(SUBSTR(action,1,1)) = 'F' then do
                /* File message in folder */
                Say 'Enter the name of the folder:'
                PULL category
                 rc = RxVIMSetMessageCategory(Inbox,MsgRefNo.1,category)
                if (rc > 0) then call vimerr
             end  /* Do */
             when TRANSLATE(SUBSTR(action,1,1)) = 'N' then do
                /* Go to the next message */
                /* Nothing to do.....loop will pull next message */
             end  /* Do */
          otherwise
          end  /* select */
     end /* do */
end  /* Do */


/* Close the message container -- Inbox */
rc = RxVIMCloseMessageContainer(Inbox)
if (rc > 0) then call vimerr


/* Close the session with the postoffice */
rc = RxVIMCloseSession(Session)
if (rc > 0) then call vimerr


/* Terminate the active VIM subsystem connection */
rc = RxVIMTerminate()
if (rc > 0) then call vimerr
signal done


/***** VIMErr *******/

/* If an error occurs, this function will return the text */
/* associated with the error.  Extended text may be       */
/* displayed if it exists for the specified error.        */

VIMERR:

erc = RxVIMStatusText(Session,rc,'Status')
Say
Say '|-Error Information ------------------------------------|'
Say '  Error Text -' status.1
Say
Say '  Ext Status -' status.2
rc = RxVIMTerminate()
signal done


/* The done section will unload the RexxVIM extensions */
/* and exit the program                                */
DONE:
/*** Drop all of the external functions ***/
call RxVIMDropFuncs
Say '|-------------------------------------------------------|'
Say 'Demo Complete.  All functions released'
'pause'
exit
