/** NtsMsg.cmd **/
/******************************************/
/*                                        */
/* Command line syntax:                   */
/*                                        */
/* NtsMsg user_name                       */
/*                                        */
/*                                        */
/******************************************/
ARG user_name
'@echo off'
'@cls'
Say 'RexxVIM Message Demonstration Program'
Say 'for Lotus Notes'
Say

/* Unload functions upon error */
SIGNAL ON ERROR NAME done

/* Prompt for the parameters if not passed on the */
/* command line                                   */
if LENGTH(STRIP(user_name)) = 0 then do
   user_name = ''
   Say 'Send Message To -'
   PARSE PULL user_name
end  /* Do */


/* Load the RexxVIM extensions to Rexx */
rc = RxFuncAdd('RxVIMLoadFuncs', 'REXXVIM', 'RxVIMLoadFuncs')
if rc <> 0 then do
   Say
   Say 'RexxVIM failed to load, return code' rc
   Say
   Say 'Functions have been released.  Retry program.'
   signal done
end  /* Do */
call RxVIMLoadFuncs
Say 'Functions are now loaded'
Say


/* Initialize the VIM subsystem */
Session = ''
rc = RxVIMInitialize()
Say
Say '|-Call To Routine -------------------------RC--|'
Say '  RxVIMInitialize -              ' RxVIMStatus(rc)
if (rc > 0) then call vimerr


/* Open a session with the postoffice using the parameters */
/* provided by the user                                    */
Session = ''
rc = RxVIMOpenSession('','','','Session')
Say '  RxVIMOpenSession -             ' RxVIMStatus(rc)
if (rc > 0) then call vimerr


/* Create a new message of type VIM_MAIL */
rc = RxVIMCreateMessage(Session,'VIM_MAIL','Message')
Say '  RxVIMCreateMessage -           ' RxVIMStatus(rc)
if (rc > 0) then call vimerr


/* Set the header text */
hdrtext = user_name"'s config.sys file"
rc = RxVIMSetMessageHeader(Message,'VIMSEL_SUBJECT', hdrtext)
Say '  RxVIMSetMessageHeader -        ' RxVIMStatus(rc)
if (rc > 0) then call vimerr


/* Set the recipient to the user that is logged on */
/* This will send the message back to ourselves    */
rc = RxVIMSetMessageRecipient(Message,'VIMSEL_TO','VIMSEL_UNKNOWN_RECIP_TYPE','VIMSEL_NATIVE','',,
                user_name,'','')
Say '  RxVIMSetMessageRecipient -     ' RxVIMStatus(rc)
if (rc > 0) then call vimerr


/* Add some text to the message */
itemtxt = 'This message was created using the VIM Toolkit for Rexx!!'
rc = RxVIMSetMessageItem(Message,'VIMSEL_NOTE_PART','VIM_TEXT','',,
         'Message Demo',itemtxt,'')
Say '  RxVIMSetMessageItem -          ' RxVIMStatus(rc)
if (rc > 0) then call vimerr


/* Send the message */
rc = RxVIMSendMessage(Message)
Say '  RxVIMSendMessage -             ' RxVIMStatus(rc)
if (rc > 0) then call vimerr


/* Close the session with the postoffice */
rc = RxVIMCloseSession(Session)
Say '  RxVIMCloseSession -            ' RxVIMStatus(rc)
if (rc > 0) then call vimerr


/* Terminate the active VIM subsystem connection */
rc = RxVIMTerminate()
Say '  RxVIMTerminate -               ' RxVIMStatus(rc)
if (rc > 0) then call vimerr
signal done


/***** VIMErr *******/

/* If an error occurs, this function will return the text */
/* associated with the error.  Extended text may be       */
/* displayed if it exists for the specified error.        */

VIMERR:

rc = RxVIMStatusText(Session,rc,'Status')
Say
Say '|-Error Information ---------------------------|'

if Status.1 = 'STATUS.1' then
  Say 'Cannot obtain error status information'
else do
  Say '  Error Text -' Status.1
  Say
  Say '  Ext Status -' Status.2
end

rc = RxVIMTerminate()
signal done


/* The done section will unload the RexxVIM extensions */
/* and exit the program                                */
DONE:
/*** Drop all of the external functions ***/
call RxVIMDropFuncs
Say '|----------------------------------------------|'
Say 'Demo Complete.  All functions released'
'pause'
exit
