/*:VRX         Main
*/
/*  Main
*/
Main:
/*  Process the arguments.
    Get the parent window.
*/
    parse source . calledAs .
    parent = ""
    argCount = arg()
    argOff = 0
    if( calledAs \= "COMMAND" )then do
        if argCount >= 1 then do
            parent = arg(1)
            argCount = argCount - 1
            argOff = 1
        end
    end
    InitArgs.0 = argCount
    if( argCount > 0 )then do i = 1 to argCount
        InitArgs.i = arg( i + argOff )
    end
    drop calledAs argCount argOff

/*  Load the windows
*/
    call VRInit
    parse source . . spec
    _VREPrimaryWindowPath = ,
        VRParseFileName( spec, "dpn" ) || ".VRW"
    _VREPrimaryWindow = ,
        VRLoad( parent, _VREPrimaryWindowPath )
    drop parent spec
    if( _VREPrimaryWindow == "" )then do
        call VRMessage "", "Cannot load window:" VRError(), ,
            "Error!"
        _VREReturnValue = 32000
        signal _VRELeaveMain
    end

/*  Process events
*/
    call Init
    signal on halt
    do while( \ VRGet( _VREPrimaryWindow, "Shutdown" ) )
        _VREEvent = VREvent()
        interpret _VREEvent
    end
_VREHalt:
    _VREReturnValue = Fini()
    call VRDestroy _VREPrimaryWindow
_VRELeaveMain:
    call VRFini
exit _VREReturnValue

VRLoadSecondary: procedure
    name = arg( 1 )

    window = VRLoad( VRWindow(), VRWindowPath(), name )
    call VRMethod window, "CenterWindow"
    call VRSet window, "Visible", 1
    call VRMethod window, "Activate"
return window

/*:VRX         digit_Click
*/
digit_Click:
    number = VRGet( VRInfo( "Object" ), "Caption" )
    call number_click number
return
/*:VRX         do_previous_operation
*/
do_previous_operation:

    /* Check for an error state */
    if( error_is_on = 1 ) then return

    /* Check if any numbers have been pressed */
    if( new_number = 0 )then do
        operand = arg( 1 )
        return
      end

    /* Get the current number on the screen */
    display_current = VRGet( 'dt_display', 'Caption' )

    /* Do the previous operation with the previous number */
    if( operand = '+' ) then
        display = display_previous + display_current
    else if( operand = '-' ) then
        display = display_previous - display_current
    else if( operand = '*' ) then
        display = display_previous * display_current
    else if( operand = '/' ) then do
        if( display_current = 0 ) then do           /* Divide by zero error */
            error_is_on = 1
            call update_memory_display 'e'
            display = 0
          end
        else
            display = display_previous / display_current
      end
    else
        display = display_current

    /* Update the operand */
    operand = arg( 1 )
    new_number = 0

    /* Update the display */
    display_previous = display
    start_new_display = 1
    call update_display

return
/*:VRX         Fini
*/
Fini:
    window = VRWindow()
    call VRSet window, 'Visible', '0'
    drop window
return 0
/*:VRX         Halt
*/
Halt:
    signal _VREHalt
return

/*:VRX         Init
*/
Init:
    memory_total = 0
    call pb_c_Click

    window = VRWindow()
    call VRMethod window, 'CenterWindow'
    call VRSet window, 'Visible', '1'
    call VRMethod window, 'Activate'
    drop window

    ValidKeys.1 = "1"
    ValidKeys.2 = "2"
    ValidKeys.3 = "3"
    ValidKeys.4 = "4"
    ValidKeys.5 = "5"
    ValidKeys.6 = "6"
    ValidKeys.7 = "7"
    ValidKeys.8 = "8"
    ValidKeys.9 = "9"
    ValidKeys.10 = "0"
    ValidKeys.11 = "."
    ValidKeys.12 = "-"
    ValidKeys.13 = "*"
    ValidKeys.14 = "/"
    ValidKeys.15 = "+"
    ValidKeys.16 = "="
    ValidKeys.17 = "%"
    ValidKeys.18 = "{F5}"
    ValidKeys.19 = "{F6}"
    ValidKeys.20 = "{F7}"
    ValidKeys.21 = "{F8}"
    ValidKeys.22 = "c"
    ValidKeys.23 = "C"
    ValidKeys.24 = "e"
    ValidKeys.25 = "E"
    ValidKeys.0 = 25

    /* Find the "=" button */
    obj = VRGet( "operator", "Self" )
    do forever
        if VRGet( obj, "Caption" ) = "=" then leave
        obj = VRGet( obj, "Sibling" )
    end
    call VRMethod obj, "SetFocus"

return


/*:VRX         Is_Valid_Key
*/
Is_Valid_Key:

key = arg( 1 )
do check = 1 to ValidKeys.0
    if key = ValidKeys.Check then do
        select
            when check < 12 then return "number"
            when check > 11 & check < 17 then return "operator"
            when check > 16 then return "other"
        end
    end
end

return 0

/*:VRX         Key_Handler
*/
Key_Handler:

keyhit = arg( 1 )
keytype = Is_Valid_Key( keyhit )

if (keytype = "operator" | keytype = "number") then do
    if keytype = "number" then do
        call number_click keyhit
    end
    else do
        call do_previous_operation keyhit
    end
end
else do
    select
        when keyhit = "%" then call pb_percent_click
        when keyhit = "{F5}" then call pb_mplus_click
        when keyhit = "{F6}" then call pb_mminus_click
        when keyhit = "{F7}" then call pb_mr_click
        when keyhit = "{F8}" then call pb_mc_click
        when keyhit = "c" then call pb_c_click
        when keyhit = "C" then call pb_c_click
        when keyhit = "e" then call pb_ce_click
        when keyhit = "E" then call pb_ce_click
        otherwise
    end
end

return

/*:VRX         number_click
*/
number_click:
    /* Check for an error state */
    if( error_is_on = 1 ) then
        return

    num = arg( 1 )
    new_number = 1

    if( start_new_display = 1 ) then do
        start_new_display = 0
        display = num

        if( num = '.' ) then  do    /* Check if the first character is a decimal */
            display ='0.'
            decimal_flag = 1
          end
        else
            decimal_flag = 0

        if( num = '0' ) then        /* Check if the first character is a zero */
            start_new_display = 1

        call update_display
        return
      end

    if( num = '.' ) then do
        decimal_flag = 1
        return
      end

    if( decimal_flag = 1) then
        display = display || num
    else do
        parse var display display'.'
        display = display || num || '.'
      end

    call update_display
return
/*:VRX         operator_Click
*/
operator_Click:
    handle = VRInfo( "Object" )
    if handle \= "" then do
        operator = VRGet( handle, "Caption" )
        call do_previous_operation operator
    end
return
/*:VRX         pb_c_Click
*/
pb_c_Click:
    display_previous = 0
    display_current = 0
    start_new_display = 1
    operand = ''
    display = 0
    decimal_flag = 0
    new_number = 1
    error_is_on = 0
    call update_display
    call update_memory_display memory_total
return
/*:VRX         pb_ce_Click
*/
pb_ce_Click:
    if( error_is_on = 1 ) then return
    display = 0
    start_new_display = 1
    call update_display
    new_number = 1
return
/*:VRX         pb_mc_Click
*/
pb_mc_Click:
    if( error_is_on = 1 ) then return
    memory_total = 0
    call update_memory_display memory_total
return
/*:VRX         pb_mminus_Click
*/
pb_mminus_Click:
    if( error_is_on = 1 ) then return
    memory_temp = VRGet( 'dt_display', 'Caption' )
    memory_total = memory_total - memory_temp
    call update_memory_display memory_total
    start_new_display = 1
return
/*:VRX         pb_mplus_Click
*/
pb_mplus_Click:
    if( error_is_on = 1 ) then return
    memory_temp = VRGet( 'dt_display', 'Caption' )
    memory_total = memory_total + memory_temp
    call update_memory_display memory_total
    start_new_display = 1
return
/*:VRX         pb_mr_Click
*/
pb_mr_Click:
    if( error_is_on = 1 ) then return
    display = memory_total
    call update_display
    start_new_display = 1
    new_number = 1
return
/*:VRX         pb_percent_Click
*/
pb_percent_Click:
    display = display / 100
    call update_display
return
/*:VRX         Quit
*/
Quit:
    window = VRWindow()
    call VRSet window, 'Shutdown', '1'
    drop window
return
/*:VRX         update_display
*/
update_display:
    /* Update the display area */
    tmp = POS( 'E', display )
    parse var display whole'.'fraction             /* Split into whole and fraction */

    if( new_number = 0 ) then
        if( tmp = 0 ) then
            fraction = strip( fraction, 'T', 0 )   /* Strip the trailing zeros from the fraction */

    display = whole || '.' || fraction             /* Concatenate the whole and fraction */
    call VRSet 'dt_display', 'Caption', display
return
/*:VRX         update_memory_display
*/
update_memory_display:
    if( arg( 1 ) = 'e' ) then
        call VRSet 'dt_memory', 'caption', 'E'
    else if( arg( 1 ) = 0 ) then
        call VRSet 'dt_memory', 'caption', ''
    else
        call VRSet 'dt_memory', 'caption', 'M'
return
/*:VRX         Window1_Close
*/
Window1_Close:
    call Quit
return
/*:VRX         Window1_KeyPress
*/
Window1_KeyPress:

obj = VRInfo( "object" )
call Key_Handler VRGet( obj, "KeyString" )

return

