/*
 * patch.cmd -- Patch VX-REXX 2.0A to 2.0B.
 */
 
if( FileExists( 'VROBJ.DLL' ) \= 1 )then do
    say "Please place the patch files and this command file in your"
    say "VX-REXX directory and run the patch command from there."
    exit
end

say "Patching VX-REXX 2.0A to 2.0B...."

files = 'pmexe.exe vredit.dll vrobj.dll vrsed.dll vrxedit.exe'

address cmd

if( FileExists( 'PMEXE.NRZ' ) )then do
    'copy pmexe.nrz pmexe.exe'
    'erase pmexe.nrz'
end

if( FileExists( 'PMRUN.NRZ' ) )then do
    'copy pmrun.nrz pmrun.exe'
    'erase pmrun.nrz'
end

do i = 1 to words( files )
    call Patch word( files, i )
end

/* Patch the other files... */

'bplevel pmdbg.exe pmdbg.b'
'bplevel vrx.exe vrx.b'
'bplevel progguid.inf progguid.b'
'bplevel a2z.inf a2z.b'

say "Rebuilding the folder..."
call buildvrx

say "Patch done."
exit


Patch: procedure
    arg file
    name = left( file, pos( '.', file ) - 1 )
    
    say "Patching file" file || "..."
    
    'copy' file name || '.BAK'
    'bpatch -p -b' name || '.B'
    
    if( rc = 0 )then do
        'erase' name || '.B'
    end
return


FileExists: procedure
return( stream( arg(1), 'c', 'query exists' ) \= '' )
