/*
 * buildodk.cmd -- Build the VX-REXX ODK folder...
 */
 
/* 
 * Only include samples that need to have /h /obj and /objd directories
 * created. (i.e. not macros)
 */
samples           = "test mousebx scrollba boundpb custom splitbar texttabl"

address CMD

'@echo off'

call RXFuncAdd 'SysLoadFuncs', 'REXXUTIL', 'SysLoadFuncs'
call SysLoadFuncs

call setlocal

/*
 * The target directory is the parm we were passed... make sure
 * the directory exists...
 */

target_dir   = ''
folder_title = ''

parse arg target_dir folder_title "," noecho

if( target_dir = '?' | target_dir = '/?' )then
    call Usage

if( folder_title = '' )then
    folder_title = 'VX-REXX ODK'

target_dir=strip(target_dir, "t", "\" )
if( target_dir = '' )then
    target_dir = directory()

if( directory( target_dir ) = '' )then
    call Usage

target_dir = directory( target_dir )

/*
 * Clean things up first...
 */

call CleanIni
call MakeEmptyDirs
/*
 * Create the main folder object
 */
 
szVideoMode = "1024x768"

R1x = 5;
R2x = 5;
R1y = 25; /* 45; */
nDeltaY = -10;
nDeltaX = 13;
if noecho="" then do
    say 'Building Workplace Shell VX-REXX ODK Objects...'
end 
R2y = R1y - 25

classname = 'WPFolder'
title     = folder_title
location  = '<WP_DESKTOP>'
iconparm  = 'ICONFILE=' || target_dir || '\odk.ico;'
setup     = 'ICONVIEWPOS=10,70,80,30;'||,
            'OBJECTID=<VXREXX_ODK>;' || iconparm

call SysCreateObject classname, title, location, setup, 'r'

R1x = 5;
R1y = R1y + nDeltaY;
classname = 'WPFolder'
title     = 'Books'
location  = '<VXREXX_ODK>'
iconparm  = 'ICONFILE=' || target_dir || '\books.ico;'
setup     = 'ICONVIEW=FLOWED;' ||,
            'ICONPOS=' || R1x || ',' || R1y || ';' ||,
            'OBJECTID=<VXREXX_ODK_BOOKS>;' || iconparm

call SysCreateObject classname, title, location, setup, 'r'

/*
 * Create a shadow of the REXX information
 */

classname = 'WPProgram'
title     = 'REXX API Information'
location  = '<VXREXX_ODK_BOOKS>'
setup     = 'EXENAME=view.exe;' ||,
            'PROGTYPE=PM;' ||,
            'ICONPOS=' || R1x || ',' || R1y || ';' ||,
            'PARAMETERS=rexxapi.inf;'

call SysCreateObject classname, title, location, setup, 'r'

/*
 * Create a shadow of the SOM information
 */

classname = 'WPProgram'
title     = 'SOM Information'
location  = '<VXREXX_ODK_BOOKS>'
setup     = 'EXENAME=view.exe;' ||,
            'PROGTYPE=PM;' ||,
            'PARAMETERS=som.inf;'

call SysCreateObject classname, title, location, setup, 'r'

/*
 * Create the book program objects
 */

classname = 'WPProgram'
title     = 'VX-REXX ODK' || '0a'x || 'Reference'
location  = '<VXREXX_ODK_BOOKS>'
setup     = 'EXENAME=view.exe;' ||,
            'PROGTYPE=PM;' ||,
            'PARAMETERS=ODKA2Z.INF;' ||,
            'STARTUPDIR=' || target_dir || '\BOOKS;'
call SysCreateObject classname, title, location, setup, 'r'

classname = 'WPProgram'
title     = "VX-REXX ODK" || "0a"x || "Programmer's Guide"
location  = '<VXREXX_ODK_BOOKS>'
setup     = 'EXENAME=view.exe;' ||,
            'PROGTYPE=PM;' ||,
            'PARAMETERS=ODKProg.INF;' ||,
            'STARTUPDIR=' || target_dir || '\BOOKS;'
call SysCreateObject classname, title, location, setup, 'r'

/*
 * Create the Readme program object
 */
classname = 'WPProgram'
title     = 'Read Me First'
location  = '<VXREXX_ODK>'
setup     = 'EXENAME=view.exe;' ||,
            'PROGTYPE=PM;' ||,
            'ICONPOS=' || R2x || ',' || R2y || ';' ||,
            'PARAMETERS=' || target_dir || '\readme.inf;' ||,
            'STARTUPDIR=' || target_dir || ';'

call SysCreateObject classname, title, location, setup, 'r'

/*
 * Create a shadow for VX-REXX
 */
 
R2x = R2x + nDeltaX;
classname = 'WPShadow'
title     = 'VX-REXX'
location  = '<VXREXX_ODK>'
setup     = 'ICONPOS=' R2x || "," || R2y || ";" ||,
            'SHADOWID=<VXREXX_FOLDER>;'

call SysCreateObject classname, title, location, setup, 'r'

/*
 * Create the projects folder
 */
R2x = R2x + nDeltaX;
classname = 'WPShadow'
title     = 'Projects'
location  = '<VXREXX_ODK>'
setup     = 'SHADOWID=' || target_dir || '\PROJECTS;OBJECTID=<VXREXX_ODK_PROJECTS>;'||,
             'ICONPOS=' R2x || "," || R2y || ";"

call SysCreateObject classname, title, location, setup, 'r'

call AddTemplate

/*
 * Create the samples folder
 */

R2x = R2x + nDeltaX;
classname = 'WPShadow'
title     = 'Projects'
location  = '<VXREXX_ODK>'
setup     = 'ICONPOS=' R2x || "," || R2y || ";" ||,
            'SHADOWID=' || target_dir || '\SAMPLES;OBJECTID=<VXREXX_ODK_SAMPLES>;'

call SysCreateObject classname, title, location, setup, 'r'

/*
 * Create the dlls folder
 */

R2x = R2x + nDeltaX;
classname = 'WPShadow'
title     = 'Objects'
location  = '<VXREXX_ODK>'
setup     = 'ICONPOS=' R2x || "," || R2y || ";" ||,
            'SHADOWID=' || target_dir || '\DLL;OBJECTID=<VXREXX_ODK_OBJECTS>;'

call SysCreateObject classname, title, location, setup, 'r'


/*
 * Create a reference for the odkbar
 */
R1x = R1x + nDeltaX;
classname = 'WPProgram'
title     = 'Quick Access'
location  = '<VXREXX_ODK>'
setup     = 'ICONPOS=' R1x || "," || R1y || ";" ||,
            'EXENAME=' || target_dir || '\BIN\odkbar.exe;' ||,
            'PROGTYPE=PM;'

call SysCreateObject classname, title, location, setup, 'r'

/*
 * Create a reference for the browser
 */
R1x = R1x + nDeltaX;
classname = 'WPProgram'
title     = 'VXBrowse'
location  = '<VXREXX_ODK>'
setup     = 'EXENAME=' || target_dir || '\BIN\vxbrowse.exe;' ||,
            'ICONPOS=' R1x || "," || R1y || ";" ||,
            'PROGTYPE=PM;' ||,
            'ASSOCFILTER=*.CLS;'

call SysCreateObject classname, title, location, setup, 'r'

/*
 * Create a reference for the tester
 */
 /*
R1x = R1x + nDeltaX;
classname = 'WPProgram'
title     = 'Object Library Test'
location  = '<VXREXX_ODK>'
setup     = 'EXENAME=' || target_dir || '\BIN\testlib.exe;' ||,
            'ICONPOS=' R1x || "," || R1y || ";" ||,
            'PROGTYPE=PM;'

call SysCreateObject classname, title, location, setup, 'r'
*/


/*
 * Open the folder... 
 */

call SysSetObjectData '<VXREXX_ODK>', 'OPEN=DEFAULT;'

exit

/****************************** End of Program ****************************/

/*
 * AddTemplate
 */

AddTemplate:

    classname = 'WPFolder'
    title     = 'New'
    location  = target_dir || '\Projects'
    setup     = 'TEMPLATE=yes;'

    call SysCreateObject classname, title, location, setup, 'r'

    from = target_dir || '\bin\CLICKME.EXE'
    to   = target_dir || '\Projects\New\CLICKME.EXE'
    address cmd 'copy' from to '2>&1 >nul'

return
    classname = 'WPDataFile'
    title     = 'Project.VRP'
    location  = '<VXREXX_TEMPLATE>'
    setup     = ''

    call SysCreateObject classname, title, location, setup, 'r'

    classname = 'WPDataFile'
    title     = 'Window1.VRY'
    location  = '<VXREXX_TEMPLATE>'
    setup     = ''

    call SysCreateObject classname, title, location, setup, 'r'

    classname = 'WPDataFile'
    title     = 'Window1.VRX'
    location  = '<VXREXX_TEMPLATE>'
    setup     = ''

    call SysCreateObject classname, title, location, setup, 'r'

    return

/*
 * CleanIni -- Clean up the .INI file out of old VX-REXX information.
 */

CleanIni:
    call SysDestroyObject '<VXREXX_ODK>'
    return
/*
 * Make empty directories.
 */    
    
MakeEmptyDirs:
    olddir = directory()
    do i=1 to words( samples )
        sample = target_dir ||"\samples\" || word( samples, i )
        call MakeEmpty sample"\h"
        call MakeEmpty sample"\obj"
        call MakeEmpty sample"\objd"
    end
    call MakeEmpty target_dir"\projects"
    call MakeEmpty target_dir"\projects\new"
    call MakeEmpty target_dir"\dll"
    call directory olddir
    return
    
MakeEmpty:procedure
parse arg dir
        if directory( dir )="" then do
            call SysMkDir dir
        end
    return    
    
/*
 * FileExists
 */
    
FileExists:
    return( stream( arg(1), 'c', 'query exists' ) <> '' )

/*
 * Usage
 */

Usage:
    say ''
    say 'Usage: buildodk [target_dir] [title]'
    say ''
    say '    target_dir   = path where VX-REXX ODK has been installed'
    say '    title        = folder title (defaults to "VX-REXX ODK")'
    say ''
    say 'This program builds/rebuilds the various Workplace Shell objects'
    say 'needed to run the VX-REXX ODK.'
    exit
