.AUTODEPEND =
.PATH.obj = .

#============================================================
#         Translator Definitions
#============================================================
INCLUDE = d:\prog\bcos2\include
LIB = d:\prog\bcos2\lib
#OPZCMP = -c -Zmt -Zomf -Zcrtdll -Wall
#OPZCMP = -c -sm -I$(INCLUDE)
OPZCMP = /Ti+ /C+ /Gm+
CC = icc
RC = brcc

#============================================================
#         Implicit Rules
#============================================================
.c.obj:
  $(CC) $(OPZCMP) $<

.rc.res:
  $(RC) -r $*.rc

#============================================================
#         List Macros
#============================================================

OBJS = pmtclsh.obj thInterp.obj
RESOURCES = pmtclsh.res
EXE_DEPENDENCIES = $(OBJS) $(RESOURCES)

DIST = pmtclsh.exe pmtclsh.ico dist\manuale.txt dist\manual.txt \
       dist\manuale.rtf dist\manual.rtf
SRC = thinterp.c pmtclsh.c pmtclsh.h pmtclsh.rc pmtclsh.mak
ZIPOPZ = -9 -j


#============================================================
#         Explicit Rules
#============================================================
pmtclsh.exe: $(EXE_DEPENDENCIES)
#  gcc -Zomf -Zcrtdll -Zmt -o pmtclsh.exe $(EXE_DEPENDENCIES)
#   bcc -v -sm -L$(LIB) -epmtclsh.exe $(OBJS)
   icc /B"/pmtype:pm" /Fepmtclsh.exe /Ti+ /Gm+ $(OBJS)
   rc $(RESOURCES) pmtclsh.exe

dist: sorgenti $(DIST)
  del dist\pmtclsh.zip
  zip $(ZIPOPZ) dist\pmtclsh $(DIST) dist\src.zip

sorgenti: $(SRC)
  del dist\src.zip
  zip $(ZIPOPZ) dist\src $(SRC)

#============================================================
#         Individual File Dependencies
#============================================================
pmtclsh.obj: pmtclsh.c
thInterp.obj: thInterp.c
pmtclsh.res: pmtclsh.rc