/*
 * tclOS2Int.h --
 *
 *	Declarations of OS2-specific shared variables and procedures.
 *
 * Copyright (c) 1994-1996 Sun Microsystems, Inc.
 * Copyright (c) 1998 Sun Microsystems, Inc.
 * Copyright (c) 1998-2001 Illya Vaes
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 */

#ifndef _TCLOS2INT
#define _TCLOS2INT

#ifndef _TCLINT
#include "tclInt.h"
#endif
#ifndef _TCLPORT
#include "tclPort.h"
#endif

#ifdef BUILD_tcl
# undef TCL_STORAGE_CLASS
# define TCL_STORAGE_CLASS EXPENTRY
#endif

#define FS_CASE_SENSITIVE    1
#define FS_CASE_IS_PRESERVED 2

#define NEW_HANDLE	0xFFFFFFFF	/* DosDuphandle: return new handle */
#define HF_STDIN	0	/* Standard input handle */
#define HF_STDOUT	1	/* Standard output handle */
#define HF_STDERR	2	/* Standard error handle */

extern HAB tclHab;	/* Anchor block */
extern LONG rc;	/* Variable for checking return codes */
extern ULONG maxPath;	/* Maximum path length */
extern BOOL usePm;	/* Make use of PM calls from Tcl? */
extern ULONG sysInfo[QSV_MAX];	/* Information about OS/2 and the system */
#ifdef VERBOSE
extern int openedFiles;	/* How many files opened (DosOpen/DosDuphandle) */
#endif

/*
 * Use PM events? TRUE if PM version; set to FALSE by tclOS2Main if that is
 * compiled with CLI_VERSION defined.
 */
EXTERN EXPENTRY BOOL TclOS2GetUsePm _ANSI_ARGS_((void));
EXTERN EXPENTRY void TclOS2SetUsePm _ANSI_ARGS_((BOOL value));
EXTERN EXPENTRY HAB  TclOS2GetHAB _ANSI_ARGS_((void));
EXTERN EXPENTRY HMQ  TclOS2GetHMQ _ANSI_ARGS_((HAB hab));

#endif	/* _TCLOS2INT */
