/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.internal.pm.OS;

public final class Color {
    public int handle;
    int rgb;
    Device device;

    Color() {
    }

    public Color(Device device, int red, int green, int blue) {
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        this.init(device, red, green, blue);
        if (device.tracking) {
            device.new_Object(this);
        }
    }

    public Color(Device device, RGB rgb) {
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        if (rgb == null) {
            SWT.error(4);
        }
        this.init(device, rgb.red, rgb.green, rgb.blue);
        if (device.tracking) {
            device.new_Object(this);
        }
    }

    public void dispose() {
        int[] colorRefCount;
        if (this.handle == -1) {
            return;
        }
        int hPal = this.device.hPalette;
        if (hPal != 0 && (colorRefCount = this.device.colorRefCount)[this.handle] > 0) {
            int n = this.handle;
            colorRefCount[n] = colorRefCount[n] - 1;
        }
        this.handle = -1;
        if (this.device.tracking) {
            this.device.dispose_Object(this);
        }
        this.device = null;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Color)) {
            return false;
        }
        Color color = (Color)object;
        return this.device == color.device && this.handle == color.handle && (this.rgb & 0xFFFFFF) == (color.rgb & 0xFFFFFF);
    }

    public int getBlue() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return this.rgb & 0xFF;
    }

    public int getGreen() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return (this.rgb & 0xFF00) >> 8;
    }

    public int getRed() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return (this.rgb & 0xFF0000) >> 16;
    }

    public RGB getRGB() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return new RGB((this.rgb & 0xFF0000) >> 16, (this.rgb & 0xFF00) >> 8, this.rgb & 0xFF);
    }

    public int hashCode() {
        return this.rgb;
    }

    void init(Device device, int red, int green, int blue) {
        if (red > 255 || red < 0 || green > 255 || green < 0 || blue > 255 || blue < 0) {
            SWT.error(5);
        }
        this.device = device;
        this.handle = this.rgb = (red & 0xFF) << 16 | (green & 0xFF) << 8 | blue & 0xFF;
        int hPal = device.hPalette;
        if (hPal == 0) {
            return;
        }
        int[] colorRefCount = device.colorRefCount;
        this.handle = OS.GpiQueryNearestPaletteIndex(hPal, this.rgb);
        int[] entry = new int[1];
        OS.GpiQueryPaletteInfo(hPal, 0, 0, this.handle, 1, entry);
        if ((entry[0] & 0xFFFFFF) == (this.rgb & 0xFFFFFF)) {
            int n = this.handle;
            colorRefCount[n] = colorRefCount[n] + 1;
            return;
        }
        int i = 0;
        while (i < colorRefCount.length) {
            if (colorRefCount[i] == 0) {
                this.handle = i;
                break;
            }
            ++i;
        }
        if (i == colorRefCount.length) {
            this.rgb = entry[0];
        } else {
            entry[0] = this.rgb;
            OS.GpiSetPaletteEntries(hPal, 2, this.handle, 1, entry);
            OS.WinPostMsg(0, 94, 0, 0);
        }
        int n = this.handle;
        colorRefCount[n] = colorRefCount[n] + 1;
    }

    public boolean isDisposed() {
        return this.handle == -1;
    }

    public String toString() {
        if (this.isDisposed()) {
            return "Color {*DISPOSED*}";
        }
        return "Color {" + this.getRed() + ", " + this.getGreen() + ", " + this.getBlue() + "}";
    }

    public static Color pm_new(Device device, int handle) {
        if (device == null) {
            device = Device.getDevice();
        }
        Color color = new Color();
        color.handle = handle;
        int rgb = handle;
        int hPal = device.hPalette;
        if (handle < 0) {
            rgb = OS.WinQuerySysColor(1, handle, 0);
            if (hPal != 0) {
                handle = OS.GpiQueryNearestPaletteIndex(hPal, rgb);
            }
        }
        if (hPal != 0) {
            int[] entry = new int[1];
            OS.GpiQueryPaletteInfo(hPal, 0, 0, handle, 1, entry);
            rgb = entry[0] & 0xFFFFFF;
        }
        color.rgb = rgb;
        color.device = device;
        return color;
    }
}

