/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import java.io.InputStream;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.pm.BITMAPINFOHEADER2;
import org.eclipse.swt.internal.pm.OS;
import org.eclipse.swt.internal.pm.POINTERINFO;
import org.eclipse.swt.internal.pm.PSZ;
import org.eclipse.swt.widgets.Display;

public final class Image
implements Drawable {
    public int type;
    public int handle;
    Device device;
    int transparentPixel;
    GC memGC;
    byte[] alphaData;
    int alpha;
    public int maskHandle;
    static final int DEFAULT_SCANLINE_PAD = 4;

    Image() {
        this.transparentPixel = -1;
        this.alpha = -1;
    }

    public Image(Device device, int width, int height) {
        this.transparentPixel = -1;
        this.alpha = -1;
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        this.init(device, width, height);
        if (device.tracking) {
            device.new_Object(this);
        }
    }

    public Image(Device device, Image srcImage, int flag) {
        this.transparentPixel = -1;
        this.alpha = -1;
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        this.device = device;
        if (srcImage == null) {
            SWT.error(4);
        }
        if (srcImage.isDisposed()) {
            SWT.error(5);
        }
        switch (flag) {
            case 0: {
                this.type = srcImage.type;
                switch (this.type) {
                    case 0: {
                        boolean mustRestore = false;
                        GC memGC = srcImage.memGC;
                        if (memGC != null && !memGC.isDisposed()) {
                            mustRestore = true;
                            OS.GpiSetBitmap(memGC.handle, 0);
                        }
                        this.handle = this.createBitmap(0, 0, 0, 0, null, null, null, srcImage.handle);
                        if (mustRestore) {
                            OS.GpiSetBitmap(memGC.handle, srcImage.handle);
                        }
                        this.transparentPixel = srcImage.transparentPixel;
                        this.alpha = srcImage.alpha;
                        if (srcImage.alphaData == null) break;
                        this.alphaData = new byte[srcImage.alphaData.length];
                        System.arraycopy(srcImage.alphaData, 0, this.alphaData, 0, this.alphaData.length);
                        break;
                    }
                    case 1: {
                        POINTERINFO info = new POINTERINFO();
                        int hbmColor = srcImage.handle;
                        int hbmPointer = srcImage.maskHandle;
                        if (hbmPointer == 0) {
                            OS.WinQueryPointerInfo(srcImage.handle, info);
                            hbmColor = info.hbmColor;
                            hbmPointer = info.hbmPointer;
                        }
                        int[] bitmapPS = new int[1];
                        this.maskHandle = this.createBitmap(0, 0, 1, 1, null, null, bitmapPS, hbmPointer);
                        int bmpPS = bitmapPS[0];
                        if (hbmColor != 0) {
                            this.handle = this.createBitmap(0, 0, 0, 0, null, null, bitmapPS, hbmColor);
                        }
                        this.dispose_compatible_GC(bmpPS, null);
                        if (srcImage.maskHandle != 0) break;
                        info.hbmColor = this.handle;
                        info.hbmPointer = this.maskHandle;
                        int hIcon = OS.WinCreatePointerIndirect(1, info);
                        if (hIcon == 0) {
                            SWT.error(2);
                        }
                        OS.GpiDeleteBitmap(this.handle);
                        OS.GpiDeleteBitmap(this.maskHandle);
                        this.handle = hIcon;
                        this.maskHandle = 0;
                        break;
                    }
                    default: {
                        SWT.error(42);
                    }
                }
                if (device.tracking) {
                    device.new_Object(this);
                }
                return;
            }
            case 1: {
                this.type = srcImage.type;
                ImageData srcData = srcImage.getImageData();
                int width = srcData.width;
                int height = srcData.height;
                GCData hPSData = new GCData();
                int hPS = device.internal_new_GC(hPSData);
                int hpsBW = this.new_compatible_GC(null, hPSData.hdc, width, height * 2);
                int hpsBmp = this.new_compatible_GC(null, hPSData.hdc, width, height);
                int bwBytesPerLine = (width + 31) / 32 * 4;
                byte[] bwData = new byte[bwBytesPerLine * height];
                int offset = bwData.length;
                PaletteData palette = srcData.palette;
                RGB[] rgbs = palette.getRGBs();
                int[] srcPixels = new int[width];
                int redMask = palette.redMask;
                int greenMask = palette.greenMask;
                int blueMask = palette.blueMask;
                int redShift = palette.redShift;
                int greenShift = palette.greenShift;
                int blueShift = palette.blueShift;
                int y = 0;
                while (y < height) {
                    srcData.getPixels(0, y, width, srcPixels, 0);
                    offset -= bwBytesPerLine;
                    int x = 0;
                    while (x < width) {
                        int pixel = srcPixels[x];
                        int red = 0;
                        int green = 0;
                        int blue = 0;
                        if (palette.isDirect) {
                            red = pixel & redMask;
                            red = redShift < 0 ? red >>> -redShift : red << redShift;
                            green = pixel & greenMask;
                            green = greenShift < 0 ? green >>> -greenShift : green << greenShift;
                            blue = pixel & blueMask;
                            blue = blueShift < 0 ? blue >>> -blueShift : blue << blueShift;
                        } else {
                            red = rgbs[pixel].red;
                            green = rgbs[pixel].green;
                            blue = rgbs[pixel].blue;
                        }
                        int intensity = red + red + green + green + green + green + green + blue >> 3;
                        int bit = (intensity >= 128 ? 0 : 128) >> x % 8;
                        int n = offset + x / 8;
                        bwData[n] = (byte)(bwData[n] | (byte)bit);
                        ++x;
                    }
                    ++y;
                }
                int bmi_cbFix = 4;
                int[] bmi = new int[]{16, width, height, 65537, 0, 0xFFFFFF};
                int hbmBW = this.createBitmap(width, height, 1, 1, bwData, bmi, new int[]{hpsBW}, 0);
                int cDark = -39;
                int cMiddle = -40;
                int cLight = -41;
                int hPalette = device.hPalette;
                if (hPalette != 0) {
                    cDark = OS.WinQuerySysColor(1, cDark, 0);
                    cMiddle = OS.WinQuerySysColor(1, cMiddle, 0);
                    cLight = OS.WinQuerySysColor(1, cLight, 0);
                    cDark = OS.GpiQueryNearestPaletteIndex(device.hPalette, cDark);
                    cMiddle = OS.GpiQueryNearestPaletteIndex(device.hPalette, cMiddle);
                    cLight = OS.GpiQueryNearestPaletteIndex(device.hPalette, cLight);
                }
                switch (this.type) {
                    case 0: {
                        this.handle = this.createBitmap(width, height, 0, 0, null, null, new int[]{hpsBmp}, 0);
                        OS.GpiSetColor(hpsBmp, cMiddle);
                        OS.GpiBox(hpsBmp, 1, new int[]{width, height}, 0, 0);
                        OS.GpiSetColor(hpsBmp, cLight);
                        OS.GpiSetBackColor(hpsBmp, cMiddle);
                        OS.GpiBitBlt(hpsBmp, hpsBW, 4, new int[]{1, 0, width, height - 1, 0, 1, width - 1, height}, 204, 2);
                        OS.GpiSetColor(hpsBmp, cDark);
                        OS.GpiSetBackMix(hpsBmp, 18);
                        OS.GpiBitBlt(hpsBmp, hpsBW, 4, new int[]{0, 0, width, height, 0, 0, width, height}, 204, 2);
                        break;
                    }
                    case 1: {
                        POINTERINFO info = new POINTERINFO();
                        int hbmColor = srcImage.handle;
                        int hbmPointer = srcImage.maskHandle;
                        if (hbmPointer == 0) {
                            OS.WinQueryPointerInfo(srcImage.handle, info);
                            hbmColor = info.hbmColor;
                            hbmPointer = info.hbmPointer;
                        }
                        this.maskHandle = this.createBitmap(0, 0, 1, 1, null, null, new int[]{hpsBmp}, hbmPointer);
                        this.handle = this.createBitmap(width, height, 0, 0, null, null, new int[]{hpsBmp}, 0);
                        OS.GpiSetColor(hpsBmp, cMiddle);
                        OS.GpiBox(hpsBmp, 1, new int[]{width, height}, 0, 0);
                        OS.GpiSetColor(hpsBmp, cDark);
                        OS.GpiSetBackColor(hpsBmp, cMiddle);
                        OS.GpiBitBlt(hpsBmp, hpsBW, 4, new int[]{0, 0, width, height, 0, 0, width, height}, 204, 2);
                        OS.GpiSetBitmap(hpsBW, this.maskHandle);
                        OS.GpiSetColor(hpsBmp, -1);
                        OS.GpiSetBackMix(hpsBmp, 18);
                        OS.GpiBitBlt(hpsBmp, hpsBW, 4, new int[]{0, 0, width, height, 0, height, width, height * 2}, 204, 2);
                        OS.GpiBitBlt(hpsBW, 0, 2, new int[]{0, 0, width, height}, 0, 0);
                        OS.GpiSetBitmap(hpsBmp, 0);
                        OS.GpiSetBitmap(hpsBW, 0);
                        if (srcImage.maskHandle != 0) break;
                        info.hbmColor = this.handle;
                        info.hbmPointer = this.maskHandle;
                        int hIcon = OS.WinCreatePointerIndirect(1, info);
                        if (hIcon == 0) {
                            SWT.error(2);
                        }
                        OS.GpiDeleteBitmap(this.handle);
                        OS.GpiDeleteBitmap(this.maskHandle);
                        this.handle = hIcon;
                        this.maskHandle = 0;
                        break;
                    }
                    default: {
                        SWT.error(42);
                    }
                }
                this.dispose_compatible_GC(hpsBmp, null);
                this.dispose_compatible_GC(hpsBW, null);
                OS.GpiDeleteBitmap(hbmBW);
                device.internal_dispose_GC(hPS, hPSData);
                if (device.tracking) {
                    device.new_Object(this);
                }
                return;
            }
            case 2: {
                ImageData data = srcImage.getImageData();
                int width = data.width;
                int height = data.height;
                PaletteData palette = data.palette;
                ImageData newData = data;
                if (!palette.isDirect) {
                    RGB[] rgbs = palette.getRGBs();
                    int i = 0;
                    while (i < rgbs.length) {
                        if (data.transparentPixel != i) {
                            int intensity;
                            RGB color = rgbs[i];
                            int red = color.red;
                            int green = color.green;
                            int blue = color.blue;
                            color.green = color.blue = (intensity = red + red + green + green + green + green + green + blue >> 3);
                            color.red = color.blue;
                        }
                        ++i;
                    }
                    newData.palette = new PaletteData(rgbs);
                } else {
                    RGB[] rgbs = new RGB[256];
                    int i = 0;
                    while (i < rgbs.length) {
                        rgbs[i] = new RGB(i, i, i);
                        ++i;
                    }
                    newData = new ImageData(width, height, 8, new PaletteData(rgbs));
                    newData.maskData = data.maskData;
                    newData.maskPad = data.maskPad;
                    int[] scanline = new int[width];
                    int redMask = palette.redMask;
                    int greenMask = palette.greenMask;
                    int blueMask = palette.blueMask;
                    int redShift = palette.redShift;
                    int greenShift = palette.greenShift;
                    int blueShift = palette.blueShift;
                    int y = 0;
                    while (y < height) {
                        int offset = y * newData.bytesPerLine;
                        data.getPixels(0, y, width, scanline, 0);
                        int x = 0;
                        while (x < width) {
                            int pixel = scanline[x];
                            int red = pixel & redMask;
                            red = redShift < 0 ? red >>> -redShift : red << redShift;
                            int green = pixel & greenMask;
                            green = greenShift < 0 ? green >>> -greenShift : green << greenShift;
                            int blue = pixel & blueMask;
                            blue = blueShift < 0 ? blue >>> -blueShift : blue << blueShift;
                            newData.data[offset++] = (byte)(red + red + green + green + green + green + green + blue >> 3);
                            ++x;
                        }
                        ++y;
                    }
                }
                this.init(device, newData);
                if (device.tracking) {
                    device.new_Object(this);
                }
                return;
            }
        }
        SWT.error(5);
    }

    public Image(Device device, Rectangle bounds) {
        this.transparentPixel = -1;
        this.alpha = -1;
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        if (bounds == null) {
            SWT.error(4);
        }
        this.init(device, bounds.width, bounds.height);
        if (device.tracking) {
            device.new_Object(this);
        }
    }

    public Image(Device device, ImageData data) {
        this.transparentPixel = -1;
        this.alpha = -1;
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        this.init(device, data);
        if (device.tracking) {
            device.new_Object(this);
        }
    }

    /*
     * Unable to fully structure code
     */
    public Image(Device device, ImageData source, ImageData mask) {
        block26: {
            block25: {
                super();
                this.transparentPixel = -1;
                this.alpha = -1;
                if (device == null) {
                    device = Device.getDevice();
                }
                if (device == null) {
                    SWT.error(4);
                }
                if (source == null) {
                    SWT.error(4);
                }
                if (mask == null) {
                    SWT.error(4);
                }
                if (source.width != mask.width || source.height != mask.height) {
                    SWT.error(5);
                }
                if (mask.depth != 1) {
                    if (mask.depth != 4) {
                        SWT.error(5);
                    }
                    palette = new PaletteData(new RGB[]{new RGB(0, 0, 0), new RGB(255, 255, 255)});
                    tempMask = new ImageData(mask.width, mask.height, 1, palette);
                    rgbs = mask.getRGBs();
                    blackIndex = 0;
                    while (blackIndex < rgbs.length) {
                        if (rgbs[blackIndex].equals(palette.colors[0])) break;
                        ++blackIndex;
                    }
                    if (blackIndex == rgbs.length) {
                        SWT.error(5);
                    }
                    pixels = new int[mask.width];
                    y = 0;
                    while (y < mask.height) {
                        mask.getPixels(0, y, mask.width, pixels, 0);
                        i = 0;
                        while (i < pixels.length) {
                            pixels[i] = pixels[i] == blackIndex ? 0 : 1;
                            ++i;
                        }
                        tempMask.setPixels(0, y, mask.width, pixels, 0);
                        ++y;
                    }
                    mask = tempMask;
                }
                blackIndex = 0;
                if (!source.palette.isDirect) break block25;
                image = new ImageData(source.width, source.height, source.depth, source.palette);
                break block26;
            }
            black = new RGB(0, 0, 0);
            rgbs = source.getRGBs();
            if (source.transparentPixel == -1) ** GOTO lbl66
            newRGBs = new RGB[rgbs.length];
            System.arraycopy(rgbs, 0, newRGBs, 0, rgbs.length);
            if (source.transparentPixel >= newRGBs.length) {
                rgbs = new RGB[source.transparentPixel + 1];
                System.arraycopy(newRGBs, 0, rgbs, 0, newRGBs.length);
                i = newRGBs.length;
                while (i <= source.transparentPixel) {
                    rgbs[i] = new RGB(0, 0, 0);
                    ++i;
                }
            } else {
                newRGBs[source.transparentPixel] = black;
                rgbs = newRGBs;
            }
            blackIndex = source.transparentPixel;
            image = new ImageData(source.width, source.height, source.depth, new PaletteData(rgbs));
            break block26;
            while (!rgbs[blackIndex].equals(black)) {
                ++blackIndex;
lbl66:
                // 2 sources

                if (blackIndex < rgbs.length) continue;
            }
            if (blackIndex == rgbs.length) {
                if (1 << source.depth > rgbs.length) {
                    newRGBs = new RGB[rgbs.length + 1];
                    System.arraycopy(rgbs, 0, newRGBs, 0, rgbs.length);
                    newRGBs[rgbs.length] = black;
                    rgbs = newRGBs;
                } else {
                    blackIndex = -1;
                }
            }
            image = new ImageData(source.width, source.height, source.depth, new PaletteData(rgbs));
        }
        if (blackIndex == -1) {
            System.arraycopy(source.data, 0, image.data, 0, image.data.length);
        } else {
            System.arraycopy(source.data, 0, image.data, 0, image.data.length);
            imagePixels = new int[image.width];
            maskPixels = new int[mask.width];
            y = 0;
            while (y < image.height) {
                source.getPixels(0, y, image.width, imagePixels, 0);
                mask.getPixels(0, y, mask.width, maskPixels, 0);
                i = 0;
                while (i < imagePixels.length) {
                    if (maskPixels[i] == 0) {
                        imagePixels[i] = blackIndex;
                    }
                    ++i;
                }
                image.setPixels(0, y, source.width, imagePixels, 0);
                ++y;
            }
        }
        bytesPerLine = (mask.width + 31) / 32 * 4;
        newMaskData = new byte[bytesPerLine * mask.height];
        newMask = new ImageData(mask.width, mask.height, 1, mask.palette, 2, newMaskData);
        maskPixels = new int[mask.width];
        y = 0;
        while (y < mask.height) {
            mask.getPixels(0, y, mask.width, maskPixels, 0);
            newMask.setPixels(0, y, newMask.width, maskPixels, 0);
            ++y;
        }
        image.maskPad = newMask.scanlinePad;
        image.maskData = newMask.data;
        this.init(device, image);
        if (device.tracking) {
            device.new_Object(this);
        }
    }

    public Image(Device device, InputStream stream) {
        this.transparentPixel = -1;
        this.alpha = -1;
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        this.init(device, new ImageData(stream));
        if (device.tracking) {
            device.new_Object(this);
        }
    }

    public Image(Device device, String filename) {
        this.transparentPixel = -1;
        this.alpha = -1;
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        this.init(device, new ImageData(filename));
        if (device.tracking) {
            device.new_Object(this);
        }
    }

    int createBitmap(int width, int height, int bitCount, int planes, byte[] bitData, int[] bitmapInfo, int[] bitmapPS, int srcBitmap) {
        int memPS;
        int n = memPS = bitmapPS == null ? 0 : bitmapPS[0];
        if (memPS == 0) {
            GCData hPSData = new GCData();
            int hPS = this.device.internal_new_GC(hPSData);
            memPS = this.new_compatible_GC(null, hPSData.hdc, width, height);
            this.device.internal_dispose_GC(hPS, hPSData);
        }
        if (srcBitmap != 0) {
            BITMAPINFOHEADER2 bm = new BITMAPINFOHEADER2();
            OS.GpiQueryBitmapInfoHeader(srcBitmap, bm);
            int depth = bm.cBitCount * bm.cPlanes;
            int numColors = 0;
            if (depth <= 8) {
                numColors = 1 << depth;
            }
            int bmi_cbFix = 4;
            bitmapInfo = new int[4 + numColors];
            bitmapInfo[0] = 16;
            bitmapInfo[3] = depth << 16 | 1;
            int imageSize = (depth * bm.cx + 31) / 32 * 4 * bm.cy;
            bitData = new byte[imageSize];
            OS.GpiSetBitmap(memPS, srcBitmap);
            OS.GpiQueryBitmapBits(memPS, 0, bm.cy, bitData, bitmapInfo);
            OS.GpiSetBitmap(memPS, 0);
        }
        if (width == 0 || height == 0) {
            width = bitmapInfo[1];
            height = bitmapInfo[2];
        }
        if (bitCount == 0 || planes == 0) {
            if (bitData != null) {
                if (bitmapInfo[3] == 65537) {
                    planes = 1;
                    bitCount = 4;
                } else {
                    planes = bitmapInfo[3] & 0xFFFF;
                    bitCount = bitmapInfo[3] >>> 16;
                }
            } else {
                int[] formats = new int[2];
                OS.GpiQueryDeviceBitmapFormats(memPS, formats.length, formats);
                planes = formats[0];
                bitCount = formats[1];
            }
        }
        BITMAPINFOHEADER2 hdr = new BITMAPINFOHEADER2();
        hdr.cx = width;
        hdr.cy = height;
        hdr.cPlanes = (short)planes;
        hdr.cBitCount = (short)bitCount;
        hdr.ulCompression = 0;
        hdr.cbImage = 0;
        hdr.cxResolution = 0;
        hdr.cyResolution = 0;
        hdr.cclrUsed = 0;
        hdr.cclrImportant = 0;
        hdr.usUnits = 0;
        hdr.usReserved = 0;
        hdr.usRecording = 0;
        hdr.usRendering = 0;
        hdr.cSize1 = 0;
        hdr.cSize2 = 0;
        hdr.ulColorEncoding = 0;
        hdr.ulIdentifier = 0;
        int hBitmap = OS.GpiCreateBitmap(memPS, hdr, bitData == null ? 0 : 4, bitData, bitmapInfo);
        if (hBitmap == 0) {
            SWT.error(2);
        }
        OS.GpiSetBitmap(memPS, hBitmap);
        if (bitData == null) {
            if (this.device.hPalette != 0) {
                OS.GpiSetColor(memPS, 15);
                OS.GpiMove(memPS, new int[]{0, 0});
                OS.GpiBox(memPS, 1, new int[]{width, height}, 0, 0);
            } else {
                OS.GpiBitBlt(memPS, 0, 2, new int[]{0, 0, width, height}, 255, 0);
            }
        }
        if (bitmapPS == null) {
            this.dispose_compatible_GC(memPS, null);
        } else {
            bitmapPS[0] = memPS;
        }
        return hBitmap;
    }

    public void dispose() {
        if (this.handle == 0) {
            return;
        }
        if (this.type == 1) {
            if (this.maskHandle == 0) {
                OS.WinDestroyPointer(this.handle);
            } else {
                OS.GpiDeleteBitmap(this.handle);
                OS.GpiDeleteBitmap(this.maskHandle);
            }
        } else {
            OS.GpiDeleteBitmap(this.handle);
        }
        this.handle = 0;
        this.memGC = null;
        if (this.device.tracking) {
            this.device.dispose_Object(this);
        }
        this.device = null;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Image)) {
            return false;
        }
        Image image = (Image)object;
        return this.device == image.device && this.handle == image.handle;
    }

    public Color getBackground() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (this.transparentPixel == -1) {
            return null;
        }
        int transRGB = 0;
        BITMAPINFOHEADER2 bm = new BITMAPINFOHEADER2();
        OS.GpiQueryBitmapInfoHeader(this.handle, bm);
        int depth = bm.cBitCount * bm.cPlanes;
        if (depth <= 8) {
            GCData hPSData = new GCData();
            int hPS = this.device.internal_new_GC(hPSData);
            int bmpPS = this.new_compatible_GC(null, hPSData.hdc, bm.cx, bm.cy);
            this.device.internal_dispose_GC(hPS, hPSData);
            int numColors = 1 << depth;
            int bmi_cbFix = 4;
            int[] bmi = new int[4 + numColors];
            bmi[0] = 16;
            bmi[3] = bm.cBitCount << 16 | bm.cPlanes;
            OS.GpiSetBitmap(bmpPS, this.handle);
            OS.GpiQueryBitmapBits(bmpPS, 0, 0, null, bmi);
            int offset = 4 + this.transparentPixel;
            transRGB = bmi[offset];
            this.dispose_compatible_GC(bmpPS, null);
        } else {
            switch (depth) {
                case 24: 
                case 32: {
                    transRGB = (this.transparentPixel & 0xFF0000) >> 16 | this.transparentPixel & 0xFF00 | (this.transparentPixel & 0xFF) << 16;
                    break;
                }
                default: {
                    return null;
                }
            }
        }
        int color = transRGB;
        if (this.device.hPalette != 0) {
            color = OS.GpiQueryNearestPaletteIndex(this.device.hPalette, color);
        }
        return Color.pm_new(this.device, color);
    }

    public Rectangle getBounds() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        BITMAPINFOHEADER2 bm = new BITMAPINFOHEADER2();
        switch (this.type) {
            case 0: {
                OS.GpiQueryBitmapInfoHeader(this.handle, bm);
                return new Rectangle(0, 0, bm.cx, bm.cy);
            }
            case 1: {
                int hBitmap;
                int hbmColor = this.handle;
                int hbmPointer = this.maskHandle;
                if (hbmPointer == 0) {
                    POINTERINFO info = new POINTERINFO();
                    OS.WinQueryPointerInfo(this.handle, info);
                    hbmColor = info.hbmColor;
                    hbmPointer = info.hbmPointer;
                }
                if ((hBitmap = hbmColor) == 0) {
                    hBitmap = hbmPointer;
                }
                OS.GpiQueryBitmapInfoHeader(hBitmap, bm);
                if (hBitmap == hbmPointer) {
                    bm.cy /= 2;
                }
                return new Rectangle(0, 0, bm.cx, bm.cy);
            }
        }
        SWT.error(42);
        return null;
    }

    public ImageData getImageData() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        BITMAPINFOHEADER2 bm = new BITMAPINFOHEADER2();
        switch (this.type) {
            case 1: {
                int hBitmap;
                int hbmColor = this.handle;
                int hbmPointer = this.maskHandle;
                if (hbmPointer == 0) {
                    POINTERINFO info = new POINTERINFO();
                    OS.WinQueryPointerInfo(this.handle, info);
                    hbmColor = info.hbmColor;
                    hbmPointer = info.hbmPointer;
                }
                if ((hBitmap = hbmColor) == 0) {
                    hBitmap = hbmPointer;
                }
                OS.GpiQueryBitmapInfoHeader(hBitmap, bm);
                int depth = bm.cBitCount * bm.cPlanes;
                int width = bm.cx;
                if (hBitmap == hbmPointer) {
                    bm.cy /= 2;
                }
                int height = bm.cy;
                int numColors = 0;
                if (depth <= 8) {
                    numColors = 1 << depth;
                }
                int bmi_cbFix = 4;
                int[] bmi = new int[4 + numColors];
                bmi[0] = 16;
                bmi[3] = depth << 16 | 1;
                int[] bitmapPS = new int[1];
                hBitmap = this.createBitmap(0, 0, 0, 0, null, null, bitmapPS, hBitmap);
                int bmpPS = bitmapPS[0];
                int cWhite = -2;
                int cBlack = -1;
                if (this.device.hPalette != 0) {
                    cWhite = 15;
                    cBlack = 0;
                }
                OS.GpiSetColor(bmpPS, cWhite);
                OS.GpiSetBackColor(bmpPS, cBlack);
                OS.GpiWCBitBlt(bmpPS, hbmPointer, 4, new int[]{0, 0, width - 1, height - 1, 0, 0, width, height}, 102, 2);
                byte[] data = null;
                int imageSize = (depth * width + 31) / 32 * 4 * height;
                data = new byte[imageSize];
                OS.GpiQueryBitmapBits(bmpPS, 0, height, data, bmi);
                int bpl = data.length / height;
                byte[] line = new byte[bpl];
                int topPtr = 0;
                int bottomPtr = data.length - bpl;
                while (topPtr < bottomPtr) {
                    System.arraycopy(data, topPtr, line, 0, bpl);
                    System.arraycopy(data, bottomPtr, data, topPtr, bpl);
                    System.arraycopy(line, 0, data, bottomPtr, bpl);
                    topPtr += bpl;
                    bottomPtr -= bpl;
                }
                PaletteData palette = null;
                if (depth <= 8) {
                    RGB[] rgbs = new RGB[numColors];
                    int srcIndex = 4;
                    int i = 0;
                    while (i < numColors) {
                        int rgb = bmi[srcIndex];
                        rgbs[i] = new RGB((rgb & 0xFF0000) >> 16, (rgb & 0xFF00) >> 8, rgb & 0xFF);
                        ++srcIndex;
                        ++i;
                    }
                    palette = new PaletteData(rgbs);
                } else if (depth == 24) {
                    palette = new PaletteData(255, 65280, 0xFF0000);
                } else if (depth == 32) {
                    palette = new PaletteData(65280, 0xFF0000, -16777216);
                } else {
                    SWT.error(38);
                }
                byte[] maskData = null;
                int maskSize = (width + 31) / 32 * 4 * height;
                maskData = new byte[maskSize];
                bmi[3] = 65537;
                OS.GpiSetBitmap(bmpPS, hbmPointer);
                OS.GpiBitBlt(bmpPS, 0, 2, new int[]{0, height, width, height * 2}, 85, 0);
                OS.GpiQueryBitmapBits(bmpPS, height, height, maskData, bmi);
                OS.GpiBitBlt(bmpPS, 0, 2, new int[]{0, height, width, height * 2}, 85, 0);
                bpl = maskData.length / height;
                topPtr = 0;
                bottomPtr = maskData.length - bpl;
                while (topPtr < bottomPtr) {
                    System.arraycopy(maskData, topPtr, line, 0, bpl);
                    System.arraycopy(maskData, bottomPtr, maskData, topPtr, bpl);
                    System.arraycopy(line, 0, maskData, bottomPtr, bpl);
                    topPtr += bpl;
                    bottomPtr -= bpl;
                }
                this.dispose_compatible_GC(bmpPS, null);
                OS.GpiDeleteBitmap(hBitmap);
                ImageData imageData = new ImageData(width, height, depth, palette, 4, data);
                imageData.maskData = maskData;
                imageData.maskPad = 4;
                return imageData;
            }
            case 0: {
                OS.GpiQueryBitmapInfoHeader(this.handle, bm);
                int width = bm.cx;
                int height = bm.cy;
                int depth = bm.cBitCount * bm.cPlanes;
                if (depth > 8 && depth != 24) {
                    if (this.device.has32bitDepth) {
                        if (depth != 32) {
                            depth = 32;
                        }
                    } else {
                        depth = 24;
                    }
                }
                int numColors = 0;
                if (depth <= 8) {
                    numColors = 1 << depth;
                }
                int bmi_cbFix = 4;
                int[] bmi = new int[4 + numColors];
                bmi[0] = 16;
                bmi[3] = depth << 16 | 1;
                boolean mustRestore = false;
                GC memGC = this.memGC;
                if (memGC != null && !memGC.isDisposed()) {
                    mustRestore = true;
                    OS.GpiSetBitmap(memGC.handle, 0);
                }
                GCData hpsData = new GCData();
                int hps = this.device.internal_new_GC(hpsData);
                int bmpPS = this.new_compatible_GC(null, hpsData.hdc, width, height);
                this.device.internal_dispose_GC(hps, hpsData);
                OS.GpiSetBitmap(bmpPS, this.handle);
                byte[] data = null;
                int imageSize = (depth * width + 31) / 32 * 4 * height;
                data = new byte[imageSize];
                OS.GpiQueryBitmapBits(bmpPS, 0, height, data, bmi);
                int bpl = data.length / height;
                byte[] line = new byte[bpl];
                int topPtr = 0;
                int bottomPtr = data.length - bpl;
                while (topPtr < bottomPtr) {
                    System.arraycopy(data, topPtr, line, 0, bpl);
                    System.arraycopy(data, bottomPtr, data, topPtr, bpl);
                    System.arraycopy(line, 0, data, bottomPtr, bpl);
                    topPtr += bpl;
                    bottomPtr -= bpl;
                }
                this.dispose_compatible_GC(bmpPS, null);
                if (mustRestore) {
                    OS.GpiSetBitmap(memGC.handle, this.handle);
                }
                PaletteData palette = null;
                if (depth <= 8) {
                    RGB[] rgbs = new RGB[numColors];
                    int srcIndex = 4;
                    int i = 0;
                    while (i < numColors) {
                        int rgb = bmi[srcIndex];
                        rgbs[i] = new RGB((rgb & 0xFF0000) >> 16, (rgb & 0xFF00) >> 8, rgb & 0xFF);
                        ++srcIndex;
                        ++i;
                    }
                    palette = new PaletteData(rgbs);
                } else if (depth == 24) {
                    palette = new PaletteData(255, 65280, 0xFF0000);
                } else if (depth == 32) {
                    palette = new PaletteData(65280, 0xFF0000, -16777216);
                } else {
                    SWT.error(38);
                }
                ImageData imageData = new ImageData(width, height, depth, palette, 4, data);
                imageData.transparentPixel = this.transparentPixel;
                imageData.alpha = this.alpha;
                if (this.alpha == -1 && this.alphaData != null) {
                    imageData.alphaData = new byte[this.alphaData.length];
                    System.arraycopy(this.alphaData, 0, imageData.alphaData, 0, this.alphaData.length);
                }
                return imageData;
            }
        }
        SWT.error(42);
        return null;
    }

    public int hashCode() {
        return this.handle;
    }

    void init(Device device, int width, int height) {
        if (width <= 0 || height <= 0) {
            SWT.error(5);
        }
        this.device = device;
        this.type = 0;
        this.handle = this.createBitmap(width, height, 0, 0, null, null, null, 0);
    }

    static int[] init(Device device, Image image, ImageData i) {
        if (image != null) {
            image.device = device;
        }
        if (i.depth == 2) {
            ImageData img = new ImageData(i.width, i.height, 4, i.palette);
            ImageData.blit(1, i.data, i.depth, i.bytesPerLine, i.getByteOrder(), 0, 0, i.width, i.height, null, null, null, 255, null, 0, img.data, img.depth, img.bytesPerLine, i.getByteOrder(), 0, 0, img.width, img.height, null, null, null, false, false);
            img.transparentPixel = i.transparentPixel;
            img.maskPad = i.maskPad;
            img.maskData = i.maskData;
            img.alpha = i.alpha;
            img.alphaData = i.alphaData;
            i = img;
        }
        if (i.palette.isDirect) {
            PaletteData palette = i.palette;
            boolean convert = false;
            switch (i.depth) {
                case 24: {
                    if (palette.redMask == 255 && palette.greenMask == 65280 && palette.blueMask == 0xFF0000) break;
                }
                case 8: 
                case 16: 
                case 32: {
                    convert = true;
                    break;
                }
                default: {
                    SWT.error(38);
                }
            }
            if (convert || i.getByteOrder() != 1) {
                PaletteData newPalette = new PaletteData(255, 65280, 0xFF0000);
                ImageData img = new ImageData(i.width, i.height, 24, newPalette);
                ImageData.blit(1, i.data, i.depth, i.bytesPerLine, i.getByteOrder(), 0, 0, i.width, i.height, palette.redMask, palette.greenMask, palette.blueMask, 255, null, 0, img.data, img.depth, img.bytesPerLine, 1, 0, 0, img.width, img.height, newPalette.redMask, newPalette.greenMask, newPalette.blueMask, false, false);
                if (i.transparentPixel != -1) {
                    img.transparentPixel = newPalette.getPixel(palette.getRGB(i.transparentPixel));
                }
                img.maskPad = i.maskPad;
                img.maskData = i.maskData;
                img.alpha = i.alpha;
                img.alphaData = i.alphaData;
                i = img;
            }
        }
        RGB[] rgbs = i.palette.getRGBs();
        int[] bmi = new int[16 + (i.palette.isDirect ? 0 : rgbs.length)];
        bmi[0] = 64;
        bmi[1] = i.width;
        bmi[2] = i.height;
        bmi[3] = i.depth << 16 | 1;
        bmi[4] = 0;
        bmi[5] = 0;
        bmi[6] = 0;
        bmi[7] = 0;
        bmi[8] = rgbs == null ? 0 : rgbs.length;
        bmi[9] = 0;
        bmi[10] = 0;
        bmi[11] = 0;
        bmi[12] = 0;
        bmi[13] = 0;
        bmi[14] = 0;
        bmi[15] = 0;
        int offset = 16;
        if (!i.palette.isDirect) {
            int j = 0;
            while (j < rgbs.length) {
                bmi[offset] = rgbs[j].red << 16 | rgbs[j].green << 8 | rgbs[j].blue;
                ++offset;
                ++j;
            }
        }
        int bpl = i.bytesPerLine;
        byte[] data = i.data;
        int newBpl = i.scanlinePad != 4 && bpl % 4 != 0 ? bpl + (4 - bpl % 4) : bpl;
        byte[] newData = new byte[i.height * newBpl];
        int srcPtr = 0;
        int destPtr = newData.length - newBpl;
        int y = 0;
        while (y < i.height) {
            System.arraycopy(data, srcPtr, newData, destPtr, bpl);
            srcPtr += bpl;
            destPtr -= newBpl;
            ++y;
        }
        data = newData;
        byte[] maskData = i.maskData;
        if (i.getTransparencyType() == 2) {
            bpl = ((i.width + 7) / 8 + (i.maskPad - 1)) / i.maskPad * i.maskPad;
            newBpl = i.maskPad != 4 && bpl % 4 != 0 ? bpl + (4 - bpl % 4) : bpl;
            newData = new byte[i.height * newBpl * 2];
            srcPtr = 0;
            destPtr = newData.length - newBpl;
            int y2 = 0;
            while (y2 < i.height) {
                System.arraycopy(maskData, srcPtr, newData, destPtr, bpl);
                srcPtr += bpl;
                destPtr -= newBpl;
                ++y2;
            }
            maskData = newData;
        }
        int[] bitmapPS = new int[1];
        int hBitmap = image.createBitmap(i.width, i.height, 0, 0, data, bmi, bitmapPS, 0);
        int bmpPS = bitmapPS[0];
        int[] result = null;
        if (i.getTransparencyType() == 2) {
            bmi[2] = bmi[2] * 2;
            bmi[3] = 65537;
            bmi[8] = 2;
            int hMask = image.createBitmap(i.width, i.height * 2, 1, 1, maskData, bmi, bitmapPS, 0);
            OS.GpiSetBitmap(bmpPS, hMask);
            OS.GpiBitBlt(bmpPS, 0, 2, new int[]{0, i.height, i.width, i.height * 2}, 85, 0);
            int cWhite = -2;
            int cBlack = -1;
            if (device.hPalette != 0) {
                cWhite = 15;
                cBlack = 0;
            }
            OS.GpiSetColor(bmpPS, cWhite);
            OS.GpiSetBackColor(bmpPS, cBlack);
            OS.GpiWCBitBlt(bmpPS, hBitmap, 4, new int[]{0, 0, i.width - 1, i.height - 1, 0, 0, i.width, i.height}, 204, 2);
            OS.GpiBitBlt(bmpPS, bmpPS, 4, new int[]{0, 0, i.width, i.height, 0, i.height, i.width, i.height * 2}, 136, 2);
            OS.GpiSetBitmap(bmpPS, hBitmap);
            OS.GpiWCBitBlt(bmpPS, hMask, 4, new int[]{0, 0, i.width - 1, i.height - 1, 0, 0, i.width, i.height}, 102, 2);
            OS.GpiSetBitmap(bmpPS, 0);
            if (image == null) {
                result = new int[]{hBitmap, hMask};
            } else {
                int sysIconWidth = OS.WinQuerySysValue(1, 38);
                int sysIconHeight = OS.WinQuerySysValue(1, 39);
                int sysPtrWidth = OS.WinQuerySysValue(1, 40);
                int sysPtrHeight = OS.WinQuerySysValue(1, 41);
                int fPointer = -1;
                if (i.width == sysIconWidth) {
                    fPointer = 0;
                } else if (i.width == sysPtrWidth) {
                    fPointer = 1;
                }
                if (fPointer >= 0) {
                    POINTERINFO info = new POINTERINFO();
                    info.fPointer = fPointer;
                    info.hbmColor = hBitmap;
                    info.hbmPointer = hMask;
                    info.hbmMiniPointer = 0;
                    info.hbmMiniColor = 0;
                    int hIcon = OS.WinCreatePointerIndirect(1, info);
                    if (hIcon == 0) {
                        SWT.error(2);
                    }
                    OS.GpiDeleteBitmap(hBitmap);
                    OS.GpiDeleteBitmap(hMask);
                    image.handle = hIcon;
                } else {
                    image.handle = hBitmap;
                    image.maskHandle = hMask;
                }
                image.type = 1;
            }
        } else if (image == null) {
            result = new int[]{hBitmap};
        } else {
            image.handle = hBitmap;
            image.type = 0;
            image.transparentPixel = i.transparentPixel;
            if (image.transparentPixel == -1) {
                image.alpha = i.alpha;
                if (i.alpha == -1 && i.alphaData != null) {
                    int length = i.alphaData.length;
                    image.alphaData = new byte[length];
                    System.arraycopy(i.alphaData, 0, image.alphaData, 0, length);
                }
            }
        }
        image.dispose_compatible_GC(bmpPS, null);
        return result;
    }

    void init(Device device, ImageData i) {
        if (i == null) {
            SWT.error(4);
        }
        Image.init(device, this, i);
    }

    int new_compatible_GC(GCData data, int compatDC, int width, int height) {
        int hPalette;
        int memPS;
        int hab = Display.internal_get_HAB();
        int memDC = OS.DevOpenDC(hab, 8, new PSZ("*"), 4, new PSZ[]{new PSZ("Display"), null, null, null}, compatDC);
        if (memDC == 0) {
            SWT.error(2);
        }
        if ((memPS = OS.GpiCreatePS(hab, memDC, new int[]{width, height}, 20488)) == 0) {
            SWT.error(2);
        }
        if (data != null) {
            data.hdc = memDC;
        }
        if ((hPalette = this.device.hPalette) != 0) {
            OS.GpiSelectPalette(memPS, hPalette);
        }
        return memPS;
    }

    void dispose_compatible_GC(int hps, GCData data) {
        int hdc = data != null ? data.hdc : OS.GpiQueryDevice(hps);
        OS.GpiDestroyPS(hps);
        OS.DevCloseDC(hdc);
    }

    public int internal_new_GC(GCData data) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (this.type != 0 || this.memGC != null) {
            SWT.error(5);
        }
        GCData tmpData = new GCData();
        int hps = this.device.internal_new_GC(tmpData);
        int imagePS = this.new_compatible_GC(data, tmpData.hdc, 0, 0);
        this.device.internal_dispose_GC(hps, tmpData);
        if (data != null) {
            data.device = this.device;
            data.image = this;
            data.hFont = this.device.systemFont();
        }
        return imagePS;
    }

    public void internal_dispose_GC(int hps, GCData data) {
        this.dispose_compatible_GC(hps, data);
    }

    public boolean isDisposed() {
        return this.handle == 0;
    }

    void refreshBitmap() {
        BITMAPINFOHEADER2 bm = new BITMAPINFOHEADER2();
        OS.GpiQueryBitmapInfoHeader(this.handle, bm);
        int depth = bm.cBitCount * bm.cPlanes;
        if (depth > 8) {
            return;
        }
        int numColors = 1 << depth;
        int bmi_cbFix = 4;
        int[] bmi = new int[4 + numColors];
        bmi[0] = 16;
        bmi[3] = depth << 16 | 1;
        byte[] bitData = new byte[(depth * bm.cx + 31) / 32 * 4 * bm.cy];
        OS.GpiQueryBitmapBits(this.memGC.handle, 0, bm.cx, bitData, bmi);
        OS.GpiSetBitmapBits(this.memGC.handle, 0, bm.cx, bitData, bmi);
    }

    public void setBackground(Color color) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (color == null) {
            SWT.error(4);
        }
        if (color.isDisposed()) {
            SWT.error(5);
        }
        if (this.transparentPixel == -1) {
            return;
        }
        boolean transRGB = false;
        BITMAPINFOHEADER2 bm = new BITMAPINFOHEADER2();
        OS.GpiQueryBitmapInfoHeader(this.handle, bm);
        int depth = bm.cBitCount * bm.cPlanes;
        GCData hPSData = new GCData();
        int hPS = this.device.internal_new_GC(hPSData);
        int bmpPS = this.new_compatible_GC(null, hPSData.hdc, bm.cx, bm.cy);
        this.device.internal_dispose_GC(hPS, hPSData);
        int numColors = 0;
        if (depth <= 8) {
            numColors = 1 << depth;
        }
        int bmi_cbFix = 4;
        int[] bmi = new int[4 + numColors];
        bmi[0] = 16;
        bmi[3] = bm.cBitCount << 16 | bm.cPlanes;
        int bytesPerLine = (depth * bm.cx + 31) / 32 * 4;
        byte[] data = new byte[bytesPerLine * bm.cy];
        OS.GpiSetBitmap(bmpPS, this.handle);
        OS.GpiQueryBitmapBits(bmpPS, 0, bm.cy, data, bmi);
        if (depth <= 8) {
            int newTransRGB = color.getRed() << 16 | color.getRed() << 8 | color.getBlue();
            int offset = 4 + this.transparentPixel;
            bmi[offset] = newTransRGB;
        } else {
            int newTransPixel = color.getRed() | color.getGreen() << 8 | color.getBlue() << 16;
            ImageData id = new ImageData(bm.cx, bm.cy, depth, new PaletteData(255, 65280, 0xFF0000), 4, data);
            int[] pixels = new int[bm.cx];
            int y = 0;
            while (y < bm.cy) {
                id.getPixels(0, y, bm.cx, pixels, 0);
                int x = 0;
                while (x < bm.cx) {
                    if (pixels[x] == this.transparentPixel) {
                        pixels[x] = newTransPixel;
                    }
                    ++x;
                }
                id.setPixels(0, y, bm.cx, pixels, 0);
                ++y;
            }
            this.transparentPixel = newTransPixel;
        }
        OS.GpiSetBitmapBits(bmpPS, 0, bm.cy, data, bmi);
        this.dispose_compatible_GC(bmpPS, null);
    }

    public String toString() {
        if (this.isDisposed()) {
            return "Image {*DISPOSED*}";
        }
        return "Image {" + this.handle + "}";
    }

    public static Image pm_new(Device device, int type, int handle) {
        if (device == null) {
            device = Device.getDevice();
        }
        Image image = new Image();
        image.type = type;
        image.handle = handle;
        image.device = device;
        return image;
    }

    private String getBits(int value) {
        int displayMask = Integer.MIN_VALUE;
        StringBuffer buf = new StringBuffer(35);
        int c = 1;
        while (c <= 32) {
            buf.append((value & displayMask) == 0 ? (char)'0' : '1');
            value <<= 1;
            if (c % 8 == 0) {
                buf.append(' ');
            }
            ++c;
        }
        return buf.toString();
    }
}

