/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.layout;

import org.eclipse.swt.layout.FormAttachment;

public final class FormData {
    public int height;
    public int width;
    public FormAttachment left;
    public FormAttachment right;
    public FormAttachment top;
    public FormAttachment bottom;
    int cacheHeight;
    int cacheWidth;
    boolean isVisited;

    public FormData() {
        this(-1, -1);
    }

    public FormData(int width, int height) {
        this.width = width;
        this.height = height;
    }

    FormAttachment getBottomAttachment() {
        if (this.isVisited) {
            return new FormAttachment(0, this.cacheHeight);
        }
        if (this.bottom == null) {
            if (this.top == null) {
                return new FormAttachment(0, this.cacheHeight);
            }
            return this.getTopAttachment().plus(this.cacheHeight);
        }
        if (this.bottom.control == null) {
            return this.bottom;
        }
        this.isVisited = true;
        FormData bottomData = (FormData)this.bottom.control.getLayoutData();
        FormAttachment topAttachment = bottomData.getTopAttachment();
        FormAttachment bottomAttachment = bottomData.getBottomAttachment();
        this.isVisited = false;
        if (this.bottom.alignment == 1024) {
            return bottomAttachment.plus(this.bottom.offset);
        }
        if (this.bottom.alignment == 0x1000000) {
            FormAttachment bottomHeight = bottomAttachment.minus(topAttachment);
            return bottomAttachment.minus(bottomHeight.minus(this.cacheHeight).divide(2));
        }
        return topAttachment.plus(this.bottom.offset);
    }

    FormAttachment getLeftAttachment() {
        if (this.isVisited) {
            return new FormAttachment(0, 0);
        }
        if (this.left == null) {
            if (this.right == null) {
                return new FormAttachment(0, 0);
            }
            return this.getRightAttachment().minus(this.cacheWidth);
        }
        if (this.left.control == null) {
            return this.left;
        }
        this.isVisited = true;
        FormData leftData = (FormData)this.left.control.getLayoutData();
        FormAttachment rightAttachment = leftData.getRightAttachment();
        FormAttachment leftAttachment = leftData.getLeftAttachment();
        this.isVisited = false;
        if (this.left.alignment == 16384) {
            return leftAttachment.plus(this.left.offset);
        }
        if (this.left.alignment == 0x1000000) {
            FormAttachment leftWidth = rightAttachment.minus(leftAttachment);
            return leftAttachment.plus(leftWidth.minus(this.cacheWidth).divide(2));
        }
        return rightAttachment.plus(this.left.offset);
    }

    FormAttachment getRightAttachment() {
        if (this.isVisited) {
            return new FormAttachment(0, this.cacheWidth);
        }
        if (this.right == null) {
            if (this.left == null) {
                return new FormAttachment(0, this.cacheWidth);
            }
            return this.getLeftAttachment().plus(this.cacheWidth);
        }
        if (this.right.control == null) {
            return this.right;
        }
        this.isVisited = true;
        FormData rightData = (FormData)this.right.control.getLayoutData();
        FormAttachment leftAttachment = rightData.getLeftAttachment();
        FormAttachment rightAttachment = rightData.getRightAttachment();
        this.isVisited = false;
        if (this.right.alignment == 131072) {
            return rightAttachment.plus(this.right.offset);
        }
        if (this.right.alignment == 0x1000000) {
            FormAttachment rightWidth = rightAttachment.minus(leftAttachment);
            return rightAttachment.minus(rightWidth.minus(this.cacheWidth).divide(2));
        }
        return leftAttachment.plus(this.right.offset);
    }

    FormAttachment getTopAttachment() {
        if (this.isVisited) {
            return new FormAttachment(0, 0);
        }
        if (this.top == null) {
            if (this.bottom == null) {
                return new FormAttachment(0, 0);
            }
            return this.getBottomAttachment().minus(this.cacheHeight);
        }
        if (this.top.control == null) {
            return this.top;
        }
        this.isVisited = true;
        FormData topData = (FormData)this.top.control.getLayoutData();
        FormAttachment topAttachment = topData.getTopAttachment();
        FormAttachment bottomAttachment = topData.getBottomAttachment();
        this.isVisited = false;
        if (this.top.alignment == 128) {
            return topAttachment.plus(this.top.offset);
        }
        if (this.top.alignment == 0x1000000) {
            FormAttachment topHeight = bottomAttachment.minus(topAttachment);
            return topAttachment.plus(topHeight.minus(this.cacheHeight).divide(2));
        }
        return bottomAttachment.plus(this.top.offset);
    }
}

