/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.imageanalyzer;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.Vector;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.ImageLoaderEvent;
import org.eclipse.swt.graphics.ImageLoaderListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.printing.PrintDialog;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ImageAnalyzer {
    static ResourceBundle bundle = ResourceBundle.getBundle("examples_images");
    Display display;
    Shell shell;
    Canvas imageCanvas;
    Canvas paletteCanvas;
    Label typeLabel;
    Label sizeLabel;
    Label depthLabel;
    Label transparentPixelLabel;
    Label timeToLoadLabel;
    Label screenSizeLabel;
    Label backgroundPixelLabel;
    Label locationLabel;
    Label disposalMethodLabel;
    Label delayTimeLabel;
    Label repeatCountLabel;
    Label paletteLabel;
    Label dataLabel;
    Label statusLabel;
    Combo backgroundCombo;
    Combo scaleXCombo;
    Combo scaleYCombo;
    Combo alphaCombo;
    Button incrementalCheck;
    Button transparentCheck;
    Button maskCheck;
    Button backgroundCheck;
    Button previousButton;
    Button nextButton;
    Button animateButton;
    StyledText dataText;
    Sash sash;
    Color whiteColor;
    Color blackColor;
    Color redColor;
    Color greenColor;
    Color blueColor;
    Color canvasBackground;
    Font fixedWidthFont;
    Cursor crossCursor;
    GC imageCanvasGC;
    int paletteWidth = 140;
    int ix = 0;
    int iy = 0;
    int py = 0;
    float xscale = 1.0f;
    float yscale = 1.0f;
    int alpha = 255;
    boolean incremental = false;
    boolean transparent = true;
    boolean showMask = false;
    boolean showBackground = false;
    boolean animate = false;
    Thread animateThread;
    Thread incrementalThread;
    String lastPath;
    String currentName;
    String fileName;
    ImageLoader loader;
    ImageData[] imageDataArray;
    int imageDataIndex;
    ImageData imageData;
    Image image;
    Vector incrementalEvents;
    long loadTime = 0L;
    static final int INDEX_DIGITS = 4;
    static final int ALPHA_CONSTANT = 0;
    static final int ALPHA_X = 1;
    static final int ALPHA_Y = 2;

    public static void main(String[] args) {
        Display display = new Display();
        ImageAnalyzer imageAnalyzer = new ImageAnalyzer();
        Shell shell = imageAnalyzer.open(display);
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
    }

    public Shell open(Display dpy) {
        this.display = dpy;
        this.shell = new Shell(this.display);
        this.shell.setText(bundle.getString("Image_analyzer"));
        this.shell.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent event) {
                ImageAnalyzer.this.resizeShell(event);
            }
        });
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                ImageAnalyzer.this.animate = false;
                if (ImageAnalyzer.this.animateThread != null) {
                    while (ImageAnalyzer.this.animateThread.isAlive()) {
                        if (ImageAnalyzer.this.display.readAndDispatch()) continue;
                        ImageAnalyzer.this.display.sleep();
                    }
                }
                e.doit = true;
            }
        });
        this.shell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (ImageAnalyzer.this.image != null) {
                    ImageAnalyzer.this.image.dispose();
                }
                ImageAnalyzer.this.whiteColor.dispose();
                ImageAnalyzer.this.blackColor.dispose();
                ImageAnalyzer.this.redColor.dispose();
                ImageAnalyzer.this.greenColor.dispose();
                ImageAnalyzer.this.blueColor.dispose();
                ImageAnalyzer.this.fixedWidthFont.dispose();
                ImageAnalyzer.this.crossCursor.dispose();
            }
        });
        this.whiteColor = new Color((Device)this.display, 255, 255, 255);
        this.blackColor = new Color((Device)this.display, 0, 0, 0);
        this.redColor = new Color((Device)this.display, 255, 0, 0);
        this.greenColor = new Color((Device)this.display, 0, 255, 0);
        this.blueColor = new Color((Device)this.display, 0, 0, 255);
        this.fixedWidthFont = new Font((Device)this.display, "courier", 10, 0);
        this.crossCursor = new Cursor((Device)this.display, 2);
        Menu menuBar = this.createMenuBar();
        this.createWidgets();
        this.shell.pack();
        this.imageCanvasGC = new GC((Drawable)this.imageCanvas);
        this.imageCanvas.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ImageAnalyzer.this.imageCanvasGC.dispose();
            }
        });
        this.shell.open();
        return this.shell;
    }

    void createWidgets() {
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.numColumns = 2;
        this.shell.setLayout((Layout)layout);
        Label separator = new Label((Composite)this.shell, 258);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        separator.setLayoutData((Object)gridData);
        Composite controls = new Composite((Composite)this.shell, 0);
        RowLayout rowLayout = new RowLayout();
        rowLayout.marginTop = 0;
        rowLayout.marginBottom = 5;
        rowLayout.spacing = 8;
        controls.setLayout((Layout)rowLayout);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        controls.setLayoutData((Object)gridData);
        Group group = new Group(controls, 0);
        group.setLayout((Layout)new RowLayout());
        group.setText(bundle.getString("Background"));
        this.backgroundCombo = new Combo((Composite)group, 12);
        this.backgroundCombo.setItems(new String[]{bundle.getString("None"), bundle.getString("White"), bundle.getString("Black"), bundle.getString("Red"), bundle.getString("Green"), bundle.getString("Blue")});
        this.backgroundCombo.select(this.backgroundCombo.indexOf(bundle.getString("White")));
        this.backgroundCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ImageAnalyzer.this.changeBackground();
            }
        });
        String[] values = new String[]{"0.1", "0.2", "0.3", "0.4", "0.5", "0.6", "0.7", "0.8", "0.9", "1", "1.1", "1.2", "1.3", "1.4", "1.5", "1.6", "1.7", "1.8", "1.9", "2", "3", "4", "5", "6", "7", "8", "9", "10"};
        group = new Group(controls, 0);
        group.setLayout((Layout)new RowLayout());
        group.setText(bundle.getString("X_scale"));
        this.scaleXCombo = new Combo((Composite)group, 4);
        int i = 0;
        while (i < values.length) {
            this.scaleXCombo.add(values[i]);
            ++i;
        }
        this.scaleXCombo.select(this.scaleXCombo.indexOf("1"));
        this.scaleXCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ImageAnalyzer.this.scaleX();
            }
        });
        group = new Group(controls, 0);
        group.setLayout((Layout)new RowLayout());
        group.setText(bundle.getString("Y_scale"));
        this.scaleYCombo = new Combo((Composite)group, 4);
        i = 0;
        while (i < values.length) {
            this.scaleYCombo.add(values[i]);
            ++i;
        }
        this.scaleYCombo.select(this.scaleYCombo.indexOf("1"));
        this.scaleYCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ImageAnalyzer.this.scaleY();
            }
        });
        group = new Group(controls, 0);
        group.setLayout((Layout)new RowLayout());
        group.setText(bundle.getString("Alpha_K"));
        this.alphaCombo = new Combo((Composite)group, 12);
        i = 0;
        while (i <= 255) {
            this.alphaCombo.add(String.valueOf(i));
            i += 5;
        }
        this.alphaCombo.select(this.alphaCombo.indexOf("255"));
        this.alphaCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ImageAnalyzer.this.alpha();
            }
        });
        group = new Group(controls, 0);
        group.setLayout((Layout)new RowLayout());
        group.setText(bundle.getString("Display"));
        this.incrementalCheck = new Button((Composite)group, 32);
        this.incrementalCheck.setText(bundle.getString("Incremental"));
        this.incrementalCheck.setSelection(this.incremental);
        this.incrementalCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ImageAnalyzer.this.incremental = ((Button)event.widget).getSelection();
            }
        });
        this.transparentCheck = new Button((Composite)group, 32);
        this.transparentCheck.setText(bundle.getString("Transparent"));
        this.transparentCheck.setSelection(this.transparent);
        this.transparentCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ImageAnalyzer.this.transparent = ((Button)event.widget).getSelection();
                if (ImageAnalyzer.this.image != null) {
                    ImageAnalyzer.this.imageCanvas.redraw();
                }
            }
        });
        this.maskCheck = new Button((Composite)group, 32);
        this.maskCheck.setText(bundle.getString("Mask"));
        this.maskCheck.setSelection(this.showMask);
        this.maskCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ImageAnalyzer.this.showMask = ((Button)event.widget).getSelection();
                if (ImageAnalyzer.this.image != null) {
                    ImageAnalyzer.this.imageCanvas.redraw();
                }
            }
        });
        this.backgroundCheck = new Button((Composite)group, 32);
        this.backgroundCheck.setText(bundle.getString("Background"));
        this.backgroundCheck.setSelection(this.showBackground);
        this.backgroundCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ImageAnalyzer.this.showBackground = ((Button)event.widget).getSelection();
            }
        });
        group = new Group(controls, 0);
        group.setLayout((Layout)new RowLayout());
        group.setText(bundle.getString("Animation"));
        this.previousButton = new Button((Composite)group, 8);
        this.previousButton.setText(bundle.getString("Previous"));
        this.previousButton.setEnabled(false);
        this.previousButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ImageAnalyzer.this.previous();
            }
        });
        this.nextButton = new Button((Composite)group, 8);
        this.nextButton.setText(bundle.getString("Next"));
        this.nextButton.setEnabled(false);
        this.nextButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ImageAnalyzer.this.next();
            }
        });
        this.animateButton = new Button((Composite)group, 8);
        this.animateButton.setText(bundle.getString("Animate"));
        this.animateButton.setEnabled(false);
        this.animateButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ImageAnalyzer.this.animate();
            }
        });
        this.typeLabel = new Label((Composite)this.shell, 0);
        this.typeLabel.setText(bundle.getString("Type_initial"));
        this.typeLabel.setLayoutData((Object)new GridData(256));
        this.imageCanvas = new Canvas((Composite)this.shell, 0x100300);
        this.imageCanvas.setBackground(this.whiteColor);
        this.imageCanvas.setCursor(this.crossCursor);
        gridData = new GridData();
        gridData.verticalSpan = 15;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.imageCanvas.setLayoutData((Object)gridData);
        this.imageCanvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent event) {
                if (ImageAnalyzer.this.image != null) {
                    ImageAnalyzer.this.paintImage(event);
                }
            }
        });
        this.imageCanvas.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent event) {
                if (ImageAnalyzer.this.image != null) {
                    ImageAnalyzer.this.showColorAt(event.x, event.y);
                }
            }
        });
        ScrollBar horizontal = this.imageCanvas.getHorizontalBar();
        horizontal.setVisible(true);
        horizontal.setMinimum(0);
        horizontal.setEnabled(false);
        horizontal.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ImageAnalyzer.this.scrollHorizontally((ScrollBar)event.widget);
            }
        });
        ScrollBar vertical = this.imageCanvas.getVerticalBar();
        vertical.setVisible(true);
        vertical.setMinimum(0);
        vertical.setEnabled(false);
        vertical.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ImageAnalyzer.this.scrollVertically((ScrollBar)event.widget);
            }
        });
        this.sizeLabel = new Label((Composite)this.shell, 0);
        this.sizeLabel.setText(bundle.getString("Size_initial"));
        this.sizeLabel.setLayoutData((Object)new GridData(256));
        this.depthLabel = new Label((Composite)this.shell, 0);
        this.depthLabel.setText(bundle.getString("Depth_initial"));
        this.depthLabel.setLayoutData((Object)new GridData(256));
        this.transparentPixelLabel = new Label((Composite)this.shell, 0);
        this.transparentPixelLabel.setText(bundle.getString("Transparent_pixel_initial"));
        this.transparentPixelLabel.setLayoutData((Object)new GridData(256));
        this.timeToLoadLabel = new Label((Composite)this.shell, 0);
        this.timeToLoadLabel.setText(bundle.getString("Time_to_load_initial"));
        this.timeToLoadLabel.setLayoutData((Object)new GridData(256));
        separator = new Label((Composite)this.shell, 258);
        separator.setLayoutData((Object)new GridData(256));
        this.screenSizeLabel = new Label((Composite)this.shell, 0);
        this.screenSizeLabel.setText(bundle.getString("Animation_size_initial"));
        this.screenSizeLabel.setLayoutData((Object)new GridData(256));
        this.backgroundPixelLabel = new Label((Composite)this.shell, 0);
        this.backgroundPixelLabel.setText(bundle.getString("Background_pixel_initial"));
        this.backgroundPixelLabel.setLayoutData((Object)new GridData(256));
        this.locationLabel = new Label((Composite)this.shell, 0);
        this.locationLabel.setText(bundle.getString("Image_location_initial"));
        this.locationLabel.setLayoutData((Object)new GridData(256));
        this.disposalMethodLabel = new Label((Composite)this.shell, 0);
        this.disposalMethodLabel.setText(bundle.getString("Disposal_initial"));
        this.disposalMethodLabel.setLayoutData((Object)new GridData(256));
        this.delayTimeLabel = new Label((Composite)this.shell, 0);
        this.delayTimeLabel.setText(bundle.getString("Delay_initial"));
        this.delayTimeLabel.setLayoutData((Object)new GridData(256));
        this.repeatCountLabel = new Label((Composite)this.shell, 0);
        this.repeatCountLabel.setText(bundle.getString("Repeats_initial"));
        this.repeatCountLabel.setLayoutData((Object)new GridData(256));
        separator = new Label((Composite)this.shell, 258);
        separator.setLayoutData((Object)new GridData(256));
        this.paletteLabel = new Label((Composite)this.shell, 0);
        this.paletteLabel.setText(bundle.getString("Palette_initial"));
        this.paletteLabel.setLayoutData((Object)new GridData(256));
        this.paletteCanvas = new Canvas((Composite)this.shell, 0x100A00);
        this.paletteCanvas.setFont(this.fixedWidthFont);
        this.paletteCanvas.getVerticalBar().setVisible(true);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        GC gc = new GC((Drawable)this.paletteLabel);
        this.paletteWidth = gc.stringExtent((String)ImageAnalyzer.bundle.getString((String)"Max_length_string")).x;
        gc.dispose();
        gridData.widthHint = this.paletteWidth;
        gridData.heightHint = 176;
        this.paletteCanvas.setLayoutData((Object)gridData);
        this.paletteCanvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent event) {
                if (ImageAnalyzer.this.image != null) {
                    ImageAnalyzer.this.paintPalette(event);
                }
            }
        });
        vertical = this.paletteCanvas.getVerticalBar();
        vertical.setVisible(true);
        vertical.setMinimum(0);
        vertical.setIncrement(10);
        vertical.setEnabled(false);
        vertical.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ImageAnalyzer.this.scrollPalette((ScrollBar)event.widget);
            }
        });
        this.sash = new Sash((Composite)this.shell, 256);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        this.sash.setLayoutData((Object)gridData);
        this.sash.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (event.detail != 1) {
                    ((GridData)ImageAnalyzer.this.paletteCanvas.getLayoutData()).heightHint = -1;
                    Rectangle paletteCanvasBounds = ImageAnalyzer.this.paletteCanvas.getBounds();
                    int minY = paletteCanvasBounds.y + 20;
                    Rectangle dataLabelBounds = ImageAnalyzer.this.dataLabel.getBounds();
                    int maxY = ImageAnalyzer.this.statusLabel.getBounds().y - dataLabelBounds.height - 20;
                    if (event.y > minY && event.y < maxY) {
                        Rectangle oldSash = ImageAnalyzer.this.sash.getBounds();
                        ImageAnalyzer.this.sash.setBounds(event.x, event.y, event.width, event.height);
                        int diff = event.y - oldSash.y;
                        Rectangle bounds = ImageAnalyzer.this.imageCanvas.getBounds();
                        ImageAnalyzer.this.imageCanvas.setBounds(bounds.x, bounds.y, bounds.width, bounds.height + diff);
                        bounds = paletteCanvasBounds;
                        ImageAnalyzer.this.paletteCanvas.setBounds(bounds.x, bounds.y, bounds.width, bounds.height + diff);
                        bounds = dataLabelBounds;
                        ImageAnalyzer.this.dataLabel.setBounds(bounds.x, bounds.y + diff, bounds.width, bounds.height);
                        bounds = ImageAnalyzer.this.dataText.getBounds();
                        ImageAnalyzer.this.dataText.setBounds(bounds.x, bounds.y + diff, bounds.width, bounds.height - diff);
                    }
                }
            }
        });
        this.dataLabel = new Label((Composite)this.shell, 0);
        this.dataLabel.setText(bundle.getString("Pixel_data_initial"));
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        this.dataLabel.setLayoutData((Object)gridData);
        this.dataText = new StyledText((Composite)this.shell, 2826);
        this.dataText.setBackground(this.display.getSystemColor(22));
        this.dataText.setFont(this.fixedWidthFont);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.heightHint = 128;
        gridData.grabExcessVerticalSpace = true;
        this.dataText.setLayoutData((Object)gridData);
        this.dataText.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent event) {
                if (ImageAnalyzer.this.image != null && event.button == 1) {
                    ImageAnalyzer.this.showColorForData();
                }
            }
        });
        this.dataText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (ImageAnalyzer.this.image != null) {
                    ImageAnalyzer.this.showColorForData();
                }
            }
        });
        this.statusLabel = new Label((Composite)this.shell, 0);
        this.statusLabel.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        this.statusLabel.setLayoutData((Object)gridData);
    }

    Menu createMenuBar() {
        Menu menuBar = new Menu((Decorations)this.shell, 2);
        this.shell.setMenuBar(menuBar);
        this.createFileMenu(menuBar);
        this.createAlphaMenu(menuBar);
        return menuBar;
    }

    void createFileMenu(Menu menuBar) {
        MenuItem item = new MenuItem(menuBar, 64);
        item.setText(bundle.getString("File"));
        Menu fileMenu = new Menu((Decorations)this.shell, 4);
        item.setMenu(fileMenu);
        item = new MenuItem(fileMenu, 0);
        item.setText(bundle.getString("OpenFile"));
        item.setAccelerator(262223);
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ImageAnalyzer.this.menuOpenFile();
            }
        });
        item = new MenuItem(fileMenu, 0);
        item.setText(bundle.getString("OpenURL"));
        item.setAccelerator(262229);
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ImageAnalyzer.this.menuOpenURL();
            }
        });
        item = new MenuItem(fileMenu, 0);
        item.setText(bundle.getString("Reopen"));
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ImageAnalyzer.this.menuReopen();
            }
        });
        new MenuItem(fileMenu, 2);
        item = new MenuItem(fileMenu, 0);
        item.setText(bundle.getString("Save"));
        item.setAccelerator(262227);
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ImageAnalyzer.this.menuSave();
            }
        });
        item = new MenuItem(fileMenu, 0);
        item.setText(bundle.getString("Save_as"));
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ImageAnalyzer.this.menuSaveAs();
            }
        });
        item = new MenuItem(fileMenu, 0);
        item.setText(bundle.getString("Save_mask_as"));
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ImageAnalyzer.this.menuSaveMaskAs();
            }
        });
        new MenuItem(fileMenu, 2);
        item = new MenuItem(fileMenu, 0);
        item.setText(bundle.getString("Print"));
        item.setAccelerator(262224);
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ImageAnalyzer.this.menuPrint();
            }
        });
        new MenuItem(fileMenu, 2);
        item = new MenuItem(fileMenu, 0);
        item.setText(bundle.getString("Exit"));
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ImageAnalyzer.this.shell.close();
            }
        });
    }

    void createAlphaMenu(Menu menuBar) {
        MenuItem item = new MenuItem(menuBar, 64);
        item.setText(bundle.getString("Alpha"));
        Menu alphaMenu = new Menu((Decorations)this.shell, 4);
        item.setMenu(alphaMenu);
        item = new MenuItem(alphaMenu, 0);
        item.setText("K");
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ImageAnalyzer.this.menuComposeAlpha(0);
            }
        });
        item = new MenuItem(alphaMenu, 0);
        item.setText("(K + x) % 256");
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ImageAnalyzer.this.menuComposeAlpha(1);
            }
        });
        item = new MenuItem(alphaMenu, 0);
        item.setText("(K + y) % 256");
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ImageAnalyzer.this.menuComposeAlpha(2);
            }
        });
    }

    void menuComposeAlpha(int alpha_op) {
        if (this.image == null) {
            return;
        }
        this.animate = false;
        Cursor waitCursor = new Cursor((Device)this.display, 1);
        this.shell.setCursor(waitCursor);
        this.imageCanvas.setCursor(waitCursor);
        try {
            if (alpha_op == 0) {
                this.imageData.alpha = this.alpha;
            } else {
                this.imageData.alpha = -1;
                switch (alpha_op) {
                    case 1: {
                        int y = 0;
                        while (y < this.imageData.height) {
                            int x = 0;
                            while (x < this.imageData.width) {
                                this.imageData.setAlpha(x, y, (x + this.alpha) % 256);
                                ++x;
                            }
                            ++y;
                        }
                        break;
                    }
                    case 2: {
                        int y = 0;
                        while (y < this.imageData.height) {
                            int x = 0;
                            while (x < this.imageData.width) {
                                this.imageData.setAlpha(x, y, (y + this.alpha) % 256);
                                ++x;
                            }
                            ++y;
                        }
                        break;
                    }
                }
            }
            this.displayImage(this.imageData);
        }
        catch (Throwable throwable) {
            Object var5_8 = null;
            this.shell.setCursor(null);
            this.imageCanvas.setCursor(this.crossCursor);
            waitCursor.dispose();
            throw throwable;
        }
        Object var5_9 = null;
        this.shell.setCursor(null);
        this.imageCanvas.setCursor(this.crossCursor);
        waitCursor.dispose();
    }

    void menuOpenFile() {
        this.animate = false;
        this.resetScaleCombos();
        FileDialog fileChooser = new FileDialog(this.shell, 4096);
        if (this.lastPath != null) {
            fileChooser.setFilterPath(this.lastPath);
        }
        fileChooser.setFilterExtensions(new String[]{"*.bmp; *.gif; *.ico; *.jpg; *.pcx; *.png; *.tif", "*.bmp", "*.gif", "*.ico", "*.jpg", "*.pcx", "*.png", "*.tif"});
        fileChooser.setFilterNames(new String[]{String.valueOf(bundle.getString("All_images")) + " (bmp, gif, ico, jpg, pcx, png, tif)", "BMP (*.bmp)", "GIF (*.gif)", "ICO (*.ico)", "JPEG (*.jpg)", "PCX (*.pcx)", "PNG (*.png)", "TIFF (*.tif)"});
        String filename = fileChooser.open();
        this.lastPath = fileChooser.getFilterPath();
        if (filename == null) {
            return;
        }
        Cursor waitCursor = new Cursor((Device)this.display, 1);
        this.shell.setCursor(waitCursor);
        this.imageCanvas.setCursor(waitCursor);
        try {
            try {
                this.loader = new ImageLoader();
                if (this.incremental) {
                    this.loader.addImageLoaderListener(new ImageLoaderListener(){

                        public void imageDataLoaded(ImageLoaderEvent event) {
                            ImageAnalyzer.this.incrementalDataLoaded(event);
                        }
                    });
                    this.incrementalThreadStart();
                }
                long startTime = System.currentTimeMillis();
                this.imageDataArray = this.loader.load(filename);
                this.loadTime = System.currentTimeMillis() - startTime;
                if (this.imageDataArray.length > 0) {
                    this.currentName = filename;
                    this.fileName = filename;
                    this.previousButton.setEnabled(this.imageDataArray.length > 1);
                    this.nextButton.setEnabled(this.imageDataArray.length > 1);
                    this.animateButton.setEnabled(this.imageDataArray.length > 1 && this.loader.logicalScreenWidth > 0 && this.loader.logicalScreenHeight > 0);
                    this.imageDataIndex = 0;
                    this.displayImage(this.imageDataArray[this.imageDataIndex]);
                    this.resetScrollBars();
                }
            }
            catch (SWTException e) {
                this.showErrorDialog(bundle.getString("Loading_lc"), filename, (Exception)((Object)e));
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.shell.setCursor(null);
            this.imageCanvas.setCursor(this.crossCursor);
            waitCursor.dispose();
            throw throwable;
        }
        Object var6_8 = null;
        this.shell.setCursor(null);
        this.imageCanvas.setCursor(this.crossCursor);
        waitCursor.dispose();
    }

    void menuOpenURL() {
        this.animate = false;
        this.resetScaleCombos();
        TextPrompter textPrompter = new TextPrompter(this.shell, 67680);
        textPrompter.setText(bundle.getString("OpenURLDialog"));
        textPrompter.setMessage(bundle.getString("EnterURL"));
        String urlname = textPrompter.open();
        if (urlname == null) {
            return;
        }
        Cursor waitCursor = new Cursor((Device)this.display, 1);
        this.shell.setCursor(waitCursor);
        this.imageCanvas.setCursor(waitCursor);
        try {
            try {
                URL url = new URL(urlname);
                InputStream stream = url.openStream();
                this.loader = new ImageLoader();
                if (this.incremental) {
                    this.loader.addImageLoaderListener(new ImageLoaderListener(){

                        public void imageDataLoaded(ImageLoaderEvent event) {
                            ImageAnalyzer.this.incrementalDataLoaded(event);
                        }
                    });
                    this.incrementalThreadStart();
                }
                long startTime = System.currentTimeMillis();
                this.imageDataArray = this.loader.load(stream);
                this.loadTime = System.currentTimeMillis() - startTime;
                if (this.imageDataArray.length > 0) {
                    this.currentName = urlname;
                    this.fileName = null;
                    this.previousButton.setEnabled(this.imageDataArray.length > 1);
                    this.nextButton.setEnabled(this.imageDataArray.length > 1);
                    this.animateButton.setEnabled(this.imageDataArray.length > 1 && this.loader.logicalScreenWidth > 0 && this.loader.logicalScreenHeight > 0);
                    this.imageDataIndex = 0;
                    this.displayImage(this.imageDataArray[this.imageDataIndex]);
                    this.resetScrollBars();
                }
            }
            catch (Exception e) {
                this.showErrorDialog(bundle.getString("Loading_lc"), urlname, e);
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            this.shell.setCursor(null);
            this.imageCanvas.setCursor(this.crossCursor);
            waitCursor.dispose();
            throw throwable;
        }
        Object var8_10 = null;
        this.shell.setCursor(null);
        this.imageCanvas.setCursor(this.crossCursor);
        waitCursor.dispose();
    }

    void incrementalThreadStart() {
        this.incrementalEvents = new Vector();
        this.incrementalThread = new Thread("Incremental"){

            public void run() {
                while (ImageAnalyzer.this.incrementalEvents != null) {
                    ImageAnalyzer imageAnalyzer = ImageAnalyzer.this;
                    synchronized (imageAnalyzer) {
                        if (ImageAnalyzer.this.incrementalEvents != null) {
                            if (ImageAnalyzer.this.incrementalEvents.size() > 0) {
                                ImageLoaderEvent event = (ImageLoaderEvent)ImageAnalyzer.this.incrementalEvents.remove(0);
                                if (ImageAnalyzer.this.image != null) {
                                    ImageAnalyzer.this.image.dispose();
                                }
                                ImageAnalyzer.this.image = new Image((Device)ImageAnalyzer.this.display, event.imageData);
                                ImageAnalyzer.this.imageData = event.imageData;
                                ImageAnalyzer.this.imageCanvasGC.drawImage(ImageAnalyzer.this.image, 0, 0, ImageAnalyzer.this.imageData.width, ImageAnalyzer.this.imageData.height, ImageAnalyzer.this.imageData.x, ImageAnalyzer.this.imageData.y, ImageAnalyzer.this.imageData.width, ImageAnalyzer.this.imageData.height);
                            } else {
                                Thread.yield();
                            }
                        }
                    }
                }
                ImageAnalyzer.this.display.wake();
            }
        };
        this.incrementalThread.setDaemon(true);
        this.incrementalThread.start();
    }

    void incrementalDataLoaded(ImageLoaderEvent event) {
        ImageAnalyzer imageAnalyzer = this;
        synchronized (imageAnalyzer) {
            this.incrementalEvents.addElement(event);
        }
    }

    void menuSave() {
        if (this.image == null) {
            return;
        }
        this.animate = false;
        if (this.imageData.type == -1 || this.fileName == null) {
            this.menuSaveAs();
            return;
        }
        Cursor waitCursor = new Cursor((Device)this.display, 1);
        this.shell.setCursor(waitCursor);
        this.imageCanvas.setCursor(waitCursor);
        try {
            try {
                this.loader.data = new ImageData[]{this.imageData};
                this.loader.save(this.fileName, this.imageData.type);
            }
            catch (SWTException e) {
                this.showErrorDialog(bundle.getString("Saving_lc"), this.fileName, (Exception)((Object)e));
            }
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.shell.setCursor(null);
            this.imageCanvas.setCursor(this.crossCursor);
            waitCursor.dispose();
            throw throwable;
        }
        Object var3_5 = null;
        this.shell.setCursor(null);
        this.imageCanvas.setCursor(this.crossCursor);
        waitCursor.dispose();
    }

    void menuSaveAs() {
        if (this.image == null) {
            return;
        }
        this.animate = false;
        FileDialog fileChooser = new FileDialog(this.shell, 8192);
        fileChooser.setFilterPath(this.lastPath);
        if (this.fileName != null) {
            fileChooser.setFileName(this.fileName);
        }
        fileChooser.setFilterExtensions(new String[]{"*.bmp", "*.gif", "*.ico", "*.jpg", "*.png"});
        fileChooser.setFilterNames(new String[]{"BMP (*.bmp)", "GIF (*.gif)", "ICO (*.ico)", "JPEG (*.jpg)", "PNG (*.png)"});
        String filename = fileChooser.open();
        this.lastPath = fileChooser.getFilterPath();
        if (filename == null) {
            return;
        }
        int filetype = ImageAnalyzer.determineFileType(filename);
        if (filetype == -1) {
            MessageBox box = new MessageBox(this.shell, 1);
            box.setMessage(ImageAnalyzer.createMsg(bundle.getString("Unknown_extension"), filename.substring(filename.lastIndexOf(46) + 1)));
            box.open();
            return;
        }
        if (new File(filename).exists()) {
            MessageBox box = new MessageBox(this.shell, 292);
            box.setMessage(ImageAnalyzer.createMsg(bundle.getString("Overwrite"), filename));
            if (box.open() == 256) {
                return;
            }
        }
        Cursor waitCursor = new Cursor((Device)this.display, 1);
        this.shell.setCursor(waitCursor);
        this.imageCanvas.setCursor(waitCursor);
        try {
            try {
                this.loader.data = new ImageData[]{this.imageData};
                this.loader.save(filename, filetype);
                this.fileName = filename;
                this.shell.setText(ImageAnalyzer.createMsg(bundle.getString("Analyzer_on"), filename));
                this.typeLabel.setText(ImageAnalyzer.createMsg(bundle.getString("Type_string"), ImageAnalyzer.fileTypeString(filetype)));
            }
            catch (SWTException e) {
                this.showErrorDialog(bundle.getString("Saving_lc"), filename, (Exception)((Object)e));
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            this.shell.setCursor(null);
            this.imageCanvas.setCursor(this.crossCursor);
            waitCursor.dispose();
            throw throwable;
        }
        Object var6_9 = null;
        this.shell.setCursor(null);
        this.imageCanvas.setCursor(this.crossCursor);
        waitCursor.dispose();
    }

    void menuSaveMaskAs() {
        if (this.image == null || !this.showMask) {
            return;
        }
        if (this.imageData.getTransparencyType() == 0) {
            return;
        }
        this.animate = false;
        FileDialog fileChooser = new FileDialog(this.shell, 8192);
        fileChooser.setFilterPath(this.lastPath);
        if (this.fileName != null) {
            fileChooser.setFileName(this.fileName);
        }
        fileChooser.setFilterExtensions(new String[]{"*.bmp", "*.gif", "*.ico", "*.jpg", "*.png"});
        fileChooser.setFilterNames(new String[]{"BMP (*.bmp)", "GIF (*.gif)", "ICO (*.ico)", "JPEG (*.jpg)", "PNG (*.png)"});
        String filename = fileChooser.open();
        this.lastPath = fileChooser.getFilterPath();
        if (filename == null) {
            return;
        }
        int filetype = ImageAnalyzer.determineFileType(filename);
        if (filetype == -1) {
            MessageBox box = new MessageBox(this.shell, 1);
            box.setMessage(ImageAnalyzer.createMsg(bundle.getString("Unknown_extension"), filename.substring(filename.lastIndexOf(46) + 1)));
            box.open();
            return;
        }
        if (new File(filename).exists()) {
            MessageBox box = new MessageBox(this.shell, 292);
            box.setMessage(ImageAnalyzer.createMsg(bundle.getString("Overwrite"), filename));
            if (box.open() == 256) {
                return;
            }
        }
        Cursor waitCursor = new Cursor((Device)this.display, 1);
        this.shell.setCursor(waitCursor);
        this.imageCanvas.setCursor(waitCursor);
        try {
            try {
                ImageData maskImageData = this.imageData.getTransparencyMask();
                this.loader.data = new ImageData[]{maskImageData};
                this.loader.save(filename, filetype);
            }
            catch (SWTException e) {
                this.showErrorDialog(bundle.getString("Saving_lc"), filename, (Exception)((Object)e));
            }
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            this.shell.setCursor(null);
            this.imageCanvas.setCursor(this.crossCursor);
            waitCursor.dispose();
            throw throwable;
        }
        Object var6_10 = null;
        this.shell.setCursor(null);
        this.imageCanvas.setCursor(this.crossCursor);
        waitCursor.dispose();
    }

    void menuPrint() {
        if (this.image == null) {
            return;
        }
        try {
            PrintDialog dialog = new PrintDialog(this.shell, 0);
            PrinterData printerData = dialog.open();
            if (printerData == null) {
                return;
            }
            Printer printer = new Printer(printerData);
            Point screenDPI = this.display.getDPI();
            Point printerDPI = printer.getDPI();
            int scaleFactor = printerDPI.x / screenDPI.x;
            Rectangle trim = printer.computeTrim(0, 0, 0, 0);
            if (printer.startJob(this.currentName)) {
                if (printer.startPage()) {
                    GC gc = new GC((Drawable)printer);
                    int transparentPixel = this.imageData.transparentPixel;
                    if (transparentPixel != -1 && !this.transparent) {
                        this.imageData.transparentPixel = -1;
                    }
                    Image printerImage = new Image((Device)printer, this.imageData);
                    gc.drawImage(printerImage, 0, 0, this.imageData.width, this.imageData.height, -trim.x, -trim.y, scaleFactor * this.imageData.width, scaleFactor * this.imageData.height);
                    if (transparentPixel != -1 && !this.transparent) {
                        this.imageData.transparentPixel = transparentPixel;
                    }
                    printerImage.dispose();
                    gc.dispose();
                    printer.endPage();
                }
                printer.endJob();
            }
            printer.dispose();
        }
        catch (SWTError e) {
            MessageBox box = new MessageBox(this.shell, 1);
            box.setMessage(String.valueOf(bundle.getString("Printing_error")) + e.getMessage());
            box.open();
        }
    }

    void menuReopen() {
        if (this.currentName == null) {
            return;
        }
        this.animate = false;
        this.resetScrollBars();
        this.resetScaleCombos();
        Cursor waitCursor = new Cursor((Device)this.display, 1);
        this.shell.setCursor(waitCursor);
        this.imageCanvas.setCursor(waitCursor);
        try {
            try {
                ImageData[] newImageData;
                this.loader = new ImageLoader();
                long startTime = System.currentTimeMillis();
                if (this.fileName == null) {
                    URL url = new URL(this.currentName);
                    InputStream stream = url.openStream();
                    newImageData = this.loader.load(stream);
                } else {
                    newImageData = this.loader.load(this.fileName);
                }
                this.loadTime = System.currentTimeMillis() - startTime;
                this.imageDataIndex = 0;
                this.displayImage(newImageData[this.imageDataIndex]);
            }
            catch (Exception e) {
                this.showErrorDialog(bundle.getString("Reloading_lc"), this.currentName, e);
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this.shell.setCursor(null);
            this.imageCanvas.setCursor(this.crossCursor);
            waitCursor.dispose();
            throw throwable;
        }
        Object var7_9 = null;
        this.shell.setCursor(null);
        this.imageCanvas.setCursor(this.crossCursor);
        waitCursor.dispose();
    }

    void changeBackground() {
        String background = this.backgroundCombo.getText();
        if (background.equals(bundle.getString("White"))) {
            this.imageCanvas.setBackground(this.whiteColor);
        } else if (background.equals(bundle.getString("Black"))) {
            this.imageCanvas.setBackground(this.blackColor);
        } else if (background.equals(bundle.getString("Red"))) {
            this.imageCanvas.setBackground(this.redColor);
        } else if (background.equals(bundle.getString("Green"))) {
            this.imageCanvas.setBackground(this.greenColor);
        } else if (background.equals(bundle.getString("Blue"))) {
            this.imageCanvas.setBackground(this.blueColor);
        } else {
            this.imageCanvas.setBackground(null);
        }
    }

    void scaleX() {
        try {
            this.xscale = Float.parseFloat(this.scaleXCombo.getText());
        }
        catch (NumberFormatException e) {
            this.xscale = 1.0f;
            this.scaleXCombo.select(this.scaleXCombo.indexOf("1"));
        }
        if (this.image != null) {
            this.resizeScrollBars();
            this.imageCanvas.redraw();
        }
    }

    void scaleY() {
        try {
            this.yscale = Float.parseFloat(this.scaleYCombo.getText());
        }
        catch (NumberFormatException e) {
            this.yscale = 1.0f;
            this.scaleYCombo.select(this.scaleYCombo.indexOf("1"));
        }
        if (this.image != null) {
            this.resizeScrollBars();
            this.imageCanvas.redraw();
        }
    }

    void alpha() {
        try {
            this.alpha = Integer.parseInt(this.alphaCombo.getText());
        }
        catch (NumberFormatException e) {
            this.alphaCombo.select(this.alphaCombo.indexOf("255"));
            this.alpha = 255;
        }
    }

    void showColorAt(int mx, int my) {
        int x = mx - this.imageData.x - this.ix;
        int y = my - this.imageData.y - this.iy;
        this.showColorForPixel(x, y);
    }

    void showColorForData() {
        int y;
        int delimiterLength = this.dataText.getLineDelimiter().length();
        int charactersPerLine = 6 + 3 * this.imageData.bytesPerLine + delimiterLength;
        int position = this.dataText.getCaretOffset();
        if (position - (y = position / charactersPerLine) * charactersPerLine < 6 || (y + 1) * charactersPerLine - position <= delimiterLength) {
            this.statusLabel.setText("");
            return;
        }
        int dataPosition = position - 6 * (y + 1) - delimiterLength * y;
        int byteNumber = dataPosition / 3;
        int where = dataPosition - byteNumber * 3;
        int xByte = byteNumber % this.imageData.bytesPerLine;
        int x = -1;
        int depth = this.imageData.depth;
        if (depth == 1) {
            if (where == 0) {
                x = xByte * 8;
            }
            if (where == 1) {
                x = xByte * 8 + 3;
            }
            if (where == 2) {
                x = xByte * 8 + 7;
            }
        }
        if (depth == 2) {
            if (where == 0) {
                x = xByte * 4;
            }
            if (where == 1) {
                x = xByte * 4 + 1;
            }
            if (where == 2) {
                x = xByte * 4 + 3;
            }
        }
        if (depth == 4) {
            if (where == 0) {
                x = xByte * 2;
            }
            if (where == 1) {
                x = xByte * 2;
            }
            if (where == 2) {
                x = xByte * 2 + 1;
            }
        }
        if (depth == 8) {
            x = xByte;
        }
        if (depth == 16) {
            x = xByte / 2;
        }
        if (depth == 24) {
            x = xByte / 3;
        }
        if (depth == 32) {
            x = xByte / 4;
        }
        if (x != -1) {
            this.showColorForPixel(x, y);
        } else {
            this.statusLabel.setText("");
        }
    }

    void showColorForPixel(int x, int y) {
        if (x >= 0 && x < this.imageData.width && y >= 0 && y < this.imageData.height) {
            int pixel = this.imageData.getPixel(x, y);
            RGB rgb = this.imageData.palette.getRGB(pixel);
            Object[] args = new Object[]{new Integer(x), new Integer(y), new Integer(pixel), Integer.toHexString(pixel), rgb};
            if (pixel == this.imageData.transparentPixel) {
                this.statusLabel.setText(ImageAnalyzer.createMsg(bundle.getString("Color_at_trans"), args));
            } else {
                this.statusLabel.setText(ImageAnalyzer.createMsg(bundle.getString("Color_at"), args));
            }
        } else {
            this.statusLabel.setText("");
        }
    }

    void animate() {
        boolean bl = this.animate = !this.animate;
        if (this.animate && this.image != null && this.imageDataArray.length > 1) {
            this.animateThread = new Thread(bundle.getString("Animation")){

                public void run() {
                    ImageAnalyzer.this.preAnimation();
                    try {
                        ImageAnalyzer.this.animateLoop();
                    }
                    catch (SWTException e) {
                        ImageAnalyzer.this.display.syncExec(new Runnable(this, e){
                            private final /* synthetic */ 41 this$1;
                            private final /* synthetic */ SWTException val$e;
                            {
                                this.this$1 = var1_1;
                                this.val$e = sWTException;
                            }

                            public void run() {
                                41.access$0(this.this$1).showErrorDialog(ImageAnalyzer.createMsg(bundle.getString("Creating_image"), new Integer(41.access$0(this.this$1).imageDataIndex + 1)), 41.access$0(this.this$1).currentName, (Exception)((Object)this.val$e));
                            }
                        });
                    }
                    ImageAnalyzer.this.postAnimation();
                }

                static /* synthetic */ ImageAnalyzer access$0(41 var0) {
                    return var0.ImageAnalyzer.this;
                }
            };
            this.animateThread.setDaemon(true);
            this.animateThread.start();
        }
    }

    void animateLoop() {
        Image offScreenImage = new Image((Device)this.display, this.loader.logicalScreenWidth, this.loader.logicalScreenHeight);
        GC offScreenImageGC = new GC((Drawable)offScreenImage);
        try {
            this.display.syncExec(new Runnable(){

                public void run() {
                    ImageAnalyzer.this.canvasBackground = ImageAnalyzer.this.imageCanvas.getBackground();
                }
            });
            offScreenImageGC.setBackground(this.canvasBackground);
            offScreenImageGC.fillRectangle(0, 0, this.loader.logicalScreenWidth, this.loader.logicalScreenHeight);
            offScreenImageGC.drawImage(this.image, 0, 0, this.imageData.width, this.imageData.height, this.imageData.x, this.imageData.y, this.imageData.width, this.imageData.height);
            int repeatCount = this.loader.repeatCount;
            while (this.animate && (this.loader.repeatCount == 0 || repeatCount > 0)) {
                if (this.imageData.disposalMethod == 2) {
                    Object var6_7;
                    Color bgColor = null;
                    int backgroundPixel = this.loader.backgroundPixel;
                    if (this.showBackground && backgroundPixel != -1) {
                        RGB backgroundRGB = this.imageData.palette.getRGB(backgroundPixel);
                        bgColor = new Color(null, backgroundRGB);
                    }
                    try {
                        offScreenImageGC.setBackground(bgColor != null ? bgColor : this.canvasBackground);
                        offScreenImageGC.fillRectangle(this.imageData.x, this.imageData.y, this.imageData.width, this.imageData.height);
                    }
                    catch (Throwable throwable) {
                        var6_7 = null;
                        if (bgColor != null) {
                            bgColor.dispose();
                        }
                        throw throwable;
                    }
                    var6_7 = null;
                    if (bgColor != null) {
                        bgColor.dispose();
                    }
                } else if (this.imageData.disposalMethod == 3) {
                    offScreenImageGC.drawImage(this.image, 0, 0, this.imageData.width, this.imageData.height, this.imageData.x, this.imageData.y, this.imageData.width, this.imageData.height);
                }
                this.imageDataIndex = (this.imageDataIndex + 1) % this.imageDataArray.length;
                this.imageData = this.imageDataArray[this.imageDataIndex];
                this.image.dispose();
                this.image = new Image((Device)this.display, this.imageData);
                offScreenImageGC.drawImage(this.image, 0, 0, this.imageData.width, this.imageData.height, this.imageData.x, this.imageData.y, this.imageData.width, this.imageData.height);
                this.imageCanvasGC.drawImage(offScreenImage, 0, 0);
                try {
                    Thread.sleep(ImageAnalyzer.visibleDelay(this.imageData.delayTime * 10));
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (this.imageDataIndex != this.imageDataArray.length - 1) continue;
                --repeatCount;
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            offScreenImage.dispose();
            offScreenImageGC.dispose();
            throw throwable;
        }
        Object var8_11 = null;
        offScreenImage.dispose();
        offScreenImageGC.dispose();
    }

    void preAnimation() {
        this.display.syncExec(new Runnable(){

            public void run() {
                ImageAnalyzer.this.animateButton.setText(bundle.getString("Stop"));
                ImageAnalyzer.this.previousButton.setEnabled(false);
                ImageAnalyzer.this.nextButton.setEnabled(false);
                ImageAnalyzer.this.backgroundCombo.setEnabled(false);
                ImageAnalyzer.this.scaleXCombo.setEnabled(false);
                ImageAnalyzer.this.scaleYCombo.setEnabled(false);
                ImageAnalyzer.this.alphaCombo.setEnabled(false);
                ImageAnalyzer.this.incrementalCheck.setEnabled(false);
                ImageAnalyzer.this.transparentCheck.setEnabled(false);
                ImageAnalyzer.this.maskCheck.setEnabled(false);
                ImageAnalyzer.this.resetScaleCombos();
                ImageAnalyzer.this.resetScrollBars();
            }
        });
    }

    void postAnimation() {
        this.display.syncExec(new Runnable(){

            public void run() {
                ImageAnalyzer.this.previousButton.setEnabled(true);
                ImageAnalyzer.this.nextButton.setEnabled(true);
                ImageAnalyzer.this.backgroundCombo.setEnabled(true);
                ImageAnalyzer.this.scaleXCombo.setEnabled(true);
                ImageAnalyzer.this.scaleYCombo.setEnabled(true);
                ImageAnalyzer.this.alphaCombo.setEnabled(true);
                ImageAnalyzer.this.incrementalCheck.setEnabled(true);
                ImageAnalyzer.this.transparentCheck.setEnabled(true);
                ImageAnalyzer.this.maskCheck.setEnabled(true);
                ImageAnalyzer.this.animateButton.setText(bundle.getString("Animate"));
                if (ImageAnalyzer.this.animate) {
                    ImageAnalyzer.this.animate = false;
                } else {
                    ImageAnalyzer.this.displayImage(ImageAnalyzer.this.imageDataArray[ImageAnalyzer.this.imageDataIndex]);
                }
            }
        });
    }

    void previous() {
        if (this.image != null && this.imageDataArray.length > 1) {
            if (this.imageDataIndex == 0) {
                this.imageDataIndex = this.imageDataArray.length;
            }
            --this.imageDataIndex;
            this.displayImage(this.imageDataArray[this.imageDataIndex]);
        }
    }

    void next() {
        if (this.image != null && this.imageDataArray.length > 1) {
            this.imageDataIndex = (this.imageDataIndex + 1) % this.imageDataArray.length;
            this.displayImage(this.imageDataArray[this.imageDataIndex]);
        }
    }

    /*
     * Unable to fully structure code
     */
    void displayImage(ImageData newImageData) {
        block8: {
            if (!this.incremental || this.incrementalThread == null) break block8;
            var2_2 = this;
            synchronized (var2_2) {
                this.incrementalEvents = null;
                // MONITOREXIT @DISABLED, blocks:[0, 2] lbl6 : MonitorExitStatement: MONITOREXIT : var2_2
                if (true) ** GOTO lbl14
            }
            do {
                if (this.display.readAndDispatch()) continue;
                this.display.sleep();
lbl14:
                // 3 sources

            } while (this.incrementalThread.isAlive());
        }
        if (this.image != null) {
            this.image.dispose();
        }
        try {
            this.image = new Image((Device)this.display, newImageData);
            this.imageData = newImageData;
        }
        catch (SWTException e) {
            this.showErrorDialog(String.valueOf(ImageAnalyzer.bundle.getString("Creating_from")) + " ", this.currentName, (Exception)e);
            this.image = null;
            return;
        }
        string = ImageAnalyzer.createMsg(ImageAnalyzer.bundle.getString("Analyzer_on"), this.currentName);
        this.shell.setText(string);
        string = this.imageDataArray.length > 1 ? ImageAnalyzer.createMsg(ImageAnalyzer.bundle.getString("Type_index"), new Object[]{ImageAnalyzer.fileTypeString(this.imageData.type), new Integer(this.imageDataIndex + 1), new Integer(this.imageDataArray.length)}) : ImageAnalyzer.createMsg(ImageAnalyzer.bundle.getString("Type_string"), ImageAnalyzer.fileTypeString(this.imageData.type));
        this.typeLabel.setText(string);
        string = ImageAnalyzer.createMsg(ImageAnalyzer.bundle.getString("Size_value"), new Object[]{new Integer(this.imageData.width), new Integer(this.imageData.height)});
        this.sizeLabel.setText(string);
        string = ImageAnalyzer.createMsg(ImageAnalyzer.bundle.getString("Depth_value"), new Integer(this.imageData.depth));
        this.depthLabel.setText(string);
        string = ImageAnalyzer.createMsg(ImageAnalyzer.bundle.getString("Transparent_pixel_value"), ImageAnalyzer.pixelInfo(this.imageData.transparentPixel));
        this.transparentPixelLabel.setText(string);
        string = ImageAnalyzer.createMsg(ImageAnalyzer.bundle.getString("Time_to_load_value"), new Long(this.loadTime));
        this.timeToLoadLabel.setText(string);
        string = ImageAnalyzer.createMsg(ImageAnalyzer.bundle.getString("Animation_size_value"), new Object[]{new Integer(this.loader.logicalScreenWidth), new Integer(this.loader.logicalScreenHeight)});
        this.screenSizeLabel.setText(string);
        string = ImageAnalyzer.createMsg(ImageAnalyzer.bundle.getString("Background_pixel_value"), ImageAnalyzer.pixelInfo(this.loader.backgroundPixel));
        this.backgroundPixelLabel.setText(string);
        string = ImageAnalyzer.createMsg(ImageAnalyzer.bundle.getString("Image_location_value"), new Object[]{new Integer(this.imageData.x), new Integer(this.imageData.y)});
        this.locationLabel.setText(string);
        string = ImageAnalyzer.createMsg(ImageAnalyzer.bundle.getString("Disposal_value"), new Object[]{new Integer(this.imageData.disposalMethod), ImageAnalyzer.disposalString(this.imageData.disposalMethod)});
        this.disposalMethodLabel.setText(string);
        delay = this.imageData.delayTime * 10;
        delayUsed = ImageAnalyzer.visibleDelay(delay);
        string = delay != delayUsed ? ImageAnalyzer.createMsg(ImageAnalyzer.bundle.getString("Delay_value"), new Object[]{new Integer(delay), new Integer(delayUsed)}) : ImageAnalyzer.createMsg(ImageAnalyzer.bundle.getString("Delay_used"), new Integer(delay));
        this.delayTimeLabel.setText(string);
        string = this.loader.repeatCount == 0 ? ImageAnalyzer.createMsg(ImageAnalyzer.bundle.getString("Repeats_forever"), new Integer(this.loader.repeatCount)) : ImageAnalyzer.createMsg(ImageAnalyzer.bundle.getString("Repeats_value"), new Integer(this.loader.repeatCount));
        this.repeatCountLabel.setText(string);
        string = this.imageData.palette.isDirect != false ? ImageAnalyzer.bundle.getString("Palette_direct") : ImageAnalyzer.createMsg(ImageAnalyzer.bundle.getString("Palette_value"), new Integer(this.imageData.palette.getRGBs().length));
        this.paletteLabel.setText(string);
        string = ImageAnalyzer.createMsg(ImageAnalyzer.bundle.getString("Pixel_data_value"), new Object[]{new Integer(this.imageData.bytesPerLine), new Integer(this.imageData.scanlinePad), ImageAnalyzer.depthInfo(this.imageData.depth)});
        this.dataLabel.setText(string);
        data = this.dataHexDump(this.dataText.getLineDelimiter());
        this.dataText.setText(data);
        index = 0;
        while ((index = data.indexOf(58, index + 1)) != -1) {
            this.dataText.setStyleRange(new StyleRange(index - 4, 4, this.dataText.getForeground(), this.dataText.getBackground(), 1));
        }
        this.statusLabel.setText("");
        this.paletteCanvas.redraw();
        this.imageCanvas.redraw();
    }

    void paintImage(PaintEvent event) {
        Image paintImage = this.image;
        int transparentPixel = this.imageData.transparentPixel;
        if (transparentPixel != -1 && !this.transparent) {
            this.imageData.transparentPixel = -1;
            paintImage = new Image((Device)this.display, this.imageData);
        }
        int w = Math.round((float)this.imageData.width * this.xscale);
        int h = Math.round((float)this.imageData.height * this.yscale);
        event.gc.drawImage(paintImage, 0, 0, this.imageData.width, this.imageData.height, this.ix + this.imageData.x, this.iy + this.imageData.y, w, h);
        if (this.showMask && this.imageData.getTransparencyType() != 0) {
            ImageData maskImageData = this.imageData.getTransparencyMask();
            Image maskImage = new Image((Device)this.display, maskImageData);
            event.gc.drawImage(maskImage, 0, 0, this.imageData.width, this.imageData.height, w + 10 + this.ix + this.imageData.x, this.iy + this.imageData.y, w, h);
            maskImage.dispose();
        }
        if (transparentPixel != -1 && !this.transparent) {
            this.imageData.transparentPixel = transparentPixel;
            paintImage.dispose();
        }
    }

    void paintPalette(PaintEvent event) {
        GC gc = event.gc;
        gc.fillRectangle(this.paletteCanvas.getClientArea());
        if (this.imageData.palette.isDirect) {
            int y = this.py + 10;
            int xTab = 50;
            gc.drawString("rMsk", 10, y, true);
            gc.drawString(ImageAnalyzer.toHex4ByteString(this.imageData.palette.redMask), xTab, y, true);
            gc.drawString("gMsk", 10, y += 12, true);
            gc.drawString(ImageAnalyzer.toHex4ByteString(this.imageData.palette.greenMask), xTab, y, true);
            gc.drawString("bMsk", 10, y += 12, true);
            gc.drawString(ImageAnalyzer.toHex4ByteString(this.imageData.palette.blueMask), xTab, y, true);
            gc.drawString("rShf", 10, y += 12, true);
            gc.drawString(Integer.toString(this.imageData.palette.redShift), xTab, y, true);
            gc.drawString("gShf", 10, y += 12, true);
            gc.drawString(Integer.toString(this.imageData.palette.greenShift), xTab, y, true);
            gc.drawString("bShf", 10, y += 12, true);
            gc.drawString(Integer.toString(this.imageData.palette.blueShift), xTab, y, true);
        } else {
            RGB[] rgbs = this.imageData.palette.getRGBs();
            if (rgbs != null) {
                int xTab1 = 40;
                int xTab2 = 100;
                int i = 0;
                while (i < rgbs.length) {
                    int y = (i + 1) * 10 + this.py;
                    gc.drawString(String.valueOf(i), 10, y, true);
                    gc.drawString(String.valueOf(ImageAnalyzer.toHexByteString(rgbs[i].red)) + ImageAnalyzer.toHexByteString(rgbs[i].green) + ImageAnalyzer.toHexByteString(rgbs[i].blue), xTab1, y, true);
                    Color color = new Color((Device)this.display, rgbs[i]);
                    gc.setBackground(color);
                    gc.fillRectangle(xTab2, y + 2, 10, 10);
                    color.dispose();
                    ++i;
                }
            }
        }
    }

    void resizeShell(ControlEvent event) {
        if (this.image == null || this.shell.isDisposed()) {
            return;
        }
        this.resizeScrollBars();
    }

    void resetScaleCombos() {
        this.xscale = 1.0f;
        this.yscale = 1.0f;
        this.scaleXCombo.select(this.scaleXCombo.indexOf("1"));
        this.scaleYCombo.select(this.scaleYCombo.indexOf("1"));
    }

    void resetScrollBars() {
        if (this.image == null) {
            return;
        }
        this.ix = 0;
        this.iy = 0;
        this.py = 0;
        this.resizeScrollBars();
        this.imageCanvas.getHorizontalBar().setSelection(0);
        this.imageCanvas.getVerticalBar().setSelection(0);
        this.paletteCanvas.getVerticalBar().setSelection(0);
    }

    void resizeScrollBars() {
        ScrollBar horizontal = this.imageCanvas.getHorizontalBar();
        ScrollBar vertical = this.imageCanvas.getVerticalBar();
        Rectangle canvasBounds = this.imageCanvas.getClientArea();
        int width = Math.round((float)this.imageData.width * this.xscale);
        if (width > canvasBounds.width) {
            horizontal.setEnabled(true);
            horizontal.setMaximum(width);
            horizontal.setThumb(canvasBounds.width);
            horizontal.setPageIncrement(canvasBounds.width);
        } else {
            horizontal.setEnabled(false);
            if (this.ix != 0) {
                this.ix = 0;
                this.imageCanvas.redraw();
            }
        }
        int height = Math.round((float)this.imageData.height * this.yscale);
        if (height > canvasBounds.height) {
            vertical.setEnabled(true);
            vertical.setMaximum(height);
            vertical.setThumb(canvasBounds.height);
            vertical.setPageIncrement(canvasBounds.height);
        } else {
            vertical.setEnabled(false);
            if (this.iy != 0) {
                this.iy = 0;
                this.imageCanvas.redraw();
            }
        }
        vertical = this.paletteCanvas.getVerticalBar();
        if (this.imageData.palette.isDirect) {
            vertical.setEnabled(false);
        } else {
            canvasBounds = this.paletteCanvas.getClientArea();
            int paletteHeight = this.imageData.palette.getRGBs().length * 10 + 20;
            vertical.setEnabled(true);
            vertical.setMaximum(paletteHeight);
            vertical.setThumb(canvasBounds.height);
            vertical.setPageIncrement(canvasBounds.height);
        }
    }

    void scrollHorizontally(ScrollBar scrollBar) {
        if (this.image == null) {
            return;
        }
        Rectangle canvasBounds = this.imageCanvas.getClientArea();
        int width = Math.round((float)this.imageData.width * this.xscale);
        int height = Math.round((float)this.imageData.height * this.yscale);
        if (width > canvasBounds.width) {
            int x = -scrollBar.getSelection();
            if (x + width < canvasBounds.width) {
                x = canvasBounds.width - width;
            }
            this.imageCanvas.scroll(x, this.iy, this.ix, this.iy, width, height, false);
            this.ix = x;
        }
    }

    void scrollVertically(ScrollBar scrollBar) {
        if (this.image == null) {
            return;
        }
        Rectangle canvasBounds = this.imageCanvas.getClientArea();
        int width = Math.round((float)this.imageData.width * this.xscale);
        int height = Math.round((float)this.imageData.height * this.yscale);
        if (height > canvasBounds.height) {
            int y = -scrollBar.getSelection();
            if (y + height < canvasBounds.height) {
                y = canvasBounds.height - height;
            }
            this.imageCanvas.scroll(this.ix, y, this.ix, this.iy, width, height, false);
            this.iy = y;
        }
    }

    void scrollPalette(ScrollBar scrollBar) {
        if (this.image == null) {
            return;
        }
        Rectangle canvasBounds = this.paletteCanvas.getClientArea();
        int paletteHeight = this.imageData.palette.getRGBs().length * 10 + 20;
        if (paletteHeight > canvasBounds.height) {
            int y = -scrollBar.getSelection();
            if (y + paletteHeight < canvasBounds.height) {
                y = canvasBounds.height - paletteHeight;
            }
            this.paletteCanvas.scroll(0, y, 0, this.py, this.paletteWidth, paletteHeight, false);
            this.py = y;
        }
    }

    String dataHexDump(String lineDelimiter) {
        if (this.image == null) {
            return "";
        }
        char[] dump = new char[this.imageData.height * (6 + 3 * this.imageData.bytesPerLine + lineDelimiter.length())];
        int index = 0;
        int i = 0;
        while (i < this.imageData.data.length) {
            if (i % this.imageData.bytesPerLine == 0) {
                int line = i / this.imageData.bytesPerLine;
                dump[index++] = Character.forDigit(line / 1000 % 10, 10);
                dump[index++] = Character.forDigit(line / 100 % 10, 10);
                dump[index++] = Character.forDigit(line / 10 % 10, 10);
                dump[index++] = Character.forDigit(line % 10, 10);
                dump[index++] = 58;
                dump[index++] = 32;
            }
            byte b = this.imageData.data[i];
            dump[index++] = Character.forDigit((b & 0xF0) >> 4, 16);
            dump[index++] = Character.forDigit(b & 0xF, 16);
            dump[index++] = 32;
            if ((i + 1) % this.imageData.bytesPerLine == 0) {
                dump[index++] = lineDelimiter.charAt(0);
                if (lineDelimiter.length() > 1) {
                    dump[index++] = lineDelimiter.charAt(1);
                }
            }
            ++i;
        }
        return new String(dump);
    }

    void showErrorDialog(String operation, String filename, Exception e) {
        MessageBox box = new MessageBox(this.shell, 1);
        String message = ImageAnalyzer.createMsg(bundle.getString("Error"), new String[]{operation, filename});
        String errorMessage = "";
        if (e != null) {
            if (e instanceof SWTException) {
                SWTException swte = (SWTException)((Object)e);
                errorMessage = swte.getMessage();
                if (swte.throwable != null) {
                    errorMessage = String.valueOf(errorMessage) + ":\n" + swte.throwable.toString();
                }
            } else {
                errorMessage = e.toString();
            }
        }
        box.setMessage(String.valueOf(message) + errorMessage);
        box.open();
    }

    static String depthInfo(int depth) {
        Object[] args = new Object[]{new Integer(depth), ""};
        switch (depth) {
            case 1: {
                args[1] = ImageAnalyzer.createMsg(bundle.getString("Multi_pixels"), new Object[]{new Integer(8), " [01234567]"});
                break;
            }
            case 2: {
                args[1] = ImageAnalyzer.createMsg(bundle.getString("Multi_pixels"), new Object[]{new Integer(4), "[00112233]"});
                break;
            }
            case 4: {
                args[1] = ImageAnalyzer.createMsg(bundle.getString("Multi_pixels"), new Object[]{new Integer(2), "[00001111]"});
                break;
            }
            case 8: {
                args[1] = bundle.getString("One_byte");
                break;
            }
            case 16: {
                args[1] = ImageAnalyzer.createMsg(bundle.getString("Multi_bytes"), new Integer(2));
                break;
            }
            case 24: {
                args[1] = ImageAnalyzer.createMsg(bundle.getString("Multi_bytes"), new Integer(3));
                break;
            }
            case 32: {
                args[1] = ImageAnalyzer.createMsg(bundle.getString("Multi_bytes"), new Integer(4));
                break;
            }
            default: {
                args[1] = bundle.getString("Unsupported_lc");
            }
        }
        return ImageAnalyzer.createMsg(bundle.getString("Depth_info"), args);
    }

    static int visibleDelay(int ms) {
        if (ms < 20) {
            return ms + 30;
        }
        if (ms < 30) {
            return ms + 10;
        }
        return ms;
    }

    static String toHexByteString(int i) {
        if (i <= 15) {
            return "0" + Integer.toHexString(i);
        }
        return Integer.toHexString(i & 0xFF);
    }

    static String toHex4ByteString(int i) {
        String hex = Integer.toHexString(i);
        if (hex.length() == 1) {
            return "0000000" + hex;
        }
        if (hex.length() == 2) {
            return "000000" + hex;
        }
        if (hex.length() == 3) {
            return "00000" + hex;
        }
        if (hex.length() == 4) {
            return "0000" + hex;
        }
        if (hex.length() == 5) {
            return "000" + hex;
        }
        if (hex.length() == 6) {
            return "00" + hex;
        }
        if (hex.length() == 7) {
            return "0" + hex;
        }
        return hex;
    }

    static String pixelInfo(int pixel) {
        if (pixel == -1) {
            return String.valueOf(pixel) + " (" + bundle.getString("None_lc") + ")";
        }
        return String.valueOf(pixel) + " (0x" + Integer.toHexString(pixel) + ")";
    }

    static String disposalString(int disposalMethod) {
        switch (disposalMethod) {
            case 1: {
                return bundle.getString("None_lc");
            }
            case 2: {
                return bundle.getString("Background_lc");
            }
            case 3: {
                return bundle.getString("Previous_lc");
            }
        }
        return bundle.getString("Unspecified_lc");
    }

    static String fileTypeString(int filetype) {
        if (filetype == 0) {
            return "BMP";
        }
        if (filetype == 2) {
            return "GIF";
        }
        if (filetype == 3) {
            return "ICO";
        }
        if (filetype == 4) {
            return "JPEG";
        }
        if (filetype == 5) {
            return "PNG";
        }
        return bundle.getString("Unknown_ac");
    }

    static int determineFileType(String filename) {
        String ext = filename.substring(filename.lastIndexOf(46) + 1);
        if (ext.equalsIgnoreCase("bmp")) {
            return 0;
        }
        if (ext.equalsIgnoreCase("gif")) {
            return 2;
        }
        if (ext.equalsIgnoreCase("ico")) {
            return 3;
        }
        if (ext.equalsIgnoreCase("jpg") || ext.equalsIgnoreCase("jpeg")) {
            return 4;
        }
        if (ext.equalsIgnoreCase("png")) {
            return 5;
        }
        return -1;
    }

    static String createMsg(String msg, Object[] args) {
        MessageFormat formatter = new MessageFormat(msg);
        return formatter.format(args);
    }

    static String createMsg(String msg, Object arg) {
        MessageFormat formatter = new MessageFormat(msg);
        return formatter.format(new Object[]{arg});
    }

    class TextPrompter
    extends Dialog {
        String message = "";
        String result = null;
        Shell dialog;
        Text text;

        public TextPrompter(Shell parent, int style) {
            super(parent, style);
        }

        public TextPrompter(Shell parent) {
            this(parent, 65536);
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String string) {
            this.message = string;
        }

        public String open() {
            this.dialog = new Shell(this.getParent(), this.getStyle());
            this.dialog.setText(this.getText());
            this.dialog.setLayout((Layout)new GridLayout());
            Label label = new Label((Composite)this.dialog, 0);
            label.setText(this.message);
            label.setLayoutData((Object)new GridData(768));
            this.text = new Text((Composite)this.dialog, 2052);
            GridData data = new GridData(768);
            data.widthHint = 300;
            this.text.setLayoutData((Object)data);
            Composite buttons = new Composite((Composite)this.dialog, 0);
            GridLayout grid = new GridLayout();
            grid.numColumns = 2;
            buttons.setLayout((Layout)grid);
            buttons.setLayoutData((Object)new GridData(128));
            Button ok = new Button(buttons, 8);
            ok.setText(bundle.getString("OK"));
            data = new GridData();
            data.widthHint = 75;
            ok.setLayoutData((Object)data);
            ok.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                private final /* synthetic */ TextPrompter this$1;
                {
                    this.this$1 = textPrompter;
                }

                public void widgetSelected(SelectionEvent e) {
                    this.this$1.result = this.this$1.text.getText();
                    this.this$1.dialog.dispose();
                }
            });
            Button cancel = new Button(buttons, 8);
            cancel.setText(bundle.getString("Cancel"));
            data = new GridData();
            data.widthHint = 75;
            cancel.setLayoutData((Object)data);
            cancel.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                private final /* synthetic */ TextPrompter this$1;
                {
                    this.this$1 = textPrompter;
                }

                public void widgetSelected(SelectionEvent e) {
                    this.this$1.dialog.dispose();
                }
            });
            this.dialog.setDefaultButton(ok);
            this.dialog.pack();
            this.dialog.open();
            while (!this.dialog.isDisposed()) {
                if (ImageAnalyzer.this.display.readAndDispatch()) continue;
                ImageAnalyzer.this.display.sleep();
            }
            return this.result;
        }
    }
}

