/******************************************************************
 * ITERATE.CMD
 *
 * This program calls the various REXX external functions provided in the FILEREXX DLL.
 *******************************************************************/


/* The FileLoadFuncs loads all the rest of the REXX functions in the FILEREXX DLL. */
/* So, we don't have to make calls to RxFuncAdd to add each one of those functions. Of */
/* course, in order to call FileLoadFuncs, we have to add that one. */
CALL RxFuncAdd 'FileLoadFuncs', 'FILEREXX', 'FileLoadFuncs'
CALL FileLoadFuncs

arg fromname toname before after
err = FileIterateExe('test.exe', fromname, toname, before, after)
IF err <> 0 THEN SAY "FileIterateExe() ERROR:" err


/* =============================================================================== */
/* FileDropFuncs: This unloads all of the functions in the FILEREXX DLL. This is not necessary, and
    we could otherwise leave it open for some other REXX script */
CALL FileDropFuncs
