/**
 * REXX Communication Control Function Library  Ver.1.1
 *                  copyright 1998-1999, Naga(Kazuo Adachi)
 *                          mailto:nagaw@ibm.net
 *                          mailto:GDB00421@nifty.ne.jp
 *
 * $Id$
 *
 * $Log$
 */

ARG nifUser, nifPass

CALL RxFuncAdd 'RxCommLoadFuncs','RxComm','RxCommLoadFuncs'
CALL RxCommLoadFuncs

/*--------------------------------------------------------*/
/**
 * Login NIFTY-Serve
 */
DO FOREVER
    rc = RxCommRead( 400 )
    IF rc = '' THEN
    DO
        ok = RxCommWrite( '.00+ P' || '0D'x )
        LEAVE
    END

    CALL CHAROUT , rc

    IF POS( 'FENICS-ROAD 3', rc ) = 1 THEN LEAVE
    IF POS( 'FENICS-ROAD 4', rc ) = 1 THEN LEAVE
    IF POS( 'FENICS-ROAD 5', rc ) = 1 THEN LEAVE

    IF POS( '## Welcome to Network World ##', rc ) = 1 THEN LEAVE

END

DO FOREVER
    rc = RxCommRead()
    /* NIFTYȂł͂̏Ȃ(^_^; */
    DO WHILE POS( '00'x, rc ) > 0
        rc = DELSTR( rc, POS( '00'x, rc ), 1 )
    END
    CALL CHAROUT , rc

    IF POS( '悤NIFTY SERVE', rc ) = 1 THEN LEAVE

    IF POS( ' INPUT ERROR'        , rc ) = 1 THEN EXIT
    IF POS( ' User-ID Error'      , rc ) = 1 THEN EXIT
    IF POS( ' Password ERROR'     , rc ) = 1 THEN EXIT
    IF POS( 'dOCł', rc ) = 1 THEN EXIT

    IF POS( 'Clear DTE', rc ) = 1 THEN EXIT
    IF POS( 'Clear OCC', rc ) = 1 THEN EXIT
    IF POS( 'Clear PAD', rc ) = 1 THEN EXIT
    IF POS( 'Clear NA' , rc ) = 1 THEN EXIT
    IF POS( 'Clear NP' , rc ) = 1 THEN EXIT
    IF POS( 'Clear NC' , rc ) = 1 THEN EXIT
    IF POS( 'Clear DER', rc ) = 1 THEN EXIT
    IF POS( 'Clear RPE', rc ) = 1 THEN EXIT

    SELECT
        WHEN rc = 'Login: '
            THEN
            rc = RxCommWrite( 'NIFTY' || '0D'x )
        WHEN rc = 'Password: '
            THEN
            rc = RxCommWrite( '0D'x )
        WHEN POS( 'HOST NAME?', rc ) = 1
            THEN
            DO
                DO UNTIL POS( '*', rc ) > 0
                    rc = RxCommRead()
                    CALL CHAROUT , rc
                END
                rc = RxCommWrite( 'C NIF' || '0D'x )
            END
        WHEN rc = ' Enter Connection-ID  --->'
            THEN
            rc = RxCommWrite( 'SVC' || '0D'x )
        WHEN rc = ' Enter User-ID  --->'
            THEN
            rc = RxCommWrite( nifUser || '0D'x )
        WHEN rc = ' Enter Password --->'
            THEN
            rc = RxCommWrite( nifPass || '0D'x )
        OTHERWISE
    END
END

RETURN
