/* Rexx: RxBldLevel using rxunlock.dll example */

call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysloadFuncs'
call SysLoadFuncs

call RxFuncAdd 'RxUnlockLoadFuncs', 'RXUNLOCK', 'RxUnlockLoadFuncs'
call RxUnlockLoadFuncs

/* disable debug output */
call RxUnlockDebug( 0 )

Say "RxBldLevel( 'rxunlock.dll' ) 1000 times"
do i=1 to 1000
  dummy = RxBldLevel( 'rxunlock.dll' )
end

/* enable debug output */
call RxUnlockDebug( 1 )

Say '--------------- testing RxBldLevel ---------------'
Say RxBldLevel( 'rxunlock.dll' )
Say RxBldLevel( 'rxunlock.pas' )
Say RxBldLevel( SysBootDrive()'\os2\bldlevel.exe' )
Say RxBldLevel( SysBootDrive()'\os2\mdos\doskrnl' )
Say RxBldLevel( SysBootDrive()'\os2krnl' )
Say RxBldLevel( SysBootDrive()'\os2krnlxxx' )
Say RxBldLevel( SysBootDrive()'\OS2\MDOS\WINOS2\CALC.EXE' )
/*Say RxBldLevel( SysBootDrive()'\OS2\MDOS\WINOS2\SYSTEM\ATM32.DLL' )*/
Say RxBldLevel( SysBootDrive()'\OS2\BOOT\danis506.add' )
Say RxBldLevel( SysBootDrive()'\OS2\BOOT\mouse.snp' )

Parse ARG spec
if spec<>'' then
   Say RxBldLevel( spec )
   