/* Biblioteka okien kontrolnych: Asua Controls
 * (c) 1999 Wojciech Gazda &  Przemysaw Dobrowolski
 * Deklaracje funkcji i zmiennych wewntrzbibliotecznych.
 * Doczenie plikw *.h z sekcji common.
 *
 * Author: $
 * $Date: 1999/06/27 12:52:14 $
 * $Name:  $
 * $RCSfile: asuintl.h $
 * $Revision: 1.1 $
 */

/*  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License Version 2 as
 *  published by the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#ifndef _ASUAINTL_H_
#define _ASUAINTL_H_

// Pliki nagwkowe zawierajce deklaracje funkcji usugowych
#include "graphics.h"    // Dodatkowe funkcje do obsugi grafiki
#include "pparams.h"     // Obsuga presentation parameters


// Zmienne globalne
// Uchwyt moduu asuactl.dll
extern HMODULE hResource;
// Wersja systemu operacynego
extern ULONG   ulWarpVer;



// Prywatne, pomocnicze struktury danych biblioteki asuactl.dll
//
// Struktura informacyjna obiektu, umoliwiajca odczyt wersji i innych informacji
#ifdef __WATCOMC__
#pragma pack(push, 1)
#else
#pragma pack(1)
#endif

typedef struct
{ ULONG   cbSize;        // Rozmiar
  PSZ     szRCSVersion;  // Numer wersji w ormacie RCS
  USHORT  usVerMajor;    // Gwny numer wersji
  USHORT  usVerMinor;    // Dodatkowy numer wersji
} CTLINFO;


// Struktury danych wsplne dla wszystkich okien kontrolnych,
// dostpne take dla uytkownika
//
// Struktura przekazywana przez okna stylu *_OWNERDRAW podczas
// przetwarzania komunikatu WM_DRAWITEM. Struktura umoliwia
// wacicielowi kontrolki przerysowanie jej ta. Zalecane jest
// aby we wszystkich kontrolkach umoliwiajcych uytkownikowi rysowanie ta,
// uywa tej wanie struktury.
typedef struct
{ HWND    hwnd;     // Uchwyt przerysowywanego okna
  HPS     hps;      // Uchwyt presentation space, ktrego naley uy podczas rysowania
  RECTL   bound;    // Wsprzdne obszaru, ktry naley przerysowa
  POINTL  refpoint; // Wsprzdne punktu odniesienia
} OWNERBACK;

#ifdef __WATCOMC__
#pragma pack(pop)
#else
#pragma pack()
#endif


// Prototypy oglnych funkcji usugowych
MRESULT AsuQueryCtlInfo(HWND hwnd, ULONG msg, MPARAM mp1, CTLINFO *CtlInfo);

// Prototypy funkcji
LONG ASUAAPI AsuCtlInitialize(HAB hab);
LONG ASUAAPI AsuGetComponentVersion(PSZ class);
LONG ASUAAPI AsuGetVersion(VOID);

#endif // _ASUAINTL_H_
/*
 * $Log: asuintl.h $
 * Revision 1.1  1999/06/27 12:52:14  Wojciech_Gazda
 * Initial revision
 *
 */
