/* Asuactl.dll
 * Pasek narzdzi - nonik
 * (c) 1999 Wojciech Gazda
 *
 * carrier.c
 *
 * $Author: Wojciech_Gazda $
 * $Date: 1999/06/27 12:35:43 $
 * $Name:  $
 * $RCSfile: carrier.c $
 * $Revision: 1.1 $
 *
 */

/*  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License Version 2 as
 *  published by the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#define  INCL_DOSDEV
#define  INCL_DOSPROCESS

// Deklaracje OS/2
#define  INCL_GPILOGCOLORTABLE
#define  INCL_GPIPRIMITIVES
#define  INCL_GPIREGIONS
#define  INCL_WINRECTANGLES
#define  INCL_WINWINDOWMGR
#define  INCL_WINTRACKRECT
#define  INCL_WINFRAMEMGR
#define  INCL_WINPOINTERS
#define  INCL_WININPUT
#define  INCL_WINATOM
#define  INCL_WINSYS
#include <os2.h>


// Deklaracje lokalne
#define  __INTERNAL_USE__
#include "asuintl.h"
#include "toolbar.h"
#include "tooldefs.h"
#include "tcontrol.h"
#include "carrier.h"
#include "objmgr.h"



// Prototypy funkcji
VOID  CrrCalcNewRect(TOOLADJ *tadj);
LONG  CrrInitialize(HWND hwnd, TOOLCTL *tcl);
LONG  CrrMinMaxFrame(HWND hwnd, SWP *newpos);
VOID  CrrMoveWithOwner(HWND hwnd, SWP *newpos, SWP *owner);
VOID  CrrPlaceControls(HWND hwnd);
LONG  CrrQueryHeight(TOOLADJ *tadj);
LONG  CrrQueryWidth(TOOLADJ *tadj);
VOID  CrrRedrawBorder(HWND hwnd);
LONG  CrrRotate(HWND hwnd, ULONG ulOptions);
LONG  CrrTrackRect(HWND hwnd);
VOID  CrrUpdateToolSize(TOOLCTL *tcl);


// Prototypy funkcji lokalnych
static LONG  CrrQueryBorder(TOOLADJ *tadj, ULONG mode);
static LONG  CrrQueryControl(TOOLADJ *tadj, ULONG mode);
static VOID  CrrQueryClientArea(TOOLADJ *tadj);
static LONG  CrrQueryEndMargin(TOOLADJ *tadj);
static VOID  CrrQueryInterior(TOOLADJ *tadj);

// Dodatkowe funkcje usugowe
static VOID  FrameOnlyDrag(TOOLCTL *tcl, TOOLTRACK *trc);
static VOID  FullWindowDrag(TOOLCTL *tcl, TOOLTRACK *trc);
static VOID  InvalidateParent(HWND hwnd, HWND oldparent, RECTL *oldpos);
static VOID  PlaceRotateButton(TOOLCTL *tcl, RECTL *rclInter);
static VOID  PlaceTitleBar(TOOLCTL *tcl, RECTL *rclInter);
static VOID  StoreOffset(TOOLCTL *tcl, RECTL *winpos);
static VOID  UpdateBeforeDrag(TOOLCTL *tcl, TOOLTRACK *trc, POINTL *offset);





// Funkcja oblicza proponowan pozycj i rozmiary paska narzdzi.
// Struktura TOOLADJ powinna przed wywoaniem mie zinicjowane pola:
// hwndToolBar, hwndParent, flAttrs, flState.
// Pozycja i rozmiary s zwracane w polu rclSizePos, i s one
// liczone wzgldem okna rodzicielskiego
//
// Parametry:
//   tadj      - [parametr/rezultat] wskanik do struktury zawirajcej pytanie
//
VOID CrrCalcNewRect(TOOLADJ *tadj)
{ RECTL rclNew;     // Nowe wymiary paska
  LONG  cx, cy;     // Szeroko i wysoko paska

  // Odczyt proponowanych wymiarw paska narzdzi
  cx = CrrQueryWidth(tadj);
  cy = CrrQueryHeight(tadj);
  // Odczyt pooenia i wymiarw okna rodzicielskiego
  WinQueryWindowRect(tadj->hwndParent, &rclNew);

  if(tadj->flState & TST_FIXED)
  { // Pasek jest zamksymalizowany
    if(tadj->flState & TST_ROTATED)
    { // Pasek jest w pozycji pionowej
      if(tadj->flAttrs & TBA_FIXEDRIGHT) rclNew.xLeft  = rclNew.xRight - cx;
      else                               rclNew.xRight = rclNew.xLeft  + cx;
    }
    else
    { // Pasek jest w pozycji poziomej
      if(tadj->flAttrs & TBA_FIXEDBOTTOM) rclNew.yTop    = rclNew.yBottom + cy;
      else                                rclNew.yBottom = rclNew.yTop    - cy;
    }
  }
  else if(tadj->flState & TST_MINIMIZED)
  { // Pasek jest zminimalizowany
    if(!(tadj->flAttrs & (TBA_FIXEDBOTTOM | TBA_FIXEDRIGHT)))
    { // Lewy grny rg okna
      rclNew.xRight  = rclNew.xLeft + cx;
      rclNew.yBottom = rclNew.yTop  - cy;
    }
    else if((tadj->flAttrs & TBA_FIXEDBOTTOM) && (tadj->flAttrs & TBA_FIXEDRIGHT))
    { // Prawy dolny rg okna
      rclNew.xLeft   = rclNew.xRight  - cx;
      rclNew.yTop    = rclNew.yBottom + cy;
    }
    else if(tadj->flAttrs & TBA_FIXEDBOTTOM)
    { // Lewy dolny rg okna
      rclNew.xRight  = rclNew.xLeft   + cx;
      rclNew.yTop    = rclNew.yBottom + cy;
    }
    else if(tadj->flAttrs & TBA_FIXEDRIGHT)
    { // Prawy grny rg okna
      rclNew.xLeft   = rclNew.xRight - cx;
      rclNew.yBottom = rclNew.yTop   - cy;
    }
  }
  else
  { // Pasek jest w stanie "floating"
    WinQueryWindowRect(tadj->hwndToolBar, &rclNew);
    WinMapWindowPoints(tadj->hwndToolBar, tadj->hwndParent, (POINTL *)&rclNew, 2);
    // Krekta wymiarw paska
    rclNew.xRight = rclNew.xLeft   + cx;
    rclNew.yTop   = rclNew.yBottom + cy;
  }
  // Zapmitanie nowych wymiarw
  tadj->rclSizePos = rclNew;
}





// Inicjacja nonika
//
// Parametry:
//   hwnd      - [parametr] uchwyt paska narzdzi
//   tcl       - [parametr/rezultat] adres gwnej struktury kontrolnej okna
//
// Powrt:
//   FALSE - poprawne wykonanie funkcji
//   TRUE  - bd inicjacji
//
LONG CrrInitialize(HWND hwnd, TOOLCTL *tcl)
{ HAB     hab;           // Uchwyt anchor block PM
//  LONG    rc;            // Kody bdw zwracane przez funkcje systemowe
//  ULONG   winstyle;      // Styl tworzonego okna


  // Odczyt anchor block PM
  hab = WinQueryAnchorBlock(hwnd);

  // Otwarcie nowego okna - paska tytuu
  if(tcl->flWinStyle & (TBS_MOVEBUTTON | TBS_FIXBUTTON))
  { tcl->hwndTitleBar = WinCreateWindow(hwnd, INTC_MINITITLE, "",
                          WS_VISIBLE, 0, 0, 0, 0,
                          hwnd, HWND_TOP, TCID_TITLEBAR,
                          NULL, NULL);
    if(tcl->hwndTitleBar == NULLHANDLE) return(TRUE);

    // Aktualizacja parametrw sterujcych wygldem paska tytuu
    if(tcl->flWinStyle & TBS_FIXBUTTON)
      tcl->flTitleState |= STT_DRAWBUTTON;

    // Zapamitanie wskanika do struktur kontrolnych paska narzdzi
    WinSetWindowPtr(tcl->hwndTitleBar, 0L, tcl);
  }

  // Otwarcie nowego okna - przycisku obracania paska narzdzi
  if(tcl->flWinStyle & TBS_ROTATEBUTTON)
  { tcl->hwndRotate = WinCreateWindow(hwnd, INTC_ROTATEBTN, "",
                        WS_VISIBLE, 0, 0, 0, 0,
                        hwnd, HWND_TOP, TCID_ROTATE,
                        NULL, NULL);
    if(tcl->hwndRotate == NULLHANDLE) return(TRUE);

    // Zapamitanie wskanika do struktur kontrolnych paska narzdzi
    WinSetWindowPtr(tcl->hwndRotate, 0L, tcl);
  }

  // Poprawne wykonanie funcji
  return(FALSE);
}





// Obsuga minimalzacji/maksymalizacji i przywrcenia stanu -
// komunikat WM_MINMAXFRAME.
//
// Parametry:
//   hwnd      - [parametr] uchwyt paska narzdzi
//   newpos    - [parametr/rezultat] - proponowane wymiary i pooenie okna
//
// Powrt:
//   TRUE - komunikat WM_MINMAXFRAME zosta wykonany
//
LONG CrrMinMaxFrame(HWND hwnd, SWP *newpos)
{ TOOLCTL *tcl;     // Wskanik do struktur kontrolnych paska narzdzi
  TOOLADJ  tadj;    // Paarametry przekazywane wacicielowi paska w celu dokonania korekt
  RECTL  oldpos;    // Stara pozycja okna
  HWND   oldparent; // Uchwyt okna rodzicielskiego przed dokonanim zmian
  LONG   oldstyle;  // Styl okna przed wywoaniem potwierdzenia TN_*
  ULONG  notify;    // Kod potwierdzenia


  tcl = ToolLoadData(hwnd, "ToolControlPos");
  if(tcl == NULL) return(0);
  notify   = 0;

  // Inicjacja struktury TOOLADJ
  tadj.hwndToolBar = hwnd;
  tadj.hwndParent  = WinQueryWindow(hwnd, QW_PARENT);
  tadj.flAttrs     = tcl->flToolAttrs;

  // Zapamitania aktualnego stanu okna
  tcl->flOldState = tcl->flToolState;
  // Odczyt starej pozycji i rozmiarw okna
  WinQueryWindowRect(hwnd, &oldpos);
  WinMapWindowPoints(hwnd, tadj.hwndParent, (POINTL *)&oldpos, 2);
  oldparent = tadj.hwndParent;

  // Okrelenie rodzaju operacji
  if((newpos->fl & SWP_MINIMIZE) && !(tcl->flToolState & TST_MINIMIZED))
  { // Okrelenie kodu potwierdzenia - minmalizacja
    notify = TN_MINIMIZE;
  }
  else if((newpos->fl & SWP_MAXIMIZE) && !(tcl->flToolState & TST_FIXED))
  { // maksymalizacja okna
    notify = TN_FIXTOOL;
  }
  else if((newpos->fl & SWP_RESTORE) && (tcl->flToolState & (TST_FIXED | TST_MINIMIZED)))
  { // Przywrcenie stanu okna
    notify = TN_RESTORE;
  }

  // Wykonanie czynnoci zalenych od stanu okna
  if(notify)
  { // Korekta wewntrznych zmiennych okna i struktur kontrolnych
    // Skasowanie znacznikw maksymalizacji i minimalizacji
    tcl->flWinStyle  &= ~(WS_MINIMIZED  | WS_MAXIMIZED);
    tcl->flToolState &= ~(TST_MINIMIZED | TST_FIXED);

    // Korekta podczas maksymalizacji
    if(notify == TN_FIXTOOL)
    { tcl->flWinStyle  |= WS_MAXIMIZED;
      tcl->flToolState |= TST_FIXED;
    }
    // Korekta podczas minimalizacji
    if(notify == TN_MINIMIZE)
    { tcl->flWinStyle  |= WS_MINIMIZED;
      tcl->flToolState |= TST_MINIMIZED;
    }

    // Zapamitanie nowych parametrw w strukturach okna
    WinSetWindowULong(hwnd, QWL_STYLE, tcl->flWinStyle);
    // Obliczenie proponowanych wymiarw i pozycji paska narzdzi
    tadj.flState = tcl->flToolState;
    WinSendMsg(hwnd, TM_CALCNEWRECT, MPFROMP(&tadj), 0L);

    // Zapamitanie pozycji do odtworzenia
    if((notify == TN_MINIMIZE) || (notify == TN_FIXTOOL))
    { if(!(tcl->flOldState & (TST_FIXED | TST_MINIMIZED)))
      { WinSetWindowUShort(hwnd, QWS_XRESTORE, oldpos.xLeft);
        WinSetWindowUShort(hwnd, QWS_YRESTORE, oldpos.yTop);
      }
    }
    else
    { // Korekta proonowanej pozycji okna
      tadj.rclSizePos.xRight -= tadj.rclSizePos.xLeft;
      tadj.rclSizePos.yBottom = tadj.rclSizePos.yTop - tadj.rclSizePos.yBottom;
      // Odczyt pozycji potrzebnej do odtworzenia stanu okna (TN_RESTORE)
      tadj.rclSizePos.xLeft   = WinQueryWindowUShort(hwnd, QWS_XRESTORE);
      tadj.rclSizePos.yTop    = WinQueryWindowUShort(hwnd, QWS_YRESTORE);
      tadj.rclSizePos.xRight += tadj.rclSizePos.xLeft;
      tadj.rclSizePos.yBottom = tadj.rclSizePos.yTop - tadj.rclSizePos.yBottom;
    }

    // Zapamitanie stylu okna
    oldstyle = WinQueryWindowULong(hwnd, QWL_STYLE);
    // Blokada przerysowywania paska narzdzi na czas przetwarzania TN_*
    WinEnableWindowUpdate(hwnd, FALSE);

    // Ustawienie znacznika trwania minimalizacji
    tcl->flToolState |= TST_MINMAXCTL;
    // Wysanie potwierdzenia do waciciela
    tadj.flState = tcl->flOldState & 0xFFFF;
    ToolSendNotify(hwnd, notify, &tadj);
    // Uwzgldnienie zmiany atrybutw
    tcl->flToolAttrs = tadj.flAttrs;
    // Skasowanie znacznika trwania minimalizacji
    tcl->flToolState &= ~TST_MINMAXCTL;

    // Sprawdzenie czy okno byo widoczne przed wysaniem potwierdzenie
    if(oldstyle & WS_VISIBLE)
    { // Wymuszenie przerysowania obszaru okna rodzicielskiego zakrywanego przez pasek narzdzi
      WinInvalidateRect(oldparent, &oldpos, TRUE);
      // Odblokowanie przerysowywania okna
      WinEnableWindowUpdate(hwnd, TRUE);
      // Obszar uniewaniony zostanie obliczony podczas przetwarzania WM_CALCVALIDRECTS
      WinValidateRect(hwnd, NULL, TRUE);
    }

    // Zapamitanie przesunicia paska narzdzi wzgldem waciciela
    if(notify == TN_RESTORE) StoreOffset(tcl, &tadj.rclSizePos);

    // Aktualizacja struktury SWP
    newpos->x   = tadj.rclSizePos.xLeft;
    newpos->y   = tadj.rclSizePos.yBottom;
    newpos->cx  = tadj.rclSizePos.xRight - tadj.rclSizePos.xLeft;
    newpos->cy  = tadj.rclSizePos.yTop   - tadj.rclSizePos.yBottom;
    // Wymuszenie przesunicia, skalowania, oraz odblokowanie odwieania
    newpos->fl |= (SWP_MOVE | SWP_SIZE);
  }
  return(0);
}





// Pozycjonowanie paska narzdzi wzgldem okna rodzicielskiego,
// w zalenoci od stylu TBS_MOVEWITHOWNER. Procedura ukrywa pasek
// narzdzi podczas minimalizacji lub ukrywania okna aplikacji.
// Parametr tool jest wskanikiem do struktury SWP zawierajcej
// proponowan pozycj i wymiary paska narzdzi.
//
// Parametry:
//   hwnd      - [parametr] uchwyt paska narzdzi
//   tool      - [parametr/rezultat] wskanik struktury SWP zawierajcej nowe pooenie paska
//   owner     - [parametr] nowa pozycja i wymiary waciciela
//
VOID CrrMoveWithOwner(HWND hwnd, SWP *tool, SWP *owner)
{ TOOLCTL *tcl;     // Wskanik do gwnej struktury kontrolnej

  tcl = ToolLoadData(hwnd, "CrrMoveWithOwner");
  if(tcl == NULL) return;

  // Ukrycie okna przy minimalizacji/ukryciu waciciela
  if(owner->fl & (SWP_HIDE | SWP_MINIMIZE))
  { WinShowWindow(hwnd, FALSE);
    return;
  }
  // Wywietlenie paska przy maksymalizacji/przywrceniu okna
  if(owner->fl & (SWP_RESTORE | SWP_MAXIMIZE | SWP_SHOW))
  { WinShowWindow(hwnd, TRUE);
  }

  // Przesuwanie okna wraz z wacicielem
  if((tcl->flWinStyle & TBS_MOVEWITHOWNER) && (owner->fl & SWP_MOVE))
  { // Korekta pooenia paska narzdzi
    tool->x = owner->x + tcl->ptlOffset.x;
    tool->y = owner->y + owner->cy - tcl->ptlOffset.y;
    tool->fl |= SWP_MOVE;
  }
}





// Pozycjonowanie okien sterujcych zachowaniem paska, takich jak:
// pasek tytuu, przycisk obracania i przyciski przewijania.
//
// Parametry:
//   hwnd      - [parametr] uchwyt paska narzdzi
//
VOID CrrPlaceControls(HWND hwnd)
{ TOOLCTL *tcl;     // Wskanik do gwnej struktury kontrolnej paska narzdzi
  TOOLADJ  tadj;    // Struktura zawierajca pytanie o stan paska narzdzi

  tcl = ToolLoadData(hwnd, "CrrPlaceControls");
  if(tcl == NULL) return;

  // Odczyt obszaru wewntrz obramowania
  tadj.hwndToolBar = hwnd;
  tadj.flAttrs     = tcl->flToolAttrs;
  tadj.flState     = tcl->flToolState;
  CrrQueryInterior(&tadj);

  // Pozycjonowanie paska tytuu
  PlaceTitleBar(tcl, &tadj.rclSizePos);
  // Pozycjonowanie przycisku obracania okna
  PlaceRotateButton(tcl, &tadj.rclSizePos);
  // Pozycjonowanie pocztkowego przycisku przesuwania okna


  // Obliczenie wsprzdnych obszaru okna przechowujcego obiekty
  CrrQueryClientArea(&tadj);
  // Pozycjonowanie okna przechowujcego obiekty
  if(tcl->flToolState & TST_MINIMIZED)
  { // Zgaszenie okna w stanie zminimalizowanym
    WinShowWindow(tcl->hwndObjectPad, FALSE);
  }
  else
  { WinSetWindowPos(tcl->hwndObjectPad, HWND_TOP,
                    tadj.rclSizePos.xLeft,
                    tadj.rclSizePos.yBottom,
                    tadj.rclSizePos.xRight - tadj.rclSizePos.xLeft,
                    tadj.rclSizePos.yTop   - tadj.rclSizePos.yBottom,
                    SWP_MOVE | SWP_SIZE | SWP_ZORDER | SWP_SHOW);
  }
}





// Funkcja oblicza wysoko paska narzdzi na podstawie danych sterujcych
// przekazanych w strukturze TOOLADJ. Powinny zosta zainicjowane pola:
// hwndToolBar, hwndParent, flState, flAttrs.
//
// Parametry:
//   tadj      - [parametr] struktura zawierajca pytanie o wysoko
//
// Powrt:
//   Proponowana wysoko paska narzdzi
//
LONG CrrQueryHeight(TOOLADJ *tadj)
{ TOOLCTL *tcl;     // Adres gwnej struktury kontrolnej paska narzdzi
  RECTL    wsize;   // Wymiary okna rodzicielskiego
  LONG     height;  // Wysoko paska narzdzi
  LONG     minh;    // Minimalna wysoko paska narzdzi

  // Odczyt afresu struktur kontrolnych
  tcl = ToolLoadData(tadj->hwndToolBar, "CrrQueryHeight");
  if(tcl == NULL) return(0);

  if(tadj->flState & TST_MINIMIZED)
  { // Odczyt wysokoci dla paska zminimalizowanego

    if(tadj->flState & TST_ROTATED)
    { // Pionowy pasek narzdzi
      height = ObjQueryWidth(tcl, tadj->flState);
      // Powikszenie rozmiarw o 50%
      height += (height >> 1);
    }
    else
    { // Poziomy pasek narzdzi
      height = CY_TITLEHEIGHT;
    }

    // Uwzgldnienie gruboci ramki
    tadj->flState |= TST_MINIMIZED;
    height += CrrQueryBorder(tadj, TDQ_HEIGHT);
    return(height);
  }
  else
  { if((tadj->flState & TST_FIXED) && (tadj->flState & TST_ROTATED))
    { // Odczyt wysokoci dla paska zmaksymalizowanego i umieszczonego pionowo
      WinQueryWindowRect(tadj->hwndParent, &wsize);
      height = wsize.yTop - wsize.yBottom;
    }
    else
    { // Odczyt wysokoci dla pozostaych stanw
      height = ObjQueryHeight(tcl, tadj->flState) + CXY_INTERNALMARGIN;
      // Uwzgldnienie wymiarw ramki
      minh   = CrrQueryBorder(tadj, TDQ_HEIGHT);

      // Tylko pionowy pasek narzdzi
      if(tadj->flState & TST_ROTATED)
      { // Wysoko tytuu i standardowych przyciskw sterujcych
        minh   += CrrQueryControl(tadj, TDQ_HEIGHT);
        height += minh;

        // Ograniczenie maksymalnej wysokoci w stanie floating
        if((tcl->ulMaxLength > 0) && (height > tcl->ulMaxLength))
        { height = tcl->ulMaxLength;
          if(height < minh) height = minh;
        }
      }
      else height += minh;
    }
  }

  return(height);
}





// Funkcja oblicza pooenie i rozmiary obszaru zawartego wewntrz obramowania.
// Struktura TOOLADJ powinna mie zainicjowane pola: hwndToolBar, flAttrs i flState.
// Obliczone wsprzdne obszaru s zwracane w polu rclSizePos, natomiast skorygowane
// atrybuty w polu flAttrs.
//
// Parametry:
//   tadj      - [parametr/rezultat] wskanik do struktury zawierajcej pytanie
//
VOID CrrQueryInterior(TOOLADJ *tadj)
{
  // Korekta wygldu ramki podczas przesuwania paska narzdzi
  if(tadj->flState & TST_FULLTRCFRAME)
  {
    // Dla zminimalizowanego paska jest rysowane tylko czarne obramowanie
    if(tadj->flState & TST_MINIMIZED)
      tadj->flAttrs &= ~TBA_FRAME;
    // W pozostaych przypadkach - pene obramowanie 3D
    else tadj->flAttrs |= TBA_FRAME;
  }
  else
  {
    // Korekta atrybutw, gdy ramka znajduje si w stanie floating - pene obramowanie
    if(!(tadj->flState & (TST_FIXED | TST_MINIMIZED)))
      tadj->flAttrs |= TBA_FRAME;
  }

  // Obliczenie obszaru wewntrz ramki
  // Odczyt penych wymiarw okna
  WinQueryWindowRect(tadj->hwndToolBar, &tadj->rclSizePos);
  // Uwzgldnienie obramowania rysowanego podczas przesuwania,
  // oraz gdy pasek jest w stanie floating
  if((tadj->flState & TST_FULLTRCFRAME) || !(tadj->flState & (TST_FIXED | TST_MINIMIZED)))
  { tadj->rclSizePos.xLeft  ++; tadj->rclSizePos.yBottom ++;
    tadj->rclSizePos.xRight --; tadj->rclSizePos.yTop    --;
  }

  // Uwzgldnienie standardowego obramowania
  if(tadj->flAttrs & TBA_LEFTFRAME)   tadj->rclSizePos.xLeft   ++;
  if(tadj->flAttrs & TBA_RIGHTFRAME)  tadj->rclSizePos.xRight  --;
  if(tadj->flAttrs & TBA_BOTTOMFRAME) tadj->rclSizePos.yBottom ++;
  if(tadj->flAttrs & TBA_TOPFRAME)    tadj->rclSizePos.yTop    --;
}





// Funkcja oblicza szeroko paska narzdzi na podstawie danych sterujcych
// przekazanych w strukturze TOOLADJ. Powinny zosta zainicjowane pola:
// hwndToolBar, hwndParent, flState, flAttrs.
//
// Parametry:
//   tadj      - [parametr] struktura zawierajca pytanie o wysoko
//
// Powrt:
//   Proponowana szeroko paska narzdzi
//
LONG CrrQueryWidth(TOOLADJ *tadj)
{ TOOLCTL *tcl;     // Adres struktur kontrolnych paska narzdzi
  RECTL    wsize;   // Wymiary okna rodzicielskiego
  LONG     width;   // Szeroko paska narzdzi
  LONG     minw;    // Minimalna szeroko w stanie floating

  // Odczyt adresu struktur kontrolnych
  tcl = ToolLoadData(tadj->hwndToolBar, "CrrQueryWidth");
  if(tcl == NULL) return(0);

  if(tadj->flState & TST_MINIMIZED)
  { // Odczyt szerokoci dla paska zminimalizowanego
    if(tadj->flState & TST_ROTATED)
    { // Pionowy pasek narzdzi
      width = CX_TITLEWIDTH;
    }
    else
    { // Poziomy pasek narzdzi
      width = ObjQueryHeight(tcl, tadj->flState);
      // Powikszenie rozmiarw o 50%
      width += (width >> 1);
    }
    // Uwzgldnienie gruboci ramki
    tadj->flState |= TST_MINIMIZED;
    width += CrrQueryBorder(tadj, TDQ_WIDTH);
    return(width);
  }
  else
  { if((tadj->flState & TST_FIXED) && !(tadj->flState & TST_ROTATED))
    { // Odczyt szerokoi dla paska zmaksymalizowanego i nieodwrconego
      WinQueryWindowRect(tadj->hwndParent, &wsize);
      width = wsize.xRight - wsize.xLeft;
    }
    else
    { // Odczyt szerokoci dla pozostaych stanw
      width = ObjQueryWidth(tcl, tadj->flState) + CXY_INTERNALMARGIN;
      // Uwzgldnienie wymiarw ramki
      minw  = CrrQueryBorder(tadj, TDQ_WIDTH);

      // Tylko poziomy pasek narzdzi
      if(!(tadj->flState & TST_ROTATED))
      { // Szeroko tytuu i standardowych przyciskw sterujcych
        minw  += CrrQueryControl(tadj, TDQ_WIDTH);
        width += minw;

        // Ograniczenie maksymalnej szerokoci paska w stanie floating
        if((tcl->ulMaxLength > 0) && (width > tcl->ulMaxLength))
        { width = tcl->ulMaxLength;
          if(width < minw) width = minw;
        }
      }
      else width += minw;
    }
  }
  return(width);
}





// Przerysowanie obramowania paska narzdzi
//
// Parametry:
//   hwnd      - [parametr] uchwyt paska narzdzi
//
VOID  CrrRedrawBorder(HWND hwnd)
{ TOOLCTL *tcl;     // Wskanik do gwnej struktury kontrolnej okna
  POINTL   pos;     // Wsprzdne oglnego przeznaczenia
  RECTL    wsize;   // Rozmiary okna
  ULONG    frame;   // Skorygowane atrybuty ramki
  HPS      hps;     // Uchwyt presentation space

  tcl = ToolLoadData(hwnd, "CrrRedrawBorder");
  if(tcl == NULL) return;
  hps = WinBeginPaint(hwnd, NULL, NULLHANDLE);

  // adowanie tablicy kolorw
  PpmQueryPresColors(hwnd, TOOL_MAXCOLOR, PPmColor, tcl->colors);
  // Tworzenie logicznej tablicy kolorw
  GpiCreateLogColorTable(hps, 0L, LCOLF_CONSECRGB, 0L, TOOL_MAXCOLOR, tcl->colors);
  // Odczyt wymiarw paska narzdzi
  WinQueryWindowRect(tcl->hwndToolBar, &wsize);
  // Zapamitanie atrybutw sterujcych wywietlaniem ramki
  frame = tcl->flToolAttrs;

  // **** TEST   ****
  // WinFillRect(hps, &wsize, TOOL_HILITEBACKGROUND);
  // DosSleep(50);
  // **** KONIEC ****

  // Rysowanie ramki uywanej podczas przesuwania okna,
  // i gdy pasek jest w stanie "floating"
  if((tcl->flToolState & TST_FULLTRCFRAME) || !(tcl->flToolState & (TST_MINIMIZED | TST_FIXED)))
  {
    // Owietlenie ramki
    GpiSetColor(hps, TOOL_FRAMEDRAGHILITE);
    pos.x = wsize.xLeft; pos.y = wsize.yBottom;
    GpiMove(hps, &pos);
    // Lewa krawd
    pos.y = wsize.yTop - 1;   GpiLine(hps, &pos);
    // Grna krawd
    pos.x = wsize.xRight - 2; GpiLine(hps, &pos);

    // Cie ramki
    GpiSetColor(hps, TOOL_FRAMEDRAGDARK);
    pos.x = wsize.xRight - 1; pos.y = wsize.yTop - 1;
    GpiMove(hps, &pos);
    // Prawa krawd
    pos.y = wsize.yBottom;    GpiLine(hps, &pos);
    // Dolna krawd
    pos.x = wsize.xLeft  + 1; GpiLine(hps, &pos);

    // Korekta wymiarw obszaru
    wsize.xLeft  ++; wsize.yBottom ++;
    wsize.xRight --; wsize.yTop    --;
    // Korekta atrybutw ramki - rysowanie penej ramki w stanie "floating"
    // i podczas przesuwania paska narzdzi
    frame |= TBA_FRAME;
  }


  // Rysowanie standardowej ramki
  // Owietlenie ramki
  GpiSetColor(hps, TOOL_FRAMEHILITE);
  pos.x = wsize.xLeft; pos.y = wsize.yBottom;
  GpiMove(hps, &pos);
  // Lewa krawd
  pos.y = wsize.yTop - 1;
  if(frame & TBA_LEFTFRAME)
  { GpiLine(hps, &pos);
    wsize.xLeft ++;
  }
  else GpiMove(hps, &pos);
  // Grna krawd
  pos.x = wsize.xRight - 1;
  if(frame & TBA_TOPFRAME)
  { GpiLine(hps, &pos);
    wsize.yTop --;
  }
  else GpiMove(hps, &pos);

  // Cie ramki
  GpiSetColor(hps, TOOL_FRAMEDARK);
  pos.x = wsize.xRight - 1; pos.y = wsize.yTop - 1;
  GpiMove(hps, &pos);
  // Prawa krawd
  pos.y = wsize.yBottom;
  if(frame & TBA_RIGHTFRAME)
  { GpiLine(hps, &pos);
    wsize.xRight --;
  }
  else GpiMove(hps, &pos);
  // Dolna krawd
  pos.x = wsize.xLeft;
  if(frame & TBA_BOTTOMFRAME)
  { GpiLine(hps, &pos);
    wsize.yBottom ++;
  }

  // Wypenienie ta
  WinFillRect(hps, &wsize, TOOL_BACKGROUND);
  // Koniec rysowania
  WinEndPaint(hps);
}





// Sterowanie obracaniem paska narzdzi
//
// Parametry:
//   hwnd      - [parametr] uchwyt paska narzdzi
//   ulOptions - [parametr] opcje sterujce obrotem
//
// Powrt
//   0
//
LONG CrrRotate(HWND hwnd, ULONG ulOptions)
{ TOOLCTL *tcl;          // Wskanik do gwnej struktury kontrolnej okna
  TOOLADJ  tadj;         // Struktura zawierajca proponowane parametry okna
  RECTL    oldpos;       // Poprzednie pooenie paska nrzdzi
  HWND     oldparent;    // Poprzednie okno rodzicielskie
  ULONG    oldstyle;     // Poprzedni styl okna


  tcl = ToolLoadData(hwnd, "CrrRotate");
  if(tcl == NULL) return(0);

  // Zmiana stanu okna na przeciwny
  if(ulOptions == TBR_ROTATE)
  { tcl->flToolState ^= TST_ROTATED;
  }
  else if(ulOptions == TBR_VERTICAL)
  { if(tcl->flToolState & TST_ROTATED) return(0);
    // Obrcenie ona do pozycji pionowej
    tcl->flToolState |= TST_ROTATED;
  }
  else if(ulOptions == TBR_HORIZONTAL)
  { if(!(tcl->flToolState & TST_ROTATED)) return(0);
    // Obrcenie okna do pozycji poziomej
    tcl->flToolState &= ~TST_ROTATED;
  }
  else return(0);

  // Inicjacja struktury TOOLADJ
  tadj.hwndToolBar = hwnd;
  tadj.hwndParent  = WinQueryWindow(hwnd, QW_PARENT);
  tadj.flAttrs     = tcl->flToolAttrs;
  tadj.flState     = tcl->flToolState & 0xFFFF;

  // Zapamietanie uchwytu okna rodzicielskiego
  oldparent = tadj.hwndParent;
  // Odczyt i zapamitanie aktualnych wymiarw okna
  WinQueryWindowRect(hwnd, &oldpos);
  WinMapWindowPoints(hwnd, oldparent, (POINTL *)&oldpos, 2);

  // Obliczenie nowej pozycji i wymiarw okna
  WinSendMsg(hwnd, TM_CALCNEWRECT, MPFROMP(&tadj), 0L);
  // Korekta nowoobliczonych obliczonych wymiarw dla stanu "floating"
  if(!(tcl->flToolState & (TST_MINIMIZED | TST_FIXED)))
  { WinOffsetRect(WinQueryAnchorBlock(hwnd), &tadj.rclSizePos,
                  0, oldpos.yTop - tadj.rclSizePos.yTop);
  }

  // Zapamitanie stylu okna
  oldstyle = WinQueryWindowULong(hwnd, QWL_STYLE);
  // Blokada przerysowywania okna
  WinEnableWindowUpdate(hwnd, FALSE);

  // Wysanie potwierdzenie o obracaniu okna
  ToolSendNotify(hwnd, TN_ROTATE, &tadj);
  // Zapamitanie nowych atrybutw
  tcl->flToolAttrs = tadj.flAttrs;

  // Sprawdzenie czy okno byo widoczne przed wysaniem komunikatu
  if(oldstyle & WS_VISIBLE)
  { // Wymuszenie odwieenia okna rodzicielskiego
    InvalidateParent(hwnd, oldparent, &oldpos);
    // Aktualizacja zawartoci paska narzdzi
    WinEnableWindowUpdate(hwnd, TRUE);
    // Obszar uniewaniony zostanie obliczony podczas przetwarzania WM_CALCVALIDRECTS
    WinValidateRect(hwnd, NULL, TRUE);
  }

  // Uaktualnienie pooenia i wymiarw paska narzdzi
  // ale tylko wtedy gdy pasek nie jest wanie minimalizowany/maksymalizowany
  // lub prznoszony w stan "floating"
  if(!(tcl->flToolState & TST_MINMAXCTL))
  { WinSetWindowPos(hwnd, HWND_TOP,
                    tadj.rclSizePos.xLeft,
                    tadj.rclSizePos.yBottom,
                    tadj.rclSizePos.xRight - tadj.rclSizePos.xLeft,
                    tadj.rclSizePos.yTop   - tadj.rclSizePos.yBottom,
                    SWP_MOVE | SWP_SIZE);
  }

  // Zapamitanie offsetu wzgldem waciciela
  if(!(tcl->flToolState & (TST_MINIMIZED | TST_FIXED)))
    StoreOffset(tcl, &tadj.rclSizePos);
  return(0);
}





// Przesuwanie paska narzdzi za pomoc myszy
//
// Parametry:
//   hwnd      - [parametr] uchwyt przesuwanego okna (paska narzdzi)
//
// Powrt:
//   TRUE  - operacja zakoczona sukcesem
//   FALSE - bd wykonania
//
LONG CrrTrackRect(HWND hwnd)
{ TOOLTRACK  trc;   // Struktura kontrolujca przesuwanie paska narzdzi
  TOOLCTL   *tcl;   // Adres struktury kontrolnej paska narzdzi
  RECTL oldpos;     // Poprzednia pozycja paska narzdzi
  HWND  oldparent;  // Uchwyt starego okna rodzicielskiego
  LONG  oldstyle;   // Styl okna przed wywoaniem potwierdzenia TN_*


  // Odczyt adresu struktur kontrolnych
  tcl = ToolLoadData(hwnd, "CrrTrackRect");
  if(tcl == NULL) return(FALSE);

  // Wstpna inicjacja struktury TOOLTRACK
  trc.hwndToolBar = hwnd;
  trc.hwndParent  = WinQueryWindow(hwnd, QW_PARENT);
  trc.flState     = tcl->flToolState & 0xFFFF;
  trc.flAttrs     = tcl->flToolAttrs;
  // Odczyt pooenia paska wzgldem okna rodzicielskiego
  WinQueryWindowRect(hwnd, &trc.rclSizePos);
  WinMapWindowPoints(hwnd, trc.hwndParent, (POINTL *)&trc.rclSizePos, 2);
  // Zapamitanie starych wartoci
  oldparent = trc.hwndParent;
  oldpos    = trc.rclSizePos;

  // Obliczenie obszaru ruchu
  if(tcl->flToolState & (TST_FIXED | TST_MINIMIZED))
  { // Pasek jest przyklejony do okna nadrzdnego - blokada przesuwu
    trc.rclBoundary = trc.rclSizePos;
  }
  else
  { // Pasek moe si swobodnie porusza wewntrz okna rodzicielskiego
    WinQueryWindowRect(trc.hwndParent, &trc.rclBoundary);
  }

  // Zapamitanie stylu okna
  oldstyle = WinQueryWindowULong(hwnd, QWL_STYLE);
  // Blokada odwieania okna na czas przetwarzania TN_BEGINTRACK
  WinEnableWindowUpdate(hwnd, FALSE);

  // Wysanie komunikatu WM_CONTROL do waciciela
  ToolSendNotify(hwnd, TN_BEGINTRACK, &trc);

  // Sprawdzenie czy okno byo widoczne przed wysaniem komunikatu
  if(oldstyle & WS_VISIBLE)
  { // Wymuszenie odwieenia okna rodzicielskiego
    InvalidateParent(hwnd, oldparent, &oldpos);
    // Aktualizacja zawartoci paska narzdzi
    WinEnableWindowUpdate(hwnd, TRUE);
    // Obszar uniewaniony zostanie obliczony podczas przetwarzania WM_CALCVALIDRECTS
    WinValidateRect(hwnd, NULL, TRUE);
  }

  // Ukrycie podpowiedzi przed rozpoczciem przesuwania
  if(tcl->hwndToolTip != NULLHANDLE)
    WinShowWindow(tcl->hwndToolTip, FALSE);

  // Sprawdzenie czy przesuwa tylko ramk
  if(ulWarpVer >= 40)
  { // Sprawdznie czy jest uaktywniona opcja "Full Window Drag"
    if(WinQuerySysValue(HWND_DESKTOP, SV_TRACKRECTLEVEL) != 0)
      // Przesuwanie caego okna w trybie "full window dragging"
      FullWindowDrag(tcl, &trc);
  }
  // Przesuwanie samej ramki
  else FrameOnlyDrag(tcl, &trc);

  // Zapamitanie aktualnych parametrw okna
  oldparent = WinQueryWindow(hwnd, QW_PARENT);
  WinQueryWindowRect(hwnd, &oldpos);
  WinMapWindowPoints(hwnd, oldparent, (POINTL *)&oldpos, 2);
  // Zapamitanie stylu okna
  oldstyle = WinQueryWindowULong(hwnd, QWL_STYLE);
  // Blokada odwieania okna
  WinEnableWindowUpdate(hwnd, FALSE);

  // Wysanie komunikatu WM_CONTROL do waciciela
  ToolSendNotify(hwnd, TN_ENDTRACK, &trc);

  // Sprawdzenie czy okno byo widoczne przed wysaniem komunikatu
  if(oldstyle & WS_VISIBLE)
  { // Wymuszenie odwieenia okna rodzicielskiego
    InvalidateParent(hwnd, oldparent, &oldpos);
    // Aktualizacja zawartoci paska narzdzi
    WinEnableWindowUpdate(hwnd, TRUE);
    // Obszar uniewaniony zostanie obliczony podczas przetwarzania WM_CALCVALIDRECTS
    WinValidateRect(hwnd, NULL, TRUE);
  }

  // Korekta pooenia i rozmiarw okna na podstawie danych przekazanych w trc
  WinSetWindowPos(hwnd, HWND_TOP,
                  trc.rclSizePos.xLeft,
                  trc.rclSizePos.yBottom,
                  trc.rclSizePos.xRight - trc.rclSizePos.xLeft,
                  trc.rclSizePos.yTop   - trc.rclSizePos.yBottom,
                  SWP_MOVE | SWP_SIZE);

  // Zapamitanie przemieszcenia okna wzgldem waciciela
  if(!(tcl->flToolState & (TST_FIXED | TST_MINIMIZED)))
    StoreOffset(tcl, &trc.rclSizePos);
  return(TRUE);
}





/*******************/
/* Funkcje lokalne */
/*******************/

// Odczyt wymiarw obramowania.
// Struktura TOOLADJ powinna mie zainicjowane pola flState i flAttrs.
//
// Parametry:
//   tadj      - [parametr] wskanik do struktury zawierajcej pytanie o rozmiary paska
//   mode      - [parametr] rodzaj odczytywanej informacji
//
static LONG CrrQueryBorder(TOOLADJ *tadj, ULONG mode)
{ LONG thick;  // Grubo obramowania

  // Obliczenie pocztkowej gruboci obramowania
  if(tadj->flState & TST_ROTATED)
  { if(mode & TDQ_HEIGHT) thick = 0;
    else thick = 2 * CXY_INTERNALMARGIN;
  }
  else
  { if(mode & TDQ_HEIGHT) thick = 2 * CXY_INTERNALMARGIN;
    else thick = 0;
  }

  // Pasek jest przesuwany - jest pene obramowanie
  if(tadj->flState & TST_FULLTRCFRAME)
  {
    // W stanie zminimalizowanym - cienka ramka
    if(tadj->flState & TST_MINIMIZED) return(2);
    // W pozostaych stanach - pena ramka
    return(thick + 4);
  }

  // Pasek w stanie floating - pena ramka
  if(!(tadj->flState & (TST_MINIMIZED | TST_FIXED))) return(thick + 4);
  // Pasek w stanie zminimalizowanym - usunicie marginesu
  if(tadj->flState & TST_MINIMIZED) thick = 0;

  // Odczyt wysokoci
  if(mode & TDQ_HEIGHT)
  { // Dolna krawd
    if(tadj->flAttrs & TBA_BOTTOMFRAME) thick++;
    // Grna krawd
    if(tadj->flAttrs & TBA_TOPFRAME)    thick++;
  }
  else
  { // Lewa krawd
    if(tadj->flAttrs & TBA_LEFTFRAME)  thick++;
    // Grna krawd
    if(tadj->flAttrs & TBA_RIGHTFRAME) thick++;
  }
  return(thick);
}





// Obliczenie rozmiarw standardowych kontrolek paska narzdzi, takich jak
// pasek tytuu, przycisk obracania okna.
//
// Parametry:
//   tadj      - [parametr] wskanik do struktury zawierajcej informacje o oknie
//   mode      - [parametr] rodzaj odczytywanej informacji: TDQ_HEIGHT, TDQ_WIDTH
//
static LONG  CrrQueryControl(TOOLADJ *tadj, ULONG mode)
{ HWND  rotate;     // Uchwyt przycisku obracania okna
  LONG  winstyle;   // Styl paska narzdzi
  LONG  thick;      // Dugo obszaru przyciskw kontrolnych

  // Odczyt stylu okna
  winstyle = WinQueryWindowULong(tadj->hwndToolBar, QWL_STYLE);
  // Odczyt uchwytu przycisku obracania okna
  if(winstyle & TBS_ROTATEBUTTON)
    rotate = WinWindowFromID(tadj->hwndToolBar, TCID_ROTATE);

  // Wstpne okrelenie rozmiarw przyciskw kontrolnych
  thick = 0;

  if(mode & TDQ_HEIGHT)
  { // Czy jest pasek tytuu ?
    if(winstyle & (TBS_MOVEBUTTON | TBS_FIXBUTTON))
      thick += (CY_TITLEHEIGHT + CXY_OBJECTSPACE);

    // Czy jest przycisk obracania ?
    if(winstyle & TBS_ROTATEBUTTON)
      if(WinIsWindowEnabled(rotate))
        thick += (CY_ROTATEBUTTON + 2 * CXY_ROTATESPACE + CXY_OBJECTSPACE);
  }
  else
  { // Czy jest pasek tytuu ?
    if(winstyle & (TBS_MOVEBUTTON | TBS_FIXBUTTON))
      thick += (CX_TITLEWIDTH + CXY_OBJECTSPACE);

    // Czy jest przycisk obracania ?
    if(winstyle & TBS_ROTATEBUTTON)
      if(WinIsWindowEnabled(rotate))
        thick += (CX_ROTATEBUTTON + 2 * CXY_ROTATESPACE + CXY_OBJECTSPACE);
  }
  return(thick);
}





// Funkcja koryguje obszar wewntrz obramowania, otrzymany za pomoc funkcji
// CrrQueryInterior tak, aby uwzgldnia on tylko obszar przeznaczony
// na obiekty umieszczane wewntrz paska narzdzi.
//
// Parametry:
//   tadj      - [parametr/rezultat] struktura zawierajca dane do skorygowania
//
static VOID CrrQueryClientArea(TOOLADJ *tadj)
{
  if(tadj->flState & TST_ROTATED)
  { // Korekta grnego marginesu
    tadj->rclSizePos.yTop    -= CrrQueryControl(tadj, TDQ_HEIGHT);
    // Korekta dolego marginesu
    if(tadj->flState & TST_FIXED)
     tadj->rclSizePos.yBottom += CrrQueryEndMargin(tadj);
    tadj->rclSizePos.yBottom += CXY_INTERNALMARGIN;
    // Korekta lewego marginesu
    tadj->rclSizePos.xLeft   += CXY_INTERNALMARGIN;
    // Korekta prawego marginesu
    tadj->rclSizePos.xRight  -= CXY_INTERNALMARGIN;
  }
  else
  { // Korekta grnego marginesu
    tadj->rclSizePos.yTop    -= CXY_INTERNALMARGIN;
    // Korekta dolego marginesu
    tadj->rclSizePos.yBottom += CXY_INTERNALMARGIN;
    // Korekta lewego marginesu
    tadj->rclSizePos.xLeft   += CrrQueryControl(tadj, TDQ_WIDTH);
    // Korekta prawego marginesu
    if(tadj->flState & TST_FIXED)
      tadj->rclSizePos.xRight  -= CrrQueryEndMargin(tadj);
    tadj->rclSizePos.xRight  -= CXY_INTERNALMARGIN;
  }
}





// Funkcja okrela szeroko kocowego marginesu
// Struktura TOOLADJ powinna mie zainicjowane pola flState i flAttrs
//
// Parametry:
//   tadj      - [parametr] wskanik do struktury zawierajcej stan paska
//
static LONG  CrrQueryEndMargin(TOOLADJ *tadj)
{ LONG margin;

  // Sprawdzenie czy trwa przesuwanie paska
  if(tadj->flState & TST_FULLTRCFRAME) return(0);

  // Obliczanie kocowego margunesu
  margin = CXY_ENDMARGIN;
  // Uwzgldnienie pooenia paska
  if(tadj->flState & TST_ROTATED)
  { if(tadj->flAttrs & TBA_TOPFRAME)    margin--;
    if(tadj->flAttrs & TBA_BOTTOMFRAME) margin--;
  }
  else
  { if(tadj->flAttrs & TBA_LEFTFRAME)   margin--;
    if(tadj->flAttrs & TBA_RIGHTFRAME)  margin--;
  }
  return(margin);
}





/******************************/
/* Dodatkowe funkcje usugowe */
/******************************/

// Przesuwanie tylko ramki paska narzdzi
//
// Parametry:
//   tcl       - wskanik do struktur kontrolnych paska narzdzi
//   trc       - parametry przesuwania
//
static VOID FrameOnlyDrag(TOOLCTL *tcl, TOOLTRACK *trc)
{ TRACKINFO tnf;    // Struktura przekazywana funkcji WinTrackRect
  POINTL    pos;    // Kocowa pozycja podczas przesuwania

  // Inicjalizacja struktury
  tnf.cxBorder    = 2;
  tnf.cyBorder    = 2;
  tnf.cxGrid      = 1;
  tnf.cyGrid      = 1;
  tnf.cxKeyboard  = 1;
  tnf.cyKeyboard  = 1;
  tnf.rclTrack    = trc->rclSizePos;
  tnf.rclBoundary = trc->rclBoundary;
  tnf.ptlMinTrackSize.x = tnf.rclTrack.xRight - tnf.rclTrack.xLeft;
  tnf.ptlMinTrackSize.y = tnf.rclTrack.yTop   - tnf.rclTrack.yBottom;
  tnf.ptlMaxTrackSize   = tnf.ptlMinTrackSize;
  tnf.fs = TF_MOVE;
  if(tcl->flToolState & (TST_FIXED | TST_MINIMIZED))
    tnf.fs |= TF_ALLINBOUNDARY;

  // Przesuwanie ramki
  WinTrackRect(trc->hwndParent, NULLHANDLE, &tnf);
  // Wysanie potwierdzenie TN_TRACKING
  pos.x = tnf.rclTrack.xLeft;
  pos.y = tnf.rclTrack.yBottom;
  ToolSendNotify(tcl->hwndToolBar, TN_TRACKING, &pos);

  // Zapamitanie rezultatw
  trc->rclSizePos = tnf.rclTrack;
}





// Przesuwanie caego okna paska narzdzi - "full window dragging"
//
// Parametry:
//   tcl       - wskanik do struktur kontrolnych paska narzdzi
//   trc       - parametry przesuwania
//
static VOID FullWindowDrag(TOOLCTL *tcl, TOOLTRACK *trc)
{ POINTL  cpos;          // Aktualna pozycja kursora i po korekcie - paska narzdzi
  POINTL  delta;         // Pooenie przesuwanego paska wzgldem kursora myszy
  POINTL  offset;        // Korekta pooenia po zmianie obramowania w UpdateBeforeDrag
  HWND    hwnd;          // Uchwyt paska narzdzi
  QMSG    smsg;          // Struktura przechowujca komunikat
  HAB     hab;           // Uchwyt anchor block PM


  hwnd = tcl->hwndToolBar;
  // Przejcie kursora myszy
  WinSetCapture(HWND_DESKTOP, tcl->hwndTitleBar);
  // Odczyt uchwytu anchor block
  hab = WinQueryAnchorBlock(hwnd);
  // Inicjacja zmiennych
  offset.x = 0; offset.y = 0;

  // Obliczenie przesunicia kursora wzgldem paska narzdzi
  WinQueryPointerPos(HWND_DESKTOP, &delta);
  WinMapWindowPoints(HWND_DESKTOP, trc->hwndParent, &delta, 1);
  delta.x -= trc->rclSizePos.xLeft;
  delta.y -= trc->rclSizePos.yBottom;

  // Pomocnicza, wewntrzna ptla przetwarzajca komunikaty
  // podczas przesuwania okna
  do
  { // Sprawdzenie czy w kolejce jest gdzie WM_PAINT,
    // przetworzenie go w pierwszej kolejnoci.
    if(WinPeekMsg(hab, &smsg, NULLHANDLE, WM_PAINT, WM_PAINT, PM_REMOVE) == TRUE)
    { // Przerysowanie wybranego okna
      WinDispatchMsg(hab, &smsg);
    }
    // Sprawdzenie czy w kolejce jest WM_QUIT
    else if(WinPeekMsg(hab, &smsg, NULLHANDLE, WM_QUIT, WM_QUIT, PM_NOREMOVE) == TRUE)
    { // Przerwanie ptli
      break;
    }

    // Pobieranie i rozsyanie pozostaych komunikatw
    else
    { // Pobranie komunikatu z kolejki
      WinGetMsg(hab, &smsg, NULLHANDLE, 0, 0);

      // Dodatkowe przetwarzanie informacji dotyczcych przycisku
      if(smsg.hwnd == tcl->hwndTitleBar)
      { // Sprawdzenie czy zwolniono przycisk, koczc przesuwanie ramki
        if(smsg.msg == WM_BUTTON1UP)
        { // Korekta wygldu ramki po zakoczeniu przesuwania
          tcl->flToolState &= ~TST_FULLTRCFRAME;
          // Przerwanie wewntrznej ptli
          break;
        }

        // Sprawdzenie czy rozpoczto przesuwanie ramki
        if(smsg.msg == WM_BUTTON1MOTIONSTART)
          // Korekta wygldu ramki przed rozpczciem przesuwania
          UpdateBeforeDrag(tcl, trc, &offset);
      }

      // Sprawdzenie czy jest to komunikat informujcy o ruchu kursora
      if(smsg.msg == WM_MOUSEMOVE)
      {
        cpos = smsg.ptl;
        // Obliczenie pozycji kursora wyraonej we wsprzdnych okna rodzicielskiego
        WinMapWindowPoints(HWND_DESKTOP, WinQueryWindow(hwnd, QW_PARENT), &cpos, 1);

        // Sprawdzenie zakresu przesuwania okna
        if(trc->flState & (TST_FIXED | TST_MINIMIZED))
        { // Przesuwanie paska - bez wyjedania krawdzi poza obrb obszaru ograniczajcego
          // Dodanie przesunicia - delta
          cpos.x -= delta.x;
          cpos.y -= delta.y;
          // Sprawdzanie kolejnych krawdzi - prawa krawd
          if((cpos.x + trc->rclSizePos.xRight - trc->rclSizePos.xLeft) > trc->rclBoundary.xRight)
            cpos.x = trc->rclBoundary.xRight - trc->rclSizePos.xRight + trc->rclSizePos.xLeft;
          // Dolna krawd
          if(cpos.y < trc->rclBoundary.yBottom)
            cpos.y = trc->rclBoundary.yBottom;
          // Lewa krawd
          if(cpos.x < trc->rclBoundary.xLeft)
            cpos.x = trc->rclBoundary.xLeft;
          // Gtna krawd
          if((cpos.y + trc->rclSizePos.yTop - trc->rclSizePos.yBottom) > trc->rclBoundary.yTop)
            cpos.y = trc->rclBoundary.yTop - trc->rclSizePos.yTop + trc->rclSizePos.yBottom;
        }
        else
        { // Sprawdzenie czy nowa pozycja zawiera si w obrbie okna i ewentualna korekta
          if(cpos.x < trc->rclBoundary.xLeft)   cpos.x = trc->rclBoundary.xLeft;
          if(cpos.y < trc->rclBoundary.yBottom) cpos.y = trc->rclBoundary.yBottom;
          if(cpos.x > trc->rclBoundary.xRight)  cpos.x = trc->rclBoundary.xRight;
          if(cpos.y > trc->rclBoundary.yTop)    cpos.y = trc->rclBoundary.yTop;
          // Dodanie przesunicia - delta
          cpos.x -= delta.x;
          cpos.y -= delta.y;
        }

        // Korekta wsprzdnych zapisanych w strukturze TOOLTRACK
        WinOffsetRect(hab, &trc->rclSizePos,
                            cpos.x - trc->rclSizePos.xLeft,
                            cpos.y - trc->rclSizePos.yBottom);

        // Ustalenie nowej pozycji okna
        WinSetWindowPos(hwnd, HWND_TOP, cpos.x + offset.x, cpos.y + offset.y, 0, 0, SWP_MOVE | SWP_NOADJUST);
        // Wysanie do waciciela komunikatu potwierdzajcego zmian pozycji
        ToolSendNotify(hwnd, TN_TRACKING, &cpos);
        // Usunicie nieprzetworzonego WM_MOUSEMOVE z kolejki
        WinPeekMsg(hab, &smsg, NULLHANDLE, WM_MOUSEMOVE, WM_MOUSEMOVE, PM_REMOVE);
      }
      // Przetwarzanie pozostaych komunikatw
      else WinDispatchMsg(hab, &smsg);
    }
  } while(1);

  // Zwolnienie kursora myszy
  WinSetCapture(HWND_DESKTOP, NULLHANDLE);
}





// Funkcja wymusza przerysowanie fragmentu stargego okna rodzicielskiego,
// zakrytego uprzednio przez pasek narzdzi, ktry zmieni rodzica.
//
// Parametry:
//   hwnd      - [parametr] uchwyt paska narzdzi
//   oldparent - [parametr] uchwyt starego okna rodzicielskiego
//   oldpos    - [parametr] poprzednia pozycja paska narzdzi, liczona wzgldem oldpos
//
static VOID InvalidateParent(HWND hwnd, HWND oldparent, RECTL *oldpos)
{ RECTL new;        // Nowa pozycja paska narzdzi
  LONG  rc;         // Kody zwracane przez funkcje
  HRGN  update;     // Odwieany obszar
  HRGN  tmp;        // Tymczasowy obszar pomocniczy
  HPS   hps;        // Uchwyt presentation space okna rodzicielskiego

  hps = WinGetPS(oldparent);
  // Odczyt wsprzdnych nowej pozycji paska narzdzi
  WinQueryWindowRect(hwnd, &new);
  WinMapWindowPoints(hwnd, oldparent, (POINTL *)&new, 2);

  // Tworzenie obszaru odwieania
  update = GpiCreateRegion(hps, 1, oldpos);
  if(update != RGN_ERROR)
  { // Region pomocniczy
    tmp = GpiCreateRegion(hps, 1, &new);
    if(tmp != RGN_ERROR)
    { // Obliczenie rnicy: oldpos - new
      rc = GpiCombineRegion(hps, update, update, tmp, CRGN_DIFF);
      if((rc != RGN_NULL) && (rc != RGN_ERROR))
        // Odwieenie obszaru
        WinInvalidateRegion(oldparent, update, TRUE);

      // Usunicie regionu pomocniczego
      if(tmp    != RGN_ERROR) GpiDestroyRegion(hps, tmp);
    }
    // Usunicie odwieanego regionu
    if(update != RGN_ERROR) GpiDestroyRegion(hps, update);
  }
  WinReleasePS(oldparent);
}





// Pozycjonowanie przycisku oracania okna
//
// Parametry:
//   tcl       - [parametr] wskanik do gwnej struktury kontrolnej paska narzdzi
//   rclInter  - [parametr] wsprzdne obszaru wewntrz obramowania
//
static VOID  PlaceRotateButton(TOOLCTL *tcl, RECTL *rclInter)
{ POINTL pos;       // Wsprzdne ognego przeznaczenia
  LONG   cx, cy;    // Wymiary przycisku

  // Sprawdzenie czy przycisk obracania okna jest
  if(!(tcl->flWinStyle & TBS_ROTATEBUTTON)) return;

  // Ukrycie przycisku obracania w stanie zminimalizowanym
  if(tcl->flToolState & TST_MINIMIZED)
  { // Ukrycie przycisku obracania
    if(tcl->flWinStyle & TBS_ROTATEBUTTON)
      WinShowWindow(tcl->hwndRotate, FALSE);
    return;
  }

  // Sprawdzenie czy przycisk obracania okna jest aktywny
  if(WinIsWindowEnabled(tcl->hwndRotate))
  { if(tcl->flToolState & TST_ROTATED)
    { pos.x = rclInter->xLeft;
      pos.y = rclInter->yTop  - CXY_ROTATESPACE - CY_ROTATEBUTTON;
      if(tcl->flWinStyle & (TBS_MOVEBUTTON | TBS_FIXBUTTON))
        pos.y -= (CY_TITLEHEIGHT + CXY_OBJECTSPACE);
      cx = rclInter->xRight - rclInter->xLeft;
      cy = CY_ROTATEBUTTON;
    }
    else
    { pos.x = rclInter->xLeft + CXY_ROTATESPACE;
      if(tcl->flWinStyle & (TBS_MOVEBUTTON | TBS_FIXBUTTON))
        pos.x += (CX_TITLEWIDTH + CXY_OBJECTSPACE);
      pos.y = rclInter->yBottom;
      cx = CX_ROTATEBUTTON;
      cy = rclInter->yTop - rclInter->yBottom;
    }
    // Pozycjonowanie przycisku obracania okna
    WinSetWindowPos(tcl->hwndRotate, HWND_TOP,
                    pos.x, pos.y, cx, cy,
                    SWP_MOVE | SWP_SIZE | SWP_ZORDER | SWP_SHOW);
  }
  else WinShowWindow(tcl->hwndRotate, FALSE);
}





// Pozycjonowanie paska tytuu.
//
// Parametry:
//   tcl       - [parametr] wskanik do gwnej struktury kontrolnej paska narzdzi
//   rclInter  - [parametr] wsprzdne obszaru wewntrz obramowania
//
static VOID PlaceTitleBar(TOOLCTL *tcl, RECTL *rclInter)
{ POINTL pos;       // Wsprzdne oglnego przeznaczenia
  LONG   length;    // Obliczona dugo paska tytuu


  // Sprawdzenie czy pasek narzdzi jest
  if(!(tcl->flWinStyle & (TBS_MOVEBUTTON | TBS_FIXBUTTON))) return;
  // Pozioma wsprzdna pocztkowa paska tytuu
  pos.x = rclInter->xLeft;

  // Sprawdzenie czy pasek narzdzi jest zminimalizowany
  if(tcl->flToolState & TST_MINIMIZED)
  { // Obliczenie duoci paska tytuu i ustalenie pooenia
    if(tcl->flToolState & TST_ROTATED)
    { length = rclInter->yTop - rclInter->yBottom;
      pos.y  = rclInter->yTop - length;
      tcl->flTitleState &= ~STT_ROTATED;
    }
    else
    { length = rclInter->xRight - rclInter->xLeft;
      pos.y  = rclInter->yBottom;
      tcl->flTitleState |= STT_ROTATED;
    }
    // Rysowanie cicia
    tcl->flTitleState |= STT_DRAWCUT;
  }
  // Pozycjonowanie w stanie normalnym
  else
  { // Ustalenie nowego pooenia paska tytuu
    if(tcl->flToolState & TST_ROTATED)
    { length = rclInter->xRight - rclInter->xLeft;
      pos.y  = rclInter->yTop - CY_TITLEHEIGHT;
      tcl->flTitleState |= STT_ROTATED;
    }
    else
    { length = rclInter->yTop - rclInter->yBottom;
      pos.y  = rclInter->yBottom;
      tcl->flTitleState &= ~STT_ROTATED;
    }
    // Wyczenie rysowania cicia
    tcl->flTitleState &= ~STT_DRAWCUT;
  }

  // Okrelenie stanu przycisku minimalizacji i maksymalizacji
  if(tcl->flToolState & (TST_MINIMIZED | TST_FIXED))
    tcl->flTitleState &= ~STT_UPTRIANGL;
  else tcl->flTitleState |= STT_UPTRIANGL;

  // Pozycjonowanie paska tytuu
  WinSetWindowPos(tcl->hwndTitleBar, HWND_TOP,
                  pos.x, pos.y, length, length,
                  SWP_MOVE | SWP_SIZE | SWP_ZORDER);
}





// Funkcja zapamituje przemieszczenie paska narzdzi wzgldem waciciela,
// w polu ptlOffset gwnej struktury kontrolnej.
//
// Parametry:
//    tcl      - [parametr/rezultat] wskanik do gwnych struktur kontrolnych okna
//    winpos   - [parametr] pozycja okna liczona wzgldem okna rodzicielskiego
//
static VOID StoreOffset(TOOLCTL *tcl, RECTL *winpos)
{ RECTL tsize;      // Rozmiary paska narzdzi
  RECTL osize;      // Rozmiary waciciela
  HWND  owner;      // Uchwyt waciciela okna
  HWND  parent;     // Uchwyt okna rodzicielskiego

  // Inicjacja zmiennych
  tsize = *winpos;
  // Odczyt uchwytu frame-window, bdcego wacicielem paska narzdzi
  owner  = WinQueryWindow(tcl->hwndToolBar, QW_FRAMEOWNER);
  // Odczyt rozmiarw waciciela
  WinQueryWindowRect(owner, &osize);
  // Odczyt uchwytu okna rodzicielskiego
  parent = WinQueryWindow(tcl->hwndToolBar, QW_PARENT);

  // Mapowanie do wsprzdnych wacicela
  WinMapWindowPoints(parent, owner, (POINTL *)&tsize, 2);
  // Zapamitanie przesunicia
  tcl->ptlOffset.x = tsize.xLeft;
  tcl->ptlOffset.y = osize.yTop - tsize.yBottom;
}





// Funkcja przygotowuje okno do przesuwania, zostaje przerysowane obramowanie
// oraz zmieniony stan okna: dadany TST_FULLTRCFRAME.
//
// Parametr:
//   tcl       - [parametr] wskanik do struktut kontrolnych paska
//   trc       - [parametr] parametry przesuwu
//   offset    - [rezultat] przesunicie korygujce pooenie ramki po zmianie obramowania
//
static VOID UpdateBeforeDrag(TOOLCTL *tcl, TOOLTRACK *trc, POINTL *offset)
{ LONG cx, cy;           // Wymiary paska narzdzi

  // Przygotowanie ramki do przesuwania - ustawienie odpowiedniego bitu stanu
  tcl->flToolState |= TST_FULLTRCFRAME;
  // Okrelnie rozmiarw paska narzdzi skorygowanych o grubo ramki
  cx = (LONG)WinSendMsg(tcl->hwndToolBar, TM_QUERYWIDTH,  MPFROMLONG(TDQ_CURRENT), 0L);
  cy = (LONG)WinSendMsg(tcl->hwndToolBar, TM_QUERYHEIGHT, MPFROMLONG(TDQ_CURRENT), 0L);

  // Obliczenie przesunicia korygujcego wzrost wymiarw ramki
  // (podczas przesuwania jest rysowane pene obramowanie 3D)
  offset->x = -((cx - trc->rclSizePos.xRight + trc->rclSizePos.xLeft  ) / 2);
  offset->y = -((cy - trc->rclSizePos.yTop   + trc->rclSizePos.yBottom) / 2);

  // Korekta wymiarw i pooenia paska narzdzi
  WinSetWindowPos(tcl->hwndToolBar, HWND_TOP,
                  trc->rclSizePos.xLeft   + offset->x,
                  trc->rclSizePos.yBottom + offset->y,
                  cx, cy, SWP_MOVE | SWP_SIZE);
}


/*
 * $Log: carrier.c $
 * Revision 1.1  1999/06/27 12:35:43  Wojciech_Gazda
 * Initial revision
 *
 */
