/*************************************************************************** 
 *    Menu identifiers.                                                    *
 ***************************************************************************/

#define GEOD_ELLIPSOIDMENU      2000       /* Sub Menu               */
#define GEOD_AIRY               2001       /* Menu Item              */
#define GEOD_AUSNSA1969         2002       /* Menu Item              */
#define GEOD_BESSEL             2003       /* Menu Item              */
#define GEOD_CLARKE1866         2004       /* Menu Item              */
#define GEOD_CLARKE1880         2005       /* Menu Item              */
#define GEOD_EVEREST            2006       /* Menu Item              */
#define GEOD_FISCHER1960        2007       /* Menu Item              */
#define GEOD_FISCHER1960SA      2008       /* Menu Item              */
#define GEOD_FISCHER1968        2009       /* Menu Item              */
#define GEOD_HOUGH              2010       /* Menu Item              */
#define GEOD_INTL               2011       /* Menu Item              */
#define GEOD_IAU1968            2012       /* Menu Item              */
#define GEOD_KRASSOVSKIY        2013       /* Menu Item              */
#define GEOD_WGS1972            2014       /* Menu Item              */
#define GEOD_MEASUREMENU        2015       /* Sub Menu               */
#define GEOD_NM                 2016       /* Menu Item              */
#define GEOD_METERS             2017       /* Menu Item              */
#define GEOD_HELPMENU           2018       /* Sub Menu               */
#define GEOD_ABOUT              2019       /* Menu Item              */
#define GEOD_EXIT               2020       /* Menu Item              */
                                
/*************************************************************************** 
 *    Window/control identifiers.                                          *
 ***************************************************************************/

#define GEOD_DIALOG             3000       /* Dialog                 */
#define GEOD_CURRMEASURE        3001       /* Static Text            */
#define GEOD_CURRELLIPSOID      3002       /* Static Text            */
#define GEOD_EQRAD              3003       /* Static Text            */
#define GEOD_POLRAD             3004       /* Static Text            */
#define GEOD_MEANRAD            3005       /* Static Text            */
#define GEOD_FLAT               3006       /* Static Text            */
#define GEOD_ECC                3007       /* Static Text            */
#define GEOD_ECC2               3008       /* Static Text            */

#define GEOD_ABOUTDIALOG        4000       /* Dialog                 */

#define DEF_BUFF                  80

typedef struct _ELLIPSOID
{
    double EquatorialRadius[2];
    double PolarRadius[2];
    double MeanRadius[2];
    double Flattening;
    double Eccentricity;
    double Eccentricity2;
} ELLIPSOID;
typedef ELLIPSOID *PELLIPSOID;

ELLIPSOID el[] = { {3443.609, 6377563.396,   /* Airy */
                    3432.104, 6356256.91,
                    3439.774, 6370461.234,
                    0.00334085,
                    0.081673374,
                    0.00667054},

                   {3443.931, 6378160.0,   /* Australian National-SA (1969) */
                    3432.384, 6356774.719,
                    3440.082, 6371031.573,
                    0.00335289,
                    0.0818202,
                    0.00669454},

                   {3443.52, 6377397.155,    /* Bessel */
                    3432.01, 6356078.963,
                    3439.682, 6370291.091,
                    0.00334277,
                    0.08169683,
                    0.00667437},

                   {3443.957, 6378206.4,   /* Clarke (1866) */
                    3432.281, 6356583.8,
                    3440.064, 6370998.9,
                    0.00339008,
                    0.08227185,
                    0.00676866},

                   {3443.98, 6378249.145,    /* Clarke (1880) */
                    3432.245, 6356514.87,
                    3440.067, 6371004.387,
                    0.00340756,
                    0.0824834,
                    0.00680351},

                   {3443.454, 6377276.345,   /* Everest */
                    3432.006, 6356075.413,
                    3439.638, 6370209.37,
                    0.00332445,
                    0.08147298,
                    0.00663785},

                   {3443.934, 6378166.0,     /* Fischer 1960 */
                    3432.389, 6356784.24,
                    3440.086, 6371038.761,
                    0.00335233,
                    0.081813334,
                    0.0069342},

                   {3443.928, 6378155.0,     /* Fischer South Asia 1960 */
                    3432.383, 6356773.32,
                    3440.08, 6371027.773,
                    0.00335233,
                    0.081813334,
                    0.00669342},

                   {3443.925, 6378150.0,     /* Fischer 1968 */
                    3432.381, 6356768.337,
                    3440.077, 6371022.985,
                    0.00335233,
                    0.08181333,
                    0.00669342},

                   {3443.99, 6378270.0,      /* Hough */
                    3432.394, 6356794.343,
                    3440.125, 6371111.148,
                    0.003367003,
                    0.08199189,
                    0.00672267},

                   {3444.054, 6378388.0,     /* International */
                    3432.459, 6356911.946,
                    3440.19, 6371229.315,
                    0.003367003,
                    0.08199189,
                    0.00672267},

                   {3443.931, 6378160.0,    /* IAU 1968 */
                    3432.384, 6356774.719,
                    3440.082, 6371031.573,
                    0.00335289,
                    0.0818202,
                    0.00669454},

                   {3443.977, 6378245.0,    /* Krassovskiy */
                    3432.43, 6356863.019,
                    3440.128, 6371117.673,
                    0.00335233,
                    0.08181333,
                    0.00669342},

                   {3443.917, 6378135.0,    /* WGS 1972 */
                    3432.371, 6356750.52,
                    3440.068, 6371006.84,
                    0.00335278,
                    0.0818188,
                    0.00669432}  };
