
/*
 *  This file was generated by the SOM Compiler.
 *  Generated using:
 *     SOM incremental update: 2.7
 */

/******************************************************************************
*
*  Module Name: MYFILE.C
*
*  OS/2 Work Place Shell Sample Program
*
*  Copyright (C) 1994, 1995 IBM Corporation
*
*      DISCLAIMER OF WARRANTIES.  The following [enclosed] code is
*      sample code created by IBM Corporation. This sample code is not
*      part of any standard or IBM product and is provided to you solely
*      for  the purpose of assisting you in the development of your
*      applications.  The code is provided "AS IS", without
*      warranty of any kind.  IBM shall not be liable for any damages
*      arising out of your use of the sample code, even if they have been
*      advised of the possibility of such damages.
*
*  Entry Points:
*
*     Class Methods:
*
*        myfM_clsQueryModuleHandle
*        myfM_clsQueryDefaultFileText
*
*     Overridden Class Methods:
*
*        myfM_wpclsInitData
*        myfM_wpclsQueryDefaultHelp
*        myfM_wpclsQueryDefaultView
*        myfM_wpclsQueryDetailsInfo
*        myfM_wpclsQueryIconData
*        myfM_wpclsQueryInstanceFilter
*        myfM_wpclsQueryStyle
*        myfM_wpclsQueryTitle
*        myfM_wpclsUnInitData
*
*     Instance Methods:
*
*        myf_AddLastWorkerPage
*        myf_soundAlarm
*        myf_queryLastWorker
*        myf_setLastWorker
*
*     Overridden Instance Methods:
*
*        myf_wpAddSettingsPages
*        myf_wpFilterPopupMenu
*        myf_wpInitData
*        myf_wpMenuItemHelpSelected
*        myf_wpMenuItemSelected
*        myf_wpModifyPopupMenu
*        myf_wpOpen
*        myf_wpQueryDetailsData
*        myf_wpRestoreState
*        myf_wpSaveState
*        myf_wpUnInitData
*        myf_wpFormatDragItem
*        myf_wpSetup
*        myf_wpSetupOnce
*
*     Non-Method Functions:
*
*        MYFILEInit
*        MYFILEWndProc
*        LastWorkerDlgProc
*
******************************************************************************/

#define MYFILE_Class_Source
#define M_MYFILE_Class_Source

#include "myfile.ih"
/* CSC2IDL:  REMOVED after .csc -> .idl conversion:  #include "myfile.ph" */

#include <string.h>
#include <stdio.h>
#include <memory.h>
#include <stdlib.h>

/*
 *   Non-Method function prototypes
 */

HWND             MYFILEInit (MYFILE*);
MRESULT EXPENTRY LastWorkerDlgProc( HWND hwnd, ULONG msg,
                                   MPARAM mp1, MPARAM mp2 );
MRESULT EXPENTRY MYFILEWndProc ( HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2 );


/***************** GLOBAL/STATIC (NON-INSTANCE) DATA SECTION ******************
*****                                                                     *****
*****    This data shouldn't be changed by instance methods or it will    *****
*****    effect all instances!  Any variables that are specific (unique   *****
*****    values) for each instance of this object should be declared as   *****
*****  instance data or dynamically allocated and stored as window data.  *****
*****                                                                     *****
*****      This global data should be declared as class instance data     *****
*****    if it will change after initialization.  In this case, it will   *****
*****                  be accessed through class methods.                 *****
*****                                                                     *****
******************************************************************************/


   CHAR       szMYFILEWindowClass[] =    "MYFILESAMPLE";
   CHAR       szMYFILEInstanceFilter[] = "*.txt";
   CHAR       szHelpLibrary[] =       "myfile.hlp";
   UCHAR      szMYFILEClassTitle[CCHMAXPATH] = "";
   HMODULE    hmod = NULLHANDLE;

   /*
    *   Statics required for FIELDINFO structures needed for DETAILS view are
    *   handled in the three functions:
    *
    *   myf_wpclsInitData, myf_wpQueryDetailsData, myf_wpQueryClassDetailsInfo
    */

   #define NUM_MYFILE_FIELDS    1

   CLASSFIELDINFO fieldinfo[NUM_MYFILE_FIELDS];      /* structure in myfile.h */

   PSZ apszMYFILEColTitles[] =
   {
      "Last Worker"           /* details column 1 */
   };


/*************************  INSTANCE METHODS SECTION  *************************
*****                                                                     *****
*****              Do not put any code in this section unless             *****
*****                   it is an object INSTANCE method                   *****
*****                                                                     *****
******************************************************************************/
#undef SOM_CurrentClass
#define SOM_CurrentClass SOMInstance


/*
 *
 *  METHOD: queryLastWorker                                ( ) PRIVATE
 *                                                         (X) PUBLIC
 *  DESCRIPTION:
 *
 *    Query name of last person to work with myfile
 *
 *  RETURN:
 *
 *    PSZ            name of last person to work on file
 *
 */
SOM_Scope PSZ   SOMLINK myf_queryLastWorker(MYFILE *somSelf)
{
    MYFILEData *somThis = MYFILEGetData(somSelf);
    MYFILEMethodDebug("MYFILE","myf_queryLastWorker");

    return _pszLastWorker;
} /* end myf_queryLastWorker */

/*
 *
 *  METHOD: setLastWorker                                  ( ) PRIVATE
 *                                                         (X) PUBLIC
 *  DESCRIPTION:
 *
 *    Set name of last person to work with myfile
 *
 *  RETURN:
 *
 *    BOOL     Successful
 *
 */
SOM_Scope BOOL   SOMLINK myf_setLastWorker(MYFILE *somSelf,
                PSZ pszWorkerName)
{
    BOOL rc = FALSE;

    MYFILEData *somThis = MYFILEGetData(somSelf);
    MYFILEMethodDebug("MYFILE","myf_setLastWorker");

    if (pszWorkerName)
    {
      if (_pszLastWorker)
      {
         _wpFreeMem(somSelf, (PBYTE) _pszLastWorker);
         _pszLastWorker = (PSZ) _wpAllocMem(somSelf, strlen(pszWorkerName)+1, NULL);
         strcpy(_pszLastWorker, pszWorkerName);
         _wpCnrRefreshDetails(somSelf);
         rc = TRUE;
      }
    }
    return(rc);

} /* end myf_setLastWorker */

/*
 *
 *  METHOD: soundAlarm                                     ( ) PRIVATE
 *                                                         (X) PUBLIC
 *  DESCRIPTION:
 *
 *    Sound an alarm
 *
 *  RETURN:
 *
 *    TRUE           Successful
 *    FALSE          Unsuccessful
 *
 */
SOM_Scope BOOL   SOMLINK myf_soundAlarm(MYFILE *somSelf)
{
    MYFILEData *somThis = MYFILEGetData(somSelf);
    MYFILEMethodDebug("MYFILE","myf_soundAlarm");

    DosBeep(100,50);
    DosSleep(100);
    DosBeep(100,50);
    DosSleep(100);
    DosBeep(100,50);
    DosSleep(100);
    DosBeep(100,50);
    DosSleep(100);
    DosBeep(100,50);
    DosSleep(300);
    DosBeep(100, 100);
    DosSleep(100);
    DosBeep(100, 100);

    return TRUE;
} /* end myf_soundAlarm */

/*
 *
 *  METHOD: AddLastWorkerPage                              ( ) PRIVATE
 *                                                         (X) PUBLIC
 *  DESCRIPTION:
 *
 *    This method adds the Last Worker page to the settings notebook.
 *
 *  RETURN:
 *
 *    0              Unsuccessful
 *    ulPageId       Identifier for the inserted page
 *
 *  HOW TO OVERRIDE:
 *
 *    Method should always be overridden in order to replace or remove
 *    the last worker page from an object which is a descendent of myfile.
 *    In most cases, an override of this method will not call the parent.
 *
 */
SOM_Scope ULONG   SOMLINK myf_AddLastWorkerPage(MYFILE *somSelf,
                HWND hwndNotebook)
{
    PAGEINFO pageinfo;

    MYFILEData *somThis = MYFILEGetData(somSelf);
    MYFILEMethodDebug("MYFILE","myf_AddLastWorkerPage");

    memset((PCH)&pageinfo,0,sizeof(PAGEINFO));
    pageinfo.cb                 = sizeof(PAGEINFO);
    pageinfo.hwndPage           = NULLHANDLE;
    pageinfo.usPageStyleFlags   = BKA_MAJOR;
    pageinfo.usPageInsertFlags  = BKA_FIRST;
    pageinfo.pfnwp              = LastWorkerDlgProc;
    pageinfo.resid              = hmod;
    pageinfo.dlgid              = IDD_LASTWORKER;
    pageinfo.pszName            = "LastWorker";
    pageinfo.pCreateParams      = somSelf;
    pageinfo.idDefaultHelpPanel = ID_HELP_LASTWORKER;
    pageinfo.pszHelpLibraryName = szHelpLibrary;

    return _wpInsertSettingsPage( somSelf, hwndNotebook, &pageinfo );

}   /* end myf_AddLastWorkerPage() */

/*
 *
 *  OVERRIDE: wpInitData                                   ( ) PRIVATE
 *                                                         (X) PUBLIC
 *  DESCRIPTION:
 *
 *    Initialize our state variables. Allocate any extra memory that
 *    we might need.
 *
 */
SOM_Scope void SOMLINK myf_wpInitData(MYFILE *somSelf)
{
    MYFILEData *somThis = MYFILEGetData(somSelf);
    MYFILEMethodDebug("MYFILE","myf_wpInitData");

    parent_wpInitData(somSelf);

    _pszLastWorker = (PSZ) _wpAllocMem(somSelf, CCHMAXPATH+1, NULL);
    if (_pszLastWorker)
    {
       strcpy(_pszLastWorker, DEFAULT_LASTWORKER);
    }


}   /* end myf_wpInitData() */

/*
 *
 *  OVERRIDE: wpUnInitData                                 ( ) PRIVATE
 *                                                         (X) PUBLIC
 *  DESCRIPTION:
 *
 *    Clear up memory that was allocated on wpInitData.
 *
 */
SOM_Scope void   SOMLINK myf_wpUnInitData(MYFILE *somSelf)
{
    MYFILEData *somThis = MYFILEGetData(somSelf);
    MYFILEMethodDebug("MYFILE","myf_wpUnInitData");

    if (_pszLastWorker)
    {
      _wpFreeMem(somSelf, (PBYTE)_pszLastWorker);
    }
    parent_wpUnInitData(somSelf);

}   /* end myf_wpUnInitData() */


/*
 *
 *  METHOD: wpSaveState                                    ( ) PRIVATE
 *                                                         (X) PUBLIC
 *  DESCRIPTION:
 *
 *    Save our state variables (last worker).
 *
 */
SOM_Scope BOOL SOMLINK myf_wpSaveState(MYFILE *somSelf)
{
    MYFILEData *somThis = MYFILEGetData(somSelf);
    MYFILEMethodDebug("MYFILE","myf_wpSaveState");

    _wpSaveString( somSelf, szMYFILEClassTitle,
                   IDKEY_LASTWORKER, _pszLastWorker);

    return (parent_wpSaveState(somSelf));

}   /* end myf_wpSaveState() */

/*
 *
 *  METHOD: wpRestoreState                                 ( ) PRIVATE
 *                                                         (X) PUBLIC
 *  DESCRIPTION:
 *
 *    Retrieve our saved state variables (last worker).
 *
 */
SOM_Scope BOOL SOMLINK myf_wpRestoreState(MYFILE *somSelf, ULONG ulReserved)
{
    ULONG cbString;
    MYFILEData *somThis = MYFILEGetData(somSelf);
    MYFILEMethodDebug("MYFILE","myf_wpRestoreState");

    _wpRestoreString( somSelf, szMYFILEClassTitle,
                      IDKEY_LASTWORKER, _pszLastWorker, &cbString );

    return (parent_wpRestoreState(somSelf,ulReserved));

}   /* myf_wpRestoreState() */

/*
 *
 *  METHOD: wpAddSettingsPages                             ( ) PRIVATE
 *                                                         (X) PUBLIC
 *  DESCRIPTION:
 *
 *    Add our own settings page to let the user modify the
 *    last worker's name.
 *
 */
SOM_Scope BOOL SOMLINK myf_wpAddSettingsPages(MYFILE *somSelf, HWND hwndNotebook)
{
    MYFILEData *somThis = MYFILEGetData(somSelf);
    MYFILEMethodDebug("MYFILE","myf_wpAddSettingsPages");

    if (parent_wpAddSettingsPages(somSelf, hwndNotebook)
             && _AddLastWorkerPage(somSelf, hwndNotebook))
    {
        return(TRUE);
    }
    else
    {
        DebugBox("myf_wpAddSettingsPages", " Failed to add a settings page.");
        return( FALSE );
    }

}   /* myf_wpAddSettingsPages() */

/*
 *
 *  METHOD: wpFilterPopupMenu                              ( ) PRIVATE
 *                                                         (X) PUBLIC
 *  DESCRIPTION:
 *
 *    Filter out any options from the context that don't apply,
 *    (e.g. we take out "Create Shadow")
 *
 *  HOW TO OVERRIDE:
 *
 *    No restrictions.
 *
 */
SOM_Scope ULONG SOMLINK myf_wpFilterPopupMenu(MYFILE *somSelf,
                ULONG ulFlags,
                HWND hwndCnr,
                BOOL fMultiSelect)
{
    MYFILEData *somThis = MYFILEGetData(somSelf);
    MYFILEMethodDebug("MYFILE","myf_wpFilterPopupMenu");

    /*
     *   This method allows you to filter which menus to include in the
     *   popup menu.  Note: wpclsQueryStyle is overridden to disallow
     *   linking (creating shadow) as well.
     */
    return( parent_wpFilterPopupMenu(somSelf,ulFlags,hwndCnr,
                    fMultiSelect) & ~CTXT_LINK );

}   /* end myf_wpFilterPopupMenu() */

/*
 *
 *  METHOD: wpModifyPopupMenu                              ( ) PRIVATE
 *                                                         (X) PUBLIC
 *  DESCRIPTION:
 *
 *    Add our extra option to the context menu
 *
 */
SOM_Scope BOOL SOMLINK myf_wpModifyPopupMenu(MYFILE *somSelf,
                HWND hwndMenu,
                HWND hwndCnr,
                ULONG iPosition)
{
    MYFILEData *somThis = MYFILEGetData(somSelf);
    MYFILEMethodDebug("MYFILE","myf_wpModifyPopupMenu");

    /*
     *   Put in our special "open myfile" submenu item under the "open" menu
     */
    _wpInsertPopupMenuItems( somSelf, hwndMenu, 0,
                               hmod, ID_OPENMENU, WPMENUID_OPEN);
    /*
     *   insert a "beep horn" menu item at the end of the list.
     */
    _wpInsertPopupMenuItems( somSelf, hwndMenu, iPosition,
                               hmod, ID_ALARMMENU, 0 );

    return (parent_wpModifyPopupMenu(somSelf,hwndMenu,hwndCnr,iPosition));

}   /* end myf_wpModifyPopupMenu() */

/*
 *
 *  METHOD: wpMenuItemSelected                             ( ) PRIVATE
 *                                                         (X) PUBLIC
 *  DESCRIPTION:
 *
 *    Process the extra menu options that we added.
 *
 */
SOM_Scope BOOL SOMLINK myf_wpMenuItemSelected(MYFILE *somSelf,
                HWND hwndFrame,
                ULONG MenuId)
{
    MYFILEData *somThis = MYFILEGetData(somSelf);
    MYFILEMethodDebug("MYFILE","myf_wpMenuItemSelected");

    /* Which of our menu items was selected ?
     */
    switch( MenuId )
    {
       case IDM_OPENMYFILE:
          /*
           *   We could call wpOpen here, but, if the object is already opened,
           *   the following API determines whether the object should be
           *   resurfaced, or if multiple views are desired.
           */
          _wpViewObject(somSelf, NULLHANDLE, OPEN_MYFILE, 0);
          break;

       case IDM_SOUNDALARM:
          _soundAlarm(somSelf);
          break;

       default:
          return parent_wpMenuItemSelected(somSelf, hwndFrame, MenuId);
          break;
    }
    return TRUE;                                          /* we processed it */

}   /* end myf_wpMenuItemSelected() */

/*
 *
 *  METHOD: wpMenuItemHelpSelected                         ( ) PRIVATE
 *                                                         (X) PUBLIC
 *  DESCRIPTION:
 *
 *    Process help from the extra menu options that we added.
 *
 */
SOM_Scope BOOL SOMLINK myf_wpMenuItemHelpSelected(MYFILE *somSelf,
                ULONG MenuId)
{
    MYFILEData *somThis = MYFILEGetData(somSelf);
    MYFILEMethodDebug("MYFILE","myf_wpMenuItemHelpSelected");

    /* Which of our menu items was selected ?
     */
   switch( MenuId )
   {
      case IDM_SOUNDALARM:

         return(_wpDisplayHelp(somSelf,ID_HELP_SOUNDALARM,szHelpLibrary));
         break;

      case IDM_OPENMYFILE:

         return(_wpDisplayHelp(somSelf,ID_HELP_OPENMYFILE,szHelpLibrary));
         break;

      default:
         break;
   }

   return (parent_wpMenuItemHelpSelected(somSelf,MenuId));

}   /* end myf_wpMenuItemHelpSelected() */

/*
 *
 *  METHOD: wpQueryDetailsData                             ( ) PRIVATE
 *                                                         (X) PUBLIC
 *  DESCRIPTION:
 *
 *    Returns the myfile specific data for the details view of this object.
 *    Sets the pointer (*ppDetailsData) to the beginning of the buffer
 *    into which the data is written.
 *
 */
SOM_Scope ULONG SOMLINK myf_wpQueryDetailsData(MYFILE *somSelf,
                PVOID *ppDetailsData,
                PULONG pcp)
{
    PMYFILEDETAILS pMYFILEDetails;
    PBYTE       pSize;
    MYFILEData *somThis = MYFILEGetData(somSelf);
    MYFILEMethodDebug("MYFILE","myf_wpQueryDetailsData");

   parent_wpQueryDetailsData(somSelf,ppDetailsData, pcp);

   if (ppDetailsData)                                          /* query data */
   {
      pMYFILEDetails                  = (PMYFILEDETAILS) *ppDetailsData;
      pMYFILEDetails->pszLastWorker   = _queryLastWorker(somSelf);

      /* point to buffer location after our details data */
      *ppDetailsData = ((PBYTE) (*ppDetailsData)) + sizeof(*pMYFILEDetails);

   }   /* end if (ppDetailsData) */
   else                                                /* query size of data */
   {
      *pcp += sizeof(*pMYFILEDetails);     /* caller is querying size of buffer */
   }

   return(TRUE);

}   /* end myf_wpQueryDetailsData() */

/*
 *
 *   METHOD: wpOpen                                         ( ) PRIVATE
 *                                                          (X) PUBLIC
 *   DESCRIPTION:
 *
 *     Opens the myfile window.
 *
 */
SOM_Scope HWND SOMLINK myf_wpOpen(MYFILE *somSelf,
                HWND hwndCnr,
                ULONG ulView,
                ULONG param)
{
 MYFILEData *somThis = MYFILEGetData(somSelf);
 MYFILEMethodDebug("MYFILE","myf_wpOpen");

   switch (ulView)
   {
      case OPEN_MYFILE:

          /*
           *   Create a basic Frame and Client window for this instance.
           */
         return MYFILEInit(somSelf);

      default:
         return parent_wpOpen(somSelf,hwndCnr,ulView,param);

   }   /* end switch (ulView) */

}   /* end myf_wpOpen() */



/*
 *
 *  METHOD: wpSetupOnce                                    ( ) PRIVATE
 *                                                         (X) PUBLIC
 *  DESCRIPTION:
 *
 *    Specify ONE TIME initialization.  This method is
 *    invoked once on an object when it is initially created.
 *
 *    The one time initialization we're doing is to write
 *    some default data to the file
 */
SOM_Scope BOOL   SOMLINK myf_wpSetupOnce(MYFILE *somSelf,
                PSZ pszSetupString)
{
    MYFILEData *somThis = MYFILEGetData(somSelf);
    ULONG  cbBytesWritten;         /* pointer to variable receiving byte count */
    APIRET rc;
    BOOL   fSuccess;
    HFILE  hf;                          /* pointer to variable for file handle */
    ULONG  ulAction;                   /* pointer to variable for action taken */
    CHAR   szObjectFilename[CCHMAXPATH];       /* buffer for wpQueryRealName() */
    ULONG  cb  = sizeof(szObjectFilename);
    PSZ    pszDefaultText;

    MYFILEMethodDebug("MYFILE","myf_wpSetupOnce");

   /*
    *   When the object is created from scratch, put some default
    *   text into the file on the hard disk
    */

   fSuccess =
   _wpQueryRealName(                 /* query full-pathname of object's file */
      somSelf,                                     /* pointer to this object */
      szObjectFilename,                                     /* return buffer */
      &cb,                                                  /* sizeof buffer */
      TRUE);                            /* request fully qualified pathname? */

   if (fSuccess)
   {
      rc =
      DosOpen(szObjectFilename, &hf, &ulAction,
         0,                             /* file size if created or truncated */
         FILE_NORMAL,                                      /* file attribute */
         FILE_OPEN             /* action taken if file exists/does not exist */
            | FILE_CREATE,
         OPEN_ACCESS_READWRITE                          /* open mode of file */
            | OPEN_SHARE_DENYNONE,
         NULL);              /* pointer to structure for extended attributes */

      if (rc)
      {
       CHAR ach[10];

         _ltoa(rc, ach, 10);
         DebugBox("myf_wpSetup:DosOpen failed rc =", ach);
      }
      else
      {
         pszDefaultText = _clsQueryDefaultFileText(_MYFILE);
         DosWrite(hf, pszDefaultText, strlen(pszDefaultText), &cbBytesWritten);
         DosClose(hf);
      }
   }   /* end if (fSuccess) */

   return parent_wpSetupOnce(somSelf,pszSetupString);

}   /* end myf_wpSetupOnce() */


/*
 *
 *  METHOD: wpSetup                                        ( ) PRIVATE
 *                                                         (X) PUBLIC
 *  DESCRIPTION:
 *
 *    Specify Setup strings to do special one time processing
 *
 *  New key\value to be parsed and processed by this override:
 *
 *             SOUND=(YES/NO)   YES will invoke _soundAlarm method
 *                              NO  will do nothing
 *
 */
SOM_Scope BOOL   SOMLINK myf_wpSetup(MYFILE *somSelf,
                PSZ pszSetupString)
{
    MYFILEData *somThis = MYFILEGetData(somSelf);
    BOOL   rcParentCall;
    CHAR   szValue[CCHMAXPATH+1];
    ULONG  cbBuffer;

    MYFILEMethodDebug("MYFILE","myf_wpSetup");

   rcParentCall = parent_wpSetup(somSelf,pszSetupString);

   cbBuffer = CCHMAXPATH;
   if ( _wpScanSetupString(somSelf,pszSetupString,"SOUND",
                           szValue,&cbBuffer) )
   {
      if ((szValue[0] == 'Y') && (szValue[1] == 'E') && (szValue[2] == 'S'))
      {
         _soundAlarm(somSelf);
      }
   }

  return rcParentCall;

}   /* end myf_wpSetup() */


/*
 * METHOD: wpFormatDragItem                              ( ) PRIVATE
 *                                                       (X) PUBLIC
 * DESCRIPTION:
 *
 *   Specify a unique RMF that will only be understood by instances
 *   of class MYFOLDER.  (see _wpDragOver and _wpDrop overrides in
 *   myfolder.c).
 */
SOM_Scope BOOL   SOMLINK myf_wpFormatDragItem(MYFILE *somSelf,
                PDRAGITEM pdrgItem)
{
/*  MYFILEData *somThis = MYFILEGetData(somSelf); */
    MYFILEMethodDebug("MYFILE","myf_wpFormatDragItem");

    parent_wpFormatDragItem(somSelf,pdrgItem);

    /* We do NOT want to really let the workplace shell render
     * our object, so change the rendering mechanism and format
     * to be uniquely ours.
     */
    DrgDeleteStrHandle(pdrgItem->hstrRMF);

    pdrgItem->hstrRMF = DrgAddStrHandle("<DRM_OUROWNSPECIAL,DRF_OBJECT>");

    return TRUE;
}


/**************************  CLASS METHODS SECTION  ***************************
*****                                                                     *****
*****              Do not put any code in this section unless             *****
*****                     it is an object CLASS method                    *****
*****                                                                     *****
******************************************************************************/
#undef SOM_CurrentClass
#define SOM_CurrentClass SOMMeta


/*
 *
 *  METHOD: clsQueryModuleHandle                           ( ) PRIVATE
 *                                                         (X) PUBLIC
 *  DESCRIPTION:
 *
 *    This method returns the module handle of this class.  If this is the
 *    first invocation, DosQueryModuleHandle is called to save the handle
 *    for future invocations.
 *
 *  RETURN:
 *
 *    0              Unsuccessful
 *    non-zero       module handle
 *
 */
SOM_Scope HMODULE   SOMLINK myfM_clsQueryModuleHandle(M_MYFILE *somSelf)
{
 APIRET rc;

    /* M_MYFILEData *somThis = M_MYFILEGetData(somSelf); */
    M_MYFILEMethodDebug("M_MYFILE","myfM_clsQueryModuleHandle");

   /*
    *   Make sure we already have module handle
    */

    if (hmod == NULLHANDLE)
    {
     zString zsPathName;
       /*
        *   Retrieve registered pathname of our module (DLL) and query the
        *   module handle.
        */
       zsPathName =
       _somLocateClassFile( SOMClassMgrObject, SOM_IdFromString("MYFILE"),
                                              MYFILE_MajorVersion, MYFILE_MinorVersion);
       rc =
       DosQueryModuleHandle( zsPathName, &hmod);
       if (rc)
       {
          DebugBox("myfM_wpclsInitData", "Failed to load module");
          return;
       }

    }   /* end if (hmod == NULLHANDLE) */

    return (hmod);

}   /* end myfM_clsQueryModuleHandle() */



/*
 *
 *  METHOD: clsQueryDefaultFileText                        ( ) PRIVATE
 *                                                         (X) PUBLIC
 *  DESCRIPTION:
 *
 *    This method returns some default text to stuff in an empty MYFILE.
 *
 *  RETURN:
 *
 *    PSZ
 *
 */
SOM_Scope PSZ   SOMLINK myfM_clsQueryDefaultFileText(M_MYFILE *somSelf)
{
    /* M_MYFILEData *somThis = M_MYFILEGetData(somSelf); */
    M_MYFILEMethodDebug("M_MYFILE","myfM_clsQueryDefaultFileText");

    return (PSZ) "This is an empty file of class MYFILE";
} /* end myfM_clsQueryDefaultFileText */

/*
 *
 *  METHOD: wpclsQueryStyle                                ( ) PRIVATE
 *                                                         (X) PUBLIC
 *  DESCRIPTION:
 *
 *     The wpclsQueryStyle method is called to allow the class object
 *     to specify the default object class style for its instances.
 *
 *  REMARKS:
 *
 *     This method can be called at any time in order to determine the
 *     default style for instances of this class.
 *
 *     This method should be overridden in order to modify the default
 *     object style for instances of this class.
 *
 */
SOM_Scope ULONG   SOMLINK myfM_wpclsQueryStyle(M_MYFILE *somSelf)
{
    /* M_MYFILEData *somThis = M_MYFILEGetData(somSelf); */
    M_MYFILEMethodDebug("M_MYFILE","myfM_wpclsQueryStyle");

    /*
     *   Modify style bits as described in programming reference.  This
     *   particular style (link) is also disabled in wpFilterPopupMenu()
     */
    return (parent_wpclsQueryStyle(somSelf) | CLSSTYLE_NEVERLINK );
}

/*
 *
 *  METHOD: wpclsInitData                                  ( ) PRIVATE
 *                                                         (X) PUBLIC
 *  DESCRIPTION:
 *
 *    Initalize the class data
 *
 */
SOM_Scope void SOMLINK myfM_wpclsInitData(M_MYFILE *somSelf)
{
 ULONG rc, i;
 PCLASSFIELDINFO pCFI;

    /* M_MYFILEData *somThis  = M_MYFILEGetData(somSelf); */
    M_MYFILEMethodDebug("M_MYFILE","myfM_wpclsInitData");

    /*
     *   Call the parent class method first
     */
    parent_wpclsInitData(somSelf);

    /*
     *   Get class title
     */
    if (!WinLoadString(WinQueryAnchorBlock(HWND_DESKTOP), _clsQueryModuleHandle(somSelf), ID_TITLE,
                         sizeof(szMYFILEClassTitle), szMYFILEClassTitle))
                              /* Load string failed: use the parent's string */
       strcpy(szMYFILEClassTitle, parent_wpclsQueryTitle(somSelf));

   /*
    *   Initialize everything needed for the CLASSFIELDINFO structures
    *   for the MYFILE object class
    */

   for (i=0, pCFI=fieldinfo; i < NUM_MYFILE_FIELDS; i++, pCFI++)
   {
      memset((PCH) pCFI, 0, sizeof(CLASSFIELDINFO));               /* zero's */

      pCFI->cb        = sizeof(CLASSFIELDINFO);
      pCFI->flData    = CFA_RIGHT | CFA_SEPARATOR | CFA_FIREADONLY;
      pCFI->flTitle   = CFA_CENTER | CFA_SEPARATOR | CFA_HORZSEPARATOR |
                        CFA_STRING | CFA_FITITLEREADONLY;
      pCFI->pNextFieldInfo = pCFI + 1;       /* point to next CLASSFIELDINFO */
      pCFI->pTitleData = (PVOID) apszMYFILEColTitles[i];
      pCFI->flCompare  = COMPARE_SUPPORTED | SORTBY_SUPPORTED;

      switch (i)
      {
         case INDEX_LASTWORKER:

            pCFI->flData           |= CFA_STRING;
            pCFI->offFieldData      = (ULONG)(FIELDOFFSET(MYFILEDETAILS,pszLastWorker));
            pCFI->ulLenFieldData    = sizeof(PSZ);
            pCFI->DefaultComparison = CMP_EQUAL;

            break;

      }   /* end switch(i) */

   }   /* end for (i=0, pCFI=fieldinfo; i < NUM_MYFILE_FIELDS; i++, pCFI++)  */

   fieldinfo[NUM_MYFILE_FIELDS-1].pNextFieldInfo = NULL;/* terminate linked list */

}   /* end myfM_ wpclsInitData() */

/*
 *
 *  METHOD: wpclsUnInitData                                ( ) PRIVATE
 *                                                         (X) PUBLIC
 *  DESCRIPTION:
 *
 *    Free any class data
 *
 */
SOM_Scope void SOMLINK myfM_wpclsUnInitData(M_MYFILE *somSelf)
{
    M_MYFILEMethodDebug("M_MYFILE","myfM_wpclsUnInitData");

    parent_wpclsUnInitData(somSelf);

}   /* end myfM_wpclsUnInitData() */

/*
 *
 *  METHOD: wpclsQueryTitle                                ( ) PRIVATE
 *                                                         (X) PUBLIC
 *  DESCRIPTION:
 *
 *    Return the string "Myfile".
 *
 */
SOM_Scope PSZ SOMLINK myfM_wpclsQueryTitle(M_MYFILE *somSelf)
{
 /* M_MYFILEData *somThis = M_MYFILEGetData(somSelf); */
    M_MYFILEMethodDebug("M_MYFILE","myfM_wpclsQueryTitle");

    /*
     *   Return the class title for a myfile
     */

    if (*szMYFILEClassTitle )
       return( szMYFILEClassTitle );
    else
       return( parent_wpclsQueryTitle(somSelf));

}   /* end myfM_wpclsQueryTitle() */

/*
 *
 *  METHOD: wpclsQueryIconDdata                            ( ) PRIVATE
 *                                                         (X) PUBLIC
 *  DESCRIPTION:
 *
 *    Return the class icon
 *
 */
SOM_Scope ULONG SOMLINK myfM_wpclsQueryIconData(M_MYFILE *somSelf,
                  PICONINFO pIconInfo)
{
   APIRET rc;

   M_MYFILEMethodDebug("M_MYFILE","myfM_wpclsQueryIconData");

   if (pIconInfo)
   {
      /*
       *   fill in icon information
       */
      pIconInfo->fFormat = ICON_RESOURCE;
      pIconInfo->hmod= _clsQueryModuleHandle(somSelf);
      pIconInfo->resid= ID_ICON;
   }

   return (sizeof(ICONINFO));

}   /* end myfM_wpclsQueryIconData() */

/*
 *
 *  METHOD: wpclsQueryDefaultHelp                          ( ) PRIVATE
 *                                                         (X) PUBLIC
 *  DESCRIPTION:
 *
 *    Process input from the extra menu option that we added.
 *
 */
SOM_Scope BOOL SOMLINK myfM_wpclsQueryDefaultHelp(M_MYFILE *somSelf,
                PULONG pHelpPanelId,
                PSZ pszHelpLibrary)
{
 /* M_MYFILEData *somThis = M_MYFILEGetData(somSelf); */
    M_MYFILEMethodDebug("M_MYFILE","myfM_wpclsQueryDefaultHelp");

    if (pHelpPanelId)                           /* set default help panel id */
       *pHelpPanelId   = ID_HELP_DEFAULT;

    if (pszHelpLibrary)                                /* copy help filename */
       strcpy(pszHelpLibrary, szHelpLibrary);

    return (TRUE);

}   /* end myfM_wpclsQueryDefaultHelp() */

/*
 *
 *  METHOD: wpclsQueryDefaultView                          ( ) PRIVATE
 *                                                         (X) PUBLIC
 *  DESCRIPTION:
 *
 *    Returns the default view for a new instance of this object.
 *
 *  REMARKS:
 *
 *    Tell the system what our default open view is...
 *
 */
SOM_Scope ULONG SOMLINK myfM_wpclsQueryDefaultView(M_MYFILE *somSelf)
{
 /* M_MYFILEData *somThis = M_MYFILEGetData(somSelf); */
    M_MYFILEMethodDebug("M_MYFILE","myfM_wpclsQueryDefaultView");

    return OPEN_MYFILE;

}   /* end myfM_wpclsQueryDefaultView() */

/*
 *
 *  METHOD: wpclsQueryDetailsInfo                          ( ) PRIVATE
 *                                                         (X) PUBLIC
 *  DESCRIPTION:
 *
 *    Appends the myfile specific chain of FIELDINFO structures describing the
 *    details data of this object to *ppClassFieldInfo (if ppClassFieldInfo
 *    is NON-NULL).  In this case it also sets *ppClassFieldInfo to the
 *    head of the linked list.
 *
 *    Adds the number of bytes required by the details data for myfile to *pSize
 *    (if pSize is NON-NULL).
 *
 *  REMARKS:
 *
 *    Add details data for this object.
 *
 */
SOM_Scope ULONG SOMLINK myfM_wpclsQueryDetailsInfo(M_MYFILE *somSelf,
                PCLASSFIELDINFO *ppClassFieldInfo,
                PULONG pSize)
{
 ULONG           cParentColumns;
 PCLASSFIELDINFO pCFI;
 ULONG           i;

    /* M_MYFILEData *somThis = M_MYFILEGetData(somSelf); */
    M_MYFILEMethodDebug("M_MYFILE","myfM_wpclsQueryDetailsInfo");

   /*
    *   Always call the parent method first to retrieve number of details
    *   columns and parent's data already defined in details buffer.
    */

   cParentColumns =
   parent_wpclsQueryDetailsInfo(somSelf, ppClassFieldInfo, pSize);

   /*
    *   If pSize is non-NULL, we must add the size of our deatils column
    *   data structure.
    */

   if (pSize)
      *pSize += sizeof(MYFILEDETAILS);                           /* adjust size */

   /*
    *   If the request was for the chained fieldinfo structures
    *   (ppClassFieldInfo is non-NULL), link them in
    *
    *   eventually the chain will look like
    *
    *   Grandad - Dad - Me - Kid - Grandkid
    *
    *   I will be getting the pointer to the beginning of the chain
    *
    *   If the beginning of the chain is 0, I will assign the address
    *   of my first CLASSFIELDINFO structure to *ppClassFieldInfo.
    *   Otherwise *pp points to the first column description in the
    *   chain.  We need to walk the chain and link our CLASSFIELDINFO
    *   structures at the end.
    */

   if (ppClassFieldInfo)
   {
      /*
       *   Find the last link in the chain;  Then link our CLASSFIELDINFO
       *   structures to the chain.
       */

      if (*ppClassFieldInfo)
      {
         pCFI = *ppClassFieldInfo;
         for (i=0;i<cParentColumns;i++)
            pCFI = (pCFI->pNextFieldInfo) ? pCFI->pNextFieldInfo : pCFI;

         pCFI->pNextFieldInfo = fieldinfo;
      }
      else
         *ppClassFieldInfo = fieldinfo;
   }
   return ((ULONG) (cParentColumns + NUM_MYFILE_FIELDS));

}   /* end myfM_wpclsQueryDetailsInfo() */

/*
 *
 *  METHOD: wpclsQueryInstanceFilter                       ( ) PRIVATE
 *                                                         (X) PUBLIC
 *  DESCRIPTION:
 *
 *     The wpclsQueryInstanceFilter method is called to allow the class
 *     object to specify the file title filters for instances of its
 *     class.
 *
 *  REMARKS:
 *
 *     A pointer to a string containing file title filter(s).  This
 *     string can contain several file title filters separated by a
 *     comma.  Example: "*.TXT, *.DOC"
 *
 *  Note:  Overriding this method will cause any data file with the extension
 *         ".txt" to become a data object of the class "MYFILE."
 *
 */
SOM_Scope PSZ   SOMLINK myfM_wpclsQueryInstanceFilter(M_MYFILE *somSelf)
{
    /* M_MYFILEData *somThis = M_MYFILEGetData(somSelf); */
    M_MYFILEMethodDebug("M_MYFILE","myfM_wpclsQueryInstanceFilter");

    return (szMYFILEInstanceFilter);
}


/**************************  ORDINARY CODE SECTION  ***************************
*****                                                                     *****
*****                  Any non-method code should go here.                *****
*****                                                                     *****
******************************************************************************/
#undef SOM_CurrentClass


/***************************************************************************
*                                                                          *
*       ROUTINE:    MYFILEInit ( )                                            *
*                                                                          *
*       DESCRIPTION:    MYFILE Initialization                                 *
*                                                                          *
*       RETURNS:    Handle of myfile frame window, NULL if error              *
*                                                                          *
***************************************************************************/
HWND MYFILEInit (MYFILE* somSelf)
{
   HAB  hab;                                       /* PM anchor block handle */
   HWND hwndFrame = NULLHANDLE;                       /* Frame window handle */
   HWND hwndClient = NULLHANDLE;
   PWINDOWDATA pWindowData;
   BOOL fSuccess;
   SWCNTRL    swcEntry;                                      /* Switch Entry */
   FRAMECDATA flFrameCtlData;                              /* Frame Ctl Data */

   hab = WinQueryAnchorBlock(HWND_DESKTOP);
   if (!WinRegisterClass( hab , szMYFILEWindowClass, (PFNWP)MYFILEWndProc ,
                            CS_SIZEREDRAW | CS_SYNCPAINT, sizeof(pWindowData)))
   {
      DebugBox("MYFILEInit", "Failure in WinRegisterClass");
      return NULLHANDLE ;
   }

   /*
    *   Allocate some instance specific data in Window words of Frame window.
    *   This will ensure our window procedure can use this object's methods
    *   (our window proc isn't passed a * somSelf pointer).
    */
   pWindowData = (PWINDOWDATA) _wpAllocMem(somSelf, sizeof(*pWindowData), NULL);

   if (!pWindowData)
   {
      DebugBox("MYFILEInit", "wpAllocMem failed to allocate pWindowData");
      return NULLHANDLE;
   }

   memset((PVOID) pWindowData, 0, sizeof(*pWindowData));
   pWindowData->cb = sizeof(*pWindowData);             /* first field = size */
   pWindowData->somSelf = somSelf;

   /* Create a frame window
    */
   flFrameCtlData.cb            = sizeof( flFrameCtlData );
   flFrameCtlData.flCreateFlags = FCF_SIZEBORDER | FCF_TITLEBAR | FCF_SYSMENU |
                                  FCF_MINMAX ;
   flFrameCtlData.hmodResources = hmod;
   flFrameCtlData.idResources   = ID_ICON;

   hwndFrame =                                        /* create frame window */
   WinCreateWindow(
      HWND_DESKTOP,               /* parent-window handle                    */
      WC_FRAME,                   /* pointer to registered class name        */
      _wpQueryTitle(somSelf),     /* pointer to window text                  */
      0,                          /* window style                            */
      0, 0, 0, 0,                 /* position of window                      */
      NULLHANDLE,                 /* owner-window handle                     */
      HWND_TOP,                   /* handle to sibling window                */
      (USHORT) ID_FRAME,          /* window identifier                       */
      (PVOID) &flFrameCtlData,    /* pointer to buffer                       */
      NULL);      ;               /* pointer to structure with pres. params. */

   if (!hwndFrame)
   {
      DebugBox("MYFILEInit", "Failure in WinCreateWindow");
      return NULLHANDLE;
   }
   hwndClient =         /* use WinCreateWindow so we can pass pres params */
   WinCreateWindow(
      hwndFrame,               /* parent-window handle                    */
      szMYFILEWindowClass,     /* pointer to registered class name        */
      NULL,                    /* pointer to window text                  */
      0,                       /* window style                            */
      0, 0, 0, 0,              /* position of window                      */
      hwndFrame,               /* owner-window handle                     */
      HWND_TOP,                /* handle to sibling window                */
      (USHORT)FID_CLIENT,      /* window identifier                       */
      pWindowData,             /* pointer to buffer                       */
      NULL);                   /* pointer to structure with pres. params. */

   if (!hwndClient)
   {
      WinDestroyWindow(hwndFrame);
      return NULLHANDLE;
   }

   WinSendMsg(hwndFrame,WM_SETICON,MPFROMP(_wpQueryIcon(somSelf)),NULL);
   WinSetWindowText(WinWindowFromID(hwndFrame,
                                    (USHORT)FID_TITLEBAR),
                                    _wpQueryTitle(somSelf));

   /*
    * Restore the Window Position
    */
   fSuccess = WinRestoreWindowPos( szMYFILEClassTitle,      /* class title */
                                   _wpQueryTitle(somSelf),  /* object title */
                                   hwndFrame);

   if (!fSuccess)
   {
    SWP        swp;

      /* Get the dimensions and the shell's suggested
       * location for the window
       */
      WinQueryTaskSizePos(hab,0,&swp);

      /* Set the frame window position
       */
      swp.fl = SWP_SIZE|SWP_MOVE|SWP_RESTORE|SWP_ZORDER;
      WinSetWindowPos(hwndFrame, HWND_TOP, swp.x, swp.y,
                                           swp.cx, swp.cy, swp.fl);
   }

   WinShowWindow(hwndFrame,TRUE);
   return hwndFrame;                                              /* success */

}   /* end MYFILEInit() */


/******************************************************************************
*
*   MYFILEWndProc()
*
*   DESCRIPTION: MYFILE Window Procedure
*
******************************************************************************/
MRESULT EXPENTRY MYFILEWndProc( HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2 )
{
  PWINDOWDATA pWindowData;
  HWND     hwndFrame;
  BOOL     fSuccess;

   hwndFrame = WinQueryWindow(hwnd, QW_PARENT);

   switch( msg )
   {
      case WM_CREATE:

        pWindowData = (PWINDOWDATA) mp1;

        if (pWindowData == NULL)
        {
           DebugBox("MYFILEWndProc:WM_CREATE", "couldn't get window words");
           return FALSE;
        }
        /*
         *   Fill in the class view/usage details and window specific data
         *   for this instance.
         */
        pWindowData->UseItem.type    = USAGE_OPENVIEW;
        pWindowData->ViewItem.view   = OPEN_MYFILE;
        pWindowData->ViewItem.handle = hwndFrame;

        /*
         *   Set window pointer with object pointer and instance view info.
         *   Then add view to the in-use list so wpSwitchTo works.
         */
        WinSetWindowPtr(hwnd, QWL_USER, pWindowData);
        _wpAddToObjUseList(pWindowData->somSelf,&pWindowData->UseItem);
        _wpRegisterView(pWindowData->somSelf, hwndFrame,
                        _wpQueryTitle(pWindowData->somSelf));
        WinSetFocus( HWND_DESKTOP, hwndFrame);
        break;

      case WM_COMMAND:

        break;

      case WM_PAINT:
         pWindowData = (PWINDOWDATA) WinQueryWindowPtr(hwnd, QWL_USER);

         if (pWindowData == NULL)
         {
            DebugBox("MYFILEWndProc:WM_PAINT", "couldn't get window words");
            return FALSE;
         }
         else
         {
          HPS    hps;
          RECTL  rectl;

           hps = WinBeginPaint( hwnd, (HPS)NULLHANDLE, &rectl);
           WinFillRect( hps, &rectl, SYSCLR_WINDOW);
           WinDrawPointer(hps, 50, 50,
                          _wpQueryIcon(pWindowData->somSelf), DP_NORMAL);
           WinEndPaint( hps );
         }
         break;

      case WM_CLOSE:
         {
          HAB hab;

            hab = WinQueryAnchorBlock(HWND_DESKTOP);

            pWindowData = (PWINDOWDATA) WinQueryWindowPtr(hwnd, QWL_USER);

            if (pWindowData == NULL)
            {
               DebugBox("MYFILEWndProc:WM_CLOSE", "couldn't get window words");
               return FALSE;
            }
            /*
             * Restore the Window Position
             */
            fSuccess = WinStoreWindowPos(szMYFILEClassTitle,
                                         _wpQueryTitle(pWindowData->somSelf),
                                         hwndFrame);
            _wpDeleteFromObjUseList(pWindowData->somSelf,&pWindowData->UseItem);
            _wpFreeMem(pWindowData->somSelf,(PBYTE)pWindowData);

            WinPostMsg( hwnd, WM_QUIT, 0, 0 );
            WinDestroyWindow ( hwndFrame ) ;
         }
         break;

      default:
         return WinDefWindowProc( hwnd, msg, mp1, mp2 );
   }
   return FALSE;

}   /* end MYFILEWndProc() */

/******************************************************************************
*
*   LastWorkerDlgProc()
*
*   DESCRIPTION: Dialog Procedure for LastWorker settings page
*
******************************************************************************/
MRESULT EXPENTRY LastWorkerDlgProc(HWND hwndDlg, ULONG msg,
                                  MPARAM mp1, MPARAM mp2)
{
 LASTWORKERDLGDATA * pLastWorkerDlgData;

   switch (msg)
   {
      case WM_INITDLG:          /* 0x003b */
      {
         PSZ       pszTemp;

         /*
          *   Store some instance specific data in Window words of this dialog.
          *   This will ensure our dialog procedure can access this objects
          *   data (our dialog proc isn't always passed a *somSelf pointer).
          */
         pLastWorkerDlgData =
            (PLASTWORKERDLGDATA) _wpAllocMem((MYFILE *)mp2, sizeof(*pLastWorkerDlgData), NULL);
         if (pLastWorkerDlgData)
         {
            memset((PVOID) pLastWorkerDlgData, 0, sizeof(*pLastWorkerDlgData));
            pLastWorkerDlgData->cb = sizeof(*pLastWorkerDlgData);
            pLastWorkerDlgData->somSelf = (MYFILE *) mp2;   /* pointer to this object */
            pszTemp = _queryLastWorker(pLastWorkerDlgData->somSelf);
            if (pszTemp)
            {
               pLastWorkerDlgData->PrevWorker =
                     (PSZ) _wpAllocMem(pLastWorkerDlgData->somSelf,
                                        CCHMAXPATH+1, NULL);
               if (pLastWorkerDlgData->PrevWorker)
               {
                  strcpy(pLastWorkerDlgData->PrevWorker, pszTemp);
               }
            }

            pLastWorkerDlgData->restorePrevWorker =
                        (PSZ) _wpAllocMem(pLastWorkerDlgData->somSelf,
                                           CCHMAXPATH+1, NULL);
            if (pLastWorkerDlgData->restorePrevWorker)
            {
               strcpy(pLastWorkerDlgData->restorePrevWorker,
                      pLastWorkerDlgData->PrevWorker);
            }
         }
         else
         {
            DebugBox("LastWorkerDlgProc:WM_INITDLG", "Couldn't allocate window words");
            break;
         }

         WinSetWindowPtr(hwndDlg, QWL_USER, pLastWorkerDlgData);

         /* set the text limit on the entry field
          */
         WinSendDlgItemMsg( hwndDlg, IDC_LASTWORKER, EM_SETTEXTLIMIT,
                            MPFROMSHORT( 0x1000-1 ), 0 );

         /* set the name into the entry field
          */
         WinSetWindowText( WinWindowFromID( hwndDlg, IDC_LASTWORKER ),
                           _queryLastWorker( (MYFILE *) mp2) );

         _wpCnrRefreshDetails( pLastWorkerDlgData->somSelf );

         return (MRESULT) FALSE;
      }   /* end case WM_INITDLG: */

      case WM_DESTROY:             /* 0x0002 */
      {
         MYFILE * pObject;

         pLastWorkerDlgData = WinQueryWindowPtr(hwndDlg, QWL_USER);
         if (pLastWorkerDlgData == NULL)
         {
            DebugBox("LastWorkerDlgProc:WM_DESTROY", "couldn't get window words");
            break;
         }

         if (pLastWorkerDlgData->PrevWorker)
         {
            _wpFreeMem(pLastWorkerDlgData->somSelf,
                       (PBYTE) pLastWorkerDlgData->PrevWorker);
         }

         if (pLastWorkerDlgData->restorePrevWorker)
         {
            _wpFreeMem(pLastWorkerDlgData->somSelf,
                       (PBYTE) pLastWorkerDlgData->restorePrevWorker);
         }

         pObject = pLastWorkerDlgData->somSelf;
         _wpFreeMem(pObject,(PBYTE)pLastWorkerDlgData);
         return (WinDefDlgProc(hwndDlg, msg, mp1, mp2) );
      }

      case WM_COMMAND:           /* 0x0020 */

         pLastWorkerDlgData = WinQueryWindowPtr(hwndDlg, QWL_USER);
         if (pLastWorkerDlgData == NULL)
         {
            DebugBox("LastWorkerDlgProc:WM_COMMAND", "couldn't get window words");
            break;
         }

         switch (SHORT1FROMMP(mp1))
         {
            case ID_UNDO:                   /* 0x0321 */
               if (pLastWorkerDlgData->restorePrevWorker)
               {
                  _setLastWorker(pLastWorkerDlgData->somSelf,
                                 pLastWorkerDlgData->restorePrevWorker);

                  if (pLastWorkerDlgData->PrevWorker)
                  {
                     strcpy(pLastWorkerDlgData->PrevWorker,
                            pLastWorkerDlgData->restorePrevWorker);
                  }
                  WinSetWindowText( WinWindowFromID( hwndDlg, IDC_LASTWORKER ),
                                    pLastWorkerDlgData->restorePrevWorker);
               }
               break;

            case ID_DEFAULT:             /* 0x0322 */
               /*
                *   preserve previous values
                */
               _setLastWorker(pLastWorkerDlgData->somSelf, DEFAULT_LASTWORKER);

               if (pLastWorkerDlgData->PrevWorker)
               {
                  strcpy(pLastWorkerDlgData->PrevWorker, DEFAULT_LASTWORKER);
               }

               WinSetWindowText( WinWindowFromID( hwndDlg, IDC_LASTWORKER ),
                                 pLastWorkerDlgData->PrevWorker);

               break;

            case ID_HELP:         /* 0x0323 */

               break;

         }   /* end switch (SHORT1FROMMP(mp1)) */

         return (MRESULT) TRUE;

      case WM_CONTROL:          /* 0x0030 */
      {
         pLastWorkerDlgData = WinQueryWindowPtr(hwndDlg, QWL_USER);
         if (pLastWorkerDlgData == NULL)
         {
            DebugBox("LastWorkerDlgProc:WM_CONTROL", "couldn't get window words");
            break;
         }

         switch (SHORT1FROMMP(mp1))
         {
         case IDC_LASTWORKER:
            if (SHORT2FROMMP(mp1) == EN_CHANGE)
            {
               CHAR newworker[CCHMAXPATH+1];

               WinQueryWindowText( WinWindowFromID( hwndDlg, IDC_LASTWORKER),
                                   CCHMAXPATH+1, newworker );
               _setLastWorker(pLastWorkerDlgData->somSelf, newworker);
               if (pLastWorkerDlgData->PrevWorker)
               {
                  strcpy(pLastWorkerDlgData->PrevWorker, newworker);
               }
            }

            return (MRESULT) TRUE;
         }
         break;

      }   /* end case WM_CONTROL: */

   }   /* end switch (msg) */

   return (WinDefDlgProc(hwndDlg, msg, mp1, mp2) );

}   /* end LastWorkerDlgProc() */


/********************************  END myfile.c  ********************************/



