/*********************************************************/
/* File: chexx.cmd					 */
/* An implementation of the game of checkers. The user	 */
/* plays against the computer. The checkerboard and	 */
/* pieces are drawn using ANSI command strings. 	 */
/*********************************************************/

CALL Initialization
DO FOREVER
  CALL DrawBoard
  IF PromptUser() THEN
    LEAVE
  you = move.1
  DO mv = 1 TO (move.0 - 1)
    mvTo = mv + 1
    CALL MovePiece move.mv, move.mvTo
    you = you 'to' move.mvTo
  END
  CALL ComputerMoves
END
SAY prompt || clrScr

EXIT

/*********************************************************/
/* Initialize variables.				 */							  */
/*********************************************************/
Initialization:
  you = ''
  computer = ''
  AnsEsc  = '1B'x || '['
  clrScr  = AnsEsc'2J'
  white   = AnsEsc'30;47m'
  black   = AnsEsc'37;40m'
  red	  = AnsEsc'30;41m'
  prompt  = AnsEsc'37;44m'
  msgClr  = AnsEsc'37;44m'
  board.  = ''
  yourMove = prompt || AnsEsc'1;1H' || 'Your move:' || AnsEsc'2;1H'
  row = 0; col = 33
  color = red
  DO ltr = C2D('A') TO C2D('H')  /* do each board row, 'A' to 'H' */
    row = row + 3
    IF col = 33 THEN /* live board columns alternate */
      DO
      col = 39
      num = 2
      END
    ELSE
      DO
      col = 33
      num = 1
      END
    letter = D2C(ltr)  /* get current board row letter */
    edge = letter || 0 /* block moving off the board */
    board.edge = '-'
    edge = letter || 9 /* block moving off the board */
    board.edge = '-'
    wrkCol = col       /* set up work column */
    IF letter = 'D' | letter = 'E' THEN
      DO
      color = white    /* reset color in preparation for 'F' to 'H' */
      DO i = num FOR 4 by 2 /* empty board rows in center */
	k = letter || i
	board.k.loc = AnsEsc || row';'wrkCol'H'
	wrkCol = wrkCol + 12
      END
      ITERATE
      END
    DO i = num FOR 4 BY 2 /* board rows with pieces */
      k = letter || i
      board.k = color || '  '
      board.k.loc = AnsEsc || row';'wrkCol'H'
      wrkCol = wrkCol + 12
    END
  END
  DO i = 0 TO 9        /* block moving off the board */
    k = 'I'i
    board.k = '-'
  END
  RETURN

/*********************************************************/
/* Draw the board and pieces in their current locations. */
/*********************************************************/
DrawBoard:
  topLine = '  '
  DO i = 1 TO 8
    topLine = topLine || Center(i, 6)
  END
  SAY prompt || clrScr || Right(topLine, 78)
  cursor = ''
  whiteSquare = white || Copies(' ', 6)
  blackSquare = black || Copies(' ', 6)
  line.0 = Copies(whiteSquare || blackSquare, 4)
  line.1 = Copies(blackSquare || whiteSquare, 4)
  lead = Copies(' ', 78 - 50)
  brd = ''
  whichLine = 0
  DO i = C2D('A') TO C2D('H') /* do each board row */
    letter = D2C(i)    /* get current board row letter */
    DO j = 1 TO 8      /* build up one row of the board */
      k = letter || j  /* board row + board column */
      brd = brd || board.k.loc || board.k
    END
    IF letter = 'H' THEN /* keep from scrolling screen */
      cursor = AnsEsc'1;1H'
    SAY prompt || lead || '  'line.whichLine
    SAY prompt || lead || letter' 'line.whichLine
    SAY prompt || lead || '  'line.whichLine || cursor
    whichLine =  whichLine
  END
  SAY brd || AnsEsc'1;1H' || prompt
  RETURN

/*********************************************************/
/* Prompt the user for their next move. 		 */
/*********************************************************/
PromptUser:
  SAY msgClr || AnsEsc'8;1H' || 'Your pieces are white.'
  SAY; SAY 'Use a letter/number'
  SAY 'combination to specify'
  SAY 'your move, like this:'
  SAY '  F3 to E4'
  IF you >< '' THEN    /* show any prior move */
    DO
    SAY; SAY 'You:'; SAY ' 'you
    SAY 'Computer'actionVerb':'; SAY ' 'computer
    END

  isOkay. = 0
  valid.1 = XRange('A', 'H')
  valid.2 = XRange('1', '8')

  DO UNTIL errorMsg = ''
    isOkay. = 0
    SAY yourMove || Copies(' ', 15) || AnsEsc'1;1H'
    PULL moves
    IF Abbrev('QUIT', moves, 1) THEN
      RETURN 1
    move. = ''; move.0 = 0
    DO i = 1	       /* loop through entered moves */
      PARSE VAR moves move.i to! moves
      IF Length(move.i) >< 2 , /* validate the move */
      | Pos(Left(move.i, 1), valid.1) = 0 ,
      | Pos(Right(move.i, 1), valid.2) = 0 THEN
	LEAVE
      move.0 = move.0 + 1
      isOkay.i = 1
    END
    errorMsg = ''
    mv = move.1
    IF  isOkay.1 | move.0 = 1 ,
    | Left(board.mv, Length(white)) >< white THEN
      errorMsg = AnsEsc'23;2H' || "Can't move from" move.1
    ELSE
      DO i = 2 TO move.0 /* check all move-to locations */
	mv = move.i
	IF  isOkay.i | board.mv >< '' ,
	| board.mv.loc = '' THEN
	  DO
	  errorMsg = errorMsg || AnsEsc'24;2H' || ,
		"Can't move to" move.i
	  LEAVE i
	  END
      END i
    IF errorMsg >< '' THEN /* complain about a bad move */
      DO
      CALL Beep 232, 125
      SAY msgClr || AnsEsc'24;2H' || errorMsg
      END
  END
  RETURN 0

/*********************************************************/
/* Make the user's requested move. Checks for a jump and */
/* removes the piece if it is a jump.			 */
/*********************************************************/
MovePiece: PROCEDURE EXPOSE board.
  fromLoc = Arg(1)
  toLoc = Arg(2)
  fromLtr = Left(fromLoc, 1)
  fromNum = Right(fromLoc, 1)
  toLtr = Left(toLoc, 1)
  toNum = Right(toLoc, 1)
  board.toLoc = board.fromLoc
  ltrDif = C2D(toLtr) - C2D(fromLtr)
  IF Abs(ltrDif) >< 1 THEN /* jumping? */
    DO
    jumpLoc = D2C(C2D(fromLtr) + ltrDif / 2)
    jumpLoc = jumpLoc || ((toNum + fromNum) / 2)
    board.jumpLoc = '' /* wipe out the piece */
    END
  board.fromLoc = ''   /* remove piece from old location */
  RETURN

/*********************************************************/
/* Determine the next move for black.			 */
/* The following algorithm implements a rather		 */
/* conservative approach to playing checkers. The	 */
/* algorithm is in 3 basic pieces:			 */
/* 1. Look for any white pieces to jump.		 */
/* 2. Try to keep any black pieces from being jumped.	 */
/* 3. Find a legal move that has a low likelihood of	 */
/*    having a black piece taken.			 */
/*********************************************************/
ComputerMoves:
  /* Look for any jump possibilities */
  blk = red || '  '
  wht = white || '  '
  jumpedOne = 0
  computer = ''
  doMove = ''
  direction = ''
  actionVerb = ''
  DO i = C2D('A') TO C2D('G') /* look through all board rows */
    DO j = 1 TO 8	      /* and all board columns */
      k = D2C(i) || j
      IF board.k >< blk THEN  /* black piece on this square? */
	ITERATE
      /* black has a piece at location k */
      DO FOREVER
	doMove = ''
	d1l1 = D2C(i + 1) || (j - 1) /* down 1, left 1 */
	d1r1 = D2C(i + 1) || (j + 1) /* down 1, right 1 */
	d2l2 = D2C(i + 2) || (j - 2) /* down 2, left 2 */
	d2r2 = D2C(i + 2) || (j + 2) /* down 2, right 2 */
	/* check for white on left diagonal */
	IF board.d1l1 = white THEN
	  DO
	  /* can we jump it? */
	  IF board.d2l2 = '' THEN /* yes! */
	    DO
	    doMove = d2l2
	    jump = d1l1
	    direction = -2
	    END
	  END
	/* check for white on right diagonal */
	IF board.d1r1 = white & doMove = '' THEN
	  DO
	  /* can we jump it? */
	  IF board.d2r2 = '' THEN /* yes! */
	    DO
	    doMove = d2r2
	    jump = d1r1
	    direction = 2
	    END
	  END
	SELECT
	  /* doing a jump */
	  WHEN doMove >< '' THEN
	    DO
	    IF computer = '' THEN
	      computer = k
	    /* move our piece */
	    board.doMove = board.k
	    computer = computer 'to' doMove
	    board.k = ''
	    /* remove the white piece */
	    board.jump = ''
	    k = doMove
	    i = C2D(Left(k, 1))
	    IF i >= C2D('G') THEN
	      RETURN
	    j = j + direction
	    jumpedOne = 1
	    END
	  /* if we jumped one, we're done */
	  WHEN jumpedOne THEN
	    DO
	    actionVerb = ' jumps'
	    RETURN
	    END
	  /* no action for this piece */
	  OTHERWISE
	    LEAVE
	END
      END
    END j
  END i

  /* Guard against being jumped */
  DO i = C2D('A') TO C2D('H') WHILE doMove = ''
    DO j = 1 TO 8
      k = D2C(i) || j
      IF board.k >< blk THEN
	ITERATE
      /* black has a piece at location k */
      d1l1 = D2C(i + 1) || (j - 1) /* down 1, left 1 */
      d1r1 = D2C(i + 1) || (j + 1) /* down 1, right 1 */
      SELECT
	WHEN board.d1l1 = wht & board.u1r1 = '' ,
	& board.d1r1 = '' THEN
	  doMove = d1r1
	WHEN board.d1r1 = wht & board.u1l1 = '' ,
	& board.d1l1 = '' THEN
	  doMove = d1l1
	OTHERWISE
	  ITERATE
      END
      actionVerb = ' moves'
      computer = k 'to' doMove
      board.doMove = board.k
      board.k = ''
    END
  END

  /* Look for a safe move */
  DO i = C2D('A') TO C2D('H') WHILE doMove = ''
    DO j = 1 TO 8
      k = D2C(i) || j
      IF board.k >< blk THEN
	ITERATE
      /* black has a piece at location k */
      d2   = D2C(i + 2) || j	   /* down 2 */
      d2l2 = D2C(i + 2) || (j - 2) /* down 2, left 2 */
      d2r2 = D2C(i + 2) || (j + 2) /* down 2, right 2 */
      d1l1 = D2C(i + 1) || (j - 1) /* down 1, left 1 */
      d1r1 = D2C(i + 1) || (j + 1) /* down 1, right 1 */
      l2   = D2C(i)	|| (j - 2) /* left 2 */
      r2   = D2C(i)	|| (j + 2) /* right 2 */
      SELECT
	WHEN board.d2 >< wht & board.d2l2 >< wht ,
	& board.d1l1 = '' THEN
	  doMove = d1l1
	WHEN board.d2 >< wht & board.d2r2 >< wht ,
	& board.d1r1 = '' THEN
	  doMove = d1r1
	WHEN board.d2 = wht & board.l2 >< '' ,
	& board.d1l1 = '' THEN
	  doMove = d1l1
	WHEN board.d2 = wht & board.r2 >< '' ,
	& board.d1r1 = '' THEN
	  doMove = d1r1
	OTHERWISE
	  ITERATE
      END
      actionVerb = ' moves'
      computer = k 'to' doMove
      board.doMove = board.k
      board.k = ''
      LEAVE i
    END j
  END i
  RETURN
