/* List0502.cmd */

SAY "Enter date as mm dd yyyy:"
PULL month day year

SAY month'-'day'-'year "is weekday number" Zeller()

EXIT

/* Zeller's Congruence
 * This function takes month, day, and year as input.
 * It returns a number that represents the day of the week
 * for the given date; 0 = Sunday ... 6 = Saturday.
 */
Zeller:
  IF month > 2 THEN
    DO
    adjMonth = month - 2
    adjYear = year
    END
  ELSE
    DO
    adjMonth = month + 10
    adjYear = year - 1
    END

  century = adjYear % 100
  yearInCentury = adjYear - 100 * century
  yrAdj = yearInCentury + (yearInCentury % 4) + (century % 4)
  yrAdj = yrAdj - century - century + 77
  dayOfWeek = ((13 * adjMonth - 1) % 5) + day + yrAdj
  dayOfWeek = dayOfWeek // 7
  RETURN dayOfWeek
