/* list1903.cmd */
IF LoadRexxUtil() THEN EXIT

CALL GetObjectIDs
desktopDir = GetDesktopDir()

ids.0 = 2
ids.1 = '<WP_OS2SYS>'  /* OS/2 System folder  */
ids.2 = '<WP_CONFIG>'  /* System Setup folder */

folderDir = ''
dirTitles. = ''
DO i = 1 TO ids.0
  id = ids.i
  handle = objects.id
  SAY Left(id, 25) GetFolderTitleFromID(id, desktopDir)
  stuff = SysIni('USER', 'PM_Abstract:FldrContent', handle)
  DO WHILE stuff >< '' /* do each handle */
    PARSE VAR stuff handle 3 5 stuff
    handle = Strip(C2X(Reverse(Left(handle, 2))), 'L', '0')
    val = SysIni('USER', 'PM_Abstract:Objects', handle)
    IF val = 'ERROR:' THEN ITERATE
    val = Translate(val, '^', '0A'x)
    val = Translate(val, Copies('00'x, 256),,
	XRange('7F'x, '1F'x))
    val = Translate(Translate(val, 'FF'x, ' '), ' ', '00'x)
    IF objects.handle >< '' THEN
      objID = Left(objects.handle, 25)
    ELSE
      objID = Left(handle, 25)
    /* pull the title out of the data */
    PARSE VAR val 'WPAbstract' objTitle 'WPObject'
    objTitle = Strip(Translate(objTitle, ' ', 'FF'x))
    objTitle = Strip(Left(objTitle, Length(objTitle) - 1))
    SAY '  'objID objTitle
  END
  CALL GetSubDirFolderTitles folderDir
  aFolder = Left('(folder)', 25)
  DO j = 1 TO dirTitles.0
    SAY '  'aFolder Translate(dirTitles.j, '^', '0A'x)
  END
END
EXIT

/* Get all known object IDs */
GetObjectIDs: PROCEDURE EXPOSE objects.
  CALL SysIni 'USER', 'PM_Workplace:Location', 'ALL:',,
      'objid.'
  objects. = ''
  DO i = 1 TO objid.0
    handle = SysIni('USER', 'PM_Workplace:Location',,
	objid.i)
    handle = Strip(C2X(Reverse(Left(handle, 2))), 'L', '0')
    id = objid.i
    objects.id = handle
    objects.handle = id
  END
  RETURN

/* Get the title of a folder from the ID */
GetFolderTitleFromID: PROCEDURE EXPOSE folderDir
  folderID = Arg(1); desktopDir = Arg(2)
  title = ''
  IF folderID = '<WP_DESKTOP>' THEN
    folderDir = desktopDir
  ELSE
    DO
    CALL SysFileTree desktopDir'\*', 'dirs.', 'DOS'
    DO i = 1 TO dirs.0
      CALL SysGetEA dirs.i, '.CLASSINFO', 'info'
      IF Pos(folderID, info) >< 0 THEN
	DO
	folderDir = dirs.i
	LEAVE
	END
    END
    END
  CALL SysGetEA folderDir, '.LONGNAME', 'title'
  PARSE VAR title 5 title
  RETURN title

/* Get the titles for immediate subdirectories */
GetSubDirFolderTitles: PROCEDURE EXPOSE dirTitles.
  parent = Arg(1)
  CALL SysFileTree parent'\*', 'dirs.', 'DO'
  dirTitles.0 = dirs.0
  DO i = 1 TO dirs.0
    CALL SysGetEA dirs.i, '.LONGNAME', 'title'
    PARSE VAR title 5 dirTitles.i
  END
  RETURN

/* Get the desktop directory */
GetDesktopDir: PROCEDURE
  CALL SysIni 'SYSTEM', 'FolderWorkareaRunningObjects',,
    'ALL:', 'desktopDir.'
  /* Create an invisible folder and then search for it */
  folderName = 'XYZ98_XY'
  rc = SysCreateObject('WPFolder', folderName,,
      '<WP_DESKTOP>',,
      'NOTVISIBLE=YES;OBJECTID=<'folderName'>;', 'R')
  theDesktop = ''
  curDir = Directory()
  DO i = 1 TO desktopDir.0
    thisOne = desktopDir.i || '\' || folderName
    IF Directory(thisOne) = thisOne THEN
      DO
      theDesktop = desktopDir.i
      CALL Directory theDesktop
      LEAVE
      END
  END
  CALL Directory curDir
  /* If not found using the quick method, use the slow one */
  IF theDesktop = '' THEN
    DO
    drives = SysDriveMap(, 'LOCAL')
    DO WHILE drives >< ''
      PARSE VAR drives thisDrive drives
      CALL SysFileTree thisDrive'\'folderName, 'dirs.', 'DOS'
      IF dirs.0 >< 0 THEN
	DO
	tail = '\' || folderName
	PARSE VAR dirs.1 theDesktop (tail) .
	LEAVE
	END
    END
    END
  CALL SysDestroyObject '<'folderName'>'
  RETURN theDesktop
