/* list1904.cmd */
IF LoadRexxUtil() THEN
  EXIT

PARSE ARG cmdLine
IF Left(cmdLine, 1) = '"' THEN
  PARSE VAR cmdLine '"' obj '"' option .
ELSE
  PARSE VAR cmdLine obj option .

IF obj = '' THEN
  SIGNAL Usage

option = Translate(option)

SELECT
  WHEN option = '' | Abbrev('DEFAULT', option, 3) THEN
    settings = 'DEFAULT'
  WHEN Abbrev('TREE', option, 1) THEN
    settings = 'TREE'
  WHEN Abbrev('ICON', option, 1) THEN
    settings = 'ICON'
  WHEN Abbrev('DETAILS', option, 3) THEN
    settings = 'DETAILS'
  WHEN Abbrev('SETTINGS', option, 1) THEN
    settings = 'SETTINGS'
  OTHERWISE
    SAY 'The option "'option'" is not recognized.'
    SAY 'Assuming DEFAULT.'
    settings = 'DEFAULT'
END

settings = 'OPEN=' || settings || ';'

rc = SysSetObjectData(obj, settings)
IF rc = 0 THEN
  SAY 'Could not open' obj

EXIT

Usage:
  SAY 'Usage:'
  SAY '  list1901 object-ID [option]'
  SAY
  SAY '  Option is one of:'
  SAY '    DEFAULT, TREE, ICON, DETAILS, or SETTINGS'
  EXIT
