/*:VRX         Main
*/
/*
    path = CfgPath( appname, exename, valname )

    appname             Name of the application (user's name)
    exename             Name of executable to look for
    valname             Name for value to store in INI file
*/
Main:
    parse arg appname, exename, valname

    cfgPath = ""

    path = IniMgr( "Get", valname )
    ok = VRFileExists( path || "\" || exename )
    if ok then do
        cfgPath = path
        signal configDone
    end

/*  Need to update the configuration
*/
    do forever
        Buttons.1 = "OK"
        Buttons.2 = "Cancel"
        Buttons.0 = 2
        id = VRPrompt( VRWindow(), appname "directory:", "path", "Configuration", "Buttons.", 1, 2 )
        if id = 2 then signal configDone
        if VRFileExists( path || "\" || exename ) = 1 then do
            call IniMgr "Set", valname, path
            cfgPath = path
            ok = 1
            signal configDone
        end
    end

configDone:
exit path

