/*:VRX         Main
*/
/*  Main
*/
Main:
/*  Process the arguments.
    Get the parent window.
*/
    parse source . calledAs .
    parent = ""
    argCount = arg()
    argOff = 0
    if( calledAs \= "COMMAND" )then do
        if argCount >= 1 then do
            parent = arg(1)
            argCount = argCount - 1
            argOff = 1
        end
    end
    InitArgs.0 = argCount
    if( argCount > 0 )then do i = 1 to argCount
        InitArgs.i = arg( i + argOff )
    end
    drop calledAs argCount argOff

/*  Load the windows
*/
    call VRInit
    parse source . . spec
    _VREPrimaryWindowPath = ,
        VRParseFileName( spec, "dpn" ) || ".VRW"
    _VREPrimaryWindow = ,
        VRLoad( parent, _VREPrimaryWindowPath )
    drop parent spec
    if( _VREPrimaryWindow == "" )then do
        call VRMessage "", "Cannot load window:" VRError(), ,
            "Error!"
        _VREReturnValue = 32000
        signal _VRELeaveMain
    end

/*  Process events
*/
    call Init
    signal on halt
    do while( \ VRGet( _VREPrimaryWindow, "Shutdown" ) )
        _VREEvent = VREvent()
        interpret _VREEvent
    end
_VREHalt:
    _VREReturnValue = Fini()
    call VRDestroy _VREPrimaryWindow
_VRELeaveMain:
    call VRFini
exit _VREReturnValue

VRLoadSecondary: procedure
    name = arg( 1 )

    window = VRLoad( VRWindow(), VRWindowPath(), name )
    call VRMethod window, "CenterWindow"
    call VRSet window, "Visible", 1
    call VRMethod window, "Activate"
return window

/*:VRX         __VXREXX____APPENDS__
*/
__VXREXX____APPENDS__:
/*
*/
return
/*:VRX         ChartOff
*/
ChartOff: procedure expose Globals.
    if Globals.!SS = "" then do
        signal ChartOffDone
    end
    call ResetChartData
    call SSSheetFini
    call SSFini
ChartOffDone:
return

/*:VRX         ChartOn
*/
ChartOn: procedure expose Globals.
    if Globals.!SS = "" then do
        ok = SSConfig()
        if \ok then signal ChartOnDone
    end

    call GetChartData

    ok = SSInit()
    if \ok then signal ChartOnDone

    ok = SSSheetInit()
    if \ok then signal ChartOnDone

    call SSChartData

ChartOnDone:
    ChartStarted = 1
    call VRMethod "Application", "PutVar", "ChartStarted"
return

/*:VRX         ChartRefresh
*/
ChartRefresh: procedure expose Globals.
    if Globals.!SS = "" then do
        ok = SSConfig()
        if \ok then signal ChartRefreshDone
    end

    call GetChartData
    call SSChartData

ChartRefreshDone:
return

/*:VRX         ChartTest
*/
ChartTest: procedure expose Globals.

    call RxFuncAdd "SysLoadFuncs", "RexxUtil", "SysLoadFuncs"
    call SysLoadFuncs
    call ShowWindow

    ok = SSConfig()
    if \ok then signal ChartTestDone

    call VRMessage VRWindow(), "Chart 10 items"

    rows = 10
    do i = 1 to rows 
        chartData.i = '"Section' i || '"' || ';' || i * i
    end
    chartData.0 = rows
    ok = VRMethod( "Application", "PutVar", "chartData." )

    call ChartOn

    call VRMessage VRWindow(), "Update 10 items, one at a time"

    do i = 1 to rows
        chartData.i = '"Section' i || '"' || ';' || i * i * i
        ok = VRMethod( "Application", "PutVar", "chartData." )
        call ChartRefresh
    end

    call VRMessage VRWindow(), "Reduce to 5 items"

    chartData.0 = 5
    ok = VRMethod( "Application", "PutVar", "chartData." )
    call ChartRefresh

ChartTestDone:
    call VRMessage VRWindow(), "Done"
    call ChartOff
    call Quit

return

/*:VRX         Fini
*/
Fini: procedure expose Globals.
    call ChartOff

    window = VRWindow()
    parent = VRGet( window, "parent" )
    if VRGet( window, "Visible" ) then do
        left = VRGet( window, "Left" ) - VRGet( parent, "Left" )
        top = VRGet( window, "Top" ) - VRGet( parent, "Top" )
        call IniMgr "Set", "ChartLeft", left
        call IniMgr "Set", "ChartTop", top
        call VRSet window, "Visible", 0
    end

    ChartFiniDone = 1
    call VRMethod "Application", "PutVar", "ChartFiniDone"
return 0

/*:VRX         GetChartData
*/
GetChartData: procedure expose Globals.
    call VRMethod "Application", "GetVar", "chartData." 
    call VRSortStem "chartData.", , "A"

    rows = chartData.0
    cols = 2
    do i = 1 to rows
        parse var chartData.i name ';' amount
        call GCDUpdate i, 1, name
        call GCDUpdate i, 2, amount
    end
        
/*  May be fewer rows.
*/
    oRows = Globals.!ChartData.0
    if rows < oRows then do
        do i = rows+1 to oRows
            call GCDUpdate i, 1, ""
            call GCDUpdate i, 2, ""
        end
    end
    else do
        Globals.!ChartData.0 = rows
    end

return

GCDUpdate: procedure expose Globals.
    parse arg i, col, value
    if Globals.!ChartData.i.col \= value then do
        Globals.!ChartData.i.col = value
        Globals.!ChartData.i.col.!new = 1
    end
    else do
        Globals.!ChartData.i.col.!new = 0
    end
return



/*:VRX         Halt
*/
Halt:
    signal _VREHalt
return

/*:VRX         Init
*/
Init: procedure expose Globals.
    window = VRWindow()
    parent = VRGet( window, "Parent" )
    left = IniMgr( "Get", "ChartLeft" )
    top = IniMgr( "Get", "ChartTop" )
    if left \= "" & top \= "" then do
        left =  left + VRGet( parent, "Left" )
        top = top + VRGet( parent, "Top" )
        call VRSet window, "Left", left, "Top", top
    end
    self = VRGet( window, "Self" )
    call VRMethod "Application", "PutVar", "self", "ChartStatusWindow"

    Globals. = ""
    call SSConfig


/*  To test this module use Options/Run to set the "Main file" to "Charts"
    and uncomment the call ChartTest:
*/
/*
    call ChartTest
*/
    ChartThreadStarted = 1
    call VRMethod "Application", "PutVar", "ChartThreadStarted"

return


/*:VRX         Quit
*/
Quit:
    window = VRWindow()
    call VRSet window, "Shutdown", 1
    drop window
return

/*:VRX         ResetChartData
*/
ResetChartData: procedure expose Globals.
    rows = Globals.!ChartData.0
    do i = 1 to rows
        globals.!ChartData.i.1 = ""
        globals.!ChartData.i.2 = ""
    end
    Globals.ChartData.0 = 0
return

/*:VRX         Restart
*/
Restart: procedure expose Globals.
    call ChartOff

    Globals. = ""
    call SSConfig

    ChartRestartDone = 1
    call VRMethod "Application", "PutVar", "ChartRestartDone"
return

/*:VRX         ShowWindow
*/
ShowWindow: procedure expose Globals.
    window = "W_Charts"
    call VRSet window, "Visible", 1
    call VRMethod window, "Activate" 
return

/*:VRX         SSChartData
*/
SSChartData: procedure expose Globals.
    interpret "call SSChartData_" || Globals.!SS
return
/*:VRX         SSChartData_123G
*/
SSChartData_123G:procedure expose Globals.

    chartDataOK = 0

    SSCtrl = "DDEC_SSCtrl"
    SSData = "DDEC_SSData"

    rows = Globals.!ChartData.0
    cols = 2
    alphaCols = "AB"
    do i = 1 to rows
        do j = 1 to cols
            if Globals.!ChartData.i.j.!new = 1 then do
                pos = SubStr( alphaCols, j, 1) || i
                call VRMethod SSData, "Poke", pos, Globals.!ChartData.i.j
            end
        end
    end
    if Globals.!NewChart = 1 then do
        Globals.!NewChart = 0
        call Status "Creating the chart"
        call DDEExec SSData, "{Goto}A:A1~{Anchor}{R}"
        do i = 1 to rows - 1
            call DDEExec SSData, "{D}"
        end
        call DDEExec SSData, "/GOT{Tab}" || "Budget by Department" || "~"
        call DDEExec SSData, "/GSTP~"
        
        /* Maximize the chart
           - The BREAK clears the chart's menu in the case where the chart
           is already maximized so the "x" item is unavailable.
        */
        call DDEExec SSData, "{TOOLMENU}x{BREAK}"      

        call Status, ""
    end

    chartDataOK = 1

return chartDataOK


/*:VRX         SSChartData_ExcelWin
*/
SSChartData_ExcelWin: procedure expose Globals.

    chartDataOK = 0

    SSCtrl = "DDEC_SSCtrl"
    SSData = "DDEC_SSData"

    rows = Globals.!ChartData.0
    cols = 2
    do i = 1 to rows
        do j = 1 to cols
            if Globals.!ChartData.i.j.!new = 1 then do
                pos = "R" || i || "C" || j
                call VRMethod SSData, "Poke", pos, Globals.!ChartData.i.j
            end
        end
    end
    if Globals.!NewChart = 1 then do
        Globals.!NewChart = 0
        pos = '"R1C1:R' || rows || 'C' || cols || '"'
        call DDEExecB SSData, "Select(" pos ")"
        call Status "Creating the chart"
        call DDEExecB SSData, "New(2)"
        call DDEExecB SSData, "Full(TRUE)"
        call Status "Transforming into a Pie 5 chart."
        call DDEExecB SSData, "Gallery.3D.Pie(5)"
        call Status, ""
    end

    chartDataOK = 1

return chartDataOK

/*:VRX         SSConfig
*/
/*
    ok = SSConfig()
*/
SSConfig: procedure expose Globals.

    ssConfigOK = 0

    Globals.!SS = IniMgr( "Get", "Spreadsheet" )
    Globals.!SSHome = VRGet( "Application", "WorkingDirectory" )
    Globals.!SSPath = ""
    Globals.!ChartData.0 = 0

    if Globals.!SS = "" then signal SSConfigDone

    interpret "ok = SSConfig_" || Globals.!SS || "()"
    if \ok then do
        Globals.!SS = ""
        signal SSConfigDone
    end
    
    ssConfigOK = 1

SSConfigDone:
return ssConfigOK

/*:VRX         SSConfig_123G
*/
SSConfig_123G: procedure expose Globals.
    Globals.!SSPath = CfgPath( "Lotus 123G", "123G.EXE", "123GPath" )
return Globals.!SSPath \= ""

/*:VRX         SSConfig_ExcelWin
*/
SSConfig_ExcelWin: procedure expose Globals.
    Globals.!SSPath = CfgPath( "Microsoft Excel", "Excel.EXE", "ExcelWinPath" )
return Globals.!SSPath \= ""

/*:VRX         SSFini
*/
SSFini: procedure expose Globals.
    ok = 0

    if Globals.!SS = "" then do
        ok = 1
        signal SSFiniDone
    end

    if \VRIsValidObject( Globals.!SSHWnd ) then do
        ok = 1
        signal SSFiniDone
    end

    if Globals.!SSShutDown \= 1 then do
        ok = 1
        signal SSFiniDone
    end

    interpret "ok = SSFini_" || Globals.!SS || "()"

SSFIniDone:
return ok


/*:VRX         SSFini_123G
*/
SSFini_123G: procedure expose Globals.

    ok = 0

    SSHWnd = Globals.!SSHWnd
    SSCtrl = "DDEC_SSCtrl"

    /* Make sure we (still) have a DDE connection
    */
    ok = DDEInit( SSCtrl, "Lotus", "System" )
    if \ok then signal SSFini_123G_Done

    /* Shut down
        - Can't be done via DDE so send keystrokes.
        - Assume chart & sheet already closed so there are no confirm dialogs
    */
    call VRMethod SSCtrl, "Terminate", "Wait", 5

    call VRMethod SSHwnd, "Activate"
    call SendKeys "1-2-3 for OS/2", "{Alt}{F4}", 10

    /* 123G seems to require extra time to shutdown or an immediate attempt to
       restart it will fail.
    */
    call TestWait "Closing 123G", 10

    ok = 1

SSFini_123G_Done:

return ok


/*:VRX         SSFini_ExcelWin
*/
SSFini_ExcelWin: procedure expose Globals.
    ok = 0

    SSCtrl = "DDEC_SSCtrl"

    /* Make sure we (still) have a DDE connection
    */
    ok = DDEInit( SSCtrl, "Excel", "System" )
    if \ok then signal SSFini_ExcelWin_Done

    /* Shut down
        - The DDE conversation ends without an ACK after sending the "Quit" command
        so don't wait for the ack, instead wait for the connection to be terminated.
    */
    call DDEExecB SSCtrl, "Error(False)"
    call DDEExecB SSCtrl, "Quit", "N"
    call DDEWaitT SSCtrl, 5

    call TestWait "Closing Excel", 5

    ok = 1

SSFini_ExcelWin_Done:

return ok


/*:VRX         SSInit
*/
/*
    ok = SSInit()

    - Start the word processor and connect to it
*/
SSInit: procedure expose Globals.
    ssInitOK = 0

    if Globals.!SS = "" then do
        ok = SSConfig()
        if \ok then do
            signal SSInitDone
        end
    end

    if VRIsValidObject( Globals.!SSHWnd ) then do
        ssInitOK = 1
        signal SSInitDone
    end
    Globals.!SSHWnd = ""

    interpret "ret = SSInit_" || Globals.!SS || "()"

    parse VAR ret hWnd ";" new
    if hWnd = "" then do
        call Error "Unable to start the spreadsheet."
        signal SSInitDone
    end

    call VRMethod hWnd, "Restore"
    call WinPos hWnd, "Top", "Right"

    Globals.!SSHWnd = hWnd
    if new = "NEW" then do
        Globals.!SSShutDown = 1
    end

    Globals.!NewChart = 1

    ssInitOK = 1

SSInitDone:

return ssInitOK


/*:VRX         SSInit_123G
*/
/*
    - The 123G window takes the title from the caption of the program object
    created to start it so we pass the extra setup info to make them match.
*/
SSInit_123G: procedure expose Globals.
    call Status "Starting Lotus 1-2-3 for OS/2"
    caption = "1-2-3 for OS/2"
    setup = ";TITLE=" || caption
    ret = RunProg( Globals.!SSPath || "\" || "123G.EXE", caption, 30, setup )
    call Status ""
return ret

/*:VRX         SSInit_ExcelWin
*/
SSInit_ExcelWin: procedure expose Globals.
    call Status "Starting Excel for Windows"
    ret = RunProg( Globals.!SSPath || "\" || "EXCEL.EXE", "Microsoft Excel", 60 )
    call Status ""
return ret

/*:VRX         SSSheetFini
*/
SSSheetFini: procedure expose Globals. 
    interpret "call SSSheetFini_" || Globals.!SS
return

/*:VRX         SSSheetFini_123G
*/
/*  
    call SSheetFini_123G

    Closing the chart & sheet cause a "Close Window" dialog to appear
    which confirms the close without save operation.  A DDE command
    cannot be used to send the close request because it will not return
    until the "Close Window" dialog has been answered -- which we can't
    do until the DDE command returns.
*/
SSSheetFini_123G:  procedure expose Globals.
    SSHWnd = Globals.!SSHWnd
    SSCtrl = "DDEC_SSCtrl"
    SSData = "DDEC_SSData"

    if( VRGet( SSData, "Status" ) = "ACTIVE" ) then do
        call VRMethod SSData, "Terminate", "Wait", 5
    end

    if( VRGet( SSCtrl, "Status" ) = "ACTIVE" ) then do
        call VRMethod SSCtrl, "Terminate", "Wait", 5

        call VRMethod SSHwnd, "Activate"            /* So it has the focus */

        call SendKeys "EMPLIST.GPH", "{Alt}-c", 5   /* Chart */
        call SendKeys "Close Window", "n", 5         

        call SendKeys "EMPLIST.WG2", "{Alt}-c", 5   /* Sheet */
        call SendKeys "Close Window", "n", 5         
    end

return


/*:VRX         SSSheetFini_ExcelWin
*/
SSSheetFini_ExcelWin: procedure expose Globals.
    SSCtrl = "DDEC_SSCtrl"
    SSData = "DDEC_SSData"

    if( VRGet( SSData, "Status" ) = "ACTIVE" ) then do
        call VRMethod SSData, "Terminate", "Wait", 5
    end

    if( VRGet( SSCtrl, "Status" ) = "ACTIVE" ) then do
        call DDEExecB SSCtrl, "Close(False)"
        call DDEExecB SSCtrl, "Close(False)"
        call VRMethod SSCtrl, "Terminate", "Wait", 5
    end

return

/*:VRX         SSSheetInit
*/
SSSheetInit: procedure expose Globals.
    interpret "ok = SSSheetInit_" || Globals.!SS || "()"
return ok 

/*:VRX         SSSheetInit_123G
*/
SSSheetInit_123G: procedure expose Globals.

    ok = 0

    SSCtrl = "DDEC_SSCtrl"
    SSData = "DDEC_SSData"

    call Status "Connecting to Lotus 1-2-3 for OS/2"
    ok = DDEInit( SSCtrl, "Lotus", "System" )   
    if \ok then signal SSSheetInit_123G_Done

    /* Load the sheet
       - Its difficult to enter absolute paths when loading a sheet so
       set the working directory within 123G first.
    */
    call Status "Loading chart"
    file = "data\EmpList.WG2"
    call DDEExec SSCtrl, "/FD" || Globals.!SSHome || "\~"
    call DDEExec SSCtrl, "/FO" || file || "~"

    /* Establish a conversation with the chart 
    */
    call Status "Connecting to" file
    ok = DDEInit( SSData, "Lotus", file )
    if \ok then signal SSSheetInit_123G_Done

    /* Activate and maximize the chart
       - The BREAK clears the sheet's menu in the case where the sheet
       is already maximized so the "x" item is unavailable.
    */
    call DDEExec SSCtrl, "{WACTIVATE " || file || "}"
    call DDEExec SSData, "{TOOLMENU}x{BREAK}"      
    
    Globals.!NewChart = 1

    ok = 1

SSSheetInit_123G_Done:

    call Status ""

return ok


/*:VRX         SSSheetInit_ExcelWin
*/
SSSheetInit_ExcelWin: procedure expose Globals.

    ok = 0

    SSCtrl = "DDEC_SSCtrl"
    SSData = "DDEC_SSData"

    call Status "Connecting to Excel for Windows"
    ok = DDEInit( SSCtrl, "Excel", "System" )   
    if \ok then signal SSSheetInit_ExcelWin_Done

    /* Load the sheet
    */
    file = Globals.!SSHome || "\data\" || "EmpList.XLS"
    call Status "Loading chart"
    call DDEExecB SSCtrl, 'Open("' || file || '")'

    /* Establish a conversation with the chart 
    */
    call Status "Connecting to" file
    ok = DDEInit( SSData, "Excel", file )
    if \ok then signal SSSheetInit_ExcelWin_Done
    
    Globals.!NewChart = 1

    ok = 1

SSSheetInit_ExcelWin_Done:

    call Status ""

return ok

/*:VRX         W_Charts_Close
*/
W_Charts_Close:
    call VRSet "W_Charts", "Visible", 0
return

/* Including file 'shared\ddeexecb.vrs' */

/* Including file 'shared\cfgpath.vrs' */

/* Including file 'shared\ddeinit.vrs' */

/* Including file 'shared\ddeinit.vrs' */

/* Including file 'shared\ddeinit.vrs' */

/* Including file 'shared\ddeinit.vrs' */

/* Including file 'shared\ddeinit.vrs' */
