/*:VRX         Main
*/
/*  Main
*/
Main:
/*  Process the arguments.
    Get the parent window.
*/
    parse source . calledAs .
    parent = ""
    argCount = arg()
    argOff = 0
    if( calledAs \= "COMMAND" )then do
        if argCount >= 1 then do
            parent = arg(1)
            argCount = argCount - 1
            argOff = 1
        end
    end
    InitArgs.0 = argCount
    if( argCount > 0 )then do i = 1 to argCount
        InitArgs.i = arg( i + argOff )
    end
    drop calledAs argCount argOff

/*  Load the windows
*/
    call VRInit
    parse source . . spec
    _VREPrimaryWindowPath = ,
        VRParseFileName( spec, "dpn" ) || ".VRW"
    _VREPrimaryWindow = ,
        VRLoad( parent, _VREPrimaryWindowPath )
    drop parent spec
    if( _VREPrimaryWindow == "" )then do
        call VRMessage "", "Cannot load window:" VRError(), ,
            "Error!"
        _VREReturnValue = 32000
        signal _VRELeaveMain
    end

/*  Process events
*/
    call Init
    signal on halt
    do while( \ VRGet( _VREPrimaryWindow, "Shutdown" ) )
        _VREEvent = VREvent()
        interpret _VREEvent
    end
_VREHalt:
    _VREReturnValue = Fini()
    call VRDestroy _VREPrimaryWindow
_VRELeaveMain:
    call VRFini
exit _VREReturnValue

VRLoadSecondary: procedure
    name = arg( 1 )

    window = VRLoad( VRWindow(), VRWindowPath(), name )
    call VRMethod window, "CenterWindow"
    call VRSet window, "Visible", 1
    call VRMethod window, "Activate"
return window

/*:VRX         ChartFini
*/
/*
    Some of the programs are shutdown with keystrokes so we wait till the shutdown is
    complete to avoid trying to shutdown two programs at once.
*/
ChartFini: procedure expose Globals.
    if Globals.!ChartsThreadID > 0 then do
        call Status "Waiting for the spreadsheet to shutdown."
        ChartFiniDone = 0
        call VRMethod "Application", "PutVar", "ChartFiniDone"            
        ok = VRMethod( "Application", "Post", Globals.!ChartsThreadID, "call Quit" )
        do 30
            call VRMethod "Application", "GetVar", "ChartFiniDone"
            if ChartFiniDone = 1 then leave
            call SysSleep 1
        end
        call Status ""
    end
return

/*:VRX         ChartInit
*/
ChartInit: procedure expose Globals.
    call Status "Starting the chart thread"
    ChartThreadStarted = 0
    call VRMethod "Application", "PutVar", "ChartThreadStarted"
    self = VRGet(VRWindow(), "Self")
    Globals.!ChartsThreadID = VRMethod( "Application", "StartThread", "Subroutine Charts", self )
    if Globals.!ChartsThreadID <= 0 then do
        call Error "Unable to start the chart thread."
        signal Halt
    end
    do 5
        call VRMethod "Application", "GetVar", "ChartThreadStarted"
        if ChartThreadStarted = 1 then leave
        call SysSleep 1
    end
    call Status ""
return

/*:VRX         ChartOff
*/
ChartOff: procedure expose Globals.
    ok = VRMethod( "Application", "Post", Globals.!ChartsThreadID, "call ChartOff" )
return

/*:VRX         ChartOn
*/
ChartOn: procedure expose Globals.
    call ChartSetData
    cmd = 'call ChartOn'
    ok = VRMethod( "Application", "Post", Globals.!ChartsThreadID, cmd )
return

/*:VRX         ChartRefresh
*/
ChartRefresh: procedure expose Globals.
    cmd = 'call ChartRefresh'
    ok = VRMethod( "Application", "Post", Globals.!ChartsThreadID, cmd )
return

/*:VRX         ChartRestart
*/
ChartRestart: procedure expose Globals.
    if Globals.!ChartsThreadID > 0 then do
        call Status "Waiting for the spreadsheet to restart."
        ChartRestartDone = 0
        call VRMethod "Application", "PutVar", "ChartRestartDone"            
        ok = VRMethod( "Application", "Post", Globals.!ChartsThreadID, "call Restart" )
        do 30
            call VRMethod "Application", "GetVar", "ChartRestartDone"
            if ChartRestartDone = 1 then leave
            call SysSleep 1
        end
        call Status ""
    end
return

/*:VRX         ChartSetData
*/
/*
    Create an array of total salary expense per department:

        chartData.0 = <number of departments>
        chartData.n = <department name> ';' <salary expense>
       
    To build the list we keep two stems:

        deptNames.0 = <number of departments>
        deptNames.n = <name of the department>

        totalSalary.<name of the department> = <total salary for department>

    Using the name of the department to index the totalSalary stem avoids the need
    to look up each name to find its index number.  Instead we check to see if that
    stem item contains a number.  If it does not we assume its a new department and
    create a new entry for it.  Otherwise it represents the total salary for that
    department which we increment with the current data.         
*/
ChartSetData: procedure expose Globals.

    numDepts = 0
    call VRMethod "CN_EmpList", "GetRecordList", "All", "records."
    do i = 1 to records.0
        deptName = CN_EmpList_GetData( records.i, "DeptName" )
        salary = CN_EmpList_GetData( records.i, "Salary" )
        if( \DataType( totalSalary.deptName, "N" ) ) then do
            numDepts = numDepts + 1
            deptNames.numDepts = deptName
            totalSalary.deptName = salary
        end
        else do
            totalSalary.deptName = totalSalary.deptName + salary
        end
    end

    do i = 1 to numDepts
        deptName = deptNames.i
        chartData.i = deptName || ';' || totalSalary.deptName
    end
    chartData.0 = numDepts
    call VRMethod "Application", "PutVar", "chartData."  

return

/*:VRX         ChartShowStatus
*/
ChartShowStatus: procedure expose Globals.
    call VRMethod "Application", "GetVar", "ChartStatusWindow"
    if VRIsValidObject( ChartStatusWindow ) then do
        call VRSet ChartStatusWindow, "Visible", 1
    end
return

/*:VRX         ChartSS
*/
ChartSS: procedure expose Globals.
    ss = IniMgr( "Get", "Spreadsheet" )
    if ss = "" then do
        ss = "123G"
        call IniMgr "Set", "Spreadsheet", ss
    end
return ss


/*:VRX         CN_EmpList_ContextMenu
*/
CN_EmpList_ContextMenu:
    call VRMethod "M_Employee", "Popup"
return

/*:VRX         CN_EmpList_DragDiscard
*/
/*
    Records have been dropped on the shredder
    - The "Fire" routines operate on all records with the Source attribute set but
    a discard event is generated for each record so Flush is used to clear any
    extra events.
*/
CN_EmpList_DragDiscard:
    call VRFlush
    call Fire 
return

/*:VRX         CN_EmpList_Fill
*/
CN_EmpList_Fill: procedure expose Globals.

    call Status "Getting the initial list..."

    file = Globals.!DBPath

    do i = 1
        call Status i
        empList.i = LineIn( file )
        ok = empList.i \= ""
        if \ok then leave
    end
    empList.0 = i - 1

    call Stream file, "C", "Close"

    ok = VRSet( "CN_EmpList", "Painting", 0 )
    ok = VRMethod( "CN_EmpList", "AddRecordList", , "", "empList.")
    call MI_Sort_Set "MI_Sort_ID", "ID"
    ok = VRSet( "CN_EmpList", "Painting", 1 )


/*  Uncomment to generate a test file
*/
/*
    call Status "Saving to a text file..."
    file = Globals.!DBPath
    call VRDeleteFile file
    do i = 1 to empList.0
        call Lineout file, empList.i
    end
    call Stream file, "C", "Close"
*/

    call Status ""

return

/*:VRX         CN_EmpList_GetData
*/
CN_EmpList_GetData: procedure expose Globals.
    parse arg record, field
    data = VRMethod( "CN_EmpList", "GetFieldData", record, field )
return data

/*:VRX         CN_EmpList_Init
*/
CN_EmpList_Init: procedure expose Globals.
    recordHandle = VRMethod( "CN_EmpList", "AddField", "ULong",  "ID",          "ID" )
    recordHandle = VRMethod( "CN_EmpList", "AddField", "String", "Name",        "Name" )
    recordHandle = VRMethod( "CN_EmpList", "AddField", "String", "Job",         "Job" )
    recordHandle = VRMethod( "CN_EmpList", "AddField", "String", "Dept",        "Dept" )
    call VRMethod "CN_EmpList", "SetFieldAttr", recordHandle, "Visible", 0
    recordHandle = VRMethod( "CN_EmpList", "AddField", "String", "Department",  "DeptName" )
    recordHandle = VRMethod( "CN_EmpList", "AddField", "String", "Salary",      "Salary" )
    recordHandle = VRMethod( "CN_EmpList", "AddField", "String", "Commission",  "Comm" )
    recordHandle = VRMethod( "CN_EmpList", "AddField", "ULong",  "Years",       "Years" )
return

/*:VRX         CN_EmpList_Reset
*/
CN_EmpList_Reset: procedure expose Globals.
    ok = VRMethod( "CN_EmpList", "RemoveRecord", "All" )
return

/*:VRX         CN_EmpList_Reset_Source
*/
CN_EmpList_Reset_Source: procedure expose Globals.
    ok = VRMethod( "CN_EmpList", "GetRecordList", "Source", "records." )
    if records.0 > 0 then do
        call VRSet "CN_EmpList", "Painting", 0
        do i = 1 to records.0
            ok = VRMethod( "CN_EmpList", "SetRecordAttr", records.i, "Source", 0 )
        end
    end
    call VRSet "CN_EmpList", "Painting", 1
return

/*:VRX         Fini
*/
Fini:
    call ReportFini
    call ChartFini

    /*
        Wait for the threads to shutdown.
    */
        do forever
            ok = VRMethod( "Application", "ListThreads", "threads." )
            call Status "Threads remaining:" threads.0
            if threads.0 = 1 then leave
            call SysSleep 1
        end

    /*  Release the INI semaphores
    */
    call IniMgr "Fini"

    call VRSet VRWindow(), "Visible", 0

return 0

/*:VRX         Fire
*/

/* 
    fired = Fire()

    - Confirm, then fire the selected employees
    - Code continues in PB_FireConfirm_OK_Click
*/
Fire: procedure expose Globals.

    ok = VRMethod( "CN_EmpList", "GetRecordList", "SourceOrSelected", "fireList." )
    call CN_EmpList_Reset_Source
    if fireList.0 = 0 then signal FireDone

    call VRLoadSecondary "SW_FireConfirm"

    do i = 1 to fireList.0
        name = VRMethod( "CN_EmpList", "GetRecordAttr", fireList.i, "Caption" )
        position = VRMethod( "LB_FireList", "AddString", name,  )
        ok = VRMethod( "LB_FireList", "SetItemData", position, fireList.i )
        selected.i = i
    end
    selected.0 = fireList.0
    ok = VRMethod( "LB_FireList", "SetSelectedList", "selected." )

FireDone:
return

/*:VRX         Halt
*/
Halt:
    signal _VREHalt
return

/*:VRX         Init
*/
Init: procedure expose Globals.

    call VRRedirectStdio "on", "EmpList.LOG"

    /*  Set the no syntax option to avoid syntax errors if the main
        thread tries to set the visible property on a status window that does
        not exist.
    */
    call VROptions "NoSyntax"

    /*  Load the OS/2 utilities such as SysSleep
    */
    call RxFuncAdd "SysLoadFuncs", "RexxUtil", "SysLoadFuncs"
    call SysLoadFuncs

    /*  Speed up INI access
    */
    call IniMgr "Init"

    /*  Use "procedure expose Globals." for all non-event procedures.
        Initial value is 0.
    */
    Globals. = 0

    TestWait = 0
    call VRMethod "Application", "PutVar", "TestWait"

    /*  Make the main window visible and active.
    */  
    window = VRWindow()
    call VRMethod window, "CenterWindow"
    call VRSet window, "Visible", 1
    call VRMethod window, "Activate"

    /*  Start the report and chart threads
    */
    call ChartInit
    call ReportInit


    /* Set the columns
    */
    Globals.!DBPath = VRGet( "Application", "WorkingDirectory" ) || "\data\EmpList.TXT"
    call CN_EmpList_Init

    /* Fill the container with all records
    */
    call CN_EmpList_Fill

InitDone:
    call MenusEnable

return

/*:VRX         MenusDisable
*/
MenusDisable: procedure
    call VRSet "M_Employee", "Enabled", 0
    call VRSet "M_View", "Enabled", 0
    call VRSet "M_Windows", "Enabled", 0
    call VRSet "M_Options", "Enabled", 0
    call VRSet "M_Help", "Enabled", 0
return

/*:VRX         MenusEnable
*/
MenusEnable: procedure expose Globals.
    call VRSet "M_Employee", "Enabled", 1
    call VRSet "M_View", "Enabled", 1
    call VRSet "M_Windows", "Enabled", 1
    call VRSet "M_Options", "Enabled", 1
    call VRSet "M_Help", "Enabled", 1
return

/*:VRX         MI_Chart_Click
*/
MI_Chart_Click:
    checked = VRGet( "MI_Chart", "Checked" )
    if ( checked ) then do
        call ChartOff
    end
    else do
        call ChartOn
    end
    call VRSet "MI_Chart", "Checked", \checked
return

/*:VRX         MI_Chart_Status_Click
*/
MI_Chart_Status_Click:
    call ChartShowStatus
return

/*:VRX         MI_Employee_Delete_Click
*/
MI_Employee_Delete_Click:
    call Fire
return

/*:VRX         MI_Help_Product_Click
*/
MI_Help_Product_Click:
    call VRLoadSecondary "SW_Product"
return

/*:VRX         MI_Options_Spreadsheet_Click
*/
MI_Options_Spreadsheet_Click:
    call SW_Options_SS_Init
return

/*:VRX         MI_Options_Test_Click
*/
MI_Options_Test_Click:
    call VRLoadSecondary "SW_Options_Test"
return

/*:VRX         MI_Options_Wordprocessor_Click
*/
MI_Options_Wordprocessor_Click:
    call SW_Options_WP_Init
return

/*:VRX         MI_Report_Status_Click
*/
MI_Report_Status_Click:
    call ReportShowStatus
return

/*:VRX         MI_Sort_Click
*/
MI_Sort_Click:
    ok = VRMethod( "CN_EmpList", "SortRecords" )
return

/*:VRX         MI_Sort_Commision_Click
*/
MI_Sort_Commision_Click:
    call MI_Sort_Set "MI_Sort_Commision", "Comm"
return

/*:VRX         MI_Sort_Department_Click
*/
MI_Sort_Department_Click:
    call MI_Sort_Set "MI_Sort_Department", "DeptName"
return

/*:VRX         MI_Sort_ID_Click
*/
MI_Sort_ID_Click:
    call MI_Sort_Set "MI_Sort_ID", "ID"
return

/*:VRX         MI_Sort_Job_Click
*/
MI_Sort_Job_Click:
    call MI_Sort_Set "MI_Sort_Job", "Job"
return

/*:VRX         MI_Sort_Name_Click
*/
MI_Sort_Name_Click:
    call MI_Sort_Set "MI_Sort_Name", "Name"
return

/*:VRX         MI_Sort_Salary_Click
*/
MI_Sort_Salary_Click:
    call MI_Sort_Set "MI_Sort_Salary", "Salary"
return

/*:VRX         MI_Sort_Set
*/
MI_Sort_Set: procedure expose Globals.
    parse arg menuItemName, fieldName

    call VRSet "MI_Sort", "DefaultItem", menuItemName

    ok = VRSet( "CN_EmpList", "DetailSort", fieldName )
/*    ok = VRMethod( "CN_EmpList", "SortRecords" )
*/
/*  Bug in V2.0 leaves the first item checked.
*/
    if menuItemName \= "MI_Sort_ID" then do
        call VRSet "MI_Sort_ID", "Checked", 0
    end

return

/*:VRX         MI_Sort_Years_Click
*/
MI_Sort_Years_Click:
    call MI_Sort_Set "MI_Sort_Years", "Years"
return

/*:VRX         MI_View_Details_Click
*/
MI_View_Details_Click:
    checked = VRGet( "MI_View_Details", "Checked" )
    if ( checked ) then do
        ok = VRSet( "CN_EmpList", "View", "Icon" )
        call VRSet "MI_Sort", "Enabled", 0
    end
    else do
        ok = VRSet( "CN_EmpList", "View", "Detail" )
        call VRSet "MI_Sort", "Enabled", 1
    end    
    call VRSet "MI_View_Details", "Checked", \checked
return

/*:VRX         PB_FireConfirm_Cancel_Click
*/
PB_FireConfirm_Cancel_Click:
    call VRDestroy "SW_FireConfirm"
return

/*:VRX         PB_FireConfirm_OK_Click
*/
PB_FireConfirm_OK_Click:

    ok = VRMethod( "LB_FireList", "GetSelectedList", "fireList." )
    show = VRGet( "RB_PSlip_Show", "Set" )
    print = VRGet( "RB_PSlip_Print", "Set" )

    do i = 1 to fireList.0
        record = VRMethod( "LB_FireList", "GetItemData", fireList.i )
        if show = 1 | print = 1 then do
            name = VRMethod( "CN_EmpList", "GetRecordAttr", record, "Caption" )
            call ReportPinkSlip name, print
        end        
        ok = VRMethod( "CN_EmpList", "RemoveRecord", record )
    end

    checked = VRGet( "MI_Chart", "Checked" )
    if ( checked ) then do
        call ChartSetData
        call ChartRefresh
    end

    call VRDestroy "SW_FireConfirm"
return

/*:VRX         PB_Options_SS_Cancel_Click
*/
PB_Options_SS_Cancel_Click:
    call SW_Options_SS_Quit
return

/*:VRX         PB_Options_SS_OK_Click
*/
PB_Options_SS_OK_Click: procedure expose Globals.
    call SW_Options_SS_Fini
    call SW_Options_SS_Quit
return

/*:VRX         PB_Options_SS_Restart_Click
*/
PB_Options_SS_Restart_Click:
    call SW_Options_SS_Fini
    call SW_Options_SS_Quit

    call ChartRestart
    checked = VRGet( "MI_Chart", "Checked" )
    if ( checked ) then do
        call ChartOn
    end

return

/*:VRX         PB_Options_Test_Cancel_Click
*/
PB_Options_Test_Cancel_Click:
    call VRDestroy "SW_Options_Test"
return

/*:VRX         PB_Options_Test_OK_Click
*/
PB_Options_Test_OK_Click: procedure expose Globals.

    j = 0
    call VRMethod "GB_Test_SS", "ListChildren", "cb."
    do i = 1 to cb.0
        if VRGet( cb.i, "Set" ) then do   
            name = VRGet( cb.i, "Name" )
            parse VAR name . "_" . "_" ssName
            j = j + 1
            ss.j = ssName
        end
    end        
    ss.0 = j

    j = 0
    call VRMethod "GB_Test_WP", "ListChildren", "cb."
    do i = 1 to cb.0
        if VRGet( cb.i, "Set" ) then do   
            name = VRGet( cb.i, "Name" )
            parse VAR name . "_" . "_" wpName
            j = j + 1
            wp.j = wpName
        end
    end        
    wp.0 = j

    cycles = VRGet( "SPIN_Test_Cycles", "Value" )

    call VRDestroy "SW_Options_Test"

    call MenusDisable
    call Test cycles
    call MenusEnable

return

/*:VRX         PB_Options_WP_Cancel_Click
*/
PB_Options_WP_Cancel_Click:
    call SW_Options_WP_Quit
return

/*:VRX         PB_Options_WP_OK_Click
*/
PB_Options_WP_OK_Click: procedure expose Globals.
    call SW_Options_WP_Fini
    call SW_Options_WP_Quit
return

/*:VRX         PB_Options_WP_Restart_Click
*/
PB_Options_WP_Restart_Click:
    call SW_Options_WP_Fini
    call SW_Options_WP_Quit

    call ReportRestart
return

/*:VRX         PB_TestStop_Click
*/
PB_TestStop_Click:
return

/*:VRX         Quit
*/
Quit:
    call VRSet VRWindow(), "Shutdown", 1
return

/*:VRX         ReportFini
*/
ReportFini: procedure expose Globals.
    if Globals.!ReportsThreadID > 0 then do
        call Status "Waiting for the word processor to shutdown."
        ReportFiniDone = 0
        call VRMethod "Application", "PutVar", "ReportFiniDone"
        ok = VRMethod( "Application", "Post", Globals.!ReportsThreadID, "call Quit" )
        do 30
            call VRMethod "Application", "GetVar", "ReportFiniDone"
            if ReportFiniDone = 1 then leave
            call SysSleep 1
        end
        call Status ""
    end
return

/*:VRX         ReportInit
*/
ReportInit: procedure expose Globals.
    call Status "Starting the report thread"
    ReportThreadStarted = 0
    call VRMethod "Application", "PutVar", "ReportThreadStarted"
    call ReportWP
    self = VRGet(VRWindow(), "Self")
    Globals.!ReportsThreadID = VRMethod( "Application", "StartThread", "Subroutine Reports", self )
    if Globals.!ReportsThreadID <= 0 then do
        call Error "Unable to start the report thread."
        signal Halt
    end
    do 5
        call VRMethod "Application", "GetVar", "ReportThreadStarted"
        if ReportThreadStarted = 1 then leave
        call SysSleep 1
    end
    call Status ""
return

/*:VRX         ReportPinkSlip
*/
ReportPinkSlip: procedure expose Globals.
    parse arg name, print
    cmd = 'call PinkSlip "' || name || '"' || ',' || print || ', "' || show || '"'
    ok = VRMethod( "Application", "Post", Globals.!ReportsThreadID, cmd )
return

/*:VRX         ReportRestart
*/
ReportRestart: procedure expose Globals.
    if Globals.!ReportsThreadID > 0 then do
        call Status "Waiting for the word processor to restart."
        ReportRestartDone = 0
        call VRMethod "Application", "PutVar", "ReportRestartDone"
        ok = VRMethod( "Application", "Post", Globals.!ReportsThreadID, "call Restart" )
        do 30
            call VRMethod "Application", "GetVar", "ReportRestartDone"
            if ReportRestartDone = 1 then leave
            call SysSleep 1
        end
        call Status ""
    end
return


/*:VRX         ReportShowStatus
*/
ReportShowStatus: procedure expose Globals.
    call VRMethod "Application", "GetVar", "ReportStatusWindow"
    if VRIsValidObject( ReportStatusWindow ) then do
        call VRSet ReportStatusWindow, "Visible", 1
    end
return

/*:VRX         ReportWP
*/
ReportWP: procedure expose Globals.
    wp = IniMgr( "Get", "Wordprocessor" )
    if wp = "" then do
        wp = "AmiPro"
        call IniMgr "Set", "Wordprocessor", wp
    end
return wp

/*:VRX         SW_FireConfirm_Close
*/
SW_FireConfirm_Close:
    window = VRInfo( "Object" )
    call VRDestroy window
    drop window
return

/*:VRX         SW_Load
*/
SW_Load: procedure expose Globals.
    parse arg name
    window = VRLoad( VRWindow(), VRWindowPath(), name )
    call VRMethod window, "CenterWindow"
return window

/*:VRX         SW_Options_SS_Close
*/
SW_Options_SS_Close:
    window = VRInfo( "Object" )
    call VRDestroy window
    drop window
return
/*:VRX         SW_Options_SS_Fini
*/
SW_Options_SS_Fini: procedure expose Globals.
    call VRMethod "GB_SS", "ListChildren", "radioButtons."
    do i = 1 to radioButtons.0
        if VRGet( radioButtons.i, "Set" ) then do   
            name = VRGet( radioButtons.i, "Name" )
            parse VAR name ."_" . "_" ss
        end
    end        

    call IniMgr "Set", "Spreadsheet", ss

return



/*:VRX         SW_Options_SS_Init
*/
SW_Options_SS_Init: procedure expose Globals.
    window = SW_Load( "SW_Options_SS" )
    ss = ChartSS()
    rb = "RB_SS_" || ss
    if VRIsValidObject( rb ) then do
        call VRSet rb, "Set", 1
    end
    call SW_Show window
return

/*:VRX         SW_Options_SS_Quit
*/
SW_Options_SS_Quit: procedure expose Globals.
    call VRDestroy "SW_Options_SS"
return

/*:VRX         SW_Options_Test_Close
*/
SW_Options_Test_Close:
    window = VRInfo( "Object" )
    call VRDestroy window
    drop window
return
/*:VRX         SW_Options_WP_Close
*/
SW_Options_WP_Close:
    window = VRInfo( "Object" )
    call VRDestroy window
    drop window
return

/*:VRX         SW_Options_WP_Fini
*/
SW_Options_WP_Fini: procedure expose Globals.
    call VRMethod "GB_WP", "ListChildren", "radioButtons."
    do i = 1 to radioButtons.0
        if VRGet( radioButtons.i, "Set" ) then do   
            name = VRGet( radioButtons.i, "Name" )
            parse VAR name ."_" . "_" wp
        end
    end        

    call IniMgr "Set", "Wordprocessor", wp

return

/*:VRX         SW_Options_WP_Init
*/
SW_Options_WP_Init: procedure expose Globals.
    window = SW_Load( "SW_Options_WP" )
    wp = ReportWP()
    rb = "RB_WP_" || wp
    if VRIsValidObject( rb ) then do
        call VRSet rb, "Set", 1
    end
    call SW_Show window
return

/*:VRX         SW_Options_WP_Quit
*/
SW_Options_WP_Quit:
    call VRDestroy "SW_Options_WP"
return


/*:VRX         SW_Product_Close
*/
SW_Product_Close:
    window = VRInfo( "Object" )
    call VRDestroy window
    drop window
return
/*:VRX         SW_Show
*/
SW_Show: procedure expose Globals.
    parse arg window
    call VRSet window, "Visible", 1
    call VRMethod window, "Activate"
return

/*:VRX         SW_TestStop_Close
*/
SW_TestStop_Close:
    window = VRInfo( "Object" )
    call VRDestroy window
    drop window
return
/*:VRX         Test
*/
/*
    call Test <n times>

    - Before calling Test, set REXX array "wp." to the list of word processors to
    test and "ss." to the list of spreadsheets.

    - Assume any event is a request to halt the test.
*/
Test: procedure expose Globals. wp. ss.

    parse arg cycles

    testWP = wp.0 \= 0
    if \testWP then do
        wp.0 = 1
    end

    testSS = ss.0 \= 0
    if \testSS then do
        ss.0 = 1
    end

    call VRLoadSecondary "SW_TestStop"

    TestWait = 1
    call VRMethod "Application", "PutVar", "TestWait"

    do cursor = 1 to cycles

        say cursor "+++++++++++++++++++++++++++++++++++++++++++++++++++++++"

        do i = 1 to wp.0 

            if TestQuit() then signal TestDone

            say i "======================================================="

            call VRSet "DT_TestCycle", "Caption", "Test" cursor "of" cycles

            statusWP = ""
            if testWP then do
                say "ReportRestart" wp.i
                call IniMgr "Set", "Wordprocessor", wp.i
                call ReportRestart
                call ReportShowStatus
                statusWP = wp.i
            end
            else do 
                statusWP = ""
            end

            do j = 1 to ss.0

                if TestQuit() then signal TestDone

                say j "-------------------------------------------------------"

                statusSS = ""
                if testSS then do
                    say "ChartRestart" ss.j
                    call IniMgr "Set", "Spreadsheet", ss.j
                    call ChartRestart
                    call ChartShowStatus
                    statusSS = ss.j
                end

                call VRSet "DT_TestCycle", "Caption", "Test" cursor "of" cycles || ":" statusWP statusSS

                if TestQuit() then signal TestDone

                if testSS then do
                    say "ChartOn"
                    ChartStarted = 0
                    call VRMethod "Application", "PutVar", "ChartStarted"
                    call ChartOn
                    ret = TestSync( "ChartStarted", 1 )
                    if ret = -1 then signal TestDone
                end

                if TestQuit() then signal TestDone

                if testWP then do
                    ReportPinkSlipDone = 0
                    call VRMethod "Application", "PutVar", "ReportPinkSlipDone"
                end
                count = TestFileAll()
                if count = -1 then signal TestDone

                call CN_EmpList_Reset
                say "CN_EmpList_Fill"
                call CN_EmpList_Fill

            end j
        end i
    end 

TestDone:
    TestWait = 0
    call VRMethod "Application", "PutVar", "TestWait"

    call VRDestroy "SW_TestStop"

return

TestFileAll: procedure expose Globals. testWP testSS
    call VRMethod "CN_EmpList", "GetRecordList", "All", "records."
    count = 0
    do i = 1 to 3 /* records.0 - 1 */

        if TestQuit() then do
            count = -1
            signal TestFileAllDone
        end

        name = VRMethod( "CN_EmpList", "GetRecordAttr", records.i, "Caption" )
        call Status "Processing" Name

        if testWP then do
            say "ReportPinkSlip" Name
            call ReportPinkSlip name, 0 /* no print */
        end

        ok = VRMethod( "CN_EmpList", "RemoveRecord", records.i )  

        if testSS then do
            say "ChartSetData"
            call ChartSetData
            say "ChartRefresh"
            call ChartRefresh
        end

        /* Wait for the first pink slip to be displayed to ensure all
           processes have a chance to get started.  Otherwise the chart or
           report routines may timeout.
        */
        if i = 1 then do
            if testWP then do
                ret = TestSync( "ReportPinkSlipDone", 1 )
                if ret = -1 then signal TestDone
            end
        end

        count = count + 1

        call Status ""
    end
TestFileAllDone:
return count

TestSync: procedure expose Globals.
    parse arg name, count
    ret = 0
    do forever
        if TestQuit() then do
            ret = -1
            signal TestSyncDone
        end
        call VRMethod "Application", "GetVar", name
        if value( name ) = count then leave
        call Status "Done" value( name ) "of" count "("name")"
        call SysSleep 2
    end
TestSyncDone:
    call Status ""
return ret

TestQuit: procedure
    event = VREvent( "N" )
    quit = event \= "nop"
return quit
/*:VRX         W_EmpList_Close
*/
W_EmpList_Close:
    call Quit
return

