/*:VRX         Main
*/
/*
    call IniMgr "Init"
    call IniMgr "Fini"
    call IniMgr "Set", name, value
    value = IniMgr( "Get", name )

    - Keep values in memory.  Only access Ini file at startup and shutdown.
*/
Main:
    signal VALUE translate( arg(1) )
exit 0

Init:
    workDir = VRGet( "Application", "WorkingDirectory" )
    iniFile = workDir || "\" || "EmpList.INI"
    
    call NameList
    do i = 1 to name.0
        value = VRGetIni( "EmpList", name.i, iniFile, "NoClose" )
        call VRMethod "Application", "PutVar", "value", "Ini" || name.i
    end
    call VRGetIni "EmpList", "Dummy", iniFile    /* Close */
exit 1

Fini:
    workDir = VRGet( "Application", "WorkingDirectory" )
    iniFile = workDir || "\" || "EmpList.INI"

    call NameList
    do i = 1 to name.0
        value = ""
        call VRMethod "Application", "GetVar", "Ini" || name.i, "value"
        call VRSetIni "EmpList", name.i, value, iniFile, "NoClose"
    end
    call VRSetIni "EmpList", "Dummy", "DUMMY", iniFile  /* Close */
exit 1

Set:
    parse arg ., name, value
    call VRMethod "Application", "PutVar", "value", "Ini" || name
exit 1

Get:
    parse arg ., name
    call VRMethod "Application", "GetVar", "Ini" || name, "value"
exit value


NameList: procedure expose name.
    name.1 = "ReportTop"
    name.2 = "ReportLeft"
    name.3 = "ChartTop"
    name.4 = "ChartLeft"
    name.5 = "Spreadsheet"
    name.6 = "Wordprocessor"
    name.7 = "DataSourceName"
    name.8 = "WordWinPath"
    name.9 = "DeScribePath"
    name.10 = "AmiProWinPath"
    name.11 = "ExcelWinPath"
    name.12 = "123GPath"
    name.13 = "AmiProPath"
    name.0 = 13
return
