/*:VRX         Main
*/
/*
    ok = SendKeys( caption, keys, timeout )

    - Wait for a window with caption "caption" to become
    active then send keys "keys".
*/
Main:
    parse arg targetCaption, keys, timeout
    retVal = 0
    if targetCaption \= "" then do
        ok = SKWait( targetCaption, timeout )
        if \ok then do
            call Error 'Unable to send "' || keys || '" to' targetCaption 'in' timeout 'seconds.'
            signal SendKeysDone
        end
    end
    ok = VRMethod( "Application", "SendKeyString", '', keys )
    if \ok then signal SendKeysDone
    call SysSleep 1
    retVal = 1
SendKeysDone:
exit retVal

/*:VRX         SKWait
*/
/*  
    ok = SKWait( caption, timeout )

    - Wait for a specified window to become active
    - Only compares up to length of <caption> so titles that change when MDI
    windows are maximized are still found.
*/
SKWait: procedure
    parse arg targetCaption, timeout

    ok = 0
    do timeout
        window = VRMethod( "Screen", "FindWindow", targetCaption, "Desktop", "descendents", "mixed", "substring" )
        if window \= "" then do
            ok=1
            call VRMethod window, "Activate"
            signal SKWFound
        end
        call SysSleep 1
    end

SKWFound:
return ok
