/*
 * main.c -- Sample mainline showing how to call a REXX macro.
 *
 */

#define INCL_DOS

#include <os2.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

extern BOOL RunInline( PSZ progbuf, ULONG proglen );

static void Usage( char *argv[] );

/*
 * Define a buffer to hold the inline program...
 */

#define PROGBUFSIZE 4096

static char Buffer[ PROGBUFSIZE ];
static char Line[ PROGBUFSIZE / 4 ];

/*
 * main -- Main entry point.  Prompt user for input.
 */

int main( int argc, char *argv[] )
  {
    ULONG len;

    /* Need at least one argument! */

    if( argc != 1 ){
        Usage( argv );
    }

    /* Prompt the user... */

    printf( "Please enter some REXX code to execute.  You can enter up to\n" );
    printf( "%d characters, splitting them across several lines if you wish.\n", PROGBUFSIZE );
    printf( "To indicate the end, simply enter a line consisting of a single\n" );
    printf( "period or press CTRL-Z:\n" );

    /* Get the input... no fancy error checking..... */

    Buffer[0] = '\0';

    for( ;; ){
        if( !fgets( Line, sizeof( Line ), stdin ) ) break;

        if( Line[0] == '.' && Line[1] == '\n' && Line[2] == '\0' ) break;

        strcat( Buffer, Line );

        /* Convert newline characters into carriage return/line feed pairs.
         * RexxStart expects the inline program to be in the same format
         * it would be on disk...
         */

        len = strlen( Buffer );

        if( Buffer[ len - 1 ] == '\n' ){
            Buffer[ len - 1 ] = '\r';
            Buffer[ len ] = '\n';
            Buffer[ len + 1 ] = '\0';
        }
    }

    RunInline( Buffer, strlen( Buffer ) );

    return( 0 );
  }

/*
 * Usage
 */

static void Usage( char *argv[] )
  {
    printf( "Usage: %s\n", argv[0] );

    exit( -1 );
  }

