/*:VRX         Main
*/
/*  Main
*/
Main:

/*  Process the arguments.
    Get the parent window.
*/
    parse source . calledAs .
    parent = ""
    argCount = arg()
    argOff = 0
    if( calledAs \= "COMMAND" )then do
        if argCount >= 1 then do
            parent = arg(1)
            argCount = argCount - 1
            argOff = 1
        end
    end
    InitArgs.0 = argCount
    if( argCount > 0 )then do i = 1 to argCount
        InitArgs.i = arg( i + argOff )
    end
    drop calledAs argCount argOff

/*  Load the windows
*/
    call VRInit
    parse source . . spec
    _VREPrimaryWindowPath = ,
        VRParseFileName( spec, "dpn" ) || ".VRW"
    _VREPrimaryWindow = ,
        VRLoad( parent, _VREPrimaryWindowPath )
    drop parent spec
    if( _VREPrimaryWindow == "" )then do
        call VRMessage "", "Cannot load window:" VRError(), ,
            "Error!"
        _VREReturnValue = 32000
        signal _VRELeaveMain
    end

/*  Process events
*/
    call Init
    signal on halt
    do while( \ VRGet( _VREPrimaryWindow, "Shutdown" ) )
        _VREEvent = VREvent()
        interpret _VREEvent
    end
_VREHalt:
    _VREReturnValue = Fini()
    call VRDestroy _VREPrimaryWindow
_VRELeaveMain:
    call VRFini
exit _VREReturnValue

VRLoadSecondary: procedure
    name = arg( 1 )

    window = VRLoad( VRWindow(), VRWindowPath(), name )
    call VRMethod window, "CenterWindow"
    call VRSet window, "Visible", 1
    call VRMethod window, "Activate"
return window

/*:VRX         Fini
*/
Fini:
    window = VRWindow()
    if TestMode \= 1 then do
        call VRSet window, 'FrameOwner', ''
        call VRSet AmiPro, 'Enabled', 1
        call VRMethod AmiPro, 'Activate'
    end
    call VRSet window, "Visible", 0
    drop window
return 0

/*:VRX         GetCurrentValues
*/
GetCurrentValues: procedure expose Globals.
    value = VRGet( "EF_1", "Value" )
    expanded = VRExpandFileName( value )
    Globals.!CurrentPath = VRParseFileName( expanded, "DP" )
    Globals.!CurrentPath = Globals.!CurrentPath || "\"
    exists = (VRFileExists( expanded ) = 1),
           & (VRIsDir( expanded ) \= 1)
    if exists = 1 then do
        Globals.!CurrentFile = expanded
    end
    else do
        Globals.!CurrentFile = ""
        Globals.!CurrentMask = VRParseFileName( expanded, "NE" ) 
    end
return

/*:VRX         Halt
*/
Halt:
    signal _VREHalt
return

/*:VRX         Init
*/
/*
    NOTE: Ami Pro 3.0 and 3.0a will GPF if a call to an external REXX
    function contains omitted arguments.
*/
Init:
    call RXFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
    call SysLoadFuncs

/*  Assume a dummy argument is passed when testing from
    the VX-REXX design environment.
*/
    TestMode = (InitArgs.0 > 0)

/* Use Globals.!XXX for global variables to simplify expose statements
*/
    Globals. = ""

    window = VRWindow()
    call VRMethod window, "CenterWindow"

    if TestMode \= 1 then do
        AmiPro = VRMethod( 'Application', 'GetActiveWindow' )
/*        call VRSet window, 'FrameOwner', AmiPro
       call VRSet AmiPro, 'Enabled', 0
*/
    end

    call VRSet window, "Visible", 1
    call VRMethod window, "Activate"
    drop window

    call VRSet "EF_1", "Value", "*.BMP"
    call NewFileList
 
    call VRSet "PB_Cancel", "Enabled", 1
    call VRSet "PB_Browse", "Enabled", 1

return

/*:VRX         LB_1_Click
*/
LB_1_Click:
    selected = VRGet( "LB_1", "SelectedString" )
    file = Globals.!CurrentPath || selected

    call VRSet "EF_1", "Value", file
    call VRSet "Pict_1", "PicturePath", file
 
    call VRSet "PB_OK", "Enabled", 1
return

/*:VRX         NewFileList
*/
NewFileList: procedure expose Globals.
    call VRSet "LB_1", "Painting", 0
    ok = VRMethod( "LB_1", "Clear" )
    call GetCurrentValues
/*
    s = VRDir( Globals.!CurrentPath || Globals.!CurrentMask, "N" )
    do while s <> ""
        position = VRMethod( "LB_1", "AddString", s )
        s = VRDir( , "N" )
    end
*/
    mask = Globals.!CurrentPath || Globals.!CurrentMask
    call SysFileTree mask, "fileList.", "FO"
    do i = 1 to fileList.0
        file = VRParseFileName( fileList.i, "NE" )
        call VRMethod "LB_1", "AddString", file 
    end
    
    call VRSet "LB_1", "Selected", 1
    call VRSet "LB_1", "Painting", 1
return

/*:VRX         PB_Browse_Click
*/
PB_Browse_Click: 
/*  Open a file dialog with the current mask
*/
    call GetCurrentValues
    FileName = VRFileDialog( VRWindow(), "Select a file", "Open", Globals.!CurrentMask )
    if FileName = "" then signal quitPB_3_Click

/*  Set the current path and fill the list box
*/
    call VRSet "EF_1", "Value", FileName
    Globals.!CurrentMask = "*." || VRParseFileName( FileName, "E" )
    call NewFileList
    call VRFlush 

/*  Set the current file to the just selected file
*/
    file = VRParseFileName( FileName, "NE" )
    position = VRMethod( "LB_1", "FindString", file, 1, "Exact" )
    call VRSet "LB_1", "Selected", position

quitPB_3_Click:
return

 
/*:VRX         PB_Cancel_Click
*/
PB_Cancel_Click:
    call Quit
return

/*:VRX         PB_OK_Click
*/
PB_OK_Click:
    call GetCurrentValues
    if Globals.!CurrentFile = "" then do
        call NewFileList
        return
    end
    if TestMode \= 1 then do
        call ImportPicture "Bitmap", Globals.!CurrentFile, ".BMP", 0
    end
    call Quit
return

/*:VRX         Quit
*/
Quit:
    window = VRWindow()
    call VRSet window, "Shutdown", 1
    drop window
return

/*:VRX         Window1_Close
*/
Window1_Close:
    call Quit
return

