/*:VRX         Main
*/
/*  Main
*/
Main:
/*  Process the arguments.
    Get the parent window.
*/
    parse source . calledAs .
    parent = ""
    argCount = arg()
    argOff = 0
    if( calledAs \= "COMMAND" )then do
        if argCount >= 1 then do
            parent = arg(1)
            argCount = argCount - 1
            argOff = 1
        end
    end; else do
        call VROptions 'ImplicitNames'
    end
    InitArgs.0 = argCount
    if( argCount > 0 )then do i = 1 to argCount
        InitArgs.i = arg( i + argOff )
    end
    drop calledAs argCount argOff

/*  Load the windows
*/
    call VRInit
    parse source . . spec
    _VREPrimaryWindowPath = ,
        VRParseFileName( spec, "dpn" ) || ".VRW"
    _VREPrimaryWindow = ,
        VRLoad( parent, _VREPrimaryWindowPath )
    drop parent spec
    if( _VREPrimaryWindow == "" )then do
        call VRMessage "", "Cannot load window:" VRError(), ,
            "Error!"
        _VREReturnValue = 32000
        signal _VRELeaveMain
    end

/*  Process events
*/
    call Init
    signal on halt
    do while( \ VRGet( _VREPrimaryWindow, "Shutdown" ) )
        _VREEvent = VREvent()
        interpret _VREEvent
    end
_VREHalt:
    _VREReturnValue = Fini()
    call VRDestroy _VREPrimaryWindow
_VRELeaveMain:
    call VRFini
exit _VREReturnValue

VRLoadSecondary:
    __vrlsWait = abbrev( 'WAIT', translate(arg(2)), 1 )
    if __vrlsWait then do
        call VRFlush
    end
    __vrlsHWnd = VRLoad( VRWindow(), VRWindowPath(), arg(1) )
    if __vrlsHWnd = '' then signal __vrlsDone
    if __vrlsWait \= 1 then signal __vrlsDone
    call VRSet __vrlsHWnd, 'WindowMode', 'Modal' 
    __vrlsTmp = __vrlsWindows.0
    if( DataType(__vrlsTmp) \= 'NUM' ) then do
        __vrlsTmp = 1
    end
    else do
        __vrlsTmp = __vrlsTmp + 1
    end
    __vrlsWindows.__vrlsTmp = VRWindow( __vrlsHWnd )
    __vrlsWindows.0 = __vrlsTmp
    do while( VRIsValidObject( VRWindow() ) = 1 )
        __vrlsEvent = VREvent()
        interpret __vrlsEvent
    end
    __vrlsTmp = __vrlsWindows.0
    __vrlsWindows.0 = __vrlsTmp - 1
    call VRWindow __vrlsWindows.__vrlsTmp 
    __vrlsHWnd = ''
__vrlsDone:
return __vrlsHWnd

/*:VRX         __VXREXX____APPENDS__
*/
__VXREXX____APPENDS__:
/*
*/
return
/*:VRX         CN_QRY_2_EndEdit
*/
CN_QRY_2_EndEdit:
    record = VRInfo( "Record" )
    if( VRInfo("Cancelled") = 1 ) then do
        ok = VRMethod( "CN_QRY_2", "DBReset", record )
        if( \ok ) then do
            status = VRGet( "QRY_CustList", "Status" )
            call VRMessage VRWindow(), "Could not reset record:" status, "Error", "E"
        end
    end
    else do
        ok = VRMethod( "CN_QRY_2", "DBUpdate", record )
        if( \ok ) then do
            status = VRGet( "QRY_CustList", "Status" )
            call VRMessage VRWindow(), "Could not update record:" status, "Error", "E"
        end
    end

return
nd

return
/*:VRX         CN_QRY_3_Click
*/
CN_QRY_3_Click: 
    custnum = VRMethod( "CN_QRY_3", "GetFieldData", VRInfo( "Record" ), "CUSTNUM" )
    call VRSet "EF_QRY_Customer_CUSTNUM", "Value", custnum
return

/*:VRX         CNCT_1_Fini
*/
CNCT_1_Fini:
 
    /*  Disconnect from the database
    */
    if( VRGet( "CNCT_1", "Connected" ) = 1 ) then do
        if( VRGet( "CNCT_1", "Changed" ) = 1 ) then do
            __message = "Changes have been made. Press Save to save them or Discard to throw them away."
            __button.0 = 2
            __button.1 = "~Save"
            __button.2 = "~Discard"
            __retcode = VRMessage( VRWindow(), __message, "Confirm", "Q", "__button.", 1, 2 )
            if( __retcode = 1 ) then do
              __method = "Commit"
            end
            else do
              __method = "Rollback"
            end
            if( VRMethod( "CNCT_1", __method ) = 0 ) then do
                call VRMessage VRWindow(), method "failed:",
                    VRGet( "CNCT_1", "Status" ), "Error", "E"
            end
        end
        if( VRMethod( "CNCT_1", "Disconnect" ) = 0 ) then do
            call VRMessage VRWindow(), "Could not close connection:",
                VRGet( "CNCT_1", "Status" ), "Error", "E"
        end
    end
return
/*:VRX         CNCT_1_Init
*/
CNCT_1_Init:
    /* Choose a database type */

    database_type = DBCnct( VRWindow() )

    if( database_type = "Abort" ) then do
        call Halt
    end

    /* Modify the connection object according to the selected database type.
    */

    if( database_type = "WSQL" ) then do
        call VRSet "CNCT_1", "DataSource", "WATCOM SQL"
        call VRSet "CNCT_1", "userid", "dba"
        call VRSet "CNCT_1", "password", "sql"

        fspec = FindSampleDB()
        call VRSet "CNCT_1", "database", fspec
    end
    else do
        /* IBM DB2/2 was choosen
        */

        call VRSet "CNCT_1", "DataSource", "IBM DB2/2"
        call VRSet "CNCT_1", "userid", ""
        call VRSet "CNCT_1", "password", ""
        call VRSet "CNCT_1", "database", "wsample"
    end

    /*  Connect to the database
    */
    if( VRGet( "CNCT_1", "Connected" ) = 0 ) then do
        if( VRMethod( "CNCT_1", "Connect" ) = 0 ) then do
            call VRMessage VRWindow(), "Could not open connection:",
                VRGet( "CNCT_1", "Status" ), "Error", "E"
        end
    end
return
/*:VRX         EF_Customer_Name_Update
*/
EF_Customer_Name_Update: 
    list.0=1
    list.1.!Column = "CUSTNUM"
    list.1.!Value = VRGet( "EF_Query_Order_CUSTNUM", "Value" )
    call VRMethod "QRY_Customer_Name", "Search", "=", ,"list."
return
/*:VRX         EF_QRY_1_ORDERNUM_Change
*/
EF_QRY_1_ORDERNUM_Change:
    call QRY_1_TextBoxChange
return
/*:VRX         EF_QRY_Customer_CUSTNUM_Change
*/
EF_QRY_Customer_CUSTNUM_Change:
    call QRY_Customer_TextBoxChange
return
/*:VRX         EF_QRY_Order_DATE_Change
*/
EF_QRY_Order_DATE_Change: 
    call QRY_Order_TextBoxChange
return

/*:VRX         EF_QRY_Order_ORDERNUM_Change
*/
EF_QRY_Order_ORDERNUM_Change: 
    call QRY_Order_TextBoxChange
return

/*:VRX         EF_Query_Customer_ORDERNUM_Change
*/
EF_Query_Customer_ORDERNUM_Change: 
    call QRY_Customer_TextBoxChange
return

/*:VRX         EF_Query_Order_CUSTNUM_Change
*/
EF_Query_Order_CUSTNUM_Change: 
    call QRY_Order_TextBoxChange
return

/*:VRX         EF_Query_Order_CUSTNUM_LostFocus
*/
EF_Query_Order_CUSTNUM_LostFocus: 
    call EF_Customer_Name_Update
return

/*:VRX         FindSampleDB
*/
FindSampleDB: procedure
    /* Finds the location of the WATCOM SQL VX-Rexx database
    */

    vxdir = VALUE( 'vxrexx', , 'os2environment' )

    if( RIGHT(vxdir, 1) = '\' ) then do
        vxdir = LEFT( vxdir, LENGTH(vxdir) - 1 )
    end

    vxdir = vxdir || "\wsample.db"

return vxdir
/*:VRX         Fini
*/
Fini:
    call QRY_1_Fini
    call CNCT_1_Fini
    window = VRWindow()
    call VRSet window, "Visible", 0
    drop window
return 0

/*:VRX         Halt
*/
Halt:
    signal _VREHalt
return

/*:VRX         Init
*/
Init:
    call CNCT_1_Init
    call QRY_1_Init

    call VRMethod "QRY_1", "BindVar", "Globals.!OrderNumValue", "OrderNum"

    call PostQueue 'call PostQueue "call Refresh" '
    /* 
     * This is a hack to initialize the fields later.
     */

    window = VRWindow()
    call VRMethod window, "CenterWindow"
    call VRSet window, "Visible", 1
    call VRMethod window, "Activate"
    drop window
return

/*:VRX         MLE_1_Change
*/
MLE_1_Change: 
    call QRY_Order_TextBoxChange
return

/*:VRX         PB_1_Click
*/
PB_1_Click: 
    call Refresh
return

/*:VRX         PB_QRY_1_First_Click
*/
PB_QRY_1_First_Click:
    call VRMethod "QRY_1", "MoveFirst"
    call QRY_1_TextBoxChange

return
/*:VRX         PB_QRY_1_Last_Click
*/
PB_QRY_1_Last_Click:
    call VRMethod "QRY_1", "MoveLast"
    call QRY_1_TextBoxChange

return
/*:VRX         PB_QRY_1_Next_Click
*/
PB_QRY_1_Next_Click:
    call VRMethod "QRY_1", "MoveNext"
    call QRY_1_TextBoxChange

return
/*:VRX         PB_QRY_1_Prev_Click
*/
PB_QRY_1_Prev_Click:
    call VRMethod "QRY_1", "MovePrev"
    call QRY_1_TextBoxChange

return
/*:VRX         PB_QRY_1_Search_Click
*/
PB_QRY_1_Search_Click:
    ok = VRMethod( "QRY_1", "Search" )
    if( ok = 0 ) then do
        call VRMessage VRWindow(),,
                       "Could not search:" VRGet( "QRY_1", "Status" ),,
                       "Error", "E"
    end
    call QRY_1_TextBoxChange

return
/*:VRX         PB_QRY_Customer_Update_Click
*/
PB_QRY_Customer_Update_Click:
    ok = VRMethod( "QRY_Customer", "Update" )
    if( ok = 0 ) then do
        call VRMessage VRWindow(),,
                       "Could not update:" VRGet( "QRY_Customer", "Status" ),,
                       "Error", "E"
    end
    call QRY_Customer_TextBoxChange

return
/*:VRX         PB_QRY_Order_Reset_Click
*/
PB_QRY_Order_Reset_Click:
    ok = VRMethod( "QRY_Order", "Reset" )
    if( ok = 0 ) then do
        call VRMessage VRWindow(),,
                       "Could not reset:" VRGet( "QRY_Order", "Status" ),,
                       "Error", "E"
    end
    call QRY_Order_TextBoxChange

return
/*:VRX         PB_QRY_Order_Update_Click
*/
PB_QRY_Order_Update_Click:
    ok = VRMethod( "QRY_Order", "Update" )
    if( ok = 0 ) then do
        call VRMessage VRWindow(),,
                       "Could not update:" VRGet( "QRY_Order", "Status" ),,
                       "Error", "E"
    end
    call QRY_Order_TextBoxChange

return
/*:VRX         PostQueue
*/
PostQueue:
    call VRMethod "Application", "PostQueue", 0, 0, arg(1)
return

/*:VRX         QRY_1_Fetch
*/
QRY_1_Fetch: 
    call Refresh
return
/*:VRX         QRY_1_Fini
*/
QRY_1_Fini:
 
    /*  Close the query
    */
    if( VRGet( "QRY_1", "Opened" ) = 1 ) then do
 
        /*  Save most recent changes
        */
        if( VRGet("QRY_1", "RowChanged" ) ) then do
            if( VRMethod( "QRY_1", "Update" ) = 0 ) then do
                call VRMessage VRWindow(), "Could not update database:",
                           VRGet( "QRY_1", "Status" ) || ".",
                           "Latest changes will not be saved.",,
                           "Error", "E"
            end
        end
 
        /*  Close the query
        */
        if( VRMethod( "QRY_1", "Close" ) = 0 ) then do
            call VRMessage VRWindow(), "Could not close query:",
                VRGet( "QRY_1", "Status" ), "Error","E"
        end
    end
return
/*:VRX         QRY_1_Init
*/
QRY_1_Init:
    /*  Open the query
    */
    if( VRGet( "QRY_1", "Opened" ) = 0 ) then do
        if( VRMethod( "QRY_1", "Open" ) = 0 ) then do
            call VRMessage VRWindow(), "Could not open query:",
                VRGet( "QRY_1", "Status" ), "Error", "E"
        end
    end
return
/*:VRX         QRY_1_TextBoxChange
*/
QRY_1_TextBoxChange: procedure expose Globals.
    queryName = "QRY_1"
    rowChanged = VRGet( queryName, "RowChanged" )

    button = "PB_" || queryName || "_Delete"
    if( VRIsValidObject( button ) ) then do
        call VRSet button, "Enabled", \rowChanged
    end

    button = "PB_" || queryName || "_Insert"
    if( VRIsValidObject( button ) ) then do
        call VRSet button, "Enabled", rowChanged
    end

    button = "PB_" || queryName || "_Reset"
    if( VRIsValidObject( button ) ) then do
        call VRSet button, "Enabled", rowChanged
    end

    button = "PB_" || queryName || "_Update"
    if( VRIsValidObject( button ) ) then do
        call VRSet button, "Enabled", rowChanged
    end

return
/*:VRX         QRY_CustList_Fini
*/
QRY_CustList_Fini:
 
    /*  Close the query
    */
    if( VRGet( "QRY_CustList", "Opened" ) = 1 ) then do
 
        /*  Save most recent changes
        */
        if( VRGet("QRY_CustList", "RowChanged" ) ) then do
            if( VRMethod( "QRY_CustList", "Update" ) = 0 ) then do
                call VRMessage VRWindow(), "Could not update database:",
                           VRGet( "QRY_CustList", "Status" ) || ".",
                           "Latest changes will not be saved.",,
                           "Error", "E"
            end
        end
 
        /*  Close the query
        */
        if( VRMethod( "QRY_CustList", "Close" ) = 0 ) then do
            call VRMessage VRWindow(), "Could not close query:",
                VRGet( "QRY_CustList", "Status" ), "Error","E"
        end
    end
return
/*:VRX         QRY_CustList_Init
*/
QRY_CustList_Init:
 
    /*  Open the query
    */
    if( VRGet( "QRY_CustList", "Opened" ) = 0 ) then do
        if( VRMethod( "QRY_CustList", "Open" ) = 0 ) then do
            call VRMessage VRWindow(), "Could not open query:",
                VRGet( "QRY_CustList", "Status" ), "Error", "E"
        end
    end
return
/*:VRX         QRY_Customer_Fini
*/
QRY_Customer_Fini:
 
    /*  Close the query
    */
    if( VRGet( "QRY_Customer", "Opened" ) = 1 ) then do
 
        /*  Save most recent changes
        */
        if( VRGet("QRY_Customer", "RowChanged" ) ) then do
            if( VRMethod( "QRY_Customer", "Update" ) = 0 ) then do
                call VRMessage VRWindow(), "Could not update database:",
                           VRGet( "QRY_Customer", "Status" ) || ".",
                           "Latest changes will not be saved.",,
                           "Error", "E"
            end
        end
 
        /*  Close the query
        */
        if( VRMethod( "QRY_Customer", "Close" ) = 0 ) then do
            call VRMessage VRWindow(), "Could not close query:",
                VRGet( "QRY_Customer", "Status" ), "Error","E"
        end
    end
return
/*:VRX         QRY_Customer_Init
*/
QRY_Customer_Init:
 
    /*  Open the query
    */
    if( VRGet( "QRY_Customer", "Opened" ) = 0 ) then do
        if( VRMethod( "QRY_Customer", "Open" ) = 0 ) then do
            call VRMessage VRWindow(), "Could not open query:",
                VRGet( "QRY_Customer", "Status" ), "Error", "E"
        end
    end
return
/*:VRX         QRY_Customer_Name_Fini
*/
QRY_Customer_Name_Fini:
 
    /*  Close the query
    */
    if( VRGet( "QRY_Customer_Name", "Opened" ) = 1 ) then do
 
        /*  Save most recent changes
        */
        if( VRGet("QRY_Customer_Name", "RowChanged" ) ) then do
            if( VRMethod( "QRY_Customer_Name", "Update" ) = 0 ) then do
                call VRMessage VRWindow(), "Could not update database:",
                           VRGet( "QRY_Customer_Name", "Status" ) || ".",
                           "Latest changes will not be saved.",,
                           "Error", "E"
            end
        end
 
        /*  Close the query
        */
        if( VRMethod( "QRY_Customer_Name", "Close" ) = 0 ) then do
            call VRMessage VRWindow(), "Could not close query:",
                VRGet( "QRY_Customer_Name", "Status" ), "Error","E"
        end
    end
return
/*:VRX         QRY_Customer_Name_Init
*/
QRY_Customer_Name_Init:
 
    /*  Open the query
    */
    if( VRGet( "QRY_Customer_Name", "Opened" ) = 0 ) then do
        if( VRMethod( "QRY_Customer_Name", "Open" ) = 0 ) then do
            call VRMessage VRWindow(), "Could not open query:",
                VRGet( "QRY_Customer_Name", "Status" ), "Error", "E"
        end
    end
return
/*:VRX         QRY_Customer_TextBoxChange
*/
QRY_Customer_TextBoxChange: procedure expose Globals.
    queryName = "QRY_Customer"
    rowChanged = VRGet( queryName, "RowChanged" )

    button = "PB_" || queryName || "_Delete"
    if( VRIsValidObject( button ) ) then do
        call VRSet button, "Enabled", \rowChanged
    end

    button = "PB_" || queryName || "_Insert"
    if( VRIsValidObject( button ) ) then do
        call VRSet button, "Enabled", rowChanged
    end

    button = "PB_" || queryName || "_Reset"
    if( VRIsValidObject( button ) ) then do
        call VRSet button, "Enabled", rowChanged
    end

    button = "PB_" || queryName || "_Update"
    if( VRIsValidObject( button ) ) then do
        call VRSet button, "Enabled", rowChanged
    end

return
/*:VRX         QRY_Order_Fini
*/
QRY_Order_Fini:
 
    /*  Close the query
    */
    if( VRGet( "QRY_Order", "Opened" ) = 1 ) then do
 
        /*  Save most recent changes
        */
        if( VRGet("QRY_Order", "RowChanged" ) ) then do
            if( VRMethod( "QRY_Order", "Update" ) = 0 ) then do
                call VRMessage VRWindow(), "Could not update database:",
                           VRGet( "QRY_Order", "Status" ) || ".",
                           "Latest changes will not be saved.",,
                           "Error", "E"
            end
        end
 
        /*  Close the query
        */
        if( VRMethod( "QRY_Order", "Close" ) = 0 ) then do
            call VRMessage VRWindow(), "Could not close query:",
                VRGet( "QRY_Order", "Status" ), "Error","E"
        end
    end
return
/*:VRX         QRY_Order_Init
*/
QRY_Order_Init:
 
    /*  Open the query
    */
    if( VRGet( "QRY_Order", "Opened" ) = 0 ) then do
        if( VRMethod( "QRY_Order", "Open" ) = 0 ) then do
            call VRMessage VRWindow(), "Could not open query:",
                VRGet( "QRY_Order", "Status" ), "Error", "E"
        end
    end
return
/*:VRX         QRY_Order_TextBoxChange
*/
QRY_Order_TextBoxChange: procedure expose Globals.
    queryName = "QRY_Order"
    rowChanged = VRGet( queryName, "RowChanged" )

    button = "PB_" || queryName || "_Delete"
    if( VRIsValidObject( button ) ) then do
        call VRSet button, "Enabled", \rowChanged
    end

    button = "PB_" || queryName || "_Insert"
    if( VRIsValidObject( button ) ) then do
        call VRSet button, "Enabled", rowChanged
    end

    button = "PB_" || queryName || "_Reset"
    if( VRIsValidObject( button ) ) then do
        call VRSet button, "Enabled", rowChanged
    end

    button = "PB_" || queryName || "_Update"
    if( VRIsValidObject( button ) ) then do
        call VRSet button, "Enabled", rowChanged
    end

return
/*:VRX         QRY_OrderItm_Fini
*/
QRY_OrderItm_Fini:
 
    /*  Close the query
    */
    if( VRGet( "QRY_OrderItm", "Opened" ) = 1 ) then do
 
        /*  Save most recent changes
        */
        if( VRGet("QRY_OrderItm", "RowChanged" ) ) then do
            if( VRMethod( "QRY_OrderItm", "Update" ) = 0 ) then do
                call VRMessage VRWindow(), "Could not update database:",
                           VRGet( "QRY_OrderItm", "Status" ) || ".",
                           "Latest changes will not be saved.",,
                           "Error", "E"
            end
        end
 
        /*  Close the query
        */
        if( VRMethod( "QRY_OrderItm", "Close" ) = 0 ) then do
            call VRMessage VRWindow(), "Could not close query:",
                VRGet( "QRY_OrderItm", "Status" ), "Error","E"
        end
    end
return
/*:VRX         QRY_OrderItm_Init
*/
QRY_OrderItm_Init:
 
    /*  Open the query
    */
    if( VRGet( "QRY_OrderItm", "Opened" ) = 0 ) then do
        if( VRMethod( "QRY_OrderItm", "Open" ) = 0 ) then do
            call VRMessage VRWindow(), "Could not open query:",
                VRGet( "QRY_OrderItm", "Status" ), "Error", "E"
        end
    end
return
/*:VRX         Quit
*/
Quit:
    window = VRWindow()
    call VRSet window, "Shutdown", 1
    drop window
return

/*:VRX         Refresh
*/
Refresh: 
    list.0 = 1
    list.1.!Column = "OrderNum"
    list.1.!Value = Globals.!OrderNumValue

    call VRMethod "QRY_OrderItm", "Search", "=", "AND", "List."
    call VRMethod "QRY_Order", "Search", "=", "AND", "List."
    call VRMethod "QRY_Customer", "Search", "=", "AND", "List."
    
    call EF_Customer_Name_Update
return
/*:VRX         SW_Customer_Close
*/
SW_Customer_Close: 
    call SW_Customer_Fini
return

/*:VRX         SW_Customer_Create
*/
SW_Customer_Create: 
    call SW_Customer_Init
return

/*:VRX         SW_Customer_Fini
*/
SW_Customer_Fini: 
    call QRY_CustList_Fini
    call QRY_Customer_Fini
    call QRY_Customer_Page_Fini
    call QRY_Customer_Information_Fini
    window = VRInfo( "Window" )
    call VRDestroy window
    drop window
return
/*:VRX         SW_Customer_Init
*/
SW_Customer_Init: 
    call QRY_CustList_Init
    call QRY_Customer_Init
    window = VRInfo( "Object" )
    if( \VRIsChildOf( window, "Notebook" ) ) then do
        call VRMethod window, "CenterWindow"
        call VRSet window, "Visible", 1
        call VRMethod window, "Activate"
    end
    drop window
return

/*:VRX         SW_Order_Close
*/
SW_Order_Close: 
    call SW_Order_Fini
return

/*:VRX         SW_Order_Create
*/
SW_Order_Create: 
    call SW_Order_Init
return

/*:VRX         SW_Order_Fini
*/
SW_Order_Fini: 
    call QRY_Customer_Name_Fini
    call QRY_Order_Fini
    window = VRInfo( "Window" )
    call VRDestroy window
    drop window
return
/*:VRX         SW_Order_Init
*/
SW_Order_Init: 
    call QRY_Customer_Name_Init
    call QRY_Order_Init
    window = VRInfo( "Object" )
    if( \VRIsChildOf( window, "Notebook" ) ) then do
        call VRMethod window, "CenterWindow"
        call VRSet window, "Visible", 1
        call VRMethod window, "Activate"
    end
    drop window
return

/*:VRX         SW_Orderitm_Close
*/
SW_Orderitm_Close: 
    call SW_Orderitm_Fini
return

/*:VRX         SW_Orderitm_Create
*/
SW_Orderitm_Create: 
    call SW_Orderitm_Init
return

/*:VRX         SW_Orderitm_Fini
*/
SW_Orderitm_Fini: 
    call QRY_OrderItm_Fini
    window = VRInfo( "Window" )
    call VRDestroy window
    drop window
return
/*:VRX         SW_Orderitm_Init
*/
SW_Orderitm_Init: 
    call QRY_OrderItm_Init
    window = VRInfo( "Object" )
    if( \VRIsChildOf( window, "Notebook" ) ) then do
        call VRMethod window, "CenterWindow"
        call VRSet window, "Visible", 1
        call VRMethod window, "Activate"
    end
    drop window
return

/*:VRX         Window1_Close
*/
Window1_Close:
    call Quit
return

