/* -------------------------------------------------------------------

	Project: 

	Objective-C interface file for the class DBIndex

	COPYRIGHT (C), 1996, Thomas Baier
	ALL RIGHTS RESERVED.

	Date:				Rev:
	1996-Jan-01			___

 */

#ifndef _DBINDEX_H_
#define _DBINDEX_H_

/*====================================================================
                      Interface of class DBIndex                      
====================================================================*/
#include <sys/types.h>
#include <limits.h>
#include <db.h>

#include <objc/Object.h>
#include <db/DBFile.h>
#include <db/DBField.h>

@interface DBIndex : Object
{
  const char *fileName;
  DBFile     *entity;
  DBField    *property;

  DB  *indexFile;
  DBT  dbt_key;
  DBT  dbt_data;

  id    searchArguments;
  char *lowerBound;
  char *upperBound;
}

/* -------------------------- Initialize -------------------------- */
-initName: (const char *) aName entity: (DBFile *) anEntity property: (DBField *) aProperty;

/* ----------------------------- Free ----------------------------- */
-free;

/* ----------- Methods for access to Instance Variables ----------- */
-setSearchArguments: args;
-searchArguments;

/* ------------------------ Public methods ------------------------ */
-(BOOL) findFirst;
-(BOOL) findNext;
-(long) currentRecord;

/* ----------------------- Private methods ------------------------ */

/* ---------------------- Archiving methods ----------------------- */

@end
#endif

