//
// Class definition header file for dbfLIB++ Version 3.1
// (c) Copyright 1996-1997, dSOFT Development Inc.
//

#ifndef _CDBF_INCLUDED_
#define _CDBF_INCLUDED_

#if (NT || WIN_32)
#include <windows.h>
#endif

#include "dbfLIB.h"
#include "string.h"

//
// Currently defined size to allocate for memo fields
// (0x1000 == 4096)
#define MEMO_BUF_SIZE   0x1000

//
// Get/Set constants
//
#define ALLOW_NULLS		0x00000000
#define AUTO_PACK		0x00000001
#define CENTURY			0x00000002
#define DATE_FORMAT		0x00000003
#define OPEN_MODE		0x00000004
#define BLOCK_SIZE		0x00000005
#define LOCK_TYPE		0x00000006
#define PADDING			0x00000007
#define UNIQUE			0x00000008
#define DELETED			0x00000009

///////////////////////////////////////////////////////////////////////////
//	CLASS: CDbfLib
//
//  dbfLIB++ base class
//
class CDbfLib
{
// Construction
public:
	CDbfLib();	// standard constructor
	~CDbfLib(); // standard destructor

// Class data (private)
private:
	DS_CHAR VerStr[8];
    DS_CHAR m_DateFormatBuf[33];

// Operations 
public:
	DS_ULONG  AllowNulls( void ){return((DS_ULONG)::GetAllowNulls());}
	DS_ULONG  AllowNulls(DS_ULONG OnOff ){return((DS_ULONG)::SetAllowNulls(OnOff));}

	DS_ULONG  AutoPack( void ){return((DS_ULONG)::GetAutoPack());}
	DS_ULONG  AutoPack(DS_ULONG OnOff ){return((DS_ULONG)::SetAutoPack(OnOff));}

	DS_ULONG Century( void ){return(::GetCentury());}
	DS_ULONG Century(DS_ULONG Century){return(::SetCentury(Century));}

	PDS_CHAR GetDateFormat( PDS_CHAR pBuf){return(::GetDbfDateFormat(pBuf));}
	PDS_CHAR GetDateFormat(){return(::GetDbfDateFormat(m_DateFormatBuf));}
	DS_LONG  SetDateFormat( PDS_CHAR NewFmt){return(::SetDbfDateFormat(NewFmt));}

	DS_ULONG OpenMode( void ){return(::GetDbfOpenMode());}
	DS_ULONG OpenMode(DS_ULONG Setting){return(::SetDbfOpenMode(Setting));}

	DS_LONG  DefaultBlockSize( void ){return(::GetDefaultBlockSize());}
	DS_LONG  DefaultBlockSize(DS_LONG Blocksize){return(::SetDefaultBlockSize((DS_SHORT)Blocksize));}

	DS_LONG  DefaultLockType( void ){return(::GetDefaultLockType());}
	DS_LONG  DefaultLockType(DS_LONG Type){return(::SetDefaultLockType((DS_SHORT)Type));}

	DS_ULONG  Padding( void ){return(::GetPadding());}
	DS_ULONG  Padding( DS_UCHAR OnOff ){return(::SetPadding(OnOff));}

	DS_ULONG  Unique( void ){return((DS_ULONG)::GetUnique());}
	DS_ULONG  Unique( DS_UCHAR OnOff ){return((DS_ULONG)::SetUnique(OnOff));}

	DS_ULONG  Deleted( void ){return((DS_ULONG)::GetDeleted());}
	DS_ULONG  Deleted( DS_UCHAR OnOff ){return((DS_ULONG)::SetDeleted(OnOff));}


	DS_ULONG Set( DS_ULONG Setting, DS_ULONG SetValue );
	DS_ULONG Set( DS_ULONG Setting, PDS_CHAR pDateFmt );
	DS_ULONG Get( DS_ULONG Setting );
	DS_ULONG Get( DS_ULONG Setting, PDS_CHAR pDateFmt );

	PDS_CHAR Version();
}; // class CDbfLib


////////////////////////////////////////////////////////////////////////
// 	CLASS: CFld
//
//	dbfLIB++ field class
//
class CFld
{
// Construction
public:
	CFld();	// standard constructor
	CFld( PDBF pDbfHandle,  PDS_CHAR pFldName ); // initialized construction
    CFld( PDBFFLD pFldDef );
    CFld( PDS_CHAR pFldName, DS_CHAR cType, int Length, int Dec );
	~CFld();

// Class data (private)
private:
	PDBF     pDbf;
	PDS_CHAR pFldPtr;
	DS_SHORT sFldRef;

	DS_SHORT sFldLen;
	DS_SHORT sFldDec;
	DS_CHAR  cFldType;
	DS_CHAR  szFieldName[11];
	DS_SHORT sNewFldLen;
	DS_SHORT sNewFldDec;
	DS_CHAR  cNewFldType;
	DS_CHAR  szNewFieldName[11];
	DS_ULONG bRemove;
	DS_ULONG bModified;

// Class data (public)
public:
	PDS_CHAR pMemoBuf;

// Implementation                                                        
public:
	DS_LONG Init( PDBF pDbf,  PDS_CHAR pFldName );
	DS_LONG ChangeName(  PDS_CHAR pNewName );
	void DeleteField();
	PDS_CHAR GetDate(  PDS_CHAR pDateBuf, int nBufsize );
	PDS_CHAR FieldName(  PDS_CHAR pNameBuf, int nBufsize );
    PDS_CHAR FieldName();
	DS_CHAR  FieldType(){ return( cFldType );}
	DS_LONG  FieldLength() { return( (DS_LONG)sFldLen);}
	DS_LONG  Decimals(){ return( (DS_LONG)sFldDec); }
	PDS_CHAR GetString(  PDS_CHAR pStrBuf, int nBufsize );
	DS_DOUBLE GetValue();

	DS_LONG SetDate( PDS_CHAR pDate);
	DS_LONG SetDate( PDS_CHAR pDate, PDS_CHAR pFormat);
	void SetFalse();
	DS_LONG SetString(  PDS_CHAR pStrBuf );
	void SetTrue();
	void SetValue( DS_DOUBLE dVal );
	void SetValue(  PDS_CHAR pBuf );

// Assignment operations
	void operator= (  PDS_CHAR pBuf );
	void operator= ( DS_DOUBLE dVal );

// inline functions
	PDS_CHAR FieldPointer(){ return( pFldPtr ); }
	DS_LONG FieldRef(){ return( (DS_LONG)sFldRef ); }
	PDBF  GetDbfHandle(){ return( pDbf ); }
	PDS_CHAR GetMemoPointer() {return (pMemoBuf); }
	DS_LONG  IsTrue( ) { return( FldTrue( pDbf, sFldRef )); }
	DS_LONG  ReadMemo(){ return((DS_LONG)MemoRead(pDbf, sFldRef, pDbf->recno, pMemoBuf, MEMO_BUF_SIZE));}
	DS_LONG  ReadMemo(PDS_CHAR pBuf, int nBufsize){ return((DS_LONG)MemoRead(pDbf, sFldRef, pDbf->recno, pBuf, (DS_SHORT)nBufsize));}
	DS_LONG  WriteMemo(){ return((DS_LONG)MemoWrite(pDbf,sFldRef,pDbf->recno,pMemoBuf,strlen(pMemoBuf)));}
	DS_LONG  WriteMemo(PDS_CHAR pBuf){ return((DS_LONG)MemoWrite(pDbf,sFldRef,pDbf->recno,pBuf,strlen(pBuf)));}

    // Field setup operations...
    // Useful when modifying database structures on an
    // existing database.  These functions are also useful 
    // for setting up a CFld to be added to a database 
    // through CDbf::AddField()
    //
    DS_LONG SetFieldName( PDS_CHAR pFieldName );
	DS_LONG SetFieldType( DS_CHAR cFieldType );
	DS_LONG SetFieldLength( int iWidth );
	DS_LONG SetFieldDecimals( int iDec );

    //
    // When a CFld object is initialize, the field name and other
    // field information are stored in the private data area. But
    // when one of the above SetField... functions is called to 
    // set the field name we must still maintain the original name.
    // So the new name is stored also in the private data area and
    // to retrieve the new name call one of the following members.
    // 
	PDS_CHAR GetNewFieldName(){ return( szNewFieldName ); }
	PDS_CHAR GetNewFieldName(  PDS_CHAR pNameBuf, int nBufsize );
	DS_CHAR GetNewFieldType(){ return( cNewFldType );}
	DS_LONG  GetNewFieldLength() { return( (DS_LONG)sNewFldLen);}
	DS_LONG  GetNewFieldDecimals(){ return( (DS_LONG)sNewFldDec); }

	friend class CDbf;
};

////////////////////////////////////////////////////////////////////////
//	Structure: CFLD_ITEM 
//
typedef struct _CFLD_ITEM
{
	void* Next;
	CFld  cfld;
} CFLD_ITEM, *PCFLD_ITEM;

////////////////////////////////////////////////////////////////////////
//	CLASS: CDbf 
//
//	dbfLIB++ database class (base class is CDbfLib)
//
class CDbf : public CDbfLib
{
// Construction
public:
	CDbf();	// standard constructor
	CDbf(  PDS_CHAR pFileName );	// open file on construction
	CDbf(  PDS_CHAR pFileName, 	// open file & index on construction
		   PDS_CHAR pIndexName );

	~CDbf(); // standard destructor

// Class data (private)
private:
	PDBF pDbf;
	DS_LONG* plErrList;
	int DefaultIndexType;
	PCFLD_ITEM pListHead;
    DS_CHAR TmpSoundexBuffer[5];
    DS_SHORT iFieldsToSort;
    DS_SHORT iSortRef[MAX_SORT_FIELDS]; // dbfLIB only allows 10 sort fields
    DS_SHORT iDirection[MAX_SORT_FIELDS];

// Implementation 
public:
	// Standard Operations
	DS_LONG AppendFrom(PDS_CHAR pFileName);
	DS_LONG AppendFrom(PDS_CHAR pFileName, DS_ULONG ulType,  PDS_CHAR pDelim ); 
	DS_LONG Clone(  PDS_CHAR pFileName );
	DS_LONG Close();
	DS_LONG Create(  PDS_CHAR pFileName );
	DS_LONG Create(  PDS_CHAR pFileName, DS_LONG lType );
	DS_LONG CreateIndex(  PDS_CHAR pIndexName,  PDS_CHAR pExpression);
	DS_LONG CreateIndex(  PDS_CHAR pIndexName,  PDS_CHAR pExpression, int iType );
	DS_LONG CopyTo(  PDS_CHAR pFileName ); 
	DS_LONG CopyTo(  PDS_CHAR pFileName, DS_ULONG ulType,  PDS_CHAR pDelim ); 
	DS_LONG Locate( DS_LONG FieldRef,  PDS_CHAR Searchdata );
	DS_LONG Locate(  PDS_CHAR pFldName,  PDS_CHAR Searchdata );
	DS_LONG LockRecord(DS_LONG recno, DS_LONG locktype);
	DS_LONG ModifyStructure( );
	DS_LONG Next();
	DS_LONG Prev();
	DS_LONG Open( PDS_CHAR pFileName );
	DS_LONG Open( PDS_CHAR pFileName, DS_ULONG OpenMode );
	DS_LONG Open(  PDS_CHAR pFileName,  PDS_CHAR pIndexName );
	DS_LONG OpenExclusive(  PDS_CHAR pFileName );
	DS_LONG OpenIndex(  PDS_CHAR pIndexName );
    DS_LONG OpenIndex(  PDS_CHAR pIndexName, int iType );
	DS_LONG Pack();
	DS_LONG Pack(DS_LONG PackMemo);
	DS_LONG RenameDbf( PDS_CHAR pOldName, PDS_CHAR pNewName );
    DS_LONG Sort( PDS_CHAR pFileOut );
    void    SortReset();
    DS_LONG SortField( DS_LONG fref, DS_LONG direction );
    DS_LONG SortField( PDS_CHAR pFldname, DS_LONG direction );
    DS_LONG SortField( CFld cfld, DS_LONG direction );
    DS_LONG SortFieldCount() { return( (DS_LONG)iFieldsToSort);}
	PDS_CHAR Soundex( PDS_CHAR pString );
	PDS_CHAR Soundex( PDS_CHAR pString,  PDS_CHAR pSCode);
	DS_LONG Use( PDS_CHAR pFileName );


	// Field operations
	CFld* GetField(  PDS_CHAR pFieldName );
	CFld* GetField( DS_LONG sFieldRef );
	DS_LONG  GetFieldRef( PDS_CHAR pFieldName){return((DS_LONG)FldRef(pDbf, pFieldName));}

	// Extended operations
	DS_LONG AddField( PDBFFLD pFldList, int NumFlds );
	DS_LONG AddField(  PDS_CHAR pFldName, DS_CHAR cType, int Width, int Dec);
	DS_LONG AddField(  CFld newFld );
	PDBF GetHandle() {return( pDbf );}

	// Inline functions
	DS_LONG Append() { return (DbfAppend( pDbf )); }
	DS_LONG Append( DS_LONG NumToAppend ) { return (DbfAppendMultiple( pDbf, NumToAppend )); }
	DS_LONG Bottom() { return( DbfBottom( pDbf ) );}
	void CloseIndex(){ IndexClose( pDbf, pDbf->curndx );}
	void CloseIndex(DS_LONG IndexHandle){ IndexClose( pDbf, (DS_SHORT)IndexHandle);}
	DS_LONG Delete() { return( (DS_LONG)DbfDelete( pDbf, pDbf->recno )); }
	DS_LONG DeleteAll() { return( DbfDeleteAll( pDbf )); }
	DS_ULONG IsRecordDeleted() { return( (DS_ULONG)DbfDeleted( pDbf ) );}
    DS_ULONG IsExclusive() { return( (DS_ULONG)pDbf->openflag == DBF_OPEN_EXCLUSIVE);}
	DS_LONG FieldCount(){ return( (DS_LONG)FldCount( pDbf ) );}
	DS_LONG FlushWrite(){ return( DbfFlushWrite(pDbf, pDbf->recno));}
	DS_LONG FlushWrite( DS_LONG recno ){ return( DbfFlushWrite(pDbf, recno));}
	DS_LONG GetCurrentIndex(){return( (DS_LONG)IndexGetCurrent(pDbf));}
	DS_LONG GetDatabaseType(){ return( (DS_LONG)DbfGetDatabaseType(pDbf));}
	DS_ULONG GetDbfName( PDS_CHAR pNameBuf, DS_ULONG BufSize){return(DbfName(pDbf, pNameBuf, BufSize));}
	DS_LONG Go( DS_LONG recno ){ return( DbfGo(pDbf, recno) );}
	DS_LONG Goto( DS_LONG recno ){ return( DbfGo(pDbf, recno) );}
	DS_LONG LockFile(){return( DbfLock(pDbf, 0));}
	DS_LONG LockRecord(){ return( DbfLock(pDbf, pDbf->recno));}
	DS_LONG LockRecord(DS_LONG recno){return( DbfLock(pDbf, recno));}
	// see above for another LockRecord overload
	DS_LONG QueryLock(){ return( DbfQueryLock( pDbf ));}
	DS_LONG Recall() { return( (DS_LONG)DbfRecall( pDbf, pDbf->recno )); }
	DS_LONG Recall(DS_LONG recno) { return( (DS_LONG)DbfRecall( pDbf, recno )); }
	DS_LONG RecallAll() { return( (DS_LONG)DbfRecallAll( pDbf )); }
	DS_LONG Reccount(){ return( DbfReccount( pDbf )); }
	DS_LONG Recno() { return (pDbf->recno); }
	DS_LONG Reindex(){ return(IndexReindex(pDbf, pDbf->curndx));}
	DS_LONG Reindex(DS_LONG IndexHandle){ return(IndexReindex(pDbf, (DS_SHORT)IndexHandle));}
	DS_LONG Seek( PDS_CHAR pSearchData){return(DbfSeek(pDbf, pSearchData));}
	DS_LONG Seek( PDS_DOUBLE pSearchData){return(DbfSeek(pDbf, (PDS_CHAR)pSearchData));}
	DS_LONG SetCurrentIndex( DS_LONG IndexHandle ){return( (DS_LONG)IndexSetCurrent(pDbf, (DS_SHORT)IndexHandle));}
	DS_LONG Skip(){ return( DbfSkip(pDbf, 1) );}
	DS_LONG Skip(DS_LONG NumToSkip){ return( DbfSkip(pDbf, NumToSkip) );}
	DS_LONG Top(){return( (DS_LONG)DbfTop(pDbf) );}
	DS_LONG TypeIndex(DS_LONG IndexHandle){return(IndexType(pDbf, (DS_SHORT)IndexHandle));}
	DS_LONG Unlock(){return(DbfUnlock(pDbf, pDbf->lockrec));}
	DS_LONG WriteRecord(){return( (DS_LONG)DbfWriteRec(pDbf, pDbf->recno));}
	DS_LONG WriteRecord(DS_LONG Recnum){return( (DS_LONG)DbfWriteRec(pDbf, Recnum));}
	DS_LONG Zap(){ return( DbfZap(pDbf) );}

}; // class CDbf

#endif  // _CDBF_INCLUDED_
//
// End of dbfLIB++ Class definitions
//
