@echo off
:: os2trace-helper - os2trace helper
:: Copies files
:: Run pmos2trc
:: Sets up paths

:: Copyright (c) 2019 Steven Levine and Associates, Inc.
:: All rights reserved.

:: 2019-03-12 SHL Baseline

if "%@eval[0]" == "0" goto is4xxx
  echo Must run in 4OS2/4DOS session
  :: 4os2 /c %0 %1 %2 %3 %4 %5 %6 %7 %8 %9
  :: delay 2
  pause
  goto eof
:is4xxx

loadbtm on
on errormsg pause
setlocal
on break @goto Halted

if "%_DOS%" != "OS2" ( echo Must run in 4OS2 session %+ beep %+ cancel )

:Main

  gosub ScanArgs

  echo Working from %_CWD
  echo Checking existing files
  echo.
  on errormsg
  dir /km *.exe;*.dll
  on errormsg pause

  for %ARG in ( %FILES ) gosub PullFile

  gosub Cleanup

  endlocal

  call os2traceenv

  gosub SetupPaths

  echo.
  echo Ready to run pmos2trc or os2trace

  quit

  :: end main

::=== PullFile() Pull file to current directory ===

:PullFile
  if not exist %ARG ( echo Cannot access %ARG %+ beep %+ cancel )

  dir /m %ARG

  set FN=%@filename[%ARG]
  iff exist %FN then
    dir /m %FN
  else
    echo %FN will be created
  endiff

  shlcpy -pF %ARG .\

  return
  :: end PullFile

::=== SetupPaths() ===

:SetupPaths
  call addpath LIBPATH %_CWD
  call addpath %_CWD
  return
  :: end SetupPaths

::=== DoOne() Do one ===

:DoOne
  echo Processing %ARG
  return
  :: end DoOne

::=== Cancel() Handle cancel ===

:Cancel
  @echo off
  :: gosub Cleanup
  cancel 255
  :: end Cancel

::=== Cleanup() Clean up ===

:Cleanup
  for %X in ( I A ) set %X=
  set X=
  :: if defined WF ( if exist %WF del /q %WF %+ set WF= )
  :: if defined LOG ( if exist %LOG del /q %LOG %+ set LOG= )
  return
  :: end Cleanup

::=== Halted() Handle break ===

:Halted
  @echo off
  echo Halted by user
  goto Cancel
  :: end Halted

::=== ScanArgs() Scan command line ===

:ScanArgs

  set BATCH=
  set VERBOSE=
  set DEBUG=
  set FILES=
  do I = 1 to %#
    set A=%[%I]
    set X=%@substr[%A,0,1]
    iff "%X" == "/" .or. "%X" == "-" then
      :: Got switch
      set Y=%@substr[%A,1,260]
      if not defined Y ( echo %A unexpected %+ goto UsageError )
      do while defined Y
	set X=%@substr[%Y,0,1]
	set Y=%@substr[%Y,1,260]
	if "%X" == "h" .or. "%X" == "?" goto UsageHelp
	iff "%X" == "b" then
	  set BATCH=1
	  iterate
	endiff
	iff "%X" == "d" then
	  set DEBUG=1
	  iterate
	endiff
	iff "%X" == "v" then
	  set VERBOSE=1
	  iterate
	endiff
	echo Switch %A unexpected
	goto UsageError
      enddo
      iterate
    endiff
    :: Got argument
    iff "%A" eq "libc" then
      for %X in ( %UNIXROOT\usr\lib\libc06*.dll %UNIXROOT\usr\lib\libcx*.dll ) (
	set FILES=%FILES %X
      )
      iterate
    endiff
    if not exist %A ( echo Cannot access %A %+ beep %+ goto UsageError )
    set X=%@ext[%A]
    if %X ne "exe" .and. %X ne "dll" ( echo File type must be .exe or .dll %+ beep %+ got UsageError )
    :: Allow wildcards
    for %X in ( %A ) (
      set Z=%@full[%X]
      set FILES=%FILES %Z
    )
    iterate
  enddo
  set I=
  set A=
  set X=

  set FILES=%@trim[%FILES]

  return

  :: end ScanArgs

::=== UsageError() Report usage error ===

:UsageError
  beep
  echo Usage: %@lower[%@name[%0]] `[-b] [-d] [-h] [-v] [-?] filespec...`
  cancel
  :: end UsageError

::=== UsageHelp() Display usage help ===

:UsageHelp
  echo.
  echo os2trace helper
  echo run from work directory
  echo pulls requested executables to work directory
  echo sets up PATH and BEGINLIBPATH
  echo runs pmos2trc if requested
  echo.
  echo Usage: %@lower[%@name[%0]] `[-b] [-d] [-h] [-v] [-?] filespec...`
  echo.
  echo `  -b        Enable batch mode`
  echo `  -d        Enable debug output`
  echo `  -h -?     Display this message`
  echo `  -v        Enable verbose output`
  echo.
  echo `  filespec  Files to pull, libc requests all libc06x DLLs`
  cancel
  :: end UsageHelp

:eof
