/* this is a REXX script for PMDF usage */
/* invoke from PMDF with: %devhlptable    */

/* queries the "DevhlpFuncDisp": this is the DevHelp Function Dispatcher table */
/* it contains the routine entries to the various DevHelp functions */
/* the symbolnames from the routine entries are queried and displayed */
/* a static string table "repstring" replaces the output string if there is some */
/* special condition regarding the function entry point, for example, DevHelps */
/* that can only be called at INIT will be overwritten in the function table */
/* by a panic routine that will abort the system if these functions are called after INIT */

numeric digits 20
rc = rxfuncadd('SysLoadFuncs','REXXUTIL','SysLoadFuncs')
rc = SysLoadFuncs()

repstring.38 = 'deprecated (dh_ROMCritSection: not implemented)'
repstring.41 = 'deprecated (dh_ABIOSGetParms)'
repstring.56 = 'only on init (dh_GetDeviceBlock)'
repstring.57 = 'undefined (reserved for profiling kernel)'
repstring.58 = 'only on init (dh_RegisterStackUsage)'
repstring.61 = 'only on init (h_SYISaveMessage f_SYISaveMessage SYISaveMessage)'
repstring.65 = 'deprecated (dh_PhysToSys)'
repstring.66 = 'deprecated (dh_PhysToSysHook)'
repstring.70 = 'undefined'
repstring.71 = 'undefined'
repstring.72 = 'undefined'
repstring.73 = 'undefined'
repstring.74 = 'undefined'
repstring.75 = 'undefined'
repstring.76 = 'undefined'
repstring.77 = 'undefined'
repstring.78 = 'undefined'
repstring.79 = 'undefined'
repstring.97 = 'only on init (dh_RegisterTmrDD)'
repstring.98 = 'only on init (dh_RegisterPerfCtrs)'
repstring.110 = 'only on init (dh_CreateInt13VDM)'
repstring.116 = 'no symbol exported (dh_StartIntMouseCursor)'
repstring.117 = 'no symbol exported (dh_EndIntMouseCursor)'
repstring.123 = 'undefined'
repstring.124 = 'undefined'
repstring.127 = 'only on init (dh_SYIOpenFile)'
repstring.128 = 'only on init (dh_SYICloseFile)'
repstring.129 = 'only on init (dh_SYIReadFile)'
repstring.130 = 'only on init (dh_SYIReadAtFile)'


trace 'o'
if \IfCalledFromPMDF() then do
   return 1
end /* do */

address df 'cmd xxx lg OS2KRNL'
rc = CompressDfReturn()
do n=4 to xxx.0-1
   parse var xxx.n address groupname .
   if groupname = 'DOSCODE' then do
      parse var address sel ':' off
      sel = strip(sel,'B',' ')
      leave
   end
end


/* the symbol for the DeviceHelp Pointer is: h_DeviceHelpDM */
/* this routine uses table "DevhlpFuncDisp" to dispatch the individual device helpers */

say '***Info: the DeviceHelp entry point represented by symbol: h_DeviceHelpDM***'
say

do n=0 to x2d(83)
   address df 'cmd xxx dw DevhlpFuncDisp+'d2x(n*3)' l1'
   rc = CompressDfReturn()
   parse var xxx.1 . off .
   symaddr = sel':'off
   address df 'cmd xxx ln 'symaddr
   rc = CompressDfReturn()
   if words(xxx.1) > 3 then do
      line = repstring.n
   end
   else do
      line = xxx.1
   end
   line = n'('d2x(n)'):'line
   say line
end

return 0


CompressDfReturn: procedure expose xxx.
if xxx.1 == '' then do
   rc = SysStemDelete(xxx,1)
end
return rc 

IfCalledFromPMDF: procedure
address df 'querydf path'
if rc == 30 then do
   say 'run this script from PMDF'
   return 0
end
else do /* do */
   return 1
end /* do */
