/* this is a REXX script for PMDF usage */
/* invoke from PMDF with: %dostable    */

/* this script will display the routines listed in the DosTable */
/* the DosTable address is typically returned on a DevHelp_GetDosVAR with index 9 */

numeric digits 20
rc = rxfuncadd('SysLoadFuncs','REXXUTIL','SysLoadFuncs')
rc = SysLoadFuncs()

trace 'o'
if \IfCalledFromPMDF() then do
   return 1
end /* do */

address df 'cmd xxx ln DosTable'
rc = CompressDfReturn()
say '********* results for *********'
say xxx.1
say '*******************************'
say '*** DosTable1 *****************'
say '*******************************'

/* first byte of dos table is the number of entries */
/* dostable starts at second byte */
address df 'cmd xxx dd DOSTable+1 lBY(DosTable)'
rc = CompressDfReturn()
rc = SysStemCopy(xxx,yyy)
do n=1 to yyy.0-1
   val.1=''
   val.2=''
   val.3=''
   val.4=''

   parse var yyy.n 16 val.1 val.2 val.3 val.4 .
   do k=1 to 4
      idx = (n-1)*4+(k-1)
      if val.k = '' then do
         iterate
      end
      if x2d(val.k) = 0 then do
         iterate
      end
      /* normal routine with selector and offset */
      if x2d(val.k) >= 65536 then do
         parse var val.k cs 5 ip
         address df 'cmd xxx ln'cs':'ip
         rc = CompressDfReturn()
         say 'index 'idx' *-* 'xxx.1
      end
      /* only selector value, points to a call gate */
      else do
         parse var val.k . 5 callgate
         address df 'cmd xxx dg 'val.k
         rc = CompressDfReturn()
         parse var xxx.1 . '=' cs ':' eip .
         address df 'cmd xxx ln 'cs':'eip
         rc = CompressDfReturn()
         say 'index 'idx' *-* 'xxx.1' (call gate, sel='callgate')'
      end
   end
end

say '*******************************'
say '*** DosTable2 *****************'
say '*******************************'

/* DosTable2 directly follows DosTable1 */
/* again, first byte of dos table is the number of entries */
/* dostable starts at second byte */
address df 'cmd xxx dd DOSTable+4*BY(DosTable)+2 lBY(DosTable+4*BY(DosTable)+1)'
rc = CompressDfReturn()
rc = SysStemCopy(xxx,yyy)
do n=1 to yyy.0-1
   val.1=''
   val.2=''
   val.3=''
   val.4=''
   parse var yyy.n 16 val.1 val.2 val.3 val.4 .
   do k=1 to 4
      idx = (n-1)*4+(k-1)
      if val.k = '' then do
         iterate
      end

      if x2d(val.k) < 65536 then do
         rest = val.k
      end
      else do
         address df 'cmd xxx ln %'val.k
         rc = CompressDfReturn()
         rest = xxx.1
         if xxx.1 = 'No Symbols Found' then do
            parse var val.k cs 5 ip
            address df 'cmd xxx ln 'cs':'ip
            rc = CompressDfReturn()
            rest = xxx.1
         end
         if xxx.1 = 'No Symbols Found' then do
            address df 'cmd xxx lg OS2KRNL'
            rc = CompressDfReturn()
            parse var xxx.4 segbase
            segbase = strip(segbase,'L',' ')
            address df 'cmd xxx ? 'segbase
            rc = CompressDfReturn()
            parse var xxx.1 . '%' linbase .
            parse var segbase sel ':' .
            if val.k >= linbase then do
               off = d2x(x2d(val.k)-x2d(linbase))
               address df 'cmd xxx ln 'sel':'off
               rc = CompressDfReturn()
               rest = xxx.1
            end
            else do
               xxx.1 = 'No Symbols Found'
            end
         end
         if xxx.1 = 'No Symbols Found' then do
            address df 'cmd xxx lg OS2KRNL'
            rc = CompressDfReturn()
            parse var xxx.5 segbase
            segbase = strip(segbase,'L',' ')
            address df 'cmd xxx ? 'segbase
            rc = CompressDfReturn()
            parse var xxx.1 . '%' linbase .
            parse var segbase sel ':' .
            if val.k >= linbase then do
               off = d2x(x2d(val.k)-x2d(linbase))
               address df 'cmd xxx ln 'sel':'off
               rc = CompressDfReturn()
               rest = xxx.1
            end
            else do
               xxx.1 = 'No Symbols Found'
            end
         end
         if xxx.1 = 'No Symbols Found' then do
            rest = val.k
         end
      end
      say 'index 'idx' *-* 'rest
   end
end

return 0


CompressDfReturn: procedure expose xxx.
if xxx.1 == '' then do
   rc = SysStemDelete(xxx,1)
end
return rc 

IfCalledFromPMDF: procedure
address df 'querydf path'
if rc == 30 then do
   say 'run this script from PMDF'
   return 0
end
else do /* do */
   return 1
end /* do */
