/* this is a REXX script for PMDF usage */
/* invoke from PMDF with: %ln    */

/* this script substitues the "ln" command in that it will attempt */
/* to resolve symbol names that require pointer transformation from linear */
/* to segmented (alias translation) */
/* it will use the mapfile that is FIRST in the list of mapfiles displayed by the "lm" command */
/* you can reload mapfiles with the "wa" command so that the will show up first in the list of mapfiles */
/* it takes the same parameters as the "ln" command */

numeric digits 20

trace 'o'
if \IfCalledFromPMDF() then do
   return 1
end /* do */

rc = rxfuncadd('SysLoadFuncs','REXXUTIL','SysLoadFuncs')
rc = SysLoadFuncs()

argument = arg(1)

if argument = '' then do
   say 'pass address to query symbolname !'
   return 1
end

if pos(':',argument) = 0 then do
   tmp = strip(argument,'L','%')
   islinear = 1
end
else do
   parse var argument sel ':' off
   tmp = sel||off
   islinear = 0
end /* do */

if datatype(tmp,'X') \= 1 then do
   say 'pass hexadecimal address !'
   return 1
end /* do */

address df 'cmd xxx ln 'argument
rc = CompressDfReturn()
line = xxx.1
if line = 'No Symbols Found' & islinear = 1 then do
   /* we are testing if we can find the address in the 1st group of the symbols file (MPDATAGROUP for the SMP OS2KRNL) */
   /* many 32-bit addresses can only be queried indirectly via the group selector */
   address df 'cmd xxx lg'
   rc = CompressDfReturn()
   parse var xxx.4 segbase .
   segbase = strip(segbase,'L',' ')
   address df 'cmd xxx ? 'segbase
   rc = CompressDfReturn()
   parse var xxx.1 . '%' linbase .
   parse var segbase sel ':' .
   argument = strip(argument,'L','%')
   if argument >= linbase then do
      off = d2x(x2d(argument)-x2d(linbase))
      address df 'cmd xxx ln 'sel':'off
      rc = CompressDfReturn()
      line = xxx.1
   end
end

if line = 'No Symbols Found' & islinear = 1 then do
   /* we are testing if we can find the address in 2nd group of the symbols file (DOSGROUP for the SMP OS2KRNL) */
   /* many 32-bit addresses can only be queried indirectly via group selector */
   address df 'cmd xxx lg'
   rc = CompressDfReturn()
   parse var xxx.5 segbase .
   segbase = strip(segbase,'L',' ')
   address df 'cmd xxx ? 'segbase
   rc = CompressDfReturn()
   parse var xxx.1 . '%' linbase .
   parse var segbase sel ':' .
   argument = strip(argument,'L','%')
   if argument >= linbase then do
      off = d2x(x2d(argument)-x2d(linbase))
      address df 'cmd xxx ln 'sel':'off
      rc = CompressDfReturn()
      line = xxx.1
   end
end

say line
return 0


CompressDfReturn: procedure expose xxx.
if xxx.1 == '' then do
   rc = SysStemDelete(xxx,1)
end
return rc 

IfCalledFromPMDF: procedure
address df 'querydf path'
if rc == 30 then do
   say 'run this script from PMDF'
   return 0
end
else do /* do */
   return 1
end /* do */
