/* this is a REXX script for PMDF usage */
/* invoke from PMDF with: %vpb          */

trace 'o'
if \IfCalledFromPMDF() then do
   return 1
end /* do */

numeric digits 20
rc = rxfuncadd('SysLoadFuncs','REXXUTIL','SysLoadFuncs')
rc = SysLoadFuncs()

address df 'output PAGE'

/* get selector for VPB */
address df 'cmd xxx ln gdt_vpb'
rc = CompressDfReturn()
dummy=word(xxx.1,1)
if dummy='No' then do
   say 'Kernel symbols not loaded'
   return 1
end

/* get VPB element length, current segment length, total segment length */
vpb=right(dummy,4)
address df 'cmd xxx dw 'vpb':0000 L3'
rc = CompressDfReturn()

if pos('Invalid',xxx.1) > 0 then do
  say 'Broken dump file (VPB segment not in memory), need to quit ...'
  return 1
end

eleLen = x2d(word(xxx.1,2))
currSegLen = x2d(word(xxx.1,3))
totalSegLen = x2d(word(xxx.1,4))

if eleLen = 0 | currSegLen = 0 | totalSegLen = 0 then do
  say 'Broken dump file (VPB segment not in memory), need to quit ...'
  return 1
end


offset = x2d(12)
num = (currSegLen-offset) / eleLen
maxnum = (totalSegLen-offset) / eleLen

say '--------------------------------------------------------------------------'
say 'Curr Num of VPBs: 'num',Max Num Of VPBs: 'maxnum
say '--------------------------------------------------------------------------'

/* cycle to all VPBs that are currently active (includes valid and invalid VPBs, see signature) */
do i=1 to num
   say '--- VPB 'i' ('ToLower(MakeAddr(vpb,offset))') ----------------------------------------------------'
   say 'Segment Offset of next VPB (hex): 'GetWord(MakeAddr(vpb,offset))
   say 'Segment Offset of previous VPB (hex): 'GetWord(MakeAddr(vpb,offset+2))
   say 'ref count (?): 'x2d(GetWord(MakeAddr(vpb,offset+4)))
   say 'search count (?): 'x2d(GetWord(MakeAddr(vpb,offset+6)))
   say 'first access: 'GetByte(MakeAddr(vpb,offset+8))
   say 'signature (hex, 0x444A = VPB_VALID, 0x4A47 = VPB_INVALID): 'GetWord(MakeAddr(vpb,offset+9))
   say 'flags (hex): 'GetByte(MakeAddr(vpb,offset+11))
   say 'fMisc (hex): 'GetByte(MakeAddr(vpb,offset+12))
   say 'FSC pointer: 'GetPointer(MakeAddr(vpb,offset+13))
   /* skip over 64 bytes of irrelevant working data */
   say 'Serial Number: 'GetDword(MakeAddr(vpb,offset+17+64))
   say 'DPB pointer: 'GetPointer(MakeAddr(vpb,offset+21+64))
   say 'sector size: 'x2d(GetWord(MakeAddr(vpb,offset+25+64)))
   say 'Total Sectors: 'x2d(GetDword(MakeAddr(vpb,offset+27+64)))
   say 'Sectors Per Track: 'x2d(GetWord(MakeAddr(vpb,offset+31+64)))
   say 'Number of Heads: 'x2d(GetWord(MakeAddr(vpb,offset+33+64)))
   say 'Volume Name: 'GetString(MakeAddr(vpb,offset+35+64),12)
   say 'DCS pointer: 'GetPointer(MakeAddr(vpb,offset+47+64))
   say 'VCS pointer: 'GetPointer(MakeAddr(vpb,offset+51+64))
   drivenumber = x2d(GetByte(MakeAddr(vpb,offset+55+64)))
   say 'Drive Number (OS2LVM): 'drivenumber' ('d2c(drivenumber+c2d(a))':)'
   say 'Unit Number (OS2LVM): 'x2d(GetByte(MakeAddr(vpb,offset+56+64)))
   say 'Special Flags (hex): 'GetWord(MakeAddr(vpb,offset+57+64))
   addr = GetPointer(MakeAddr(vpb,offset+21+64))
   say '--- associated DPB ('addr')-------------------------------------------'
   address df 'cmd xxx .d DPB 'addr
   rc = CompressDfReturn()
   o = xxx.0-1
   do j=1 to o
      say xxx.j
   end

   offset = offset + eleLen
end /* do */

signal dump
/* cycle to all VPBs that are currently active (includes valid and invalid VPBs, see signature) */
do i=1 to num
   say '--- VPB 'i' (#'vpb':'d2x(offset)')----------------------------------------------------'
   address df 'cmd xxx .d VPB 'MakeAddr(vpb,offset)
   rc = CompressDfReturn()
   o= xxx.0-1
   do j=1 to o
      say xxx.j
   end /* do */
   addr = word(xxx.10,2)
   say '--- associated DPB ('addr')-------------------------------------------'
   address df 'cmd xxx .d DPB 'addr
   rc = CompressDfReturn()
   o = xxx.0-1
   do j=1 to o
      say xxx.j
   end
   offset = offset + eleLen
end /* do */

dump:
return 0


MakeAddr: procedure
parse arg sel,off .
return sel':'d2x(off)

GetByte: procedure
parse arg address .
address df 'cmd yyy db 'address' L1'
rc = CompressDfReturn2()
return (word(yyy.1,2))

GetWord: procedure
parse arg address .
address df 'cmd yyy dw 'address' L1'
rc = CompressDfReturn2()
return word(yyy.1,2)

GetDword: procedure
parse arg address .
address df 'cmd yyy dd 'address' L1'
rc = CompressDfReturn2()
return word(yyy.1,2)

GetPointer: procedure
parse arg address .
address df 'cmd yyy dw 'address' L2'
rc = CompressDfReturn2()
return word(yyy.1,3)':'word(yyy.1,2)

GetString: procedure
parse arg address,len .
address df 'cmd yyy da 'address' L'len't'
rc = CompressDfReturn2()
parse var yyy.1 . string
return string

ToLower: procedure
parse arg val .
return translate(val,'abcdef','ABCDEF')


CompressDfReturn: procedure expose xxx.
if xxx.1 == '' then do
   rc = SysStemDelete(xxx,1)
end
return rc 

CompressDfReturn2: procedure expose yyy.
if yyy.1 == '' then do
   rc = SysStemDelete(yyy,1)
end
return rc 

IfCalledFromPMDF: procedure
address df 'querydf path'
if rc == 30 then do
   say 'run this script from PMDF'
   return 0
end
else do /* do */
   return 1
end /* do */
