#===================================================================
#
#   PMM Sample Make file
#
#===================================================================

# Activate/deactivate PMM easily
USE_PMM = 1

CC      = icc /c /Ge /Gd- /Se /Re /Ss

LFLAGS  = /NOI /NOE /NOD /ALIGN:16 /EXEPACK /M /BASE:0x10000

!if $(USE_PMM)
# Add the PMM library here =========================================
LIBS    = OS2386 + DDE4MBS + PMM
!else
LIBS    = OS2386 + DDE4MBS
!endif
LINK    = LINK386 $(LFLAGS)


all: pmmsam.exe

pmmsam.obj: pmmsam.c pmmsam.h

pmmsam.lnk: pmmsam.mak
    echo pmmsam.obj      > pmmsam.lnk
    echo pmmsam.exe     >> pmmsam.lnk
    echo pmmsam.map     >> pmmsam.lnk
    echo $(LIBS)        >> pmmsam.lnk
    echo pmmsam.def     >> pmmsam.lnk

pmmsam.res: pmmsam.rc pmmsam.ico pmmsam.h

pmmsam.exe: pmmsam.obj  pmmsam.lnk pmmsam.def pmmsam.res
    $(LINK) @pmmsam.lnk
    rc -p -x pmmsam.res pmmsam.exe

