#include "example.h"

#pragma argsused
void Run ( BALLS *pBalls )
/* Main loop of the program. */
{
   #if defined (OS2) && defined (GUI)
   while (WinGetMsg (hAB, &QMsg, 0, 0, 0))
   {
      WinDispatchMsg (hAB, &QMsg);
   }
   #else
   while (!kbhit ())
   {
      RunBalls (pBalls);
      Pause (DELAY);
   }
   getch ();   /* Remove that termination key from keyboard buffer */
   #endif
}

void RunBalls ( BALLS *pBalls )
/* Let every running ball take a new step. Heading to their current direction,
   and moving in their current speed. Change direction of each ball so that
   no balls run outside visible screen area. */
{
   int iC1;

   #if defined (OS2) && defined (GUI)
   if (WinQueryFocus (HWND_DESKTOP) != hWndClient)
   {
      /* Don't hogg the single input queue of OS/2 when user work in some
         other window than this stupid one. */
      return;     
   }
   #endif

   for (iC1 = 0;
        iC1 < pBalls->iNr;
        RunBall (&pBalls->Ball[iC1++]));
}

void RunBall ( BALL *pBall )
/* Kernel function of RunBalls(). */
{
   PaintBall (pBall, BLACK);         /* Hide the ball from old position */

   MoveHorizontally (pBall);
   MoveVertically (pBall);

   PaintBall (pBall, pBall->iColor); /* Show the ball at new position */
}

void MoveHorizontally ( BALL *pBall )
/* Move specified ball left/right.
   Change speed and direction when the  ball reach any edge of screen. */
{
   pBall->iXPos += pBall->iHSpeed;

   if (pBall->iXPos > iScreenW)
   {
      pBall->iHSpeed = -NEWSPEED (MAXHSPEED);
      pBall->iXPos = iScreenW;
      NEWCOLOR (pBall->iColor);
   }
   else
   if (pBall->iXPos <= 0)
   {
      pBall->iXPos = 1;
      pBall->iHSpeed = NEWSPEED (MAXHSPEED);
   }
}

void MoveVertically ( BALL *pBall )
/* Move specified ball up/down.
   Change speed and direction when the  ball reach any edge of screen. */
{
   pBall->iYPos += pBall->iVSpeed;

   if (pBall->iYPos > iScreenH)
   {
      pBall->iYPos = iScreenH;
      pBall->iVSpeed = -NEWSPEED (MAXVSPEED);
   }
   else
   if (pBall->iYPos <= 0)
   {
      pBall->iYPos = 1;
      pBall->iVSpeed = NEWSPEED (MAXVSPEED);
   }
}

void PaintBall ( BALL *pBall, int iColor )
/* Paint specified ball at its current position, using specified color */
{
   #ifdef GUI
   #ifdef OS2
   POINTL pt;
   pt.x = pBall->iXPos;
   pt.y = pBall->iYPos;
   GpiMove (hPS, &pt);
   GpiSetColor (hPS, iColor);
   GpiFullArc (hPS, DRO_OUTLINE, MAKEFIXED (1, 0));
   #else
   setcolor (iColor);
   circle (pBall->iXPos, pBall->iYPos, 5);
   #endif
   #else
   /* Prevent text screen from being vertically scrolled if the ball is
      positioned at bottom right corner of screen (text modes only) */
   if ((pBall->iXPos == iScreenW) &&
       (pBall->iYPos == iScreenH))
   {
      return;
   }

   textcolor (iColor);
   gotoxy (pBall->iXPos, pBall->iYPos);
   putch ('*');
   #endif
}
