#include <string.h>
#include <sys/types.h>
#include <sys/param.h>
#include <sys/stat.h>

extern char * getenv();
extern void cannoname();
extern char * unsymlink();
extern char * getwd();

/* kshgetwd is a routine that acts just like getwd, but is optimized
 * for ksh users, taking advantage of the fact that ksh maintains
 * an environment variable named PWD holding path name of the
 * current working directory.
 *
 * The primary motivation for this is not really that it is algorithmically
 * simpler, but that it is much less likely to bother NFS if we can just
 * guess the name of the current working directory using the hint that
 * ksh maintains. Anything that avoids NFS gettar failed messages is
 * worth doing.
 */
char *
kshgetwd(pathname)
   char *   pathname;
{
   struct stat kshstat, dotstat ;
   char        kshname[MAXPATHLEN] ;
   char *      kshp ;

   kshp = getenv("PWD") ;
   if (kshp) {
      /* OK, there was a PWD environment variable */
      strcpy(kshname, kshp) ;
      if (unsymlink(kshname)) {
         /* And we could resolve the symbolic links through it */
         if (kshname[0] == '/') {
            /* And the name we have is an absolute path name */
            if (stat(kshname, &kshstat) == 0) {
               /* And we can stat the name */
               if (stat(".", &dotstat) == 0) {
                  /* And we can stat "." */
                  if ((kshstat.st_dev == dotstat.st_dev) &&
                      (kshstat.st_ino == dotstat.st_ino)) {
                     /* By golly, that name is the same file as "." ! */
                     return(strcpy(pathname, kshname)) ;
                  }
               }
            }
         }
      }
   }
   /* Oh well, something did not work out right, do it the hard way */
   return(getwd(pathname)) ;
}
