/* Copyright (c) 1986, Greg McGary */
static char sccsid[] = "@(#)opensrc.c	1.1 86/10/09";

#include	<stdio.h>
#include	<string.h>
#include	<sys/types.h>
#include	<sys/stat.h>

char *findSrcFILE();
char *getSCCS();
char *coRCS();

FILE *
openSrcFILE(path, sccsDir, rcsDir, filter)
	char		*path;
	char		*sccsDir;
	char		*rcsDir;
	char		*filter;
{
	char		*command = NULL;
	char		*what = NULL;
	char		*get = "get SCCS file";
	char		*checkout = "checkout RCS file";
	char		*dirName;
	char		*baseName;
	struct stat	statb;
	char		popcom[1024];
	FILE		*srcFILE;

	if (stat(path, &statb) != 0) {
		if ((baseName = strrchr(path, '/')) == NULL) {
			dirName = ".";
			baseName = path;
		} else {
			dirName = path;
			*baseName++ = '\0';
		}

		if (rcsDir && (command = coRCS(dirName, baseName, rcsDir)))
			what = checkout;
		else if (sccsDir && (command = getSCCS(dirName, baseName, sccsDir)))
			what = get;
		else if ((command = coRCS(dirName, baseName, "RCS"))
		     ||  (command = coRCS(dirName, baseName, ".")))
			what = checkout;
		else if ((command = getSCCS(dirName, baseName, "SCCS"))
		     ||  (command = getSCCS(dirName, baseName, "sccs"))
		     ||  (command = getSCCS(dirName, baseName, ".")))
			what = get;

		if (dirName == path)
			*--baseName = '/';

		if (!command) {
			filerr("open", path);
			return NULL;
		}

		system(command);
		fprintf(stderr, "%s\n", command);
	}
	if (stat(path, &statb) != 0) {
		filerr("open", path);
		return NULL;
	}
	if (filter != NULL) {
		sprintf(popcom,filter,path);
		srcFILE = popen(popcom, "r");
	} else {
		srcFILE = fopen(path, "r");
	}
	if (srcFILE == NULL) {
		filerr("open", path);
	}
	return srcFILE;
}

void
closeSrcFILE(fp, filter)
	FILE		*fp;
	char		*filter;
{
	if (filter != NULL) {
		pclose(fp);
	} else {
		fclose(fp);
	}
}

char *
getSCCS(dir, base, sccsDir)
	char		*dir;
	char		*base;
	char		*sccsDir;
{
	static char	cmdBuf[BUFSIZ];
	char		fileBuf[BUFSIZ];
	struct stat	statBuf;

	if (!*sccsDir)
		sccsDir = ".";

	sprintf(fileBuf, "%s/%s/s.%s", dir, sccsDir, base);
	if (stat(fileBuf, &statBuf) < 0)
		return NULL;
	sprintf(cmdBuf, "cd %s; get -s %s/s.%s", dir, sccsDir, base);

	return cmdBuf;
}

char *
coRCS(dir, base, rcsDir)
	char		*dir;
	char		*base;
	char		*rcsDir;
{
	static char	cmdBuf[BUFSIZ];
	char		fileBuf[BUFSIZ];
	struct stat	statBuf;

	if (!*rcsDir)
		rcsDir = ".";

	sprintf(fileBuf, "%s/%s/%s,v", dir, rcsDir, base);
	if (stat(fileBuf, &statBuf) < 0)
		return NULL;
	sprintf(cmdBuf, "cd %s; co -q %s/%s,v", dir, rcsDir, base);

	return cmdBuf;
}
