// Developer Helper Object Set, (C) 1994 Thomas E. Bednarz, Jr.
//  All rights reserved


#include"nmdlog.h"

TNonModalDialog *tempTHIS = NULL;


//-------------------------------------------------------------------
//  TNonModalDialog
TNonModalDialog::TNonModalDialog(ULONG resource):
      TWinBase(resource)
{
   tempTHIS = this;
}


//-------------------------------------------------------------------
//  ~TNonModalDialog
TNonModalDialog::~TNonModalDialog()
{

}


//-------------------------------------------------------------------
//  Init
BOOL TNonModalDialog::Init(HAB hab)
{
   SWP swp;

   MakeFrame();
 
   WinQueryTaskSizePos(hab, 0, &swp);

   WinSetWindowPos(hwndFrame,(ULONG)NULL, swp.x,
			swp.y, 0,0,SWP_SHOW | SWP_MOVE);
 

}


//-------------------------------------------------------------------
//  getClassName
const char *TNonModalDialog::getClassName(void)
{
   return "TNonModalDialog";
}


//-------------------------------------------------------------------
//  MakeFrame
BOOL TNonModalDialog::MakeFrame(void)
{
   hwndFrame = WinLoadDlg( HWND_DESKTOP,
			                 HWND_DESKTOP,
 			                 (PFNWP)ClientDlogProc,
			                 0,fResource,NULL);

   return (hwndFrame != (HWND)NULL);

}


//-------------------------------------------------------------------
//  doCommand
MRESULT TNonModalDialog::doCommand(HWND hWnd, ULONG Message, MPARAM mParam1, MPARAM mParam2)
{
   return WinDefDlgProc(hWnd, Message,mParam1, mParam2);
}


//-------------------------------------------------------------------
//  DlogProc
MRESULT TNonModalDialog::DlogProc(HWND hWnd, ULONG Message, MPARAM mParam1, MPARAM mParam2 )
{
   switch (Message)
   {
       case WM_CLOSE:
          WinPostMsg(hWnd, WM_QUIT, 0,0);
          return FALSE;
       case WM_COMMAND:
            return doCommand(hWnd, Message, mParam1, mParam2);
         break;
        default:
           return WinDefDlgProc(hWnd, Message,mParam1, mParam2);
           break;
   }
   return (MRESULT)FALSE;
}


//-------------------------------------------------------------------
//  ClientDlogProc
MRESULT EXPENTRY TNonModalDialog::ClientDlogProc(HWND hWnd,ULONG iMessage,
       MPARAM mParam1, MPARAM mParam2)
{

    TNonModalDialog *pDialog = (TNonModalDialog *)WinQueryWindowULong(hWnd,0);

    if (pDialog == 0)
    {
        if (iMessage == WM_INITDLG)
        {
            pDialog = tempTHIS;
            WinSetWindowULong(hWnd,0,(ULONG)pDialog);
            return pDialog->DlogProc(hWnd,iMessage,mParam1,mParam2);
        }
        else
            return WinDefDlgProc(hWnd,iMessage,mParam1,mParam2);
    }
    else
        return pDialog->DlogProc(hWnd,iMessage,mParam1,mParam2);
}

