// Developer Helper Object Set, (C) 1994 Thomas E. Bednarz, Jr.
//  All rights reserved


#include"window.h"
#include<os2.h>


BOOL TWindow::fInitialized = FALSE;



static TWindow *temp_win_THIS;

//-------------------------------------------------------------------
//  TWindow
TWindow::TWindow(CHAR *title, ULONG flags, ULONG resource):
   TWinBase(resource)
{
   temp_win_THIS = this;
   flCreateFlags = flags;

   fTitle = title;
}


//-------------------------------------------------------------------
//  ~TWindow
TWindow::~TWindow()
{

}


//-------------------------------------------------------------------
//  Init
BOOL TWindow::Init(HAB hab)
{
   Register(hab);
   return MakeFrame();
}


//-------------------------------------------------------------------
//  ShowWindow
BOOL TWindow::ShowWindow(int nCmdShow)
{ 
   return WinShowWindow(hwndFrame,nCmdShow);
}
     

//-------------------------------------------------------------------
//  Wpdate
BOOL TWindow::Update(void)
{ 
   return WinUpdateWindow(hwndFrame);
}


//-------------------------------------------------------------------
//  WndProc
MRESULT TWindow::WndProc(HWND hWnd, ULONG Message, MPARAM mParam1, MPARAM mParam2 )
{
   switch(Message)
   {
      case WM_ERASEBACKGROUND:
         return (MRESULT)TRUE;

      case WM_COMMAND:
            return doCommand( hWnd, Message, mParam1, mParam2);
         break;

      case WM_DESTROY:
            return (MRESULT)FALSE;
         break;

//      case WM_PAINT:
//            return (MRESULT) FALSE;
//         break;

      default:
         return WinDefWindowProc(hWnd, Message, mParam1, mParam2);
   }
   return (MRESULT)FALSE;
}


//-------------------------------------------------------------------
//  getClassName
const char *TWindow::getClassName(void)
{
   return "TWindow";
}


//-------------------------------------------------------------------
//  Register
void TWindow::Register(HAB anchor_block)
{
   if (!fInitialized)
   {
     WinRegisterClass(anchor_block, getClassName(),
                    ClientWndProc, 0,sizeof(TWindow));
     fInitialized = TRUE;
   }

}


//-------------------------------------------------------------------
//  MakeFrame
BOOL TWindow::MakeFrame(void)
{
   hwndFrame = WinCreateStdWindow (HWND_DESKTOP,  WS_VISIBLE,
               &flCreateFlags ,getClassName(), (const char*)fTitle, 0L,
               (HMODULE) NULL, fResource, (PHWND)&hwndClient);


   return (hwndFrame!=(HWND)NULL);
   return TRUE;
}


//-------------------------------------------------------------------
//  doCommand
MRESULT TWindow::doCommand(HWND hWnd, ULONG Message, MPARAM mParam1, MPARAM mParam2)
{
   return WinDefWindowProc(hWnd, Message, mParam1, mParam2);
}


//-------------------------------------------------------------------
//  ClientWndProc
MRESULT EXPENTRY TWindow::ClientWndProc(HWND hWnd,ULONG iMessage,
    MPARAM mParam1, MPARAM mParam2)
{
 
    TWindow *pWindow = (TWindow *)WinQueryWindowULong(hWnd,0);

    if (pWindow == 0) 
    {
        if (iMessage == WM_CREATE) 
        {
            pWindow = temp_win_THIS;
            WinSetWindowULong(hWnd,0,(ULONG)pWindow);
            return pWindow->WndProc(hWnd,iMessage,mParam1,mParam2);
        } 
        else
            return WinDefWindowProc(hWnd,iMessage,mParam1,mParam2);
    } 
    else
        return pWindow->WndProc(hWnd,iMessage,mParam1,mParam2);
}


//-------------------------------------------------------------------
//  GetClient
HWND TWindow::GetClient(void)
{
   return hwndClient;
}

//-------------------------------------------------------------------
//  scrollWin
void TWindow::scrollWin(LONG hs, LONG vs)
{
   WinScrollWindow(GetClient(),hs, vs, (PRECTL)NULL,
        (PRECTL)NULL, (HRGN)NULLHANDLE,(PRECTL)NULL,0);
}
