%{
/*
================================================================================
                        Texinfo converting Tools
                         Release 1.00 28.03.97
                       (c) 1996 by Andreas Kaiser
                    (c) 1997 by Karl Heinz Marbaise
================================================================================

Discription:
    Lexical analyser for Texinfo to RTF
    (Beta state)

Authors:
   Andreas Kaiser
   Karl Heinz Marbaise

e-mail:
   Internet: KHMarbaise@p69.ks.fido.de
   Fido-net: 2:2452/117.69

Bugs, question:
   to above e-mail adress.

Register:
   Please send a e-mail to above adress to register.
   (include the release you want to register)
   This registration should be done to let me
   know how many people using these tools and
   if it is worth to invest more time in continuing
   development these tools or let the first release
   of them be the last.
   That is the only reason to make a registration.
   I think a e-mail is not to much, isn't it?

License:
   The "Texinfo converting tools" are free software;
   you can redistribute it and/or modify it under the terms of
   the GNU General Public License as published by the Free
   Software Foundation; either version 2, or (at your option)
   any later version.

   The "Texinfo converting tools" are distributed in the hope that
   they will be useful, but WITHOUT ANY WARRANTY; without even the
   implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
   PURPOSE.  See the GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with the "Texinfo converting tools" ; see the file COPYING.
   If not, write to the:
   Free Software Foundation,
   59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.

   See \texicvt1.00\COPYING for details.

================================================================================
*/


/*
------------------------------------------------------------------------------
                      (R)evision (C)ontrol (S)ystem
------------------------------------------------------------------------------
*/

static char *rtf_l = "$Id: RTF.L 1.4 1997/03/30 15:08:21 KHM Exp $";


#include "info.h"
#include <ctype.h>
#include <errno.h>
#if defined (__EMX__)
#include <strstrea.h>
#else
#include <strstream.h>
#endif
/*extern "C" char *strupr(char *);*/

/*#undef yywrap*/
#define YY_NO_TOP_STATE  /* supress compiler warning
                          * 'yy_top_state' defined but not used
                          */
#define SAVESTATE(x)  yy_push_state(x)
#define RESTORESTATE  yy_pop_state ()

/*
 * PUTE ("i", "ANTON");
 * Creates;
 * {\i ANTON}
 */
///#define PUTE(x,y)  *out << "{" << x << " " << y << "}"
#define PUTE(x,y)  PUTS ("{" << x << " " << y << "}")

/* PUTE ("A", "HREF=ANTON", "Das ist ein Test");
 * Creates:
 * <A HREF=ANTON>Das ist ein Test</A>
 */
#define PUTEA(x,a,y)  *out << "<" << x << " " << a << ">" << y << "</" << x << ">"

String & arg();
String & eol();
String Test;
void unexpected(const char *);
void footnote();
void skip();
void dot();
void include(const char *);
void Defs
     (
         int xVariant,     /* is on of the @def...x */
         int exCategory,   /* =1 means category exists */
         int exClass,      /* =1 class exists */
         int exType,       /* =1 means type exists */
         int exArgs,       /* =1 means arguments exists */
         const char *TypeOfIndex,  /* make index entry in e.g. "fn" */
         const char *CategoryDef   /* some of the @def's are shortages of other @def's */
     );
String &EolPar (void);

void ErrorOut (const char *msg, const char *yyt);
void WarningOut (const char *msg, const char *yyt);

typedef enum { ifclear, ifset, ifhtml, iftex, ifinfo } tIfType;

static const char *cIfType[5] =
    {
        "ifclear",
        "ifset",
        "ifhtml",
        "iftex",
        "ifinfo"
    };


typedef struct
    {
        tIfType IfType;
        int     Condition;
    } tIfStack;

typedef struct
    {
        YY_BUFFER_STATE state;
        char            *fn;   /* File name of include file */
        int             lineno;
    } tIncludeStack;
/* extern "C" int yywrap();*/

int iff(String& arg, tIfType IfType);
/*int iff(String&, int); */
/*int endiff();*/
int endiff(tIfType IfType);


const int	MaxIncl = 10;
/* YY_BUFFER_STATE inclstack[MaxIncl];*/
tIncludeStack   inclstack[MaxIncl];
int		incllevel = 0;

const int	MaxIf = 10;
/* int		ifstack[MaxIf];*/
tIfStack        ifstack[MaxIf];
int		iflevel = 0;

/* This need to let @raisesection or
 * @lowersection work, but actual it doesn't
 */
int             HeadingLevel = 0;

%}
%option stack
/*%option noyywrap*/

NL      \r?\n
WS      [ \t]*
WSP     [ \t]+

%x	TABLE MENU FALSE IGNORE TEX TITLE DIRENTRY MULTITABLE

%x      IFTEX IGNORESTUFF IFSET IFCLEAR

%%
    
START-INFO-DIR-ENTRY{WS}{NL}  { SAVESTATE (IGNORESTUFF); yylineno++; }
<IGNORESTUFF>.            ;
<IGNORESTUFF>\n           ++yylineno;
<IGNORESTUFF>END-INFO-DIR-ENTRY[ \t]*\n   { ++yylineno; RESTORESTATE;  };

">"                     *out << "&gt;";
"<"                     *out << "&lt;";
@\*			*out << "<BR>" << endl;
@\.			PUTS ("."); /* *out << ".";*/
@\:			;
@@			PUTS ("@"); /* *out << "@"; */
@\{			*out << "\\{";
@\}			*out << "\\}";
\\                      *out << "\\\\";

@afourpaper             { WarningOut ( "@afourpaper has to be rounded with @iftex ... @end iftex"
                                     ",look into Texinfo Manual Release 3.9 section 'Printing on A4 Paper'", yytext); }
@appendix		heading(HeadingLevel+1, eol());
@appendixsec		heading(HeadingLevel+2, eol());
@appendixsection	heading(HeadingLevel+2, eol());
@appendixsubsec		heading(HeadingLevel+3, eol());
@appendixsubsubsec	heading(HeadingLevel+4, eol());
@asis			;
@author			PUTE("ADRESS", eol());
@b\{			PUTE("\\b", arg ());
@break			;
@bullet\{\}		*out << "&curren;";
@bye			return 0;
<INITIAL,MENU,TABLE>@c  skip();
@cartouche		;
@end\ cartouche         ;
@center			*out << "\\par \\pard \\qc " << eol () << endl << "\\par \\pard ";
@chapheading		heading(HeadingLevel+1, eol());
@chapter		heading(HeadingLevel+1, eol());
@cindex			{ String s = eol (); indexref("cp", s);
                          *out << "{\\cs16\\super" << endl;
                          *out << "K{\\footnote \\pard\\plain \\s15 \\f4\\fs20\\lang1031 {\\cs16\\super K}" << s << "}" << endl;
                          *out << "}" << endl;
                        }
@cite\{			PUTE("CITE", arg());
@clear			flags.del(eol());
@code\{			PUTE("\\f11", arg ());
<INITIAL,MENU,TABLE>@comment  skip();
@contents               ;
@copyright\{\}		*out << "&copy;";
@cropmarks		/*!!*/;
@defcodeindex           skip ();
                        /*
                              +------------------------- x-Version (@def...x)
                              !  +---------------------- has category
                              !  !  +------------------- has class
                              !  !  !  +---------------- has type
                              !  !  !  !  +------------- has arguments
                              !  !  !  !  !    +-------- type of index
                              !  !  !  !  !    !    +--- category name
                              !  !  !  !  !    !    !           */
@defcv{WSP}             Defs (0, 1, 1, 0, 0, "vr", (char *)NULL);
@defcvx{WSP}            Defs (1, 1, 1, 0, 0, "vr", (char *)NULL);
@deffn{WSP}             Defs (0, 1, 0, 0, 1, "fn", (char *)NULL);
@deffnx{WSP}            Defs (1, 1, 0, 0, 1, "fn", (char *)NULL);
@defivar{WSP}           Defs (0, 0, 1, 0, 0, "vr", "Instance Variable");
@defivarx{WSP}          Defs (1, 0, 1, 0, 0, "vr", "Instance Variable");
@defmac{WSP}            Defs (0, 0, 0, 0, 1, "fn", "Macro");
@defmacx{WSP}           Defs (1, 0, 0, 0, 1, "fn", "Macro");
@defmethod{WSP}         Defs (0, 0, 1, 0, 1, "fn", "Method");
@defmethodx{WSP}        Defs (1, 0, 1, 0, 1, "fn", "Method");
@defop{WSP}             Defs (0, 1, 1, 0, 1, "fn", (char *)NULL);
@defopx{WSP}            Defs (1, 1, 1, 0, 1, "fn", (char *)NULL);
@defopt{WSP}            Defs (0, 0, 0, 0, 0, "vr", "User Option");
@defoptx{WSP}           Defs (1, 0, 0, 0, 0, "vr", "User Option");
@defspec{WSP}           Defs (0, 0, 0, 0, 1, "fn", "Special Form");
@defspecx{WSP}          Defs (1, 0, 0, 0, 1, "fn", "Special Form");
@deftp                  Defs (0, 1, 0, 1, 1, "vr", (char *)NULL);
@deftpx{WSP}            Defs (1, 1, 0, 1, 1, "vr", (char *)NULL);
@deftypefn{WSP}         Defs (0, 1, 0, 1, 1, "fn", (char *)NULL);
@deftypefnx{WSP}        Defs (1, 1, 0, 1, 1, "fn", (char *)NULL);
@deftypefun{WSP}        Defs (0, 0, 0, 1, 1, "fn", "Function");
@deftypefunx{WSP}       Defs (1, 0, 0, 1, 1, "fn", "Function");
@deftypevr{WSP}         Defs (0, 1, 0, 1, 0, "vr", (char *)NULL);
@deftypevrx{WSP}        Defs (1, 1, 0, 1, 0, "vr", (char *)NULL);
@deftypevar{WSP}        Defs (0, 0, 0, 1, 0, "vr", "Variable");
@deftypevarx{WSP}       Defs (1, 0, 0, 1, 0, "vr", "Variable");
@defun{WSP}             Defs (0, 0, 0, 0, 1, "fn", "Function");
@defunx{WSP}            Defs (1, 0, 0, 0, 1, "fn", "Function");
@defvar{WSP}            Defs (0, 0, 0, 0, 0, "vr", "Variable");
@defvarx{WSP}           Defs (1, 0, 0, 0, 0, "vr", "Variable");
@defvr{WSP}             Defs (0, 1, 0, 0, 0, "vr", (char *)NULL);
@defvrx{WSP}            Defs (1, 1, 0, 0, 0, "vr", (char *)NULL);
@dircategory            skip ();
@direntry               SAVESTATE (DIRENTRY); skip ();
<DIRENTRY>.             ;
<DIRENTRY>\n            yylineno++;
<DIRENTRY>@end\ direntry skip (); RESTORESTATE;
@end\ def[a-z]+         margin(-10); newpara = 1;

@dfn\{			PUTE ("DFN", arg ());
@display		beg_example("default");
@end\ display		end_example();
@dmn\{			PUTS(' ' << arg());
@dots\{\}		*out << "&middot;&middot;&middot;";
@email\{                { String s = arg ();
                          PUTEA ("a", "href=\"mailto:" << s << "\"", s);
                        }
@emph\{			PUTE ("EM", arg ());
@enumerate		item_begin("<OL>\n", 'o',0); skip();
@end\ enumerate		item_end("</OL>\n");
@equiv\{\}		PUTS("==");
@enddots\{\}            *out << "&middot;&middot;&middot;&middot;";
@error\{\}		PUTEA ("NOTE", "ROLE=WARNING", "");
@evenfooting		eol();
@evenheading		eol();
@everyfooting		eol();
@everyheading		eol();
@example		beg_example("Courier");
@end\ example		end_example();
@exdent			{ int old=margin(0); PUTS(eol()); margin(old); }
@expansion\{\}		PUTS("==>");
@file\{			PUTE ("TT", arg ());
@finalout		;
@findex			indexref("fn", eol());
@flushleft		;
@end\ flushleft		;
@flushright		*out << "<P ALIGN=RIGHT>" << endl;
@end\ flushright	*out << "</P>" << endl;
@footnote\{		footnote();
@footnotestyle		skip ();
@format			*out << endl << "\\par {\\f11 ";
@end\ format		*out << "\\par }" << endl;
@ftable			item_begin(":parml break=fit.", 'p',"Function"); SAVESTATE (TABLE);
@end\ ftable		item_end(":eparml.");
<TABLE>@code		istackp->beg = Item("Courier"); istackp->end = Item("default");
<TABLE>@kbd		istackp->beg = 0; istackp->end = 0;
<TABLE>@key		istackp->beg = 0; istackp->end = 0;
<TABLE>@samp		istackp->beg = Item("Courier", 0, "&apos."); istackp->end = Item("default", 0, "&apos.");
<TABLE>@var		istackp->beg = Item(0, 1); istackp->end = Item(0, 1);
<TABLE>@file		istackp->beg = Item("Courier"); istackp->end =Item("default");
<TABLE>@dfn		istackp->beg = Item(0, 1); istackp->end = Item(0, 1);
<TABLE>@cite		istackp->beg = Item(0, 1); istackp->end = Item(0, 1);
<TABLE>@asis		istackp->beg = 0; istackp->end = 0;
<TABLE>@bullet		istackp->beg = Item(0, 100); istackp->end = Item(0, 0);
<TABLE>@b		istackp->beg = Item(0, 2); istackp->end = Item(0, 2);
<TABLE>@strong		istackp->beg = Item(0, 2); istackp->end = Item(0, 2);
<TABLE>@i		istackp->beg = Item(0, 1); istackp->end = Item(0, 1);
<TABLE>@r		istackp->beg = Item("'Tms Rmn'"); istackp->end = Item("default");
<TABLE>@t		istackp->beg = Item("Courier"); istackp->end = Item("default");
<TABLE>@emph		istackp->beg = Item(0, 1); istackp->end = Item(0, 1);
<TABLE>[ \t]		;
<TABLE>\n		RESTORESTATE; /*BEGIN(0);*/ ++yylineno; /* this might an error */
@group			;
@end\ group		;
@heading		heading(HeadingLevel+2, eol());
@headings		eol();
@hyphenation\{          arg ();
@i\{			PUTE ("\\i", arg ());
<INITIAL,IFCLEAR,MENU,TABLE>@ifclear{WSP}           if (iff(eol(), ifclear)) SAVESTATE (IFCLEAR);
<IFCLEAR>.              ;
<IFCLEAR>\n             { if (yy_flex_debug) cerr << "IFCLEAR> " << endl; ++yylineno;}
<INITIAL,IFCLEAR,MENU,TABLE>@end\ ifclear {    int s = endiff (ifclear);
                             if (s<0)
                                 ErrorOut ("Unmatched @end ifclear", (char *)NULL);
                             else
                             {
                                 if (s)
                                     RESTORESTATE;
                             }
                             skip ();
                        }
<INITIAL,MENU,TABLE>@ifset{WSP}             if (!iff(eol(), ifset)) SAVESTATE (IFSET);
<IFSET>.                ;
<IFSET>\n               { if (yy_flex_debug)cerr << "IFSET> " << endl; ++yylineno; }
<INITIAL,IFSET,MENU,TABLE>@end\ ifset {   int s = endiff (ifset);
                            if (s<0)
                                ErrorOut ("Unmatched @end ifset", (char *)NULL);
                            else
                            {
                                if (!s) RESTORESTATE;
                            }
                        }
@ifinfo			;
@end\ ifinfo		;
@iftex			{ SAVESTATE (IFTEX); } /* Ignore everything which is used
                                                * to make a prettier output with TeX
                                                */
<IFTEX>.               ;
<IFTEX>\n               ++yylineno;
<IFTEX>^@end[ \t]+iftex  { RESTORESTATE; }
@ignore			SAVESTATE (IGNORE); /* BEGIN (IGNORE) */
<IGNORE>^@end\ ignore    { /*BEGIN(0);*/ eol(); RESTORESTATE; }
<IGNORE>\n		++yylineno;
<IGNORE>.		; /* Test += yytext[0];*/
@include{WSP}           { include(EolPar ()); /* BEGIN(INITIAL);*/ SAVESTATE (INITIAL); }
@inforef		eol();
^\\input		{ skip (); /* eol(); */ }
@item			istackp->item(eol());
@itemize		item_begin("<UL>\n", 'u',0); skip();
@end\ itemize		item_end("</UL>\n");
@itemx			istackp->item(eol());
@kbd\{			PUTE ("KBD", arg ());
@key\{			PUTE ("KBD", arg ());
@kindex			indexref("ky", eol());
@lisp			beg_example("Courier");
@end\ lisp		end_example();
@majorheading		eol();
@medbreak		;
@menu			eol(); SAVESTATE (MENU); /*BEGIN(MENU);*/ menu.line = ""; *out << "<UL>" << endl;
<MENU>@end\ menu	RESTORESTATE; /*BEGIN(0);*/ eol(); menu.flush(); *out << "</UL>" << endl;
<MENU>\*[ \t]+		menu.flush(); menu.line = eol();
<MENU>[ \t]+		menu.line += ' '; menu.line += eol();
<MENU>\n[ \t]*\n	menu.flush(); PUTL(); ++yylineno;
<MENU>\n		++yylineno;
<MENU>^\@detailmenu       skip ();
<MENU>^\@end\ detailmenu  skip ();
<MENU>.			menu.flush(); PUTS(yytext[0]); PUTS(eol()); PUTL();
@minus\{\}              *out << "-";
@multitable             skip (); SAVESTATE (MULTITABLE);
<MULTITABLE>\n          ++yylineno;
<MULTITABLE>.           ;
<MULTITABLE>^@end\ multitable   skip (); RESTORESTATE;
@need			eol();
@node			words(eol()); node(w[0], w[1], w[2], w[3]);
@nwnode                 words(eol()); node(w[0], w[1], w[2], w[3]);
@noindent		newpara = 0; /*PUTS(endl << ".br"); PUTL();*/
@oddfooting		eol();
@oddheading		eol();
@page			;
@paragraphindent	eol();
@pindex			indexref("pg", eol());
@point\{\}		*out << "*";
@print\{\}		*out << "-!";
@printindex		printindex(eol());
@pxref\{		words(arg()); xref("see ", w[0], w[1], w[2], w[3], w[4]);
@quotation		margin(+10); PUTA(":rm margin=4.");
@end\ quotation		margin(-10); PUTA(":rm margin=1.");
@r\{			font("'Tms Rmn'"); PUTS(arg()); font(0);
@ref\{			words(arg()); xref(0, w[0], w[1], w[2], w[3], w[4]);
@refill			;
@result\{\}		*out << "=>";
@samp\{			PUTE("SAMP", arg ());
@sc\{			{ const char *cp = upcase(arg()); PUTE ("\\scaps", cp); }
@section		heading(HeadingLevel+2, eol());
@set			setflag(eol());
@setchapternewpage	skip (); /* eol(); */
@setfilename		skip (); /* eol () */
@settitle		PUTS(eol ());
@shortcontents		;
@smallbook		;
@smallexample		beg_example("Courier");
@end\ smallexample	end_example();
@smalllisp		beg_example("Courier");
@end\ smalllisp		end_example();
@sp			{ int n = atoi(eol()); while (n--) *out << "\\par \\par" << endl; }
@strong\{		PUTE ("\\outl", arg ());
@subheading		heading(HeadingLevel+3, eol());
@subsection		heading(HeadingLevel+3, eol());
@subsubheading		heading(HeadingLevel+4, eol());
@subsubsection		heading(HeadingLevel+4, eol());
@subtitle		eol();
@summarycontents	;
@syncodeindex		eol();
@synindex		eol();
@t\{			PUTE ("TT", arg ());
                        /* I can't find any documentation about this @tt{} */
@tt\{			PUTE ("TT", arg ());
@table			/* BEGIN(TABLE); */ item_begin(":parml break=fit.", 'p',0); SAVESTATE (TABLE);
@end\ table		item_end(":eparml.");
@ktable			item_begin(":parml break=fit.", 'p',0); SAVESTATE (TABLE); /* BEGIN (TABLE); */
@end\ ktable		item_end(":eparml.");
@TeX\{\}		*out << "TeX";
@tex			SAVESTATE (TEX); /* BEGIN(TEX);*/
<TEX>^@end\ tex		RESTORESTATE; /*BEGIN(0);*/ eol();
<TEX>\n			++yylineno;
<TEX>.			;
@thischapter		;
@thischaptername	;
@thisfile		;
@thispage		;
@thistitle		;
@tindex			indexref("tp", eol());
@title			skip (); /* might be changed to get the title */
@titlefont\{		arg();
@shorttitlepage		eol();
@titlepage		SAVESTATE (TITLE); /*BEGIN(TITLE);*/
<TITLE>^@end\ titlepage	RESTORESTATE; /* BEGIN(0);*/ eol();
<TITLE>\n		++yylineno;
<TITLE>.		;
@today\{\}              ;
@top			table["Top"] = Name(++hdid, 1, 0); heading(1, eol());
@unnumbered		heading(HeadingLevel+1, eol());
@unnumberedsec		heading(HeadingLevel+2, eol());
@unnumberedsubsec	heading(HeadingLevel+3, eol());
@unnumberedsubsubsec	heading(HeadingLevel+4, eol());
@url\{                  PUTE ("URL", arg ()); /* this should be changed to make a link */
@value\{		{ String& s = arg(); if (flags.contains(s)) PUT(flags[s]); }
@var\{			PUTE ("VAR", arg ());
@vindex			indexref("vr", eol());
@vskip			eol();
@vtable			SAVESTATE(TABLE); item_begin(":parml break=fit.", 'p',"Variable"); /* BEGIN(TABLE); */
@end\ vtable		item_end(":eparml.");
@w\{			PUT ("\\par " << arg()); /* *out << arg () << endl;*/ /*  << endl; */ /*single_word(arg());*/
@xref\{			words(arg()); xref("See ", w[0], w[1], w[2], w[3], w[4]);

@end[ ]+[.]+           ErrorOut ("Unknown control", yytext);

                        /* Those things inserted here are handled but
                           not correct.
                           I have to check if they are makeable in IPF
                           */
@AA\{\}                 *out << "A";
@aa\{\}                 *out << "a";
@AE\{\}                 *out << "&AElig;";
@ae\{\}                 *out << "&aelig;";
@dotless\{              PUTS(arg()); /* has to print without dots.
                                        I don't know if this is possible
                                        under IPF */
@H\{                    { arg (); } /* Ignore the parameters */
@l\{\}                  *out << "l";
@L\{\}                  *out << "L";
@o\{\}                  *out << "&oslash;";
@O\{\}                  *out << "&Oslash;";
@OE\{\}                 *out << "OE"; /* not correct */
@oe\{\}                 *out << "oe"; /* not correct */
@\"a                    *out << "&auml;";
@\"o                    *out << "&ouml;";
@\"u                    *out << "&uuml;";
@\"A                    *out << "&Auml;";
@\"O                    *out << "&Ouml;";
@\"U                    *out << "&Uuml;";
@ss\{\}                 *out << "&szlig;";
@questiondown\{\}       *out << "&iquest;";
@exclamdown\{\}         *out << "&iexcl;";
@pounds\{\}             *out << "&pund;";
@dotaccent\{            PUTS(arg ());
@ringaccent\{           PUTS(arg ());
@tieaccent\{            PUTS(arg ());
@ubaraccent\{           PUTS(arg ());
@udotaccent\{           PUTS(arg ());
@u\{                    PUTS(arg ());
@v\{                    PUTS(arg ());


@raisesections          skip (); /*HeadingLevel--; */
@lowersections          skip (); /*HeadingLevel++; */
\&			*out << "&amp;";
\n			++yylineno; return '\n';
\r			;
" "                     return 0x20;
\:			*out << ":";
\.			*out << ".";
\{			return '{'; /* PUTS(arg());*/
\}			return '}';
.			PUTS (yytext[0]); /**out << yytext[0]; */
<<EOF>>			{
                          if (yy_flex_debug) cerr << "<<EOF>> done." << endl;
                          if (--incllevel < 0)
				yyterminate();
			  else {
				yy_delete_buffer(YY_CURRENT_BUFFER);
                                if (inclstack[incllevel].fn)
                                    free (inclstack[incllevel].fn);
				yy_switch_to_buffer(inclstack[incllevel].state);
                                yylineno = inclstack[incllevel].lineno;
                                /*yyrestart (yyin);*/
			  }
			}


@end\ [-a-zA-Z0-9_$]+   ErrorOut ("Unknown @end control-sequence", yytext); yylineno++;
@[-a-zA-Z0-9_$]+        ErrorOut ("Unknown control", yytext);

%%

// @[$0-9A-Z_a-z]+         ErrorOut ("Unknown control", yytext);
//@defcv[ \t]+		define(eol(), 0, "vr", 1, 0, null);
//                       { SAVESTATE (DEF); }
//<DEF>  /* in paramter or arguments it is allowed to put @var or @values
//        * (seen in texinfo manual chapter 16 def-commands)
//        */
//<DEF>@var\{             { PUT(":hp1."); PUTS(arg()); PUT(":ehp1."); }
//<DEF>@value\{		{ String& s = arg(); if (flags.contains(s)) PUT(flags[s]); }

//<DEF>\n                 { RESTORESTATE; }

/***********************
<INITIAL,TABLE,FALSE,MENU,TITLE>@ifclear	if (!iff(eol(), 0)) SAVESTATE (FALSE);
<INITIAL,TABLE,FALSE,MENU,TITLE>@ifset		if (!iff(eol(), 1)) SAVESTATE (FALSE);
<INITIAL,TABLE,MENU,TITLE>^@end\ ifclear	RESTORESTATE;
<INITIAL,TABLE,MENU,TITLE>^@end\ ifset		RESTORESTATE;
<FALSE>^@end\ if[a-z]+				yy_start = endiff(); eol(); RESTORESTATE;
<FALSE>\n		++yylineno;
<FALSE>.		;
**********************************************************/



static String	buffer;

String &
arg()
{
	ostrstream ostr;
	ostream *old = out;
	out = &ostr;
        int Argument = 1;

	if (plevel == 9)
		unexpected(0);
	plines[++plevel] = yylineno;
	if (yy_flex_debug)
	{
	    fprintf(stderr, "++push to %d\n", plevel);
	    cerr << "Saving state." << endl;
	}
        SAVESTATE (INITIAL);
	int old_np = newpara;
	int old_nl = lastnl;
	/* BEGIN(0);*/
	newpara = 0;
	for (;;) {
		switch (yylex()) {
		case 0:
			unexpected("EOF");
                case '{':
                     continue;

                case '}':
                    if (!Argument)
                        continue;
                    else
                        Argument = 0;
                    break;

                case 0x20:
                    *out << " ";
                    continue;


		case '\n':

			/*if (ostr.pcount() > 100) {
				PUTL();
			} else
				PUT(' ');
                                */
                        *out << endl;
			/*++yylineno; */ /* already done by yylex () */
			continue;
		default:
			continue;
		}
		break;
	}

	if (yy_flex_debug)
	    cerr << "Restoring state." << endl;
	    
        RESTORESTATE;

	newpara = old_np;
	lastnl = old_nl;

	if (yy_flex_debug)
		fprintf(stderr, "++pop from %d\n", plevel);
	--plevel;

	buffer = String(ostr.str(), ostr.pcount());
	/* while (buffer.length() && isspace(buffer[0]))
		buffer.del(0, 1);
                */

	if (yy_flex_debug)
		cerr << "arg(): \"" << buffer << "\"" << endl;

	out = old;
	return buffer;
}

String &
eol()
{
	ostrstream ostr;
	ostream *old = out;
	out = &ostr;
	
	if (plevel == 9)
		unexpected(0);
	plines[++plevel] = yylineno;
	if (yy_flex_debug)
		fprintf(stderr, "++push to %d\n", plevel);

	int old_start = yy_start;
	int old_np = newpara;
	int old_nl = lastnl;
        int Argument = 0;

	BEGIN(INITIAL); /* this might be wrong */
	newpara = 0;
	for (;;) {
		switch (yylex()) {
		case 0:
			unexpected("EOF");
                case '{':
                    Argument = 1;
                    PUTS(arg());
                    continue;
		case '}':
                    if (!Argument)
                        unput('}');
                    else
                        Argument = 0;
		    break;
		case '\n':
			/*unput('\n');*/
                        /**out << endl;*/
			break;
                case 0x20:
                    *out << " ";
                    continue;
		default:
			continue;
		}
		break;
	}
	yy_start = old_start;
	newpara = old_np;
	lastnl = old_nl;

	if (yy_flex_debug)
		fprintf(stderr, "++pop from %d\n", plevel);
	--plevel;

	buffer = String(ostr.str(), ostr.pcount());
	while (buffer.length() && isspace(buffer[0]))
		buffer.del(0, 1);
	out = old;
	return buffer;
}

void
unexpected(const char *msg)
{
	if (msg)
            ErrorOut ("Unexpected EOF",(char *)NULL);
	else
        {
                if (incllevel > 0)
                    cerr << inclstack[incllevel-1].fn << ": Nesting overflow in line " << yylineno << endl;
                else
                    cerr << "Nesting overflow in line " << yylineno << endl;
        }
	for (; plevel; --plevel)
        {
		cerr << "\tunterminated argument starting in line "
		     << plines[plevel] << endl;
        }
	cerr.flush();
	exit(1);
}

void
footnote()
{
	++fnid;
	PUTS(":fn id=fn" << fnid << '.' << arg() << ":efn. "
	  << ":link reftype=fn refid=fn" << fnid << ".(" << fnid << "):elink.");
}

void
newline()
{
	if (!lastnl) {
		lastnl = 1;
		*out << endl;
	}
	if (!nofill) {
		int c = yyinput();
		if (c == '\n') {
			newpara = 1;
			do ++yylineno; while ((c = yyinput()) == '\n');
		}
		unput(c);
	}
}	

void
skip()
{
    int c;
    for (; (c = yyinput()) != '\n'; )
        ;
    ++yylineno;
}

String &EolPar (void)
{
    static String Buffer;
    int c;
    Buffer = "";
    for (; (c = yyinput()) != '\n'; )
        Buffer += (char)c;
    /* ++yylineno; ???*/
    return Buffer;
}

void
dot()
{
	int c = yyinput();
	if (c == '.') {
		PUTS("&dot.");
		do { PUT("&dot."); } while ((c = yyinput()) == '.');
	} else if (lastnl) {
		PUTS("&dot.");
	} else
		PUTS('.');
	unput(c);
}

void include(const char *fname)
{
	if (incllevel >= MaxIncl)
        {
		cerr << "Includes nested too deeply" << endl;
		exit(1);
	}
        inclstack[incllevel].fn = strdup (fname);
        if (!(inclstack[incllevel].fn))
        {
            cerr << "Not enough memory" << endl;
            exit (2);
        }

	inclstack[incllevel].state = YY_CURRENT_BUFFER;
	inclstack[incllevel++].lineno = yylineno;
        cerr << " [" << fname;
	char name[FILENAME_MAX+1];
	strcpy(name, fname);
	char *namep = strtok(name, " \t");	// strip any blanks
	yyin = fopen(namep, "r");
	if (!yyin) {
		char *dotp = strrchr(namep, '.');
		if (dotp && !strpbrk(dotp, ":\\/") && strlen(dotp) > 4)
			dotp[4] = 0;		// truncate .texi to .tex
		yyin = fopen(namep, "r");
	}
	if (!yyin)
        {
		cerr << "Cannot open include file '" << namep << "': "
		     << strerror(errno) << endl;
		exit(1);
	}

        IncludeFile = 1;

        /* next include file we start counting from one */
        yylineno = 1;
	yy_switch_to_buffer(yy_create_buffer(yyin, YY_BUF_SIZE));
        yyrestart (yyin);
}

int
yywrap()
{
    static int Nr = 0;
    fclose (yyin);
    if (incllevel >0 )
    {
        cerr << "] ";
        Nr ++;
        if (Nr > 3)
        {
            cerr << endl;
            Nr = 0;
        }
    }
    else
        cerr << "] " << endl;

    if (--incllevel < 0)
    {
          yyterminate();
          return 1;
    }
    else
    {
          yy_delete_buffer(YY_CURRENT_BUFFER);
          if (inclstack[incllevel].fn)
              free (inclstack[incllevel].fn);
          yylineno = inclstack[incllevel].lineno;
          yy_switch_to_buffer(inclstack[incllevel].state);
          return 0;
    }
}




int iff(String& arg, tIfType IfType)
{

    if (yy_flex_debug)
        cerr << "Contains(" << arg << ")=" << flags.contains (arg) << endl;

    if (iflevel >= MaxIf)
    {
        cerr << "Conditions nested too deeply" << endl;
        exit (3);
    }

    ifstack[iflevel].IfType = IfType;
    ifstack[iflevel++].Condition = flags.contains(arg);
    if (flags.contains(arg))
        return 1;
    else
        return 0;
}

int endiff(tIfType IfType)
{
    String s;

    if (iflevel < 1)
        return -1; /* Error, unmatched @end */

    --iflevel;
    if (ifstack[iflevel].IfType != IfType)
    {
        s = "Expected @end ";
        s += cIfType[ifstack[iflevel].IfType];
        s += " but read another.";
        ErrorOut (s, (char *)NULL);
    }
    return ifstack[iflevel].Condition;
}


/*
 */
String &DefPar ()
{
    static String buffer;
    ostrstream ostr;
    ostream *old = out;
    out = &ostr;
    int old_start = yy_start;
    int old_np = newpara;
    int old_nl = lastnl;
    int c;
    int Paras = 0;

    if (plevel == 9)
	    unexpected(0);
    plines[++plevel] = yylineno;
    if (yy_flex_debug)
	    fprintf(stderr, "++ DefPar:: push to %d\n", plevel);

    BEGIN(0);
    newpara = 0;
    for (;;)
    {
        c = yylex ();
        if (yy_flex_debug)
	    fprintf(stderr, "  DefPar:: c=%d c=\"%c\"\n", c, (char)c);
        switch (c)
        {
            case 0:
                unexpected("EOF");

            case '{':
                if (yy_flex_debug)
	            fprintf(stderr, "DefPar:: { erkannt\n");
                Paras = 1;
                /*yylex ();*/
                /**out << arg();*/
                continue;

            case '}':
                if (!Paras)
                {
                    yyinput ();
                    continue;
                }

                if (yy_flex_debug)
	            fprintf(stderr, "DefPar:: } erkannt\n");
                Paras = 0;
                /*c = yylex ();*/
                yyinput ();
                /*IgnoreSpace ();*/
                break;

            case 0x20:
                if (Paras)
                {
                    *out << " ";
                    continue;
                }
                else
                {
                /*c = yylex ();*/
                /*IgnoreSpace ();*/
                break;
                }

            case '\n':
                /* *out << endl; ??? */
                /*unexpected ("LF");*/
                break;

            default:
                continue;

        } /* switch (yylex())... */
        break;
    } /* for (;;)... */

    yy_start = old_start;
    newpara = old_np;
    lastnl = old_nl;

    if (yy_flex_debug)
	    fprintf(stderr, "++ DefPar:: pop from %d\n", plevel);

    --plevel;

    while ( (c = yyinput ()) == ' ');
    unput (c);

    buffer = String(ostr.str(), ostr.pcount());
    while (buffer.length() && isspace(buffer[0]))
	    buffer.del(0, 1);
    out = old;
    return buffer;
}


void Defs
     (
         int xVariant,     /* is on of the @def...x */
         int exCategory,   /* =1 means category exists */
         int exClass,      /* =1 class exists */
         int exType,       /* =1 means type exists */
         int exArgs,       /* =1 means arguments exists */
         const char *TypeOfIndex,  /* make index entry in e.g. "fn" */
         const char *CategoryDef   /* some of the @def's are shortages of other @def's */
     )
{
    String Category = CategoryDef;
    String Class;
    String Type;
    String Name;
    String Args;

    if (yy_flex_debug)
    {
        cerr << "Defs" << endl;
        cerr << "Defs::Category:" << endl;
    }

    if (exCategory)
    {
        Category = DefPar ();
        if (yy_flex_debug)
            cerr << "CAT: " << Category << endl;
    }

    if (yy_flex_debug)
        cerr << "Defs::Class:" << endl;

    if (exClass)
    {
        Class = DefPar ();
        if (yy_flex_debug)
            cerr << "CLASS: " << Class << endl;
    }

    if (yy_flex_debug) cerr << "Defs::Type:" << endl;

    if (exType)
    {
        Type = DefPar ();
        if (yy_flex_debug)
            cerr << "TYP: " << Type << endl;
    }

    /* should always exist */
    if (yy_flex_debug)
        cerr << "Defs::Name:" << endl;
    Name = DefPar ();

    if (yy_flex_debug)
        cerr << "Defs::Args:" << endl;
    if (exArgs)
    {
        Args = eol ();
        if (yy_flex_debug)
            cerr << "ARGS: " << Args << endl;
    }

    /*newpara = 1;
    if (xVariant)
        margin (-10);
    else if (newpara)
        para (); */

    /*font ("Courier", FontSize);*/

    /*if (xVariant)
        *out << endl << "XVARIANTE" << endl;
        */

    PUTL ();
    PUT (" \\par "); /* *out << endl << "\\par "; */

    if (exType)
        PUT ("{\\i " << Type << "} ");

    /* *out << "{\\b\\f5 " << Name << " } "; */
    PUT ("{\\b\\f5 " << Name << " } ");

    if (exArgs)
        PUT ("{\\b\\i\\f11 " << Args << "} ");

    if (exCategory)
    {
        PUT ("{\\fs24 [" << Category << "]}");
        PUTL ();
    }
    else
        PUTL();

    lastnl = 1;
/*    margin (10);
    */
    indexref (TypeOfIndex, Name);

}


void ErrorOut (const char *msg, const char *yyt)
{
    if (incllevel > 0)
        cerr << endl << inclstack[incllevel-1].fn << ":"
             << yylineno << ": " << msg << "(" << yyt << ")"
             << endl;
    else
        cerr << msg << "(" << yyt << ") in line " << yylineno << endl;
}

void WarningOut (const char *msg, const char *yyt)
{
    if (incllevel > 0)
        cerr << endl << "warning: " << inclstack[incllevel-1].fn << ":"
             << yylineno << ": " << msg << "(" << yyt << ")"
             << endl;
    else
        cerr << "warning: " << msg << "(" << yyt << ") in line " << yylineno << endl;
}



