{&AlignCode-,AlignData-,AlignRec-,G3+,Speed-,Frame-}
{$M 262144}
uses  os2base, miscUtil, SysLib, CmdLine, Collect, os2exe, exe386,
  strOp, Crt, Dos;

const
  Version   = '0.1.0 ';
  Recurse   : boolean = false;
  AllDone   : boolean = false;
  CreateRPL : boolean = false;
type
  pModuleExport = ^tModuleExport;
  tModuleExport = record
    Module : pString;
    Entry : pString;
    Ordinal : Longint;
  end;
  pModuleExportCollection = ^tModuleExportCollection;
  tModuleExportCollection = object(tCollection)
    procedure FreeItem(Item: Pointer); virtual;
  end;
var
  fNames  : pStringCollection;
  OldExit : Procedure;
  LX      : pLX;
  RPL     : pModuleExportCollection;

procedure tModuleExportCollection.FreeItem;
begin
  DisposeStr (pModuleExport (Item)^.Module);
  DisposeStr (pModuleExport (Item)^.Entry);
  Dispose (pModuleExport (Item));
end;

Procedure ReadRPL;
label
  badformat;
var
  N,S : String;
  T   : Text;
  L,I : Longint;
  MEx : pModuleExport;
begin
  S := SourcePath + '\lxFix.rpl';
  Assign (T, S); Reset (T);
  if (ioResult <> 0) then
  begin
    TextAttr := $0E;
    Writeln (' WARNING: Cannot read RPL file ', S);
    exit;
  end;

  L := 0;
  while not EOF (T) do
  begin
    Readln (T, S);
    Inc (L);
    DelStartSpaces (S);
    if (S = '') or (S [1] = ';') then
      continue;

    I := First (' ', S);
    if (I = 0) then
    begin
badformat:
      Writeln (' Line ', L, ': Invalid module export definition');
      continue;
    end;
    N := Copy (S, 1, I - 1);
    S := Copy (S, I + 1, 255);
    DelStartSpaces (S);
    I := First ('.', S);
    if (I = 0) then
      goto badformat;

    New (MEx);
    MEx^.Entry := NewStr (N);
    N := Copy (S, 1, I - 1);
    MEx^.Module := NewStr (UpStrg (N));
    S := Copy (S, I + 1, 255);
    MEx^.Ordinal := DecVal (S);
    RPL^.AtInsert (RPL^.Count, MEx);
  end;

  Close (T);
end;

Procedure OutputRPL (const fN : string);
var
  S : string;
  T : Text;
  I : Longint;
  ModName : pString;
  Description : pString;
begin
  I := LX^.Header.lxMFlags and lxModType;
  if (I <> lxDLL) and (I <> lxPMDLL) then
  begin
    TextAttr := $0E;
    Writeln (' WARNING: module ', fN, ' is not a DLL');
    exit;
  end;

  ModName := NIL;
  For I := 1 to LX^.ResNameTbl^.Count do
    with pNameTblRec(LX^.ResNameTbl^.At (pred (I)))^ do
      if (Ord = 0) then
      begin
        ModName := Name;
        break;
      end;
  if (ModName = NIL) then
  begin
    TextAttr := $0E;
    Writeln (' WARNING: Dynamic library does not have module name defined');
    exit;
  end;

  Description := NIL;
  For I := 1 to LX^.NResNameTbl^.Count do
    with pNameTblRec(LX^.NResNameTbl^.At (pred (I)))^ do
      if (Ord = 0) then
      begin
        Description := Name;
        break;
      end;

  S := Copy (fN, 1, Last ('.', fN)) + 'rpl';
  Assign (T, S); Rewrite (T);
  if ioResult <> 0 then
  begin
    TextAttr := $0C;
    Writeln (' Error writing .RPL file ', S);
    exit;
  end;

  Write (T, '; --- Module ', ModName^);
  if (Description <> NIL) then
    Writeln (T, ' (', Description^, ')')
  else
    Writeln (T);
  For I := 1 to LX^.ResNameTbl^.Count do
    with pNameTblRec(LX^.ResNameTbl^.At (pred (I)))^ do
      if (Ord <> 0) then
        Writeln (T, Name^, ' ', ModName^, '.', Ord);
  For I := 1 to LX^.NResNameTbl^.Count do
    with pNameTblRec(LX^.NResNameTbl^.At (pred (I)))^ do
      if (Ord <> 0) then
        Writeln (T, Name^, ' ', ModName^, '.', Ord);

  Close (T);
end;

function ReplaceFixup (FUP : pLXreloc) : boolean;
var
  I,J,K : Longint;
  MEx : pModuleExport;
  Module : string;
  Ordinal : Longint;
  pS : pString;
begin
  ReplaceFixup := FALSE;

  Module := upStrg (pString (LX^.ImpModTbl^.At (pred (FUP^.ObjMod)))^);
  Ordinal := FUP^.Target.extRef.Ord;

  for I := 1 to RPL^.Count do
  begin
    MEx := pModuleExport (RPL^.At (pred (I)));
    if (MEx^.Module^ = Module) and
       (MEx^.Ordinal = Ordinal) then
    begin
      K := 0;
      for J := 1 to LX^.ImpProcTbl^.Count do
      begin
        pS := LX^.ImpProcTbl^.At (pred (J));
        if (pS <> nil) then
        begin
          if (pS^ = MEx^.Entry^) then
            break;
          Inc (K, succ (length (pS^)));
        end else
          Inc (K);
      end;
      if (J >= LX^.ImpProcTbl^.Count) then
        LX^.ImpProcTbl^.AtInsert (LX^.ImpProcTbl^.Count, NewStr (MEx^.Entry^));

      FUP^.Flags := (FUP^.Flags and (not nrRtype)) or nrRnam;
      FUP^.Target.extRef.Ord := K;

      ReplaceFixup := TRUE;
      exit;
    end;
  end;
end;

Procedure ConvertFixups (const fN : string);
var
  Fx : pFixupCollection;
  P  : Integer;
  nP : pByteArray;
  PageChg : boolean;
  ReplCount : Longint;
  Module : String;
  I : integer;
begin
  ReplCount := 0;
  New (Fx, Create (16, 16));
  For P := 1 to LX^.Header.lxMPages do
  begin
    if (LX^.Header.lxMFlags and (lxNoIntFix + lxNoExtFix) <> 0) or
       (LX^.ObjMap^[P].PageFlags = pgZeroed)
    then begin
         end
    else with LX^.ObjMap^[P] do
         begin
           LX^.UnpackPage (P);
           if PageFlags <> pgValid then Continue;
           GetMem (nP, LX^.Header.lxPageSize);
           Move (LX^.Pages^[Pred (P)]^, nP^, PageSize);
           FreeMem (LX^.Pages^[Pred (P)], PageSize);
           if PageSize < LX^.Header.lxPageSize then
             FillChar (nP^[PageSize], LX^.Header.lxPageSize - PageSize, 0);
           LX^.Pages^[Pred (P)] := nP;
          end;
    if LX^.GetFixups (P, Fx) then
    begin
      PageChg := FALSE;
      For I := 1 to Fx^.Count do
        with pLXreloc (Fx^.At (pred (I)))^ do
          if (Flags and nrRtype) = nrRord then
          begin
            if (ReplaceFixup (pLXreloc (Fx^.At (pred (I))))) then
            begin
              PageChg := TRUE;
              Inc (ReplCount);
            end;
          end;
      if (PageChg) then
        LX^.SetFixups (P, Fx);
    end;
    Fx^.FreeAll;
  end;
  Dispose (Fx, Destroy);
  TextAttr := $0A;
  if (ReplCount <> 0) then
  begin
    Writeln (' ', fN, ': ', ReplCount, ' references fixed');
    if (LX^.Save (fN, 0) <> 0) then
    begin
      Writeln (' ERROR writing executable image');
      allDone := TRUE;
    end;
  end;
end;

Procedure ProcessFile (const fN : string; Attr : Byte);
var
  rc : Integer;
begin
  rc := LX^.LoadLX (fN);
  if (rc = lxeIsNEformat) then
    rc := LX^.LoadNE (fN, lneIgnoreBound or lneIgnoreLngName or lneIgnoreRsrc);
  if rc <> 0 then
  begin
    TextAttr := $0C;
    Writeln (' Error loading module ', fN);
    exit;
  end;

  if (CreateRPL) then
    OutputRPL (fN)
  else
    ConvertFixups (fN);
end;

Procedure ProcessFiles(const fN : string; Level : Longint);
var
  sr : SearchRec;
  nf : Longint;
  _d : DirStr;
  _n : NameStr;
begin
  _d := extractDir(fN);
  _n := extractName(fN);
  FindFirst(fN, Archive or Hidden or SysFile or Directory, sr);
  nf := 0;
  if (DosError <> 0) and (Level = 0) and (not Recurse) then
  begin
    textAttr := $0C;
    Writeln(' Cannot find such files: ', fN);
  end else
    while (DosError = 0) and (not allDone) do
    begin
      Inc (nf);
      if (length(_d) + length(sr.Name) <= 255) and (sr.Name[1] <> '.') then
        ProcessFile(_d + sr.Name, sr.Attr);
      FindNext (sr);
    end;
  FindClose (sr);
  if allDone or not Recurse then Exit;
  if nf = 0 then
  begin
    textAttr := $0B; Write(' ', Short(_d, 77));
    ClrEOL; Write(#13);
  end;
  FindFirst (_d + '*', Archive or Hidden or SysFile or Directory, sr);
  while (dosError = 0) and (not allDone) do
  begin
    if (sr.Attr and Directory <> 0) and (sr.Name[1] <> '.') and
       (length(_d) + length(sr.Name) + length(_n) + 1 <= 255) then
      ProcessFiles(_d + sr.Name + '\' + _n, succ(Level));
    FindNext (sr);
  end;
  FindClose (sr);
end;

Procedure Stop(eCode : Byte);
begin
  case eCode of
   1,2,3:begin
            case eCode of
              2 : begin
                   TextAttr := $0C;
                   Writeln(' Invalid switch - see help below for details');
                  end;
            end;
            TextAttr := $07;
            Writeln(' Usage: lxFix [executable{ executable{ ...}}]');
            Writeln(' /C{+|-} Create .RPL file(s) for dynamic link modules');
            Writeln(' /R{+|-} [R]ecursive (+) file search through subdirectories');
            TextAttr := $08;
            Writeln('Example: lxFix *.exe');
          end;
  end;
  Halt(eCode);
end;

Function ParmHandler(var S : string) : Byte;

Function Enabled : boolean;
begin
  Enabled := TRUE;
  if length(S) = 1 then
    exit
  else if (S[2] in ['+','-']) then
    ParmHandler := 2
  else if (S[2] in [' ','/']) then
    exit
  else Stop(2);
  if S[2] = '-' then
    Enabled := FALSE;
end;

begin
 ParmHandler := 1;
 case upCase (S [1]) of
   '?',
   'H' : Stop(1);
   'R' : Recurse := Enabled;
   'C' : CreateRPL := Enabled;
   else Stop(2);
 end;
end;

Function NameHandler(var S : string) : Byte;
var
 fN : string;
begin
 NameHandler := ParseName(S, 1, fN);
 if fN <> '' then fNames^.AtInsert(fNames^.Count, NewStr(fN));
end;

Procedure MyExitProc;
begin
  Write (#13);
  TextAttr := $07; ClrEOL;
  OldExit;
end;

var
  I : Integer;

begin
  TextAttr := $0F;
  Writeln('[ lxFix ][ Version '+Version+']');
  Writeln(' Copyright 2000 by FRIENDS software  No rights reserved ');
  TextAttr := $07;
  @OldExit := ExitProc; ExitProc := @MyExitProc;
  New(fNames, Create(8, 8));
  ParseCommandLine(#0, ParmHandler, NameHandler);
  if (fNames^.Count = 0) then Stop(1);

  if (not CreateRPL) then
  begin
    New (RPL, Create (16, 16));
    ReadRPL;
  end;

  New (LX, Create);
  For I := 0 to pred(fNames^.Count) do
  begin
    ProcessFiles (pString(fNames^.At(I))^, 0);
    if allDone then break;
  end;
  Dispose (LX, Destroy);

  if (RPL <> NIL) then
    Dispose (RPL, Destroy);

  TextAttr := $01; ClrEOL;
  Writeln('Done');
end.

