#if !defined( SSCALCSSH)
#  define SSCALCSSH
#  include<string.h>
#  include<sslexc.h>
#  include<ssyaccc.h>

#  define ALexExpressionListMain       0
#  define ALexExpressionListMLCom      1
#  define ALexExpressionListSLCom      2

#  define ALexEnd                      4
#  define ALexPlus                     5
#  define ALexMinus                    6
#  define ALexDiv                      7
#  define ALexMult                     8
#  define ALexMod                      9
#  define ALexPow                      10
#  define ALexOr                       11
#  define ALexAnd                      12
#  define ALexNot                      13
#  define ALexOParen                   14
#  define ALexCParen                   15
#  define ALexDec                      16
#  define ALexOct                      17
#  define ALexHex                      18

#  define AYaccStart                   1
#  define AYaccStartList               2
#  define AYaccExprSingle              3
#  define AYaccExprError               4
#  define AYaccExprPlus                5
#  define AYaccExprMinus               6
#  define AYaccExprMult                7
#  define AYaccExprDiv                 8
#  define AYaccExprMod                 9
#  define AYaccExprNot                 10
#  define AYaccExprAnd                 11
#  define AYaccExprOr                  12
#  define AYaccExprNested              13
#  define AYaccExprNumber              14
#  define AYaccNumberDec               15
#  define AYaccNumberOct               16
#  define AYaccNumberHex               17

   struct _AYaccStackElement
      {
      SSSigned32       olVal;
      };

   typedef struct _AYaccStackElement AYaccStackElement;

   SSRetConstChar ALexClassTokenToConstChar( SSUnsigned32 qulToken)
      {
      const char* zpchToken;
      switch ( qulToken)
         {
         case ALexEnd:
            zpchToken = ";";
            break;

         case ALexPlus:
            zpchToken = "+";
            break;

         case ALexMinus:
            zpchToken = "-";
            break;

         case ALexDiv:
            zpchToken = "/";
            break;

         case ALexMult:
            zpchToken = "*";
            break;

         case ALexMod:
            zpchToken = "%";
            break;

         case ALexPow:
            zpchToken = "**";
            break;

         case ALexOr:
            zpchToken = "or";
            break;

         case ALexAnd:
            zpchToken = "and";
            break;

         case ALexNot:
            zpchToken = "not";
            break;

         case ALexOParen:
            zpchToken = "(";
            break;

         case ALexCParen:
            zpchToken = ")";
            break;

         case ALexDec:
            zpchToken = "dec";
            break;

         case ALexOct:
            zpchToken = "oct";
            break;

         case ALexHex:
            zpchToken = "hex";
            break;

         case SSYaccErrorToken:
            zpchToken = "%error";
            break;

         case SSYaccEofToken:
            zpchToken = "eof";
            break;

         default:
            zpchToken = SSLexTokenNotFound;
         }
      return zpchToken;
      }

   AYaccStackElement* AYaccElementFromProduction( void* qpYacc,
      SSUnsigned32 qulIndex)
      {
      void* zpEle = SSYaccGetElementFromProduction( qpYacc, qulIndex);
      return ( AYaccStackElement*) SSYaccStackElementGetExtra( zpEle);
      }

   SSRetVoidP AYaccClassReduce( void* qpYacc, SSUnsigned32 qulProd, 
      SSUnsigned32 qulSize, void* qpParm)
      {
      void* zpEle;
      SSSigned32 zlVal;
      AYaccStackElement* zpStack;
 
      switch ( qulProd)
         {
         case AYaccStart:
         /* start -> exprStatement */
            break;

         case AYaccStartList:
         /* start -> start exprStatement */
            break;

         case AYaccExprSingle:
         /* exprStatement -> expr ; */
            {
            AYaccStackElement* zpEle = AYaccElementFromProduction( qpYacc, 0);
            printf( "%d,%x\n", zpEle->olVal, zpEle->olVal);
            break;
            }

         case AYaccExprError:
         /* exprStatement -> %error ; */
            break;

         case AYaccExprPlus:
         /* expr -> expr + expr */
            {
            AYaccStackElement* zpEle0 = AYaccElementFromProduction( qpYacc, 0);
            AYaccStackElement* zpEle2 = AYaccElementFromProduction( qpYacc, 2);
            zlVal = zpEle0->olVal + zpEle2->olVal;
            break;
            }

         case AYaccExprMinus:
         /* expr -> expr - expr */
            {
            AYaccStackElement* zpEle0 = AYaccElementFromProduction( qpYacc, 0);
            AYaccStackElement* zpEle2 = AYaccElementFromProduction( qpYacc, 2);
            zlVal = zpEle0->olVal - zpEle2->olVal;
            break;
            }

         case AYaccExprMult:
         /* expr -> expr * expr */
            {
            AYaccStackElement* zpEle0 = AYaccElementFromProduction( qpYacc, 0);
            AYaccStackElement* zpEle2 = AYaccElementFromProduction( qpYacc, 2);
            zlVal = zpEle0->olVal * zpEle2->olVal;
            break;
            }

         case AYaccExprDiv:
         /* expr -> expr / expr */
            {
            AYaccStackElement* zpEle0 = AYaccElementFromProduction( qpYacc, 0);
            AYaccStackElement* zpEle2 = AYaccElementFromProduction( qpYacc, 2);
            if ( zpEle2->olVal == 0)
               {
               printf( "0 divisor detected, terminating\n");
               SSYaccSetAbort( qpYacc);
               break;
               }
            zlVal = zpEle0->olVal / zpEle2->olVal;
            break;
            }

         case AYaccExprMod:
         /* expr -> expr % expr */
            {
            AYaccStackElement* zpEle0 = AYaccElementFromProduction( qpYacc, 0);
            AYaccStackElement* zpEle2 = AYaccElementFromProduction( qpYacc, 2);
            if ( zpEle2->olVal == 0)
               {
               printf( "0 divisor detected, terminating\n");
               SSYaccSetAbort( qpYacc);
               break;
               }
            zlVal = zpEle0->olVal % zpEle2->olVal;
            break;
            }

         case AYaccExprNot:
         /* expr -> not expr */
            {
            AYaccStackElement* zpEle = AYaccElementFromProduction( qpYacc, 0);
            zlVal = ~zpEle->olVal;
            break;
            }

         case AYaccExprAnd:
         /* expr -> expr and expr */
            {
            AYaccStackElement* zpEle0 = AYaccElementFromProduction( qpYacc, 0);
            AYaccStackElement* zpEle2 = AYaccElementFromProduction( qpYacc, 2);
            zlVal = zpEle0->olVal & zpEle2->olVal;
            break;
            }

         case AYaccExprOr:
         /* expr -> expr or expr */
            {
            AYaccStackElement* zpEle0 = AYaccElementFromProduction( qpYacc, 0);
            AYaccStackElement* zpEle2 = AYaccElementFromProduction( qpYacc, 2);
            zlVal = zpEle0->olVal | zpEle2->olVal;
            break;
            }

         case AYaccExprNested:
         /* expr -> ( expr ) */
            {
            AYaccStackElement* zpEle = AYaccElementFromProduction( qpYacc, 1);
            zlVal = zpEle->olVal;
            break;
            }

         case AYaccExprNumber:
         /* expr -> number */
            {
            AYaccStackElement* zpEle = AYaccElementFromProduction( qpYacc, 0);
            zlVal = zpEle->olVal;
            break;
            }

         case AYaccNumberDec:
         /* number -> dec */
            {
            void* zpEle = SSYaccGetElementFromProduction( qpYacc, 0);
            void* zpLexeme = SSYaccStackElementGetLexeme( zpEle);
            char* zpchLexeme = ( char*) SSLexLexemeGetBuffer( zpLexeme);
            zlVal = strtol( zpchLexeme, 0, 0);
            break;
            }

         case AYaccNumberOct:
         /* number -> oct */
            {
            void* zpEle = SSYaccGetElementFromProduction( qpYacc, 0);
            void* zpLexeme = SSYaccStackElementGetLexeme( zpEle);
            char* zpchLexeme = ( char*) SSLexLexemeGetBuffer( zpLexeme);
            zlVal = strtol( zpchLexeme, 0, 0);
            break;
            }

         case AYaccNumberHex:
         /* number -> hex */
            {
            void* zpEle = SSYaccGetElementFromProduction( qpYacc, 0);
            void* zpLexeme = SSYaccStackElementGetLexeme( zpEle);
            char* zpchLexeme = ( char*) SSLexLexemeGetBuffer( zpLexeme);
            zlVal = strtol( zpchLexeme, 0, 0);
            break;
            }

         }

      zpEle = SSYaccStackElementCreate( sizeof( AYaccStackElement), 0);
      zpStack = ( AYaccStackElement*) SSYaccStackElementGetExtra( zpEle);
      zpStack->olVal = zlVal;
      return zpEle;
      }

   SSRetVoid ABadCorrelatorCallback( void* qpCorr, const char* qpchVer,
      void* qpParm)
      {
      printf( "Bad correlator detected, %p, %.4s\n", qpCorr, qpchVer);
      abort();
      }

   SSBooleanValue AYaccErrorCallback( void* qpYacc, void* qpLexeme,
      SSUnsigned32 qulState, void* qpParm)
      {
      char* zpchLexeme = "eof";
      SSUnsigned32 zulLine = 0;
      SSUnsigned32 zulOffset = 0;
 
      if ( qpLexeme)
         {
         zpchLexeme = ( char*) SSLexLexemeGetBuffer( qpLexeme);
         zulLine = SSLexLexemeGetLine( qpLexeme);
         zulOffset = SSLexLexemeGetOffset( qpLexeme);
         }
      printf( "Syntax error at %d,%d: %s\n", zulLine, zulOffset, zpchLexeme);
      if ( !qpLexeme)
         printf( "   Probable missing semicolon\n");
      return SSYaccProcessError( qpYacc);
      }

   int main( int qiArg, char** qapszArg)
      {
      void* zpLex;
      void* zpYacc;
      void* zpExcept;
      void* zpConsumer;
      void* zpLexTable;
      void* zpYaccTable;

      if ( qiArg < 2)
         {
         printf( "Missing argument\n");
         return 1;
         }

      SSExceptionSetBadCorrelatorCallback( ABadCorrelatorCallback, 0);

      zpConsumer = SSLexConsumerCreate( qapszArg[ 1], strlen( qapszArg[ 1]),
         SSLexConsumerTypeCharacter, 0, &zpExcept);
      if ( !zpConsumer)
         {
         printf( "Create consumer failed: %s\n", SSExceptionGetMessage( zpExcept));
         SSExceptionDestroy( zpExcept);
         return 1;
         }

      zpLexTable = SSLexTableCreate( "sscalc.dfa", &zpExcept);
      if ( !zpLexTable)
         {
         printf( "Create lex table failed: %s\n", SSExceptionGetMessage( zpExcept));
         SSExceptionDestroy( zpExcept);
         return 1;
         }

      zpLex = SSLexCreate( zpLexTable, zpConsumer, &zpExcept);
      if ( !zpLex)
         {
         printf( "Create lex failed: %s\n", SSExceptionGetMessage( zpExcept));
         SSExceptionDestroy( zpExcept);
         return 1;
         }

      zpYaccTable = SSYaccTableCreate( "sscalc.llr", &zpExcept);
      if ( !zpYaccTable)
         {
         printf( "Create yacc table failed: %s\n", SSExceptionGetMessage( zpExcept));
         SSExceptionDestroy( zpExcept);
         return 1;
         }

      zpYacc = SSYaccCreate( zpLex, zpYaccTable, AYaccClassReduce, 0,
         sizeof( AYaccStackElement), &zpExcept);
      if ( !zpYacc)
         {
         printf( "Create yacc failed: %s\n", SSExceptionGetMessage( zpExcept));
         SSExceptionDestroy( zpExcept);
         return 1;
         }

      SSYaccSetErrorCallback( zpYacc, AYaccErrorCallback, 0);

      SSYaccParse( zpYacc);
      zpExcept = SSYaccGetLastException( zpYacc);
      if ( zpExcept)
         printf( "Parse: %s\n", SSExceptionGetMessage( zpExcept));

      return 0;
      }

#endif
